#include <stream.h>
#include <string.h>

#include "SingleCpuMux.h"
#include "TestTask.h"
#include "IoThread.h"

main(int argc, char** argv)
{
    if ( argc != 2 )
    {
	cerr << "Usage: " << argv[ 0 ] << " s|r\n" ;
	exit( 1 ) ;
    }

    SingleCpuMux Cpu(0);
#ifdef notdef
    Cpu.add( new IOThread( &Cpu ) ) ;
#endif

    if ( strcmp( argv[ 1 ], "s" ) == 0 )
	Cpu.add( new TestTask( "sender", SENDER ) ) ;
    else
	Cpu.add( new TestTask( "receiver", RECEIVER ) ) ;

    Cpu.fireItUp( 1, 0 ) ;

    cout << "Done!\n";
}
