#include <stream.h>
#include <sys/types.h>
#include <fcntl.h>

#include "MultiAsync.h"
#include "Fd.h"

/*
 * Because close is intercepted
 */
#define CLOSE( fd )		(void) syscall( SYS_close, fd )



int duplicateAndAssign( int fd )
{
	int newFd = fdAllocator.request() ;
	if ( newFd != -1 )
	{
		/*
		 * we don't use fcntl in case we decide to intercept it
		 * in the future
		 */
		int dupFd = syscall( SYS_fcntl, fd, F_DUPFD, newFd ) ;
		ASSERT( dupFd == newFd ) ;
	}
	CLOSE( fd ) ;

	if ( newFd != -1 )
		multiAsyncIO_array[ newFd ].set_owner() ;

	return( newFd ) ;
}


int socket( int domain, int type, int protocol )
{
	MultiAsyncIO::ioInit() ;

	int fd = syscall( SYS_socket, domain, type, protocol ) ;
	if ( fd == -1 )
		return( fd ) ;
	else
		return( duplicateAndAssign( fd ) ) ;
}


int open( char *path, int flags, int mode )
{
	MultiAsyncIO::ioInit() ;

	int fd = syscall( SYS_open, path, flags, mode ) ;
	if ( fd == -1 )
		return( fd ) ;
	else
		return( duplicateAndAssign( fd ) ) ;
}


int creat( char *path, int mode )
{
	MultiAsyncIO::ioInit() ;

	int fd = syscall( SYS_creat, path, mode ) ;
	if ( fd == -1 )
		return( fd ) ;
	else
		return( duplicateAndAssign( fd ) ) ;
}

