#include "std.h"

#include "assert.h"

#include "Fd.h"

/*
 * There can only be one (what was the movie?)
 */
FdAllocator fdAllocator ;

FdAllocator::FdAllocator()
{
	fdTableSize = getdtablesize() ;
	fdUsed = new bool[ fdTableSize ] ;
	for ( int i = 0 ; i < fdTableSize ; i++ )
		fdUsed[ i ] = FALSE ;
}


/*
 * Request to allocate the specific fd
 * This function is used for initialization
 */
int FdAllocator::request( int fd )
{
	if ( fdUsed[ fd ] )
		return( -1 ) ;
	else
	{
		fdUsed[ fd ] = TRUE ;
		return( 0 ) ;
	}
}


/*
 * Returns the lowest numbered unused file descriptor
 * This function may be invoked by more than one cpu
 */
int FdAllocator::request()
{
	int retval = -1 ;

	lock.reserve() ;
	for ( int i = 0 ; i < fdTableSize ; i++ )
		if ( fdUsed[ i ] == FALSE )
		{
			fdUsed[ i ] = TRUE ;
			retval = i ;
			break ;
		}
	lock.release() ;
	return( retval ) ;
}


void FdAllocator::release( int fd )
{
	assert( fdUsed[ fd ] == TRUE ) ;
	fdUsed[ fd ] = FALSE ;
}

