#include "CpuMux.h"
#include "Main.h"
#include "Send.h"
#include "Recv.h"
#include "assert.h"

Send::Send(int xpid, int recvs, int xhowMany)
    : ( "SEND", 20000, HARDWARE_CONTEXT_CHECK_MPROTECT,
       (ThreadPriority)-xpid ),
      rnd(0, recvs-1, &gen), gen(-xpid,xpid)
{
    pid = xpid;
    howMany = xhowMany;
}


void
Send::main()
{
    int i;
    for (i = 0; i < howMany; i++) {
	int to = int (rnd());
#ifndef NO_IO
	CERR_ALWAYS_PRE;
	cout << "Send " << i << " to " << to << "\n";
	CERR_POST;
#endif
	theRecvs[ to ] -> add( i );
	CpuMux::reschedule();
    }
}

Send::~Send()
{
#ifndef NO_IO
    CERR_ALWAYS_PRE;
    cout << "Sender bids good bye\n";
    CERR_POST;
#endif
}
