#include <stream.h>
#include "Main.h"
#include "Recv.h"
#include "assert.h"

Recv *theRecvs[MAX_RECVS];

Recv::Recv(int xpid)
    : ( "RECV", 20000, HARDWARE_CONTEXT_CHECK_MPROTECT,
       (ThreadPriority)-xpid ) 
{
    pid = xpid;
    sprintf(nameBuffer,"Recv-%d", pid);
    name(nameBuffer);
}

void
Recv::main()
{
#ifndef NO_IO
    CERR_ALWAYS_PRE;
    cout << "Hi mom, I'm #" << pid << "\n";
    CERR_POST;
#endif

    while(1) {
	int msg = remove();

#ifndef NO_IO
	CERR_ALWAYS_PRE;
	cout << "#" << pid << " got message " << msg << "\n";
	CERR_POST;
#endif
    }
}

void
Recv::add(int message)
{
    AwesimeFifoItem foo = (AwesimeFifoItem) message;
    mailBox.add( & foo );
}

int
Recv::remove()
{
    AwesimeFifoItem foo;
    mailBox.remove(&foo);
    return( (int) foo );
}
	
