#include "Table.h"
#include "CpuMux.h"

Table TheTable;

Table::Table()
{
    for (int i = 0; i < PHILOSOPHERS; i++ ) {
	available[i] = TRUE;
    }
}

void
Table::getForks(int left, int right)
{
    bool ok = FALSE;
    while ( ok == FALSE ) {
	lock.reserve();
	if ( available[left] && available[right] ) {
	    ok = TRUE;
	    available[left] = FALSE;
	    available[right] = FALSE;
	}
	lock.release();
	if ( ok == FALSE ) CpuMux::reschedule();
    }
}

void
Table::returnForks(int left, int right)
{
    lock.reserve();
    available[left] = TRUE;
    available[right] = TRUE;
    lock.release();
}
