// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef MultiMuxCpu_h
#define MultiMuxCpu_h
#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <SimulationMultiplexor.h>
#include <MultiCpuMux.h>
#include <HardwareContext.h>

//
//	Like it says.
//
extern double CurrentSimulatedTime;
extern const double NullTime;

class SpinBarrier;
class TimeSchedulerPQ;

class MultiSimMux : public SimulationMultiplexor, public MultiCpuMux {
protected:
//    MultiCpuMux multiCpu;

    SpinLock *myPendingEventsLock;
    SpinBarrier *cpuBarrier;

    virtual int advanceTime();

    void allocateLocalEventStructures(int,int);

    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

public:
    MultiSimMux(int debug = 0, int barrierMaxLoops = 0);

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();
};

#endif /* MultiMuxCpu_h */
