// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef MultiCpuMux_h
#define MultiCpuMux_h
#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <CpuMultiplexor.h>
#include <MultiCpuMuxExceptions.h>

extern SpinLock CpuCerrLock;

class MultiCpuMux : public CpuMultiplexor {
    friend class MultiSimMux;
protected:

    SpinFetchAndOp *globalCurrentEventsCounter;

    int oldGeneration; // placed here to avoid optimizer screwups
    //
    // Constructors of this class and all subclasses should call their
    // own allocateLocalEventStructures, because constructors automatically
    // chain the calls.
    //
    // Use AllocateEventStructures when allocating resources for a CPU and
    // you're not in the constructor. Use deallocateEventStructures for
    // removing those resources. These routines should call subclass
    // instances of the same names.
    //
    void allocateLocalEventStructures(int,int);

    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

    //
    //	like add, but adds to another CPU
    //
    virtual void addToAnother(int, Thread *);
    virtual Thread *remove();

    //
    //	Exception handlers.
    //

    friend class ExceptionRelocate;
    ExceptionRelocate relocateException;

    friend class ExceptionEnrollDismissCpu;
    ExceptionEnrollDismissCpu enrollDismissCpuException;

public:
    MultiCpuMux(int debug = 0);
    virtual ~MultiCpuMux();

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void enrollCpu();
    virtual void dismissCpu();

    virtual void add(Thread *);
};

#endif /* MultiCpuMux_h */
