// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _SEvSplayPQ_h
#ifdef __GNUG__
#pragma interface
#endif
#define _SEvSplayPQ_h 1

#include "SEv.PQ.h"
#include "SEv.SplayNode.h"

class SEvSplayPQ : public SEvPQ
{
protected:
  SEvSplayNode*   root;

  SEvSplayNode*   leftmost();
  SEvSplayNode*   rightmost();
  SEvSplayNode*   pred(SEvSplayNode* t);
  SEvSplayNode*   succ(SEvSplayNode* t);
  void            _kill(SEvSplayNode* t);
  SEvSplayNode*   _copy(SEvSplayNode* t);

public:
                  SEvSplayPQ();
                  SEvSplayPQ(SEvSplayPQ& a);
  virtual       ~SEvSplayPQ();

  Pix           enq(SEv& item);
  SEv           deq(); 

  SEv&          front();
  void          del_front();

  int           contains(SEv& item);

  void          clear(); 

  Pix           first(); 
  Pix           last(); 
  void          next(Pix& i);
  void          prev(Pix& i);
  SEv&          operator () (Pix i);
  void          del(Pix i);
  Pix           seek(SEv& item);

  int           OK();                    // rep invariant
};


inline SEvSplayPQ::~SEvSplayPQ()
{
  _kill(root);
}

inline SEvSplayPQ::SEvSplayPQ()
{
  root = 0;
  count = 0;
}

inline SEvSplayPQ::SEvSplayPQ(SEvSplayPQ& b)
{
  count = b.count;
  root = _copy(b.root);
}

inline Pix SEvSplayPQ::first()
{
  return Pix(leftmost());
}

inline Pix SEvSplayPQ::last()
{
  return Pix(rightmost());
}

inline void SEvSplayPQ::next(Pix& i)
{
  if (i != 0) i = Pix(succ((SEvSplayNode*)i));
}

inline void SEvSplayPQ::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((SEvSplayNode*)i));
}

inline SEv& SEvSplayPQ::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((SEvSplayNode*)i)->item;
}

inline void SEvSplayPQ::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int SEvSplayPQ::contains(SEv& key)
{
  return seek(key) != 0;
}

#endif
