// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef MultiCpuMux_h
#define MultiCpuMux_h
#ifdef __GNUG__
#  pragma interface
#endif

#include <CpuMux.h>
#include <MultiCpuMuxExceptions.h>

//
//	Filled in by the single original UNIX process. This value may
//	change during execution
//

class ThreadContainer;

class MultiCpuMux : public CpuMux {

protected:
    int eventsAddedThisBatch;

    void AddToCpu(int cpu, Thread *who);
    Thread *RemoveFromCpu(int cpu);

protected:

    int oldGeneration; // placed here to avoid optimizer screwups

    void allocateLocalEventStructures(int,int);
    void deallocateEventStructures();

    virtual ThreadContainer* allocateThreadContainer();

    //
    //	like add, but adds to another CPU
    //
    virtual void addToAnother_(int, Thread *);
    virtual Thread *remove();

    //
    //	Exception handlers.
    //

    friend class ExceptionRelocate;
    ExceptionRelocate relocateException;

    friend class ExceptionEnrollDismissCpu;
    ExceptionEnrollDismissCpu enrollDismissCpuException;

    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void enrollCpu();
    virtual void dismissCpu();

    virtual void add_(Thread *);

    virtual void addReserve_();
    virtual void addUnlocked_(Thread*);
    virtual void addRelease_();

    MultiCpuMux(bool debug = FALSE);
    virtual ~MultiCpuMux();

public:

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));

    static void addToAnother(int, Thread*);
    static MultiCpuMux *Cpu();
};

inline MultiCpuMux *MultiCpuMux::Cpu()
{
    return( (MultiCpuMux *) ThisCpu ) ;
}

inline void MultiCpuMux::addToAnother(int i, Thread *t)
{
    MultiCpuMux::Cpu() -> addToAnother_(i, t);
}

#endif /* MultiCpuMux_h */
