#ifdef __GNUG__
#  pragma implementation
#endif

#include "CpuMux.h"
#include "CpuMuxP.h"
#include "EventSequence.h"
#include "Thread.h"
#include "SEv.SplayPQ.h"

EventSequence::EventSequence( int count_ ) : tickets(count_ - 1 )
{
    pile = new SEvSplayPQ;
    counter = count_;
    lock.release();
}

void
EventSequence::reset( int count_ ) 
{
    lock.reserve();
    counter = count_;
    tickets = count_ - 1;

    for (;; ) {
	if ( pile -> empty() ) break;

	SEv& ev = pile -> front();
	if ( ev.time() < counter ) {
	    SEv ev = pile -> deq();
	    assert( ! ev.isOtherEvent() );
	    CpuMux::add( ev.thread() );
	} else {
	    break;
	}
    }

    lock.release();
}

EventSequence::~EventSequence()
{
    lock.reserve();
    if ( pile == NULL ) {
	delete pile;
    }
    lock.release();
}

void
EventSequence::advance(int x)
{
    lock.reserve();
    counter += x;
    for (;; ) {
	if ( pile -> empty() ) break;

	SEv& ev = pile -> front();
	if ( ev.time() < counter ) {
	    SEv ev = pile -> deq();
	    assert( ! ev.isOtherEvent() );
	    CpuMux::add( ev.thread() );
	} else {
	    break;
	}
    }
    lock.release();
}

void
EventSequence::await(int x)
{
    lock.reserve();
    if ( x >= counter ) {
	lock.release();
	setContext(0, (void *) x);
	CpuMux::reserveByException( this );
    } else {
	lock.release();
    }
}

int
EventSequence::reserveByException(Thread *byWho, ExceptionReserve&)
{
    int blocked = 0;

    int x = (int) getContext(0);
    lock.reserve();
    if ( x >= counter ) {
	pile -> enq(SEv(byWho, x));
	blocked = 1;
    }
    lock.release();
    return( blocked );
}
