#include <stream.h>
#include "Main.h"
#include "Table.h"
#include "Phil.h"
#include "CpuMux.h"
#include "Semaphore.h"
#include "GenerousSemaphore.h"
#include "Barrier.h"

GenerousSemaphore foo(0);
SpinFetchAndOp Phil::mouthFulls(0);

extern Table TheTable;

Phil::Phil(int xpid) : ( "Philosopher", 5000, HARDWARE_CONTEXT_CHECK_MPROTECT) 
{
    pid = xpid;
    sprintf(nameBuffer,"Phil-%d", pid);
    name(nameBuffer);
}

void
Phil::main()
{
    int toTheRight = (pid + 1) % PHILOSOPHERS;

    CERR_ALWAYS_PRE;
    cerr << name() << " using forks " << pid << " and " << toTheRight << "\n";
    CERR_POST;

    static Barrier sayGrace( PHILOSOPHERS );
    sayGrace.rendezvous();


    while( mouthFulls.value() < 10 ) {

	TheTable.getForks(pid, toTheRight);

	CERR_ALWAYS_PRE;
	cerr << name() << " gets to eat\n";
	CERR_POST;

	TheTable.returnForks(pid, toTheRight);

	mouthFulls += 1;
    }
    CERR_ALWAYS_PRE;
    cerr << name() << " wanders off to burb awhile\n";
    CERR_POST;
}
