#include <stream.h>

#include "SimMux.h"
#include "Customer.h"
#include "Gen.h"
#include "Facility.h"
#include "NegativeExpntl.h"

Gen::Gen(int customers_, double meanService, double meanArrival)
	: ( "CUSTMR", 10000),
	  rng(time(0), time(0)),
	  serviceTime(meanService, &rng),
	  arrivalTime(meanArrival, &rng)

{
    customers = customers_;
}

void
Gen::main()
{
    //
    // Add all the customers
    //

    for (int i = 0; i < customers; i++ ) {
	SimMux::add( new Customer( serviceTime() ));
	SimMux::hold( arrivalTime() );
    }
}
