/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/spxrdkey.c,v $
 *
 *
 *  MODULE NAME:    spxrdkey.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <syslog.h>
#include <sys/time.h>
#include <pwd.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigZ.h"
#include "BigRSA.h"
#include "random.h"
#include "objid.h"
#include "spxapi_defs.h"
#include "gssapi_defs.h"

#ifdef sun
#define strcasecmp	strcmp_support
#endif

char *progname, *rindex();

extern int optind, opterr;
extern char *optarg;

static RSAKeyStorage ver_pubRSAKey;
int encode_SPHINX_Certificate();
unsigned char *asn1_cert;
int           asn1_cert_len;
PE            certpe;

main(argc, argv)
int  argc;
char **argv;
{
  struct passwd   *pwd;
  ClaimantCred *claimant_cred;
  TrustedCred *ta_claimant_cred;
  TrustedAuthority *ta;
  char  fullname[FULLNAME_SZ], inethost[FULLNAME_SZ];
  int   errflg = 0, ta_index = 0, vflag = 0, tflag = 0, ta_num=0;
  int   n_hosts = 0, c, i, status, certifnum = 0, time_now;
  char  *cp, host_names[8][ANAME_SZ], cdc_server[ANAME_SZ], issuer[ANAME_SZ];
  char  cdc_domain[FULLNAME_SZ], errmsg[120];
  struct type_SPHINX_Certificate     *cert;
  struct type_SPHINX_CertPath        *certpath;
  CrossNameList   crossnames;

  opterr = 0;
  bzero(cdc_server, sizeof(cdc_server));
  bzero(issuer, sizeof(issuer));

  while ((c=getopt(argc, argv, "t:vh:")) != EOF)
    switch(c) {
      case 't' :
	tflag = 1;
        ta_num = atoi(optarg);
	break;
      case 'v' :
	vflag = 1;
	break;
      case 'h' :
        strcpy(cdc_server, optarg);
        break;
      case '?' :
        errflg++;
        break;
    }

  if (argv[optind] != NULL) strcpy(fullname, argv[optind++]);
  if (optind != argc) errflg++;

  if (!strlen(fullname)) {
    errflg++;
  }

  if (errflg) {
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;
    printf("Usage: %s [-v] [-t num] [-h host] x500_name\n", progname);
    printf("\t-v\tverbose mode\n");
    printf("\t-t\tonly use last TA\n");
    printf("\t-h\talternate CDC server host to contact\n");
    exit(1);
  }

  if (fullname[0] == '.') {
    strcpy(cdc_domain, get_domain_name(NULL));
    strcat(cdc_domain, &fullname[1]);
    bzero(fullname, sizeof(fullname));
    strcpy(fullname, cdc_domain);
  } else {
    if (fullname[0] != '/') {
      strcpy(cdc_domain, get_domain_name(NULL));
      strcat(cdc_domain, "/");
      strcat(cdc_domain, fullname);
      bzero(fullname, sizeof(fullname));
      strcpy(fullname, cdc_domain);
    }
  }

  pwd = getpwuid(getuid());
  if (pwd == 0) {
    printf("unknown user id --- exit\n");
    exit(0);
  }
  status = Sphinx_Acquire_cred(pwd->pw_name,
			       NULL,
			       GSS_C_INITIATE,
			       (char **) &claimant_cred,
			       (char **) &ta_claimant_cred,
			       0);
  if (status < 0) {
    Sphinx_error_message(status, errmsg);
    printf("'%s'\n",errmsg);
    exit(0);
  }

  /*  check credential validity  */

  if (tflag) {
    i = 0;
    ta =  ta_claimant_cred->head;
    if (ta_num <= ta_claimant_cred->count)
      for (;i<ta_num-1;ta=ta->next,i++);
    ta_claimant_cred->head = ta;
    ta->next = NULL;
    ta_claimant_cred->count = 1;
  }

  printf("call read_pub_key for '%s' :\n", fullname);
  if (vflag) {
    printf("\tcdc_server is '%s'\n", cdc_server);
    display_ta_cred(ta_claimant_cred, 0);
  }
  if ((i = read_pub_key(fullname, &ver_pubRSAKey, ta_claimant_cred,
			cdc_server, vflag)) <= 0) {
    switch(i) {
      case -1 :
        printf("\nSPX unable to communicate with CDC server\n");
        exit(0);
        break;
      case -2 :
        printf("\nSPX tree walk fails going down\n");
        exit(0);
        break;
      case -3 :
        printf("\nSPX tree walk fails going up\n");
        exit(0);
        break;
      case -4 :
        printf("\nX.500 target name in unknown domain\n");
        exit(0);
        break;
      case -5 :
	printf("\ntarget certification path don't exist in CDC\n");
	exit(0);
	break;
      default :
        printf("\nSPX read pubkey returns unknown error - %d\n", i);
        exit(0);
    }
  }
  printf("\nSPX successfully read public key\n");
  PrintPubKey(&ver_pubRSAKey);
}
