/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdc_ping.c,v $
 *
 *
 *  MODULE NAME:    spxping.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <syslog.h>
#include <sys/time.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigZ.h"
#include "BigRSA.h"
#include "cdc.h"
#include "objid.h"

#ifdef sun
#define strcasecmp	strcmp_support
#endif

char *progname, *rindex();

extern int optind, opterr;
extern char *optarg;

int encode_SPHINX_Certificate();
unsigned char *asn1_cert;
int           asn1_cert_len;
PE            certpe;

main(argc, argv)
int  argc;
char **argv;
{
  char  fullname[FULLNAME_SZ], inethost[FULLNAME_SZ];
  int   dflag = 0, errflg = 0, tflag = 0, ta_index = 0, aflag = 0, vflag = 0;
  int   xflag = 0;
  int   n_hosts = 0, c, i, status, certifnum = 0;
  char  *cp, host_names[8][ANAME_SZ], cdc_server[ANAME_SZ], issuer[ANAME_SZ];
  char  cdc_domain[FULLNAME_SZ];
  struct type_SPHINX_Certificate     *cert;
  struct type_SPHINX_CertPath        *certpath;
  CrossNameList   crossnames;
  KTEXT_ST        pkt_st;
  KTEXT           pkt = &pkt_st;

  opterr = 0;
  bzero(cdc_server, sizeof(cdc_server));
  bzero(issuer, sizeof(issuer));
  while ((c=getopt(argc, argv, "vatdh:x:")) != EOF)
    switch(c) {
      case 'v' :
	vflag = 1;
	break;
      case 'a' :
        aflag = 1;
        dflag = 1;
        break;
      case 't' :
        tflag = 1;
        break;
      case 'd' :
        dflag = 1;
        break;
      case 'h' :
        strcpy(cdc_server, optarg);
        break;
      case 'x' :
	xflag = 1;
	strcpy(issuer, optarg);
	break;
      case '?' :
        errflg++;
        break;
    }

  if (argv[optind] != NULL) strcpy(fullname, argv[optind++]);

  if (optind != argc) errflg++;
  if (!strlen(fullname)) {
    errflg++;
  }

  if (errflg) {
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;
    printf("Usage: %s [-da] [-t] [-h host] [-x issuer] x500_name\n", progname);
    printf("\t-t\tread TA certificate (default principal certificate)\n");
    printf("\t-d\tdisplay x500 certificate\n");
    printf("\t-a\tdisplay all X500 certificates\n");
    printf("\t-x\textract into local file (issuer_certif_issuer)\n");
    printf("\t-h\talternate CDC server host to contact\n");
    exit(1);
  }

  if (fullname[0] == '.') {
    strcpy(cdc_domain, get_domain_name(NULL));
    strcat(cdc_domain, &fullname[1]);
    bzero(fullname, sizeof(fullname));
    strcpy(fullname, cdc_domain);
  } else {
    if (fullname[0] != '/') {
      strcpy(cdc_domain, get_domain_name(NULL));
      strcat(cdc_domain, "/");
      strcat(cdc_domain, fullname);
      bzero(fullname, sizeof(fullname));
      strcpy(fullname, cdc_domain);
    }
  }
  find_cdc(fullname, &n_hosts, host_names);
  if (n_hosts == 0) {
    printf("unable to locate CDC server for '%s' domain\n", fullname);
    exit(0);
  }
  printf("try contacting :\n");
  for (i=0; i<n_hosts; i++)
    printf("\t%s\n", host_names[i]);

  crossnames.num = 0;

  if (tflag) {
    ta_index = 0;
    status = read_tacertif_cstub(pkt, fullname, 0, 0, &ta_index, &certpath, cdc_server, 0);
  } else {
    status = read_certif_cstub(pkt, fullname, NULL /* fullname */, &crossnames, &certpath, cdc_server, vflag);
  }

  if (status != 0) {
    switch(status) {
      case CDC_BUILD_REQ_ERROR :
	printf("error building request pkt to CDC\n");
        break;
      case CDC_UNAVAILABLE :
	printf("unable to ping CDC server\n");
	break;
      case CDC_CHECK_RES_ERROR :
	printf("error checking response pkt from CDC\n");
	break;
      case CDC_CHECK_RES_UNKNOWN :
	printf("unexpected response from CDC\n");
	break;
      case int_SPHINX_CDCStatus_unrecognizedDomain :
	printf("CDC server ... %s is up, unknown domain name\n", cdc_server);
	break;
      case int_SPHINX_CDCStatus_unrecognizedCA :
	printf("CDC server ... %s is up, unknown ca name\n", cdc_server);
	break;
      case int_SPHINX_CDCStatus_unrecognizedPrincipal :
	printf("CDC server ... %s is up, unknown principal name\n", cdc_server);
	break;
      case int_SPHINX_CDCStatus_illegalRequest :
	printf("CDC server ... %s is up, illegal request\n", cdc_server);
	break;
      default :
	printf("read certif returns unknown error - %d\n", status);
	break;
      }
    exit(0);
  }

  printf("CDC server ... %s is up, found principal certif\n", cdc_server);

  if (!dflag) exit(0);
  if (certpath == NULL) exit(0);

  while (1) {
    do {
      time_t now;
      char issu_uid[UID_SZ], subj_uid[UID_SZ];
      char *ca_sig;
      int  j;
      int  issu_uidlen, subj_uidlen, ca_sig_size ;
  
      RSAKeyStorage subject_Key;
      BigNumDigit   tn[2*DigitLim];

      now = time(0);
      cert = certpath->Certificate;
      certifnum++;
      printf("\nDisplay certificate #%d contents on %s", certifnum, ctime(&now));
      printf("Version:        ");
      if (cert->cinfo->version == NULL)
	printf("v1988 (DEFAULT)\n");
      else {
	int i = cert->cinfo->version->parm;
	switch (i) {
	case 0: printf("v1988 (0)\n");
	  break;
	case 1: printf("v1992 (1)\n");
	  break;
	default: printf("unrecognized (%d)\n", i);
	}
      }
      printf("Serial Number:  %d\n", cert->cinfo->serialNumber->parm);
      printf("Signature Algorithm: ");
      display_alg_id(cert->cinfo->signature);
      printf("Issuer:  %s\n", rdn_to_str(cert->cinfo->issuer));
      printf("Subject: %s\n", rdn_to_str(cert->cinfo->subject));
      validate_expired(cert->cinfo->valid,1);
      
      printf("Subject Key Algorithm Identifier: ");
      display_alg_id(cert->cinfo->subjectPublicKey->algorithm);
      
      if (key_from_certif(cert->cinfo,&subject_Key)) {
	printf("Subject Public Key:");
	PrintPubKey(&subject_Key);
      }
      else {
	printf("\nError Extracting Subject Public Key.\n");
	return(0);
      }
      if(uid_from_certif(cert->cinfo,issu_uid,&issu_uidlen,subj_uid,&subj_uidlen)) {
	printf("Issuer  UID:    ");
	hexdump(issu_uid, issu_uidlen);
	printf("Subject UID:    ");
	hexdump(subj_uid, subj_uidlen);
      }
      else {
	subj_uid [0] = 0;
	subj_uidlen = 1;
      }
      printf("Signature Algorithm Identifier: ");
      display_alg_id(cert->algorithm);
      
      printf("Signature:");
      ca_sig = prim2str(cert->signature, &ca_sig_size );
      memset(tn,0,sizeof(tn));
      memcpy(tn,ca_sig+1,ca_sig_size-1);
      free(ca_sig);
      PrintBigNum(tn,BnnNumDigits(tn,2*DigitLim),16);
      printf("\n------------------------------------------------------------\n");

      if (xflag) {
	status = encode_SPHINX_Certificate(&certpe, 1, NULL, NULLCP, cert);
	if (status == NOTOK) {
	  printf("Encode Certificate failed.\n");
	}
	status = pe2ssdu(certpe, &asn1_cert, &asn1_cert_len);
	write_certif(asn1_cert, asn1_cert_len, issuer, issuer);
	printf("writing %s_certif_%s\n", issuer, issuer);
	xflag = 0;
      }
      printf("\n");
      certpath = certpath->next;
    } while ((certpath != NULL) && (aflag));
    if ((tflag) && (ta_index != 0)) {
      status = read_tacertif_cstub(pkt, fullname, 0, 0, &ta_index, &certpath, cdc_server, 0);
    } else exit(0);
  }
}
