/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/spxinit.c,v $
 *
 *
 *  MODULE NAME:    spxinit.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/param.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"

#define	DEFAULT_LIFETIME_HOURS   72
#define DEFAULT_SESSION_KEYSIZE  384

#define MIN_SESSION_KEYSIZE	256
#define MAX_SESSION_KEYSIZE	512 

#define MIN_LIFETIME_HOURS	0
#define MIN_LIFETIME_MINUTES    15
#define MAX_LIFETIME_HOURS	144

extern int optind, opterr;
extern char *optarg;

#define ILLEGAL_PASSWORD     -3

char   *progname, *rindex();

main(argc, argv)
    int    argc;
    char   *argv[];
{
    register char *cp;
    register i;
    int     c, uselocalfile = 0, errflg = 0, status;
    int     keysize = DEFAULT_SESSION_KEYSIZE;
    char    aname[ANAME_SZ], myname[ANAME_SZ], ca[ANAME_SZ];
    char    longname[FULLNAME_SZ], tmplongname[FULLNAME_SZ];
    char    *env;
    int     vflag = 0, cflag = 0, nflag = 0;
    int     lifetime = DEFAULT_LIFETIME_HOURS * 60;
    struct passwd       *pwd;

    opterr = 0;
    while ((c=getopt(argc, argv, "vlc:k:t:n:")) != EOF)
      switch(c) {
        case 'l' :
	  uselocalfile = 1;
	  break;
        case 'c' :
	  cflag++;
	  strcpy(ca, optarg);
	  break;
	case 'k' :
	  i = atoi(optarg);
	  if ((i < MIN_SESSION_KEYSIZE) || (i > MAX_SESSION_KEYSIZE)) {
	    if (i < MIN_SESSION_KEYSIZE)  i = MIN_SESSION_KEYSIZE;
	    if (i > MAX_SESSION_KEYSIZE)  i = MAX_SESSION_KEYSIZE;
	    printf("session keysize out of range [%d ... %d], set to %d\n", MIN_SESSION_KEYSIZE, MAX_SESSION_KEYSIZE, i);
	  }
	  keysize = i;
	  break;
	case 't' :
	  i = atoi(optarg);
	  if ((i <= MIN_LIFETIME_HOURS) || (i > MAX_LIFETIME_HOURS)) {
	    if (i <= MIN_LIFETIME_HOURS) {
              lifetime = MIN_LIFETIME_MINUTES;
              printf("validity set to %d minutes\n", MIN_LIFETIME_MINUTES);
            }
	    if (i > MAX_LIFETIME_HOURS) {
              lifetime = MAX_LIFETIME_HOURS * 60;
	      printf("validity time interval out of range, set to %d hours\n", MAX_LIFETIME_HOURS);
            }
	  } else lifetime = i*60;
	  break;
	case 'n' :
	  strcpy(tmplongname, optarg);
	  nflag = 1;
	  break;
	case 'v' :
	  vflag = 1;
	  break;
	case '?' :
	  errflg++;
	  break;
	}

    pwd = getpwuid(getuid());
    strcpy(myname, pwd->pw_name);
    if (!*myname)
      exit(0);

    strcpy(aname, myname);

    if (optind != argc) errflg++;
    if (errflg) {
      progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;
      printf("Usage: %s [-lv] [-k key_size] [-t hours] [-c ca_name] [-n fullname]\n", progname);
      printf("\t-k      session key size (default %d)\n",DEFAULT_SESSION_KEYSIZE);
      printf("\t-t      time interval for session (default %d hours)\n", DEFAULT_LIFETIME_HOURS);
      printf("\t-l      use local key and certificate files to init credentials\n");
      printf("\t-c      alternate CA RDN (default is 'OU=Users')\n");
      printf("\t          (default CA RDN may also be overrided by SPHINX_LOCAL_CA variable)\n");
      printf("\t-n      principal's full name (default prompts for full name)\n");
      printf("\t          (default full name may be specified by SPHINX_LOCAL_NAME variable)\n");
      printf("\t-v      verbose mode\n");
      exit(1);
    }
    if (!cflag) {
      if ((env = (char *) getenv("SPHINX_LOCAL_CA")) != NULL) strcpy(ca, env);
      else { strcpy(ca, "OU=Users"); }
    }
    if (ca[2] != '=') {
      printf("illegal CA RDN - '%s' (need attribute type)\n", ca);
      printf("using default CA - 'OU=Users'\n");
      strcpy(ca, "OU=Users");
    }
    if (nflag == 0) {
      if ((env = (char *) getenv("SPHINX_LOCAL_NAME")) != NULL)
        strcpy(tmplongname, env);
      else {
        printf("Enter full name without quotes (i.e., John Smith) : ");
        if ((gets(tmplongname) == NULL) || (*tmplongname == '\0')) {
          printf("unknown user name\n");
          exit(1);
        }
      }
    }
    if (tmplongname[0] != '/') {
      strcpy(longname,"CN=");
      strcat(longname, tmplongname);
      printf("Init Claimant credentials (%d hours) for\n\t'%s/%s/%s'\n", (lifetime/60), get_domain_name(NULL), ca, longname);
    } else {
      strcpy(longname, tmplongname);
      printf("Init Claimant credentials (%d hours) for\n\t'%s'\n", (lifetime/60), longname);
    }

    status = cdc_get_pwd_in_cfile(myname, aname, lifetime, keysize/2, uselocalfile, ca, longname, vflag);
    if (status != 0) {
      switch (status) {
        case ILLEGAL_PASSWORD :
	  printf("illegal password\n");
	  break;
        case CDC_UNAVAILABLE :
	  printf("CDC unavailable\n");
	  break;
        case int_SPHINX_CDCStatus_unrecognizedPrincipal :
	  printf("user is not registered\n");
	  break;
        case int_SPHINX_CDCStatus_unrecognizedDomain :
	  printf("incorrect CDC configuration (wrong domain)\n");
	  break;
        default :
	  printf("spxinit: error - %d\n", status);
	  break;
        }
    }
}
