/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/install_server.c,v $
 *
 *
 *  MODULE NAME:    install_server.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/param.h>
#include "cdc.h"
#include "cdc_db.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "SPHINX-types.h"

#define	DEFAULT_LIFETIME	365 * 24 * 60

extern int optind, opterr;
extern char *optarg;

#define ILLEGAL_PASSWORD     -3

char   *progname, *rindex();

main(argc, argv)
    char   *argv[];
{
    register char *cp;
    int     c, lifetime = DEFAULT_LIFETIME, status;
    char    servername[ANAME_SZ], ca[ANAME_SZ], *env;
    int     vflag = 0, cflag = 0, errflg = 0, uselocalfile = 0;

    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

    opterr = 0;
    bzero(ca, sizeof(ca));
    bzero(servername, sizeof(servername));
    while ((c=getopt(argc, argv, "vlc:")) != EOF)
      switch(c) {
        case 'l' :
	  uselocalfile = 1;
	  break;
        case 'c' :
	  cflag++;
	  strcpy(ca, optarg);
	  break;
	case 'v' :
	  vflag = 1;
	  break;
	case '?' :
	  errflg++;
	  break;
	}

    if (argv[optind] != NULL) strcpy(servername, argv[optind++]);
    if (optind != argc) errflg++;
    if (errflg) {
      printf("Usage: %s [-lv] [-c ca_name] [servername]\n", progname);
      printf("\t-l      use local (key and certificate files) to init credentials\n");
      printf("\t-c      alternate CA RDN (default is 'OU=Servers')\n");
      printf("\t          (default CA RDN may also be overrided by SPHINX_LOCAL_CA variable)\n");
      printf("\t-v      verbose mode\n");
      exit(1);
    }

    if (!cflag) {
      if ((env = (char *) getenv("SPHINX_LOCAL_CA")) != NULL) strcpy(ca, env);
      else { strcpy(ca, "OU=Servers"); }
    }
    if (ca[2] != '=') {
      printf("illegal CA name - '%s' (need attribute type)\n", ca);
      printf("using default CA RDN - 'OU=Servers'\n");
      strcpy(ca, "OU=Servers");
    }
    if (strlen(servername) == 0) {
      printf("Enter server's name : ");
      gets(servername);
      if (!*servername)
	exit(0);
    }
    printf("Init Verifier credentials for\n\t'%s/%s/CN=%s'\n", get_domain_name(NULL), ca, servername);
    status = cdc_get_pwd_in_vfile(servername, lifetime, uselocalfile, ca, vflag);
    if (status != 0) {
      switch (status) {
        case ILLEGAL_PASSWORD :
 	  printf("illegal password\n");
	  break;
        case CDC_UNAVAILABLE :
  	  printf("CDC unavailable\n");
	  break;
        case int_SPHINX_CDCStatus_unrecognizedPrincipal :
	  printf("service is not registered\n");
	  break;
        case int_SPHINX_CDCStatus_unrecognizedDomain :
          printf("incorrect CDC configuration (wrong domain)\n");
          break;
        default :
  	  printf("install_server: error - %d\n", status);
	  break;
        }
    }
}

usage()
{
    fprintf(stderr, "Usage: %s [-irvl] [name]\n", progname);
    exit(1);
}
