/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/ver_string.c,v $
 *
 *
 *  MODULE NAME:    ver_string.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>
#include "cdc.h"

extern char *getenv();

/*
 * This routine is used to generate the name of the file that holds
 * the user's cache of server contexts and associated session keys.
 *
 * If it is set, cdc_context_string contains the context file name.
 * Otherwise, the filename is constructed as follows:
 *
 */

static char cdc_verifier_string[MAXPATHLEN] = "";

char *ver_string(key, id)
char *key, *id;
{
    FILE *f;
    int len;
    char linebuf[200], service_name[2*ANAME_SZ];
    char *env;

    if (id != NULL)
      (void) sprintf(cdc_verifier_string, "%s_%s_%s",VER_ROOT,key,id);
    else {
      if ((f = fopen("/etc/services.spx", "r")) != NULL) {
        while (get_service_line(f, linebuf)) {
          sscanf(linebuf, "%s", service_name);
          if (strcmp(service_name, key)) continue;
          len = strlen(service_name);
          sscanf(&linebuf[len], "%s", cdc_verifier_string);
	  return cdc_verifier_string;
        }
      }
    }
    if ((env = getenv("SPHINX_VERIFIER_FILE")) != NULL)
      (void) strcpy(cdc_verifier_string, env);
    else sprintf(cdc_verifier_string, "%s_%s",VER_ROOT,key);
    return cdc_verifier_string;
}

get_service_line(f, linebuf)
FILE *f;
char *linebuf;
{
  int c, i = 0;

  c = getc(f);
  while ((c != '\n') && (c != EOF)) {
    linebuf[i++] = c;
    c = getc(f);
  }
  linebuf[i] = '\0';
  if (c == EOF)  return(0);
  return(1);
}
