/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdc/RCS/find_cdc.c,v $
 *
 *
 *  MODULE NAME:    find_cdc.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <strings.h>
#include <pwd.h>
#include <ctype.h>
#include "cdc.h"
#include "cdc_db.h"

#ifdef sun
#define strcasecmp     strcmp_support
#define strncasecmp    strncmp_support
#endif

extern int cdc_debug;

find_cdc(cdc_domain, n_hosts, host_names)
char *cdc_domain;
int *n_hosts;
char host_names[8][ANAME_SZ];
{
  FILE *f;
  int  c, offset, len, numhosts = 0, single_quoted = 0, double_quoted = 0;
  int  found_localhost = 0;
  struct passwd  *pwd;
  char  servers_filename[80], linebuf[255], *env;
  char  domain_entry[FULLNAME_SZ], host_entry[80], *domain_entry_ptr;

  if ((env = (char *) getenv("HOME")) != NULL) strcpy(servers_filename, env);
  else {
    pwd = getpwuid(getuid());
    strcpy(servers_filename, pwd->pw_dir);
  }
  strcat(servers_filename, "/");
  strcat(servers_filename, CDC_SERVERS);
  if ((f = fopen(servers_filename, "r")) == NULL) {
    strcpy(servers_filename, "/etc/");
    strcat(servers_filename, CDC_SERVERS);
    if ((f = fopen(servers_filename, "r")) == NULL) {
      if (strncasecmp(cdc_domain, CDC_DOMAIN, strlen(CDC_DOMAIN)) == 0) {
        *n_hosts = 1;
        strcpy(host_names[0], CDC_PRIMARY_SERVER);
        return(ASUCCESS);
      } else {
        *n_hosts = 0;
        return(AFAILURE);
      }
    }
  }

  *n_hosts = 0;
  while(get_line(f, linebuf)) {
    single_quoted = 0;
    double_quoted = 0;
    sscanf(linebuf, "%s", domain_entry);
    offset = strlen(domain_entry);
    if (domain_entry[0] == '"') double_quoted = 1;
    if (domain_entry[0] == '\'') single_quoted = 1;
    if (single_quoted || double_quoted) {
      if (single_quoted) {
        if (domain_entry[offset-1] != '\'') {
          while ((linebuf[offset] != '\0') && (linebuf[offset] != '\'')) {
            domain_entry[offset] = linebuf[offset];
            offset++;
          }
        } else domain_entry[offset-1] = '\0';
      }
      if (double_quoted) {
        if (domain_entry[offset-1] != '"') {
          while ((linebuf[offset] != '\0') && (linebuf[offset] != '"')) {
            domain_entry[offset] = linebuf[offset];
            offset++;
          }
        } else domain_entry[offset-1] = '\0';
      }
      domain_entry[offset++] = '\0';
      domain_entry_ptr = &domain_entry[1];
    } else domain_entry_ptr = &domain_entry[0];
    len = strlen(domain_entry_ptr);
    if (strncasecmp(cdc_domain, domain_entry_ptr, len) == 0) {
      while (sscanf(&linebuf[offset], "%s", host_entry) != -1) {
/*
 * fix to use localhost in cdc.servers table
 */
        if (strcmp(host_entry, "localhost") == 0) {
          found_localhost = 1;
          gethostname(host_entry, sizeof(host_entry));
        }
	while (((c = linebuf[offset]) == ' ') || (c == '\t'))  offset++;
        if (found_localhost == 1)  offset = offset + 9;
	else offset = offset + strlen(host_entry);
	found_localhost = 0;
	strcpy(host_names[numhosts], host_entry);
	numhosts++;
      }
      *n_hosts = numhosts;
      break;
    }
  }
  if (numhosts == 0) {
    if (strncasecmp(cdc_domain, CDC_DOMAIN, strlen(CDC_DOMAIN)) == 0) {
      *n_hosts = 1;
      strcpy(host_names[0], CDC_PRIMARY_SERVER);
      return(ASUCCESS);
    } else {
      *n_hosts = 0;
      return(AFAILURE);
    }
  }
  (void) fclose(f);
  return(ASUCCESS);
}

int x500_to_cdc(fullname, cdc_domain)
char *fullname, *cdc_domain;
{
  FILE *f;
  int  c, offset, len, numhosts = 0, single_quoted = 0, double_quoted = 0;
  int  found_localhost = 0;
  struct passwd  *pwd;
  char  servers_filename[80], linebuf[255], *env;
  char  domain_entry[FULLNAME_SZ], inet_host_entry[80], *domain_entry_ptr;

  if ((env = (char *) getenv("HOME")) != NULL) strcpy(servers_filename, env);
  else {
    pwd = getpwuid(getuid());
    strcpy(servers_filename, pwd->pw_dir);
  }
  strcat(servers_filename, "/");
  strcat(servers_filename, CDC_CONF);
  if ((f = fopen(servers_filename, "r")) == NULL) {
    strcpy(servers_filename, "/etc/");
    strcat(servers_filename, CDC_CONF);
    if ((f = fopen(servers_filename, "r")) == NULL) {
      if (!strncasecmp(fullname, CDC_DOMAIN, strlen(CDC_DOMAIN))) {
        strcpy(cdc_domain, CDC_DOMAIN);
        return(ASUCCESS);
      } else {
        return(AFAILURE);
      }
    }
  }

  /*
   *  read the default domain name from CDC_CONF file -- first line
   *  (clean up string if it is quoted)
   */
  bzero(domain_entry, sizeof(domain_entry));
  get_line(f, domain_entry);
  domain_entry_ptr = &domain_entry[0];
  if ((domain_entry[0] == '"') || (domain_entry[0] == '\'')) {
    domain_entry_ptr = &domain_entry[1];
    domain_entry[strlen(domain_entry)-1] = '\0';
  }
  if (!strncasecmp(fullname, domain_entry_ptr, strlen(domain_entry_ptr))) {
    strcpy(cdc_domain, domain_entry_ptr);
    (void) fclose(f);
    return(ASUCCESS);
  }

  while(get_line(f, linebuf)) {
    sscanf(linebuf, "%s", inet_host_entry);   /*  read Internet hostname  */
    offset = strlen(inet_host_entry);

    single_quoted = 0;
    double_quoted = 0;
    sscanf(&linebuf[offset], "%s", domain_entry);
    len = strlen(domain_entry);
    if (domain_entry[0] == '"') double_quoted = 1;
    if (domain_entry[0] == '\'') single_quoted = 1;
    if (single_quoted || double_quoted) {
      if (single_quoted) {
        if (domain_entry[len-1] != '\'') {
          while ((linebuf[offset] != '\0') && (linebuf[offset] != '\'')) {
            domain_entry[len] = linebuf[offset];
            offset++;
            len++;
          }
        } else domain_entry[len-1] = '\0';
      }
      if (double_quoted) {
        if (domain_entry[len-1] != '"') {
          while ((linebuf[offset] != '\0') && (linebuf[offset] != '"')) {
            domain_entry[len] = linebuf[offset];
            offset++;
            len++;
          }
        } else domain_entry[len-1] = '\0';
      }
      domain_entry[len++] = '\0';
      domain_entry_ptr = &domain_entry[1];
    } else domain_entry_ptr = &domain_entry[0];
    if (!strncasecmp(fullname, domain_entry_ptr, strlen(domain_entry_ptr))) {
      strcpy(cdc_domain, domain_entry_ptr);
     (void) fclose(f);
     return(ASUCCESS);
    }
  }
  strcpy(cdc_domain, "");
  (void) fclose(f);
  return(AFAILURE);
}

int get_line(f, linebuf)
FILE *f;
char *linebuf;
{
  int c, i = 0;

  c = getc(f);
  while ((c != '\n') && (c != EOF)) {
    linebuf[i++] = c;
    c = getc(f);
  }
  linebuf[i] = '\0';
  if ((c == EOF) && (i == 0))  return(0);
  return(1);
}
