/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/decode_certif_aux.c,v $
 *
 *
 *  MODULE NAME:    decode_certif_aux.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <syslog.h>
#include "SPHINX-types.h"

int	decode_SPHINX_Certificate();

struct type_SPHINX_Certificate *decode_certif_aux(asn1_certif, certif_len)
char *asn1_certif;
int  certif_len;
{
  int  explicit, result;
  PE   certif_pe;
  struct type_SPHINX_Certificate *internalcertif=NULL;

  if ((certif_pe = ssdu2pe(asn1_certif, certif_len, 0, &result)) == NULL) {
    syslog(LOG_INFO, "decode_certif: error converting certif to pe");  
#ifdef DEBUG
printf("\n%s: error converting certif to pe", __FILE__);  
#endif
    return(NULL);
  }
  explicit = 1;
  if (decode_SPHINX_Certificate(certif_pe, explicit, &certif_len, NULLCP, &internalcertif) == NOTOK) {
    syslog(LOG_INFO, "decode_certif: decode_SPHINX_Certificate not ok\n");  
#ifdef DEBUG
printf("\n%s: decoded certificate error" , __FILE__);  
#endif
    return(NULL);
  }

  pe_free(certif_pe);
  return(internalcertif);
}
