/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/create_ticket_aux.c,v $
 *
 *
 *  MODULE NAME:    create_ticket_aux.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *      J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include <pwd.h>


#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "bigrsacode.h"
#include "bigsignverify.h"
#include "random.h"
#include "spxapi_defs.h"

#include "SPHINX-types.h"
#include "objid.h"

#define DAYS 60*60*24
#define MAX_INT_BYTES 255
#define MAX_SIZE 2*DigitLim*sizeof(BigNumDigit)

#ifdef DEBUG
#undef DEBUG
#endif

struct type_SPHINX_Name *str_to_rdn();
struct type_SPHINX_AlgorithmIdentifier *create_alg_id();

int create_ticket_aux(s_pubkey, cred, tktin)
struct type_SPHINX_TicketInfo **tktin;
ClaimantCred     *cred;
RSAKeyStorage *s_pubkey;
{
  int    i,encoded_key_len;
  static char subject_pubkey[MAX_SIZE];
  struct type_SPHINX_TicketInfo *tktinfo;
  struct type_SPHINX_ShortPosixValidity *tktvalidity;
  unsigned char   *encoded_s_pubkey;

  if (*tktin = tktinfo = (struct type_SPHINX_TicketInfo *) 
                        malloc(sizeof(struct type_SPHINX_TicketInfo)));
  else return(0);
  memset(tktinfo,0,sizeof(struct type_SPHINX_TicketInfo));
  
  tktinfo->version = NULL;
  if ( tktinfo->validity = tktvalidity = (struct type_SPHINX_ShortPosixValidity *) 
                malloc(sizeof(struct type_SPHINX_ShortPosixValidity)));
  else goto finished;
  memset(tktinfo->validity,0,sizeof(struct type_SPHINX_ShortPosixValidity));
  
  if (tktvalidity->notBefore = (struct type_SPHINX_ShortPosixTime *) 
                malloc(sizeof(struct type_SPHINX_ShortPosixTime)));
  else goto finished;
  tktvalidity->notBefore->parm = cred->before;
  
  if ( tktvalidity->notAfter = (struct type_SPHINX_ShortPosixTime *) 
                        malloc(sizeof(struct type_SPHINX_ShortPosixTime)));
  else goto finished;
  tktvalidity->notAfter->parm = cred->after;

  *subject_pubkey=0;
  memcpy(subject_pubkey+1,cred->uuid,cred->uidlen);
  if (tktinfo->subjectUID = (struct type_SPHINX_UID *)
               str2prim(subject_pubkey, cred->uidlen+1, PE_CLASS_UNIV, PE_PRIM_BITS));
  else goto finished;
  prim2bit(tktinfo->subjectUID);
  
  if (encoded_s_pubkey = EncodePublic(s_pubkey));
  else {
        printf("\n%s: Error encoding public key.\n", __FILE__);
        goto finished;
  }
  *subject_pubkey=0;
  memcpy(subject_pubkey+1,encoded_s_pubkey, 
                                encoded_key_len=DecodeTotalLength(encoded_s_pubkey));
  FreePublic(encoded_s_pubkey);

  if (tktinfo->delegatingPublicKey = (struct type_SPHINX_SubjectPublicKeyInfo *) 
                        malloc(sizeof(struct type_SPHINX_SubjectPublicKeyInfo)));
  else goto finished;
  memset(tktinfo->delegatingPublicKey, 0, 
                                sizeof(struct type_SPHINX_SubjectPublicKeyInfo));
  i = s_pubkey->nl;
  i = (i*sizeof(BigNumDigit)*8)-
                       BnnNumLeadingZeroBitsInDigit(BnnGetDigit(s_pubkey->n+i-1));
  if (tktinfo->delegatingPublicKey->algorithm = create_alg_id(RSA_OID,&i));
  else goto finished;
  
  if(tktinfo->delegatingPublicKey->subjectPublicKey = 
              str2prim(subject_pubkey, encoded_key_len+1, PE_CLASS_UNIV, PE_PRIM_BITS));
  else goto finished;
  prim2bit(tktinfo->delegatingPublicKey->subjectPublicKey);

  return(1);

finished:

  free_SPHINX_TicketInfo(tktinfo);
  return(0);
}

