/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*            ALGORITHMES SOUS-EXPONENTIELS DE CALCUL              */
/*            DU GROUPE DE CLASSES ET DU REGULATEUR                */
/*                    (McCURLEY, BUCHMANN)                         */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#include "genpari.h"
const long CBUCH = 15; /*DOIT ETRE DE LA FORME 2^k-1 !!!*/
#ifdef __cplusplus
const long HASHT = 1024;
#else
#define HASHT 1024
#endif

void addcolumnmat(long **mat, long s, long cardsub, long *numbase, long *subbase, long *ex, long nbprimfact, long *primfact, long *expoprimfact, GEN form1, GEN log2precis, GEN vecexpo);
void addcolumnmat1(long **mat, long s, long cardsub, long *numbase, long *subbase, long *ex, long nbprimfact1, long *primfact1, long *expoprimfact1, GEN form1, long *fpd, long nbprimfact, long *primfact, long *expoprimfact, GEN form2, GEN log2precis, GEN vecexpo);
void addcolumnmat2(long **mat, long s, long cardsub, long *numbase, long *subbase, long *ex, long nbprimfact1, long *primfact1, long *expoprimfact1, GEN form1, long *fpd, long nbprimfact, long *primfact, long *expoprimfact, GEN form2, GEN log2precis, GEN vecexpo);
void initbuchreal(GEN D, double cbach, double cbach2, long *precreg, GEN *log2precis, long *qqq, GEN *dr, double *drc, double *logd, GEN *sqrtD, GEN *isqrtD, double *lim, long *limc, long *limbach, long prec);
long *subfactorbaseimag(GEN d, GEN *w, double ll, long kc, long* vectprime, long* vperm, long *ptnbram);
long *subfactorbasereal(GEN d, GEN *w, double ll, long precreg, long kc, long* vectprime, long* vperm, long *ptnbram, GEN isqrtD, GEN sqrtD, long sens);
long factorbasequad(GEN d, long n2, long n, long **ptnum, long **ptbase, long *ptkc, long *badprim, long *nbbadprim);
long factorisequad(GEN f, long n, long limp, long *ptlo, long *primfact, long *expoprimfact, long *badprim, long nbbadprim, long *base, long limhash);
long *largeprime(long q1, long *ex, long np, long nrho, long cardsubbase, long **hashtab);
long *largeprime2(long q1, long *ex, long np, long cardsubbase, long **hashtab);
GEN **powsubfactimag(GEN w, long n, long a);
GEN **powsubfactreal(GEN w, long n, long a, GEN D, GEN isqrtD, GEN sqrtD, long sens, long precreg);
GEN sqrealform3(GEN x, GEN D, GEN isqrtD, long sens);
GEN comprealform3(GEN x, GEN y, GEN D, GEN isqrtD, long sens);
GEN rhorealform3(GEN x, GEN D, GEN isqrtD);
GEN redrealform3(GEN x, GEN D, GEN isqrtD, long sens);
GEN initializeform3(long *ex, GEN **tabform, long cardtab, GEN d, GEN isqrtd, long sens);
GEN sqrealform5(GEN x, GEN D, GEN isqrtD, GEN sqrtD, long sens);
GEN powrealform5(GEN x, long n, GEN D, GEN isqrtD, GEN sqrtD, long sens, long precreg);
GEN comprealform5(GEN x, GEN y, GEN D, GEN isqrtD, GEN sqrtD, long sens);
GEN rhorealform5(GEN x, GEN D, GEN isqrtD, GEN sqrtD);
GEN redrealform5(GEN x, GEN D, GEN isqrtD, GEN sqrtD, long sens);
GEN initializeform5(long *ex, GEN **tabform, long cardtab, GEN d, GEN isqrtd, GEN sqrtd, long sens);
GEN redrealform(GEN x, GEN D, GEN isqrtD, GEN sqrtD, long sens, long precreg);
GEN gcdrealnoer(GEN a, GEN b);
GEN lfunc(GEN D);

GEN subfactorbasegen(long N, long m, GEN vectbase, long *vperm, long* ptss);
GEN **powsubfactgen(GEN nf, GEN w, long a, long PRECREG);
GEN idealmulprimered(GEN nf, GEN x, GEN vp, long PRECREG);
GEN getfu(GEN nf, GEN xarch, GEN reg, long *pte, long PRECREG);
long factorisegen(GEN nf, GEN ideal, long kcz, long limp, long *primfact, long *expoprimfact, long *primfactorbase, GEN *idealbase, long *numideal, long *numprimfactorbase, long limhash);
long factorbasegen(GEN nf, long n2, long n, long **ptnumprim, long **ptprim, long **ptnum, GEN **ptideal, long *ptkc, long *ptkcz, long *ptkcz2, GEN *ptlfun);
GEN cleancol(GEN x,long N,long RU,long PRECREG);

GEN buchimag(GEN D, GEN gcbach, GEN gcbach2, GEN gCO)
{
  long CO;
  double cbach,cbach2;
  long limc,limc2,mglob,m,cp,nbram,auxrel,lo,lo1,ran,nlze,col;
  long *fpd,b1,b2,fpc,pp,ep,b,extrarel,c,ic,jc,limhash;
  long kc2,*numbase,*base,*subbase;
  long **mat,**matinit,*vectprime,*vperm,*vinvperm;
  long primfact[100],expoprimfact[100],primfact1[100],expoprimfact1[100];
  long badprim[100],nbbadprim;
  long av=avma,tetpil,kc,kcco,kccopro,i,j,*pro,p2,*p1,*ex,q,s,nbtest,mm,av3;
  long sizeofmit,k,nrelsup,nreldep;
  double drc,lim,logd;
  GEN dr,v,detmat,u1u2,u1,u2,c_1;
  GEN matgen,matc,matalpha,**vp,form,form1,pc,mit,met,mot,p3,p4,basecl;
  GEN extramat,extramatc,pdep;
  long* hashtab[HASHT];

  if((typ(D)!=1)||(typ(gCO)!=1)) err(bucher1);
  if(!signe(D)) err(bucher2);
  if(signe(D)>0) err(bucher3);
  s=D[lgef(D)-1]&3;
  if((s==1)||(s==2)) err(bucher4);
  if(signe(gCO)<=0) err(bucher5);
  CO=itos(gCO);
  cbach=gtodouble(gcbach);cbach2=gtodouble(gcbach2);
  if((!cmpis(D,-3))||(!cmpis(D,-4)))
    {
      p3=cgetg(5,17);p3[1]=un;p3[2]=lgetg(1,17);p3[3]=lgetg(1,17);
      p3[4]=un;return p3;
    }
  dr=cgetr(3);affir(D,dr);drc=rtodbl(dr);logd=log(fabs(drc));
  lim=sqrt(fabs(drc)/3.0);cp=(long)exp(sqrt(logd*log(logd)/8.0));
 increaseimag:
  nreldep=nrelsup=0;
  limc=(long)(cbach*logd*logd);
  if(cp>limc) limc=cp;
  limc2=max(20,(long)(cbach2*logd*logd));if(limc>limc2) limc2=limc;
  kc2=factorbasequad(D,limc2,limc,&numbase,&base,&kc,badprim,&nbbadprim);
  if(!kc)
    {
      free(base);free(numbase);
      if(cbach>5.99)
	err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);goto increaseimag;
    }
  pro=(long*)malloc(sizeof(long)*(kc2+1));vectprime=(long*)malloc(sizeof(long)*(kc2+1));
  for(i=1;i<=kc2;i++)
    {
      p2=vectprime[i]=base[i];
      pro[i]=(p2>0) ? p2 : -p2;
    }
  free(base);base=pro;
  vperm=(long*)malloc(sizeof(long)*(kc+1));
  for(i=1;i<=kc;i++) vperm[i]=i;
  subbase=subfactorbaseimag(D,&v,lim,kc,vectprime,vperm,&nbram);
  if(nbram<0)
    {
      free(vperm);free(vectprime);free(base);free(numbase);free(subbase);
      if(cbach>5.99)
	err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);goto increaseimag;
    }
  kcco=kc+CO;
  mglob=m=subbase[0];
  vp=powsubfactimag(v,m,CBUCH+7);
  mat=(long **)malloc(sizeof(long)*(kcco+1));
  matinit=(long **)malloc(sizeof(long)*(kcco+1));
  for(i=1;i<=kcco;i++)
    {
      p1=(long *)malloc(sizeof(long)*(kc+1));matinit[i]=mat[i]=p1;
      for(j=1;j<=kc;j++) p1[j]=0;
    }
  ex=(long*)malloc(sizeof(long)*(m+1));
  q=BITS_IN_LONG-1-(long)ceil(log((double)CBUCH)/log(2.0));
  s=0;nbtest=0;
  mm=m+nbram+CO;
  limhash=(limc<(MAXHALFULONG>>1))?limc*limc:((ulong)(HIGHBIT>>1));
  for(i=0;i<HASHT;i++) hashtab[i]=(long*)0;
  auxrel=0;
  while(s<mm)
    {
      for(i=1;i<=m;i++) ex[i]=(mymyrand()>>q)+1;
      av3=avma;
      form=vp[1][ex[1]];
      for (i=2;i<=m;i++) form=compimag(form,vp[i][ex[i]]);
      pc=primeform(D,stoi(base[1+(s%kc)]));
      form=compimag(form,pc);
      fpc=factorisequad(form,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
      nbtest++;
      if(fpc>1)
	{
	  fpd=largeprime(fpc,ex,1+(s%kc),0,mglob,hashtab);
	  if(fpd)
	    {
	      auxrel++;
	      s++;
	      lo1=lo;
	      for(j=1;j<=lo1;j++) {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
	      form1=vp[1][fpd[2]];
	      for(i=2;i<=m;i++) 
		form1=compimag(form1,vp[i][fpd[i+1]]);
	      if(fpd[m+2])
		{
		  pc=primeform(D,stoi(base[fpd[m+2]]));
		  form1=compimag(form1,pc);
		}
	      b1=itos(modis((GEN)form1[2],(fpc<<1)));b2=itos(modis((GEN)form[2],(fpc<<1)));
	      factorisequad(form1,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	      if(b1==b2)
		{
		  for(i=1;i<=m;i++)
		    mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
		  mat[s][1+(s-1)%kc]--;
		  if(fpd[m+2]) mat[s][fpd[m+2]]++;
		  for(j=1;j<=lo;j++)
		    {
		      pp=primfact[j];ep=expoprimfact[j];
		      b1=itos(modis((GEN)form1[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]-=ep;
		    }
		  for(j=1;j<=lo1;j++)
		    {
		      pp=primfact1[j];ep=expoprimfact1[j];
		      b1=itos(modis((GEN)form[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]+=ep;
		    }
		}
	      else
		{
		  if((b1+b2)!=(fpc<<1)) {s--;auxrel--;}
		  else
		    {
		      for(i=1;i<=m;i++)
			mat[s][numbase[subbase[i]]]= -fpd[i+1]-ex[i];
		      mat[s][1+(s-1)%kc]--;
		      if(fpd[m+2]) mat[s][fpd[m+2]]--;
		      for(j=1;j<=lo;j++)
			{
			  pp=primfact[j];ep=expoprimfact[j];
			  b1=itos(modis((GEN)form1[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		      for(j=1;j<=lo1;j++)
			{
			  pp=primfact1[j];ep=expoprimfact1[j];
			  b1=itos(modis((GEN)form[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		    }
		}
	    }
	}	  
      if(fpc==1)
	{
	  s++;
	  for(i=1;i<=m;i++) mat[s][numbase[subbase[i]]]= -ex[i];
	  mat[s][1+(s-1)%kc]--;
	  for(j=1;j<=lo;j++)
	    {
	      pp=primfact[j];ep=expoprimfact[j];
	      b=itos(modis((GEN)form[2],(pp<<1)));
	      if(b>pp) ep= -ep;
	      mat[s][numbase[pp]]+=ep;
	    }
	}
      avma=av3;
    }
  while(s<kcco)
    {
      for(i=1;i<=m;i++) ex[i]=(mymyrand()>>q)+1;
      av3=avma;
      form=vp[1][ex[1]];
      for (i=2;i<=m;i++) form=compimag(form,vp[i][ex[i]]);
      pc=primeform(D,stoi(base[s+1-CO]));
      form=compimag(form,pc);
      fpc=factorisequad(form,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
      nbtest++;
      if(fpc>1)
	{
	  fpd=largeprime(fpc,ex,s+1-CO,0,mglob,hashtab);
	  if(fpd)
	    {
	      auxrel++;
	      s++;lo1=lo;
	      for(j=1;j<=lo1;j++) {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
	      form1=vp[1][fpd[2]];
	      for(i=2;i<=m;i++) 
		form1=compimag(form1,vp[i][fpd[i+1]]);
	      if(fpd[m+2])
		{
		  pc=primeform(D,stoi(base[fpd[m+2]]));
		  form1=compimag(form1,pc);
		}
	      b1=itos(modis((GEN)form1[2],(fpc<<1)));b2=itos(modis((GEN)form[2],(fpc<<1)));
	      factorisequad(form1,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	      if(b1==b2)
		{
		  for(i=1;i<=m;i++)
		    mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
		  mat[s][s-CO]= -1;
		  if(fpd[m+2]) mat[s][fpd[m+2]]++;
		  for(j=1;j<=lo;j++)
		    {
		      pp=primfact[j];ep=expoprimfact[j];
		      b1=itos(modis((GEN)form1[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]-=ep;
		    }
		  for(j=1;j<=lo1;j++)
		    {
		      pp=primfact1[j];ep=expoprimfact1[j];
		      b1=itos(modis((GEN)form[2],(pp<<1)));
		      if(b1>pp) ep= -ep;
		      mat[s][numbase[pp]]+=ep;
		    }
		}
	      else
		{
		  if((b1+b2)!=(fpc<<1)) {s--;auxrel--;}
		  else
		   {
		      for(i=1;i<=m;i++)
			mat[s][numbase[subbase[i]]]= -fpd[i+1]-ex[i];
		      mat[s][s-CO]= -1;
		      if(fpd[m+2]) mat[s][fpd[m+2]]--;
		      for(j=1;j<=lo;j++)
			{
			  pp=primfact[j];ep=expoprimfact[j];
			  b1=itos(modis((GEN)form1[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		      for(j=1;j<=lo1;j++)
			{
			  pp=primfact1[j];ep=expoprimfact1[j];
			  b1=itos(modis((GEN)form[2],(pp<<1)));
			  if(b1>pp) ep= -ep;
			  mat[s][numbase[pp]]+=ep;
			}
		    }
		}
	    }
	}
      if(fpc==1)
	{
	  s++;
	  for(i=1;i<=m;i++) mat[s][numbase[subbase[i]]]= -ex[i];
	  mat[s][s-CO]= -1;
	  for(j=1;j<=lo;j++)
	    {
	      pp=primfact[j];ep=expoprimfact[j];
	      b=itos(modis((GEN)form[2],(pp<<1)));
	      if(b>pp) ep= -ep;
	      mat[s][numbase[pp]]+=ep;
	    }
	  if(!(mat[s][s-CO])) {for(i=1;i<=kc;i++) mat[s][i]=0;s--;}
	}
      avma=av3;
    }
  nbtest=auxrel=0;
  while(s<kc2)
    {
      for (i=1;i<=m;i++) ex[i]=(mymyrand()>>q)+1;
      av3=avma;
      form=vp[1][ex[1]];
      for (i=2;i<=m;i++) form=compimag(form,vp[i][ex[i]]);
      pp=base[s+1];
      pc=primeform(D,stoi(pp));
      form=compimag(form,pc);
      fpc=factorisequad(form,s,pp,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
      nbtest++;
      if(fpc>1)
	{
	  fpd=largeprime2(fpc,ex,s+1,mglob,hashtab);
	  if(fpd&&(fpc!=pp)) {auxrel++;s++;}
	}
      if(fpc==1) s++;
      avma=av3;
    }
  matc=cgetg(kcco+1,19);for(i=1;i<=kcco;i++) matc[i]=lgetg(1,18);
  mit=hnfspec(mat,&pdep,&matc,vperm,&matalpha,kcco,kc,m,&nlze,&col);
  kccopro=kcco;
 morerelimag:
  if(nlze)
    {
      vinvperm=(long*)malloc(sizeof(long)*kc+1);for(i=1;i<=kc;i++) vinvperm[vperm[i]]=i;
      s=0;extrarel=nlze+2;
      extramat=cgetg(extrarel+1,19);
      for(j=1;j<=extrarel;j++) extramat[j]=lgetg(kc+1,18);
      while(s<extrarel)
	{
	  free(ex);ex=(long*)malloc(sizeof(long)*(nlze+1));
	  for (i=1;i<=nlze;i++) ex[i]=(mymyrand()>>q)+1;
	  form=gpuigs(primeform(D,stoi(labs(vectprime[vperm[1]]))),ex[1]);
	  for (i=2;i<=nlze;i++)
	    form=compimag(form,gpuigs(primeform(D,stoi(labs(vectprime[vperm[i]]))),ex[i]));
	  fpc=factorisequad(form,kc,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  if(fpc==1)
	    {
	      s++;p1=(GEN)extramat[s];
	      for(i=1;i<=nlze;i++) p1[i]=lstoi(-ex[i]);
	      for(i=nlze+1;i<=kc;i++) p1[i]=zero;
	      for(j=1;j<=lo;j++)
		{
		  pp=primfact[j];ep=expoprimfact[j];
		  b=itos(modis((GEN)form[2],(pp<<1)));
		  if(b>pp) ep= -ep;
		  k=vinvperm[numbase[pp]];
		  p1[k]=laddsg(ep,(GEN)p1[k]);
		}
	    }
	}
      extramatc=cgetg(extrarel+1,19);
      for(i=1;i<=extrarel;i++) extramatc[i]=lgetg(1,18);
      if(nrelsup) nlze=0;
      mit=hnfadd(mit,&pdep,&matc,vperm,&matalpha,kccopro,kc,col,&nlze,extramat,extramatc);
      free(vinvperm);kccopro+=extrarel;col=kccopro-(lg(matalpha)-1);
      if(nlze)
	{
	  nreldep++;
	  if(nreldep>5) 
	    {
	      free(vperm);free(vectprime);free(ex);free(base);free(numbase);free(subbase);
	      for(i=1;i<=kcco;i++) free(matinit[i]);free(matinit);free(mat);
	      for(i=1;i<=m;i++) free(vp[i]);free(vp);
	      for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
	      if(cbach>5.99)
		err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
	      else
		{
		  avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);
		  goto increaseimag;
		}
	    }
	  else goto morerelimag;
	}
    }
  p1=gun;sizeofmit=lg(mit)-1;
  for(i=1;i<=sizeofmit;i++) p1=mulii(p1,gcoeff(mit,i,i));
  c_1=gdiv(gmul(p1,mppi(4)),gmul(lfunc(D),gsqrt(absi(D),4)));
  if(gcmpgs(gmul2n(c_1,2),3)<0) err(talker,"bug check in buchimag, PLEASE REPORT!!!");
  if(gcmpgs(gmul2n(c_1,1),3)>0)
    {
      nrelsup++;
      if(nrelsup>5) 
	{
	  free(vperm);free(vectprime);free(ex);free(base);free(numbase);free(subbase);
	  for(i=1;i<=kcco;i++) free(matinit[i]);free(matinit);free(mat);
	  for(i=1;i<=m;i++) free(vp[i]);free(vp);
	  for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
	  if(cbach>5.99)
	    fprintf(stderr,"\n  ***   Warning: check is greater than 1.5, suggest increasing extra relations\n");
	  else 
	    {
	      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);
	      goto increaseimag;
	    }
	}
      else {nlze=min(kc,nrelsup);goto morerelimag;}
    }
  u1u2=smith2(mit);u1=(GEN)u1u2[1];u2=(GEN)u1u2[2];
  met=gmul(u1,gmul(mit,u2));
  u1=ginv(u1);
  lo=lg(met)-1;
  c=0;for(i=1;i<=lo;i++) if(!gcmp1(gcoeff(met,i,i))) c++;
  basecl=cgetg(c+1,17);
  for(j=1;j<=c;j++)
    {
      p3=gpui(primeform(D,stoi(labs(vectprime[vperm[1]]))),gcoeff(u1,1,j));
      for(i=2;i<=lo;i++)
	p3=gmul(p3,gpui(primeform(D,stoi(labs(vectprime[vperm[i]]))),gcoeff(u1,i,j)));
      basecl[j]=(long)p3;
    }
  tetpil=avma;p4=cgetg(5,17);p4[1]=lcopy(p1);mot=cgetg(c+1,17);p4[2]=(long)mot;
  for(i=1;i<=c;i++) mot[i]=lcopy(gcoeff(met,i,i));
  p4[3]=lcopy(basecl);p4[4]=lcopy(c_1);
  free(base);free(vectprime);free(ex);free(subbase);free(numbase);
  free(vperm);
  for(i=1;i<=kcco;i++) free(matinit[i]);free(matinit);free(mat);
  for(i=1;i<=m;i++) free(vp[i]);free(vp);
  for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
  return gerepile(av,tetpil,p4);
}

long *subfactorbaseimag(GEN d, GEN *w, double ll, long kc, long* vectprime, long* vperm, long *ptnbram)
{
  long i,j,k,nbidp,pp,*subbase,pro[100];
  double prod;
  GEN p1;

  i=0;*ptnbram=0;prod=1;if(ll<=1.1) ll=1.1;
  for(j=1;(j<=kc)&&(prod<=ll);j++)
    {
      pp=vectprime[j];
      if(pp>0) {pro[++i]=pp;prod*=pp;vperm[i]=j;}
      else (*ptnbram)++;
    }
  if(prod<=ll) {*ptnbram= -1;return (long*)0;}
  nbidp=i;
  for(k=1;k<j;k++) if(vectprime[k]<=0) vperm[++i]=k;
  *w=cgetg(nbidp+1,18);
  for(j=1;j<=nbidp;j++) 
    {
      p1=primeform(d,stoi(pro[j]));(*w)[j]=(long)p1;
    }
  subbase=(long*)malloc(sizeof(long)*(nbidp+1));subbase[0]=nbidp;
  for(j=1;j<=nbidp;j++) subbase[j]=pro[j];
  return subbase;
}
  
GEN **powsubfactimag(GEN w, long n, long a)
{
  long i,j;
  GEN **x;

  x=(GEN**)malloc(sizeof(long)*(n+1));
  for(i=1;i<=n;i++) x[i]=(GEN*)malloc(sizeof(long)*(a+1));
  for(i=1;i<=n;i++)
    {
      x[i][0]=gpuigs((GEN)w[1],0);
      for(j=1;j<=a;j++) x[i][j]=compimag(x[i][j-1],(GEN)w[i]);
    }
  return x;
}


long factorbasequad(GEN d, long n2, long n, long **ptnum, long **ptbase, long *ptkc, long *badprim, long *nbbadprim)
{
  byteptr delta=diffptr;
  long av2,i,pp,qq,fl,kr,r,*numbase,*base,sizemat;
  GEN p1;

  numbase=(long*)malloc(sizeof(long)*(n2+1));*ptnum=numbase;
  base=(long*)malloc(sizeof(long)*(n2+1));*ptbase=base;
  *ptkc=0;*nbbadprim=0;av2=avma;i=0;pp=*delta++;qq=2;fl=1;
  while(pp<=n2)
    {
      if((kr=krogs(d,pp))!=-1)
	{
	  if(kr) {i++;numbase[pp]=i;base[i]=pp;}
	  else
	    {
	      p1=divis(d,pp);
	      if(signe(modis(p1,pp))) {i++;numbase[pp]=i;base[i]= -pp;}
	      else
		{
		  if(pp==2)
		    {
		      r=p1[lgef(p1)-1]&7;if(signe(d)<0) r=8-r;
		      if(r>=4) {i++;numbase[pp]=i;base[i]= -pp;}
		      else badprim[++(*nbbadprim)]=pp;
		    }
		  else badprim[++(*nbbadprim)]=pp;
		}
	    }
	}
      pp+=*delta++;
      if((pp>n)&&fl) {sizemat=i;*ptkc=sizemat;fl=0;}
    }
  avma=av2;return i;
}

long factorisequad(GEN f, long n, long limp, long *ptlo, long *primfact, long *expoprimfact, long *badprim, long nbbadprim, long *base, long limhash)
{
  long sr,i,p,k,fl=1,av1,av2,q1,lo;
  GEN x,q,r;

  av1=avma;lo=0;x=(GEN)(absi((GEN)f[1]));if(gcmp1(x)) {avma=av1;*ptlo=0;return 1;}
  av2=avma;
  for(i=1;(i<=n)&&fl;i++)
    {
      p=base[i];q=dvmdis(x,p,&r);
      if(sr=(!signe(r)))
	{
	  primfact[++lo]=p;x=q;k=0;av2=avma;
	  while(sr)
	    {k++;q=dvmdis(x,p,&r);if(sr=(!signe(r))) {x=q;av2=avma;}}
	  expoprimfact[lo]=k;
	}
      else avma=av2;
      fl=(cmpis(q,p)>0);
    }
  if(!fl)
    {
      if(gcmp1(x)) {avma=av1;*ptlo=lo;return 1;}
      else
	{
	  if(cmpis(x,limp)<=0)
	    {
	      for(i=1;i<=nbbadprim;i++)
		if(!signe(modis(x,badprim[i]))) {avma=av1;*ptlo=lo;return 0;}
	      primfact[++lo]=itos(x);expoprimfact[lo]=1;avma=av1;*ptlo=lo;return 1;
	    }
	}
    }
  *ptlo=lo;
  if(cmpis(x,limhash)<=0)
    {q1=itos(x);avma=av1;return q1;}
  else {avma=av1;return 0;}
}

long *largeprime2(long q1, long *ex, long np, long cardsubbase, long **hashtab)
{
  long hashv,*pt,cpt,i,*p1;

  hashv=((q1&2047)-1)>>1;pt=hashtab[hashv];cpt=0;
  while(pt&&(q1!=pt[1])) {pt=(long*)(*pt);cpt++;}
  if(!pt)
    {
      if(!(p1=(long*)malloc((cardsubbase+4)<<TWOPOTBYTES_IN_LONG))) err(bucher6);
      p1[1]=q1;
      for(i=2;i<cardsubbase+2;i++) p1[i]=ex[i-1];p1[cardsubbase+2]=np;p1[cardsubbase+3]=0;
      p1[0]=cpt ? (long)hashtab[hashv] : 0;hashtab[hashv]=p1;return (long*)0;
    }
  else return (pt[cardsubbase+2]==np) ? (long*)0 : pt;
}

GEN buchreal(GEN D, GEN gsens, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec)
{
  long sens,RELSUP,nrelsup,nreldep,kccopro;
  double cbach,cbach2;
  long precreg,limc,limbach,cardsubbase,cardsub,nbram,auxrel;
  long nbprimfact,nbprimfact1,ran,fl,fl2,lo,initform5,findecycle,memoirefindecycle;
  long nbrhocourant,nbrhocumule,nrho,*fpd,b1,b2,fpc,pp,ep,b,extrarel,c,ic,jc,limhash;
  long sizebach,nbcol1,nbcol2,nbcol3,nbrow1,nbrow2,nbrow3,*numbase,*base,*subbase;
  long **mat,**matinit,*vectprime,*vperm,*vinvperm;
  long primfact[100],expoprimfact[100],primfact1[100],expoprimfact1[100];
  long badprim[100],nbbadprim,nlze,col,sizeofmit;
  long av=avma,av1,av2,tetpil,dec,sizemat,sizematcol,i,j,k,*pro,p2,*p1,*ex,qqq,s,nbtest,mm;
  double drc,lim,logd;
  GEN dr,sqrtD,isqrtD,log2precis,tabprform,detmat,detmatsur2;
  GEN matgen,matc,extramat,extramatc,vecexpo,**tabpowprform;
  GEN forminit,form,form0,form1,form2,pc,mit,met,mot,p3,p4,pdep,matalpha;
  GEN wecexpo,xecexpo,matpro;
  GEN reg,c_1,u1u2,u1,u2,basecl;
  long* hashtab[HASHT];

  if((typ(D)!=1)||(typ(gRELSUP)!=1)||(typ(gsens)!=1)) err(bucher1);
  if(!signe(D)) err(bucher2);
  if(signe(D)<0) err(bucher8);
  s=D[lgef(D)-1]&3;
  if((s==2)||(s==3)) err(bucher4);
  if(signe(gRELSUP)<=0) err(bucher5);
  sens=abs(signe(gsens));
  if(sens) 
    {
      /* sens=0;fprintf(stderr,"\n  ***   Warning: narrow class group request not yet implemented, ignored\n"); */
    }
  RELSUP=itos(gRELSUP);
  cbach=gtodouble(gcbach);cbach2=gtodouble(gcbach2);
increasereal:
  nreldep=nrelsup=0;
  initbuchreal(D,cbach,cbach2,&precreg,&log2precis,&qqq,&dr,&drc,&logd,&sqrtD,&isqrtD,&lim,&limc,&limbach,prec);
  sizebach=factorbasequad(D,limbach,limc,&numbase,&base,&sizemat,badprim,&nbbadprim);
  if(!sizemat)
    {
      free(base);free(numbase);
      if(cbach>5.99)
	err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);goto increasereal;
    }
  if(!(pro=(long*)malloc(sizeof(long)*(sizebach+1)))) err(talker,"out of memory3!");
  if(!(vectprime=(long*)malloc(sizeof(long)*(sizebach+1)))) err(talker,"out of memory4!");
  for(i=1;i<=sizebach;i++)
    {p2=vectprime[i]=base[i];pro[i]=(p2>0) ? p2 : -p2;}
  free(base);base=pro;
  if(!(vperm=(long*)malloc(sizeof(long)*(sizemat+1)))) err(talker,"out of memory5!");
  for(i=1;i<=sizemat;i++) vperm[i]=i;
  subbase=subfactorbasereal(D,&tabprform,lim,precreg,sizemat,vectprime,vperm,&nbram,isqrtD,sqrtD,sens);
  if(nbram<0)
    {
      free(vperm);free(vectprime);free(base);free(numbase);free(subbase);
      if(cbach>5.99)
        err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);
      goto increasereal;
    }
  sizematcol=sizemat+RELSUP;
  cardsubbase=cardsub=subbase[0];
  tabpowprform=powsubfactreal(tabprform,cardsub,CBUCH+7,D,isqrtD,sqrtD,sens,precreg);
  vecexpo=cgetg(sizematcol+1,17);
  for(i=1;i<=sizematcol;i++) vecexpo[i]=lgetr(precreg);
  mat=(long**)malloc((sizematcol+1)*sizeof(long));if(!((long)mat)) err(talker,"out of memory6!");
  matinit=(long**)malloc((sizematcol+1)*sizeof(long));if(!((long)matinit)) err(talker,"out of memory7!");
  for(i=1;i<=sizematcol;i++)
    {
      matinit[i]=mat[i]=(long*)malloc((sizemat+1)*sizeof(long));
      if(!((long)(mat[i]))) err(talker,"out of memory8!");
    }
  for(i=1;i<=sizematcol;i++) for(j=1;j<=sizemat;j++) mat[i][j]=0;
  if(!(ex=(long*)malloc(sizeof(long)*(cardsub+1)))) err(talker,"out of memory9!");
  limhash=(limc<(MAXHALFULONG>>1))?limc*limc:((ulong)(HIGHBIT>>1));
  s=nbtest=auxrel=0;
  mm=cardsub+nbram+RELSUP;
  for(i=0;i<HASHT;i++) hashtab[i]=(long*)0;
  while(s<mm)
    {
      for(i=1;i<=cardsub;i++) ex[i]=(mymyrand()>>qqq)+1;
      av1=avma;
      form=form0=initializeform3(ex,tabpowprform,cardsub,D,isqrtD,sens);
      initform5=0;findecycle=memoirefindecycle=1;nbrhocourant=nbrhocumule=0;
      do
	{
	  av2=avma;
	  fpc=factorisequad(form,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  if(fpc==1)
	    {
	      if(!initform5)
		{
		  form1=initializeform5(ex,tabpowprform,cardsub,D,isqrtD,sqrtD,sens);
		  initform5=1;
		}
	      for(i=1;i<=nbrhocourant;i++) form1=rhorealform5(form1,D,isqrtD,sqrtD);
	      nbrhocourant=0;s++;
	      addcolumnmat(mat,s,cardsub,numbase,subbase,ex,nbprimfact,primfact,expoprimfact,form1,log2precis,vecexpo);
	    }
	  else if(fpc>1)
	    {
	      fpd=largeprime(fpc,ex,0,nbrhocumule,cardsubbase,hashtab);
	      if(fpd)
		{
		  if(!initform5)
		    {
		      form1=initializeform5(ex,tabpowprform,cardsub,D,isqrtD,sqrtD,sens);
		      initform5=1;
		    }
		  for(i=1;i<=nbrhocourant;i++)
		    form1=rhorealform5(form1,D,isqrtD,sqrtD);
		  nbrhocourant=0;nbprimfact1=nbprimfact;
		  for(j=1;j<=nbprimfact1;j++)
		    {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
		  form2=tabpowprform[1][fpd[2]];
		  for(i=2;i<=cardsub;i++) 
		    form2=comprealform5(form2,tabpowprform[i][fpd[i+1]],D,isqrtD,sqrtD,sens);
		  for(i=1;i<=fpd[cardsub+3];i++)
		    form2=rhorealform5(form2,D,isqrtD,sqrtD);
		  if((!sens)&&(signe(addii((GEN)form2[1],(GEN)form2[3]))))
		    {setsigne((GEN)form2[1],1);setsigne((GEN)form2[3],-1);}
		  b1=itos(modis((GEN)form2[2],(fpc<<1)));b2=itos(modis((GEN)form1[2],(fpc<<1)));
		  factorisequad(form2,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
		  if(b1==b2)
		    {
		      s++;
		      addcolumnmat1(mat,s,cardsub,numbase,subbase,ex,nbprimfact1,primfact1,expoprimfact1,form1,fpd,nbprimfact,primfact,expoprimfact,form2,log2precis,vecexpo);
		    }
		  else
		    {
		      if((b1+b2)==(fpc<<1))
			{
			  s++;
			  addcolumnmat2(mat,s,cardsub,numbase,subbase,ex,nbprimfact1,primfact1,expoprimfact1,form1,fpd,nbprimfact,primfact,expoprimfact,form2,log2precis,vecexpo);
			}
		    }
		}
	    }
	  form=rhorealform3(form,D,isqrtD);nbrhocourant++;nbrhocumule++;
	  if(!sens)
	    {
	      if(memoirefindecycle==findecycle)
		{
		  if(gegal((GEN)form[1],(GEN)form0[1])&&gegal((GEN)form[2],(GEN)form0[2])) memoirefindecycle=0;
		  if(gegal((GEN)form[1],negi((GEN)form0[1]))&&gegal((GEN)form[2],(GEN)form0[2])) memoirefindecycle=0;
		  tetpil=avma;form=gcopy(form);
		  if(initform5) form1=gcopy(form1);
		  dec=lpile(av2,tetpil,0)>>TWOPOTBYTES_IN_LONG;
		  form+=dec;if(initform5) form1+=dec;
		}
	      else {findecycle=0;avma=av2;}
	    }
	  else
	    {
	      if(memoirefindecycle==findecycle)
		{
		  if(gegal((GEN)form[1],(GEN)form0[1])&&gegal((GEN)form[2],(GEN)form0[2])) memoirefindecycle=0;
		  tetpil=avma;form=gcopy(form);
		  if(initform5) form1=gcopy(form1);
		  dec=lpile(av2,tetpil,0)>>TWOPOTBYTES_IN_LONG;
		  form+=dec;if(initform5) form1+=dec;
		}
	      else {findecycle=0;avma=av2;}
	    }
	}
      while((s<mm)&&findecycle);
      avma=av1;
    }
  while(s<sizematcol)
    {
      for(i=1;i<=cardsub;i++) ex[i]=(mymyrand()>>qqq)+1;
      av1=avma;
      form=initializeform3(ex,tabpowprform,cardsub,D,isqrtD,sens);
      pc=redrealform3(primeform(D,stoi(base[s+1-RELSUP]),precreg),D,isqrtD,sens);
      form=comprealform3(form,pc,D,isqrtD,sens);forminit=form;nrho=fl=fl2=0;
      do
	{
	  fpc=factorisequad(form,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  nbtest++;
	  if(fpc>1)
	    {
	      fpd=largeprime(fpc,ex,s+1-RELSUP,nrho,cardsubbase,hashtab);
	      if(fpd)
		{
		  form=initializeform5(ex,tabpowprform,cardsub,D,isqrtD,sqrtD,sens);
		  pc=redrealform(primeform(D,stoi(base[s+1-RELSUP]),precreg),D,isqrtD,sqrtD,sens,precreg);
		  pc[4]=zero;affsr(1,(GEN)pc[5]);
		  form=comprealform5(form,pc,D,isqrtD,sqrtD,sens);
		  for(i=1;i<=nrho;i++) form=rhorealform5(form,D,isqrtD,sqrtD);
		  auxrel++;s++;nbprimfact1=nbprimfact;
		  for(j=1;j<=nbprimfact1;j++)
		    {primfact1[j]=primfact[j];expoprimfact1[j]=expoprimfact[j];}
		  form1=tabpowprform[1][fpd[2]];
		  for(i=2;i<=cardsub;i++) 
		    form1=comprealform5(form1,tabpowprform[i][fpd[i+1]],D,isqrtD,sqrtD,sens);
		  if(fpd[cardsub+2])
		    {
		      pc=redrealform(primeform(D,stoi(base[fpd[cardsub+2]]),precreg),D,isqrtD,sqrtD,sens,precreg);
		      pc[4]=zero;affsr(1,(GEN)pc[5]);
		      form1=comprealform5(form1,pc,D,isqrtD,sqrtD,sens);
		    }
		  for(i=1;i<=fpd[cardsub+3];i++) 
		    form1=rhorealform5(form1,D,isqrtD,sqrtD);
		  if((!sens)&&(signe(addii((GEN)form1[1],(GEN)form1[3]))))
		    {setsigne((GEN)form1[1],1);setsigne((GEN)form1[3],-1);}
		  b1=itos(modis((GEN)form1[2],(fpc<<1)));b2=itos(modis((GEN)form[2],(fpc<<1)));
		  factorisequad(form1,sizemat,limc,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
		  if(b1==b2)
		    {
		      fl2=1;
		      for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
		      mat[s][s-RELSUP]= -1;
		      if(fpd[cardsub+2]) mat[s][fpd[cardsub+2]]++;
		      for(j=1;j<=nbprimfact;j++)
			{
			  pp=primfact[j];ep=expoprimfact[j];b1=itos(modis((GEN)form1[2],(pp<<1)));
			  if(b1>pp) ep= -ep;mat[s][numbase[pp]]-=ep;
			}
		      for(j=1;j<=nbprimfact1;j++)
			{
			  pp=primfact1[j];ep=expoprimfact1[j];b1=itos(modis((GEN)form[2],(pp<<1)));
			  if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
			}
		      affrr(shiftr(mpadd(mulir(mulsi(EXP220,subii((GEN)form[4],(GEN)form1[4])),log2precis),mplog(absr(divrr((GEN)form[5],(GEN)form1[5])))),-1),(GEN)vecexpo[s]);
		    }
		  else
		    {
		      if((b1+b2)!=(fpc<<1)) {s--;auxrel--;}
		      else
			{
			  fl2=1;
			  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]= -fpd[i+1]-ex[i];
			  mat[s][s-RELSUP]= -1;
			  if(fpd[cardsub+2]) mat[s][fpd[cardsub+2]]--;
			  for(j=1;j<=nbprimfact;j++)
			    {
			      pp=primfact[j];ep=expoprimfact[j];
			      b1=itos(modis((GEN)form1[2],(pp<<1)));
			      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
			    }
			  for(j=1;j<=nbprimfact1;j++)
			    {
			      pp=primfact1[j];ep=expoprimfact1[j];
			      b1=itos(modis((GEN)form[2],(pp<<1)));
			      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
			    }
			  affrr(shiftr(mpadd(mulir(mulsi(EXP220,addii((GEN)form1[4],(GEN)form[4])),log2precis),mplog(absr(mulrr((GEN)form1[5],(GEN)form[5])))),-1),(GEN)vecexpo[s]);
			}
		    }
		}
	    }
	  if ((fpc!=1)&&(!fl2))
	    {
	      form=rhorealform3(form,D,isqrtD);nrho++;
	      if((sens)||(!signe(addii((GEN)form[1],(GEN)form[3]))))
		{form=rhorealform3(form,D,isqrtD);nrho++;}
	      else {setsigne((GEN)form[1],1);setsigne((GEN)form[3],-1);}
	      fl=gegal((GEN)form[1],(GEN)forminit[1]);
	      if(fl) fl=gegal((GEN)form[2],(GEN)forminit[2]);
	      if(fl) fl=gegal((GEN)form[3],(GEN)forminit[3]);
	    }
	}
      while((fpc!=1)&&(!fl)&&(!fl2));
      if(fpc==1)
	{
	  form=initializeform5(ex,tabpowprform,cardsub,D,isqrtD,sqrtD,sens);
	  pc=redrealform(primeform(D,stoi(base[s+1-RELSUP]),precreg),D,isqrtD,sqrtD,sens,precreg);
	  pc[4]=zero;affsr(1,(GEN)pc[5]);
	  form=comprealform5(form,pc,D,isqrtD,sqrtD,sens);
	  for(i=1;i<=nrho;i++) form=rhorealform5(form,D,isqrtD,sqrtD);
	  s++;
	  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]= -ex[i];
	  mat[s][s-RELSUP]= -1;
 	  for(j=1;j<=nbprimfact;j++)
	    {
	      pp=primfact[j];ep=expoprimfact[j];b=itos(modis((GEN)form[2],(pp<<1)));
	      if(b>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
	    }
	  affrr(shiftr(mpadd(mulir(mulsi(EXP220,(GEN)form[4]),log2precis),mplog(absr((GEN)form[5]))),-1),(GEN)vecexpo[s]);
	  if(!(mat[s][s-RELSUP])) {for(i=1;i<=sizemat;i++) mat[s][i]=0;s--;}
	}
      avma=av1;
    }
  nbtest=auxrel=0;
  while(s<sizebach)
    {
      for (i=1;i<=cardsub;i++) ex[i]=(mymyrand()>>qqq)+1;
      av1=avma;
      form=initializeform3(ex,tabpowprform,cardsub,D,isqrtD,sens);
      pp=base[s+1];
      pc=redrealform3(primeform(D,stoi(pp),precreg),D,isqrtD,sens);
      form=comprealform3(form,pc,D,isqrtD,sens);forminit=form;fl2=0;
      do
	{
	  fpc=factorisequad(form,s,pp,&nbprimfact,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  nbtest++;
	  if(fpc>1)
	    {
	      fpd=largeprime2(fpc,ex,s+1,cardsubbase,hashtab);
	      if(fpd&&(fpc!=pp)){auxrel++;s++;fl2=1;}
	    }
	  if((fpc!=1)&&(!fl2))
	    {
	      form=rhorealform3(form,D,isqrtD);
	      if((sens)||(!signe(addii((GEN)form[1],(GEN)form[3])))) 
		form=rhorealform3(form,D,isqrtD);
	      else{setsigne((GEN)form[1],1);setsigne((GEN)form[3],-1);}
	      fl=gegal((GEN)form[1],(GEN)forminit[1]);
	      if(fl) fl=gegal((GEN)form[2],(GEN)forminit[2]);
	      if(fl) fl=gegal((GEN)form[3],(GEN)forminit[3]);
	    }
	}
      while((fpc!=1)&&(!fl)&&(!fl2));
      if(fpc==1) s++;
      avma=av1;
    }
  matc=cgetg(sizematcol+1,19);
  for(i=1;i<=sizematcol;i++){p1=cgetg(2,18);matc[i]=(long)p1;p1[1]=vecexpo[i];}
  mit=hnfspec(mat,&pdep,&matc,vperm,&matalpha,sizematcol,sizemat,cardsub,&nlze,&col);
  kccopro=sizematcol;
 morerelreal:
  if(nlze)
    {
      if(!(vinvperm=(long*)malloc(sizeof(long)*sizemat+1))) err(talker,"out of memory10!");
      for(i=1;i<=sizemat;i++) vinvperm[vperm[i]]=i;
      s=0;extrarel=nlze+2;
      extramat=cgetg(extrarel+1,19);
      for(j=1;j<=extrarel;j++) extramat[j]=lgetg(sizemat+1,18);
      extramatc=cgetg(extrarel+1,19);
      for(i=1;i<=extrarel;i++) extramatc[i]=lgetg(2,18);
      while(s<extrarel)
	{
	  free(ex);
	  if(!(ex=(long*)malloc(sizeof(long)*(nlze+1)))) err(talker,"out of memory11!");
	  for (i=1;i<=nlze;i++) ex[i]=(mymyrand()>>qqq)+1;
	  form=gpuigs(primeform(D,stoi(labs(vectprime[vperm[1]])),precreg),ex[1]);
	  for (i=2;i<=nlze;i++)
	    form=compreal(form,gpuigs(primeform(D,stoi(labs(vectprime[vperm[i]])),precreg),ex[i]));
	  fpc=factorisequad(form,sizemat,limc,&lo,primfact,expoprimfact,badprim,nbbadprim,base,limhash);
	  if(fpc==1)
	    {
	      s++;p1=(GEN)extramat[s];
	      for(i=1;i<=nlze;i++) p1[i]=lstoi(-ex[i]);
	      for(i=nlze+1;i<=sizemat;i++) p1[i]=zero;
	      for(j=1;j<=lo;j++)
		{
		  pp=primfact[j];ep=expoprimfact[j];
		  b=itos(modis((GEN)form[2],(pp<<1)));
		  if(b>pp) ep= -ep;
		  k=vinvperm[numbase[pp]];
		  p1[k]=laddsg(ep,(GEN)p1[k]);
		}
	      coeff(extramatc,1,s)=form[4];
	    }
	}
      if(nrelsup) nlze=0;
      mit=hnfadd(mit,&pdep,&matc,vperm,&matalpha,kccopro,sizemat,col,&nlze,extramat,extramatc);
      free(vinvperm);kccopro+=extrarel;col=kccopro-(lg(matalpha)-1);
      if(nlze)
	{
	  nreldep++;
	  if(nreldep>5) 
	    {
	      free(vperm);free(vectprime);free(ex);free(base);free(numbase);free(subbase);
	      for(i=1;i<=sizematcol;i++) free(matinit[i]);free(matinit);free(mat);
	      for(i=1;i<=cardsub;i++) free(tabpowprform[i]);free(tabpowprform);
	      for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
	      if(cbach>5.99)
		err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
	      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);
	      goto increasereal;
	    }
	  else goto morerelreal;
	}
    }
  p1=gun;sizeofmit=lg(mit)-1;
  for(i=1;i<=sizeofmit;i++) p1=mulii(p1,gcoeff(mit,i,i));
  extrarel=col-sizeofmit;
  reg=gabs(gcoeff(matc,1,1));
  for(i=2;i<=extrarel;i++) reg=gcdrealnoer(gcoeff(matc,1,i),reg);
  if(gexpo(reg)<=-3)
    {
      nrelsup++;
      if(nrelsup>5) 
	{
	  free(vperm);free(vectprime);free(ex);free(base);free(numbase);free(subbase);
	  for(i=1;i<=sizematcol;i++) free(matinit[i]);free(matinit);free(mat);
	  for(i=1;i<=cardsub;i++) free(tabpowprform[i]);free(tabpowprform);
	  for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
	  if(cbach>5.99)
	    err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
	  else
	    {
	      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);
	      goto increasereal;
	    }
	}
      else {nlze=min(sizemat,nrelsup);goto morerelreal;}
    }
  c_1=gdiv(gmul2n(gmul(p1,reg),1),gmul(lfunc(D),sqrtD));  
  if(gcmpgs(gmul2n(c_1,2),3)<0) err(talker,"bug check in buchreal, PLEASE REPORT!!!");
  if(gcmpgs(gmul2n(c_1,1),3)>0)
    {
      nrelsup++;
      if(nrelsup>5) 
	{
	  free(vperm);free(vectprime);free(ex);free(base);free(numbase);free(subbase);
	  for(i=1;i<=sizematcol;i++) free(matinit[i]);free(matinit);free(mat);
	  for(i=1;i<=cardsub;i++) free(tabpowprform[i]);free(tabpowprform);
	  for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
	  if(cbach>5.99)
	    fprintf(stderr,"\n  ***   Warning: check is greater than 1.5, suggest increasing extra relations\n");
	  else
	    {
	      avma=av;cbach=min(2*cbach,6);cbach2=max(cbach2,cbach);
	      goto increasereal;
	    }
	}
      else {nlze=min(sizemat,nrelsup);goto morerelreal;}
    }
  u1u2=smith2(mit);u1=(GEN)u1u2[1];u2=(GEN)u1u2[2];
  met=gmul(u1,gmul(mit,u2));
  u1=ginv(u1);
  lo=lg(met)-1;
  c=0;for(i=1;i<=lo;i++) if(!gcmp1(gcoeff(met,i,i))) c++;
  basecl=cgetg(c+1,17);
  for(j=1;j<=c;j++)
    {
      p3=gpui(primeform(D,stoi(labs(vectprime[vperm[1]])),precreg),gcoeff(u1,1,j));
      for(i=2;i<=lo;i++)
        p3=gmul(p3,gpui(primeform(D,stoi(labs(vectprime[vperm[i]])),precreg),gcoeff(u1,i,j)));
      basecl[j]=(long)p3;
    }
  tetpil=avma;p4=cgetg(6,17);p4[1]=lcopy(p1);
  mot=cgetg(c+1,17);p4[2]=(long)mot;for(i=1;i<=c;i++) mot[i]=lcopy(gcoeff(met,i,i));
  p4[3]=lcopy(basecl);p4[4]=lcopy(reg);p4[5]=lcopy(c_1);
  free(base);free(vectprime);free(ex);free(subbase);free(numbase);
  free(vperm);
  for(i=1;i<=sizematcol;i++) free(matinit[i]);free(matinit);free(mat);
  for(i=1;i<=cardsub;i++) free(tabpowprform[i]);free(tabpowprform);
  for(i=1;i<HASHT;i++) {if(hashtab[i]) free(hashtab[i]);}
  return gerepile(av,tetpil,p4);
}


long *subfactorbasereal(GEN d, GEN *w, double ll, long precreg, long kc, long* vectprime, long* vperm, long *ptnbram, GEN isqrtD, GEN sqrtD, long sens)
{
  long i,j,k,nbidp,pp,*subbase,pro[100];
  double prod;
  GEN p1;

  i=0;*ptnbram=0;prod=1;if(ll<=1.1) ll=1.1;
  for(j=1;(j<=kc)&&(prod<=ll);j++)
    {
      pp=vectprime[j];
      if(pp>0) {pro[++i]=pp;prod*=pp;vperm[i]=j;}
      else (*ptnbram)++;
    }
  if(prod<=ll) {*ptnbram= -1;return (long*)0;}
  nbidp=i;
  for(k=1;k<j;k++) if(vectprime[k]<=0) vperm[++i]=k;
  *w=cgetg(nbidp+1,18);
  for(j=1;j<=nbidp;j++)
    {
      p1=redrealform(primeform(d,stoi(pro[j]),precreg),d,isqrtD,sqrtD,sens,precreg);
      (*w)[j]=(long)p1;
    }
  if(!(subbase=(long*)malloc(sizeof(long)*(nbidp+1)))) err(talker,"out of memory12!");
  subbase[0]=nbidp;
  for(j=1;j<=nbidp;j++) subbase[j]=pro[j];
  return subbase;
}
  
GEN **powsubfactreal(GEN w, long n, long a, GEN D, GEN isqrtD, GEN sqrtD, long sens, long precreg)
{
  long i,j;
  GEN **x;

  if(!(x=(GEN**)malloc(sizeof(long)*(n+1)))) err(talker,"out of memory13!");
  for(i=1;i<=n;i++) 
    {
      if(!(x[i]=(GEN*)malloc(sizeof(long)*(a+1)))) err(talker,"out of memory14!");
    }
  for(i=1;i<=n;i++)
    {
      j=0;x[i][j]=powrealform5((GEN)w[1],0,D,isqrtD,sqrtD,sens,precreg);
      while(j<a){j++;x[i][j]=comprealform5(x[i][j-1],(GEN)w[i],D,isqrtD,sqrtD,sens);}
    }
  return x;
}
  
long *largeprime(long q1, long *ex, long np, long nrho, long cardsubbase, long **hashtab)
{
  long hashv,*pt,cpt,i,*p1,fl;

  hashv=((q1&2047)-1)>>1;pt=hashtab[hashv];cpt=0;
  while(pt&&(q1!=pt[1])) {pt=(long*)(*pt);cpt++;}
  if(!pt)
    {
      if(!(p1=(long*)malloc((cardsubbase+4)<<TWOPOTBYTES_IN_LONG))) err(bucher6);
      p1[1]=q1;
      for(i=2;i<cardsubbase+2;i++) p1[i]=ex[i-1];p1[cardsubbase+2]=np;p1[cardsubbase+3]=nrho;
      p1[0]=cpt ? (long)hashtab[hashv] : 0;hashtab[hashv]=p1;return (long*)0;
    }
  else
    {
      fl=1;i=2;while(fl&&(i<(cardsubbase+2))) {fl=(pt[i]==ex[i-1]);i++;}
      if(fl) fl=(pt[i]==np);return fl ? (long*)0 : pt;
    }
}

GEN comprealform3(GEN x, GEN y, GEN D, GEN isqrtD, long sens)
{
  long av,tetpil;
  GEN s,n,d,d1,x1,x2,y1,y2,v1,v2,b3,c3,m,z,p1,r;
  
  av=avma;s=shifti(addii((GEN)x[2],(GEN)y[2]),-1);n=subii((GEN)y[2],s);
  d=bezout((GEN)y[1],(GEN)x[1],&y1,&x1);d1=bezout(s,d,&x2,&y2);
  v1=divii((GEN)x[1],d1);v2=divii((GEN)y[1],d1);
  m=addii(mulii(mulii(y1,y2),n),mulii((GEN)y[3],x2));setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v2,r)),1);
  c3=addii(mulii((GEN)y[3],d1),mulii(r,addii((GEN)y[2],p1)));
  z=cgetg(4,17);z[1]=lmulii(v1,v2);z[2]=laddii((GEN)y[2],b3);z[3]=ldivii(c3,v1);
  tetpil=avma;return gerepile(av,tetpil,redrealform3(z,D,isqrtD,sens));
}

GEN comprealform5(GEN x, GEN y, GEN D, GEN isqrtD, GEN sqrtD, long sens)
{
  long av,tetpil,ss;
  GEN s,n,d,d1,x1,x2,y1,y2,v1,v2,b3,c3,m,z,p1,r;
  
  av=avma;s=shifti(addii((GEN)x[2],(GEN)y[2]),-1);n=subii((GEN)y[2],s);
  d=bezout((GEN)y[1],(GEN)x[1],&y1,&x1);d1=bezout(s,d,&x2,&y2);
  v1=divii((GEN)x[1],d1);v2=divii((GEN)y[1],d1);
  m=addii(mulii(mulii(y1,y2),n),mulii((GEN)y[3],x2));setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v2,r)),1);
  c3=addii(mulii((GEN)y[3],d1),mulii(r,addii((GEN)y[2],p1)));
  z=cgetg(6,17);z[1]=lmulii(v1,v2);z[2]=laddii((GEN)y[2],b3);z[3]=ldivii(c3,v1);
  z[5]=lmulrr((GEN)x[5],(GEN)y[5]);
  if((ss=expo((GEN)z[5]))>=EXP220) {z[4]=laddii(addsi(1,(GEN)x[4]),(GEN)y[4]);setexpo((GEN)z[5],ss-EXP220);}
  else z[4]=laddii((GEN)x[4],(GEN)y[4]);
  tetpil=avma;return gerepile(av,tetpil,redrealform5(z,D,isqrtD,sqrtD,sens));
}

GEN sqrealform3(GEN x, GEN D, GEN isqrtD, long sens)
{
  long av,tetpil;
  GEN d1,x2,y2,v1,b3,c3,m,z,p1,r;
  
  av=avma;
  d1=bezout((GEN)x[2],(GEN)x[1],&x2,&y2);v1=divii((GEN)x[1],d1);
  m=mulii((GEN)x[3],x2);setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v1,r)),1);
  c3=addii(mulii((GEN)x[3],d1),mulii(r,addii((GEN)x[2],p1)));
  z=cgetg(4,17);z[1]=lmulii(v1,v1);z[2]=laddii((GEN)x[2],b3);z[3]=ldivii(c3,v1);
  tetpil=avma;return gerepile(av,tetpil,redrealform3(z,D,isqrtD,sens));
}

GEN sqrealform5(GEN x, GEN D, GEN isqrtD, GEN sqrtD, long sens)
{
  long av,tetpil,ss;
  GEN d1,x2,y2,v1,b3,c3,m,z,p1,r;
  
  av=avma;
  d1=bezout((GEN)x[2],(GEN)x[1],&x2,&y2);v1=divii((GEN)x[1],d1);
  m=mulii((GEN)x[3],x2);setsigne(m,-signe(m));
  r=modii(m,v1);b3=shifti((p1=mulii(v1,r)),1);
  c3=addii(mulii((GEN)x[3],d1),mulii(r,addii((GEN)x[2],p1)));
  z=cgetg(6,17);z[1]=lmulii(v1,v1);z[2]=laddii((GEN)x[2],b3);z[3]=ldivii(c3,v1);
  z[5]=lmulrr((GEN)x[5],(GEN)x[5]);
  if((ss=expo((GEN)z[5]))>=EXP220) {z[4]=laddii(addsi(1,(GEN)x[4]),(GEN)x[4]);setexpo((GEN)z[5],ss-EXP220);}
  else z[4]=lshifti((GEN)x[4],1);
  tetpil=avma;return gerepile(av,tetpil,redrealform5(z,D,isqrtD,sqrtD,sens));
}

GEN rhorealform3(GEN x, GEN D, GEN isqrtD)
{
  long av,tetpil,s;
  GEN y,p1,nn;
  
  av=avma;y=cgetg(4,17);y[1]=lcopy((GEN)x[3]);
  s=signe((GEN)y[1]);setsigne((GEN)y[1],1);
  if(cmpii(isqrtD,(GEN)y[1])>=0) nn=divii(addii(isqrtD,(GEN)x[2]),p1=shifti((GEN)y[1],1));
  else nn=divii(addii((GEN)y[1],(GEN)x[2]),p1=shifti((GEN)y[1],1));
  p1=mulii(nn,p1);y[2]=lsubii(p1,(GEN)x[2]);
  setsigne((GEN)y[1],s);p1=shifti(subii(mulii((GEN)y[2],(GEN)y[2]),D),-2);y[3]=ldivii(p1,(GEN)y[1]);
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN rhorealform5(GEN x, GEN D, GEN isqrtD, GEN sqrtD)
{
  long av,tetpil,s,ss;
  GEN y,p1,nn;
  
  av=avma;y=cgetg(6,17);y[1]=lcopy((GEN)x[3]);
  s=signe((GEN)y[1]);setsigne((GEN)y[1],1);
  if(cmpii(isqrtD,(GEN)y[1])>=0) nn=divii(addii(isqrtD,(GEN)x[2]),p1=shifti((GEN)y[1],1));
  else nn=divii(addii((GEN)y[1],(GEN)x[2]),p1=shifti((GEN)y[1],1));
  p1=mulii(nn,p1);y[2]=lsubii(p1,(GEN)x[2]);
  setsigne((GEN)y[1],s);p1=shifti(subii(mulii((GEN)y[2],(GEN)y[2]),D),-2);y[3]=ldivii(p1,(GEN)y[1]);
  y[5]=lmulrr(divrr(addir((GEN)x[2],sqrtD),subir((GEN)x[2],sqrtD)),(GEN)x[5]);
  if((ss=expo((GEN)y[5]))>=EXP220) {y[4]=laddsi(1,(GEN)x[4]);y[5]=lshiftr((GEN)y[5],-EXP220);}
  else y[4]=x[4];
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN redrealform3(GEN x, GEN D, GEN isqrtD, long sens)
{
  long fl,av=avma,tetpil;
  GEN y,p1;
  
  y=cgetg(4,17);y[1]=x[1];y[2]=x[2];y[3]=x[3];
  if((signe((GEN)x[2])<=0)||(cmpii((GEN)x[2],isqrtD)>0)) fl=1;
  else
    {
      p1=subii(isqrtD,shifti(absi((GEN)x[1]),1));
      if(signe(p1)<0) fl=(cmpii((GEN)x[2],absi(p1))<0);else fl=(cmpii((GEN)x[2],p1)<=0);
    }
  while(fl)
    {
      y=rhorealform3(y,D,isqrtD);
      if((signe((GEN)y[2])<=0)||(cmpii((GEN)y[2],isqrtD)>0)) fl=1;
      else
	{
	  p1=subii(isqrtD,shifti(absi((GEN)y[1]),1));
	  if(signe(p1)<0) fl=(cmpii((GEN)y[2],absi(p1))<0);else fl=(cmpii((GEN)y[2],p1)<=0);
	}
    }
  if(signe((GEN)y[1])<0)
    {
      if(sens||(!signe(addii((GEN)y[1],(GEN)y[3]))))
	{tetpil=avma;return gerepile(av,tetpil,rhorealform3(y,D,isqrtD));}
      else
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	  setsigne((GEN)y[1],1);setsigne((GEN)y[3],-1);return y;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN redrealform5(GEN x, GEN D, GEN isqrtD, GEN sqrtD, long sens)
{
  long fl,av=avma,tetpil;
  GEN y,p1;
  
  y=cgetg(6,17);y[1]=x[1];y[2]=x[2];y[3]=x[3];y[4]=x[4];y[5]=x[5];
  if((signe((GEN)x[2])<=0)||(cmpii((GEN)x[2],isqrtD)>0)) fl=1;
  else
    {
      p1=subii(isqrtD,shifti(absi((GEN)x[1]),1));
      if(signe(p1)<0) fl=(cmpii((GEN)x[2],absi(p1))<0);else fl=(cmpii((GEN)x[2],p1)<=0);
    }
  while(fl)
    {
      y=rhorealform5(y,D,isqrtD,sqrtD);
      if((signe((GEN)y[2])<=0)||(cmpii((GEN)y[2],isqrtD)>0)) fl=1;
      else
	{
	  p1=subii(isqrtD,shifti(absi((GEN)y[1]),1));
	  if(signe(p1)<0) fl=(cmpii((GEN)y[2],absi(p1))<0);else fl=(cmpii((GEN)y[2],p1)<=0);
	}
    }
  if(signe((GEN)y[1])<0)
    {
      if(sens||(!signe(addii((GEN)y[1],(GEN)y[3]))))
	{tetpil=avma;return gerepile(av,tetpil,rhorealform5(y,D,isqrtD,sqrtD));}
      else
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	  setsigne((GEN)y[1],1);setsigne((GEN)y[3],-1);return y;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN redrealform(GEN x, GEN D, GEN isqrtD, GEN sqrtD, long sens, long precreg)
{
  long fl,av=avma,tetpil;
  GEN y,p1;
  
  y=cgetg(6,17);y[1]=x[1];y[2]=x[2];y[3]=x[3];y[4]=zero;affsr(1,(GEN)(y[5]=lgetr(precreg)));
  if((signe((GEN)x[2])<=0)||(cmpii((GEN)x[2],isqrtD)>0)) fl=1;
  else
    {
      p1=subii(isqrtD,shifti(absi((GEN)x[1]),1));
      if(signe(p1)<0) fl=(cmpii((GEN)x[2],absi(p1))<0);else fl=(cmpii((GEN)x[2],p1)<=0);
    }
  while(fl)
    {
      y=rhorealform5(y,D,isqrtD,sqrtD);
      if((signe((GEN)y[2])<=0)||(cmpii((GEN)y[2],isqrtD)>0)) fl=1;
      else
	{
	  p1=subii(isqrtD,shifti(absi((GEN)y[1]),1));
	  if(signe(p1)<0) fl=(cmpii((GEN)y[2],absi(p1))<0);else fl=(cmpii((GEN)y[2],p1)<=0);
	}
    }
  if(signe((GEN)y[1])<0)
    {
      if(sens||(!signe(addii((GEN)y[1],(GEN)y[3]))))
	{tetpil=avma;return gerepile(av,tetpil,rhorealform5(y,D,isqrtD,sqrtD));}
      else
	{
	  tetpil=avma;y=gerepile(av,tetpil,gcopy(y));
	  setsigne((GEN)y[1],1);setsigne((GEN)y[3],-1);return y;
	}
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN powrealform5(GEN x, long n, GEN D, GEN isqrtD, GEN sqrtD, long sens, long precreg)
{
  GEN y,p1;
  long av,tetpil,fl;

  if(!n)
    {
      y=cgetg(6,17);y[1]=un;
      if(mpodd((GEN)x[2])) y[2]=(mpodd(isqrtD)) ? lcopy(isqrtD) : laddsi(-1,isqrtD);
      else {y[2]=lcopy(isqrtD);(((GEN)y[2])[lgef(isqrtD)-1])&=(~0x1);}
      av=avma;p1=subii(mulii((GEN)y[2],(GEN)y[2]),D);tetpil=avma;
      y[3]=lpile(av,tetpil,shifti(p1,-2));y[4]=zero;affsr(1,(GEN)(y[5]=lgetr(precreg)));
      return y;
    }
  av=avma;
  if(n<0)
    {
      p1=cgetg(6,17);p1[1]=x[1];p1[2]=lnegi((GEN)x[2]);p1[3]=x[3];
      p1[4]=lnegi(addsi(1,(GEN)x[4]));p1[5]=lshiftr(divir(gun,(GEN)x[5]),EXP220);n= -n;x=p1;
    }
  if(n==1) 
    {tetpil=avma;return gerepile(av,tetpil,redrealform(x,D,isqrtD,sqrtD,sens,precreg));}
  for(fl=0;n>1;n>>=1)
    {
      if(n&1)
	{if(fl) y=comprealform5(y,x,D,isqrtD,sqrtD,sens);else {fl=1;y=x;}}
      x=sqrealform5(x,D,isqrtD,sqrtD,sens);
    }
  tetpil=avma;y=fl ? comprealform5(y,x,D,isqrtD,sqrtD,sens) : gcopy(x);
  return gerepile(av,tetpil,y);
}

GEN initializeform3(long *ex, GEN **tabform, long cardtab, GEN d, GEN isqrtd, long sens)
{
  long av,tetpil,i;
  GEN form;

  av=avma;form=tabform[1][ex[1]];
  for(i=2;i<=cardtab;i++)
    {form=comprealform3(form,tabform[i][ex[i]],d,isqrtd,sens);}
  tetpil=avma;
  return gerepile(av,tetpil,gcopy(form));
}

GEN initializeform5(long *ex, GEN **tabform, long cardtab, GEN d, GEN isqrtd, GEN sqrtd, long sens)
{
  long av,tetpil,i;
  GEN form;

  av=avma;form=tabform[1][ex[1]];
  for(i=2;i<=cardtab;i++)
    form=comprealform5(form,tabform[i][ex[i]],d,isqrtd,sqrtd,sens);
  tetpil=avma;
  return gerepile(av,tetpil,gcopy(form));
}

void addcolumnmat(long **mat, long s, long cardsub, long *numbase, long *subbase, long *ex, long nbprimfact, long *primfact, long *expoprimfact, GEN form1, GEN log2precis, GEN vecexpo)
{
  long i,j,pp,b,ep;

  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]= -ex[i];
  for(j=1;j<=nbprimfact;j++)
    {
      pp=primfact[j];ep=expoprimfact[j];b=itos(modis((GEN)form1[2],(pp<<1)));
      if(b>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  affrr(shiftr(mpadd(mulir(mulsi(EXP220,(GEN)form1[4]),log2precis),
		     mplog(absr((GEN)form1[5]))),-1),(GEN)vecexpo[s]);
}

void addcolumnmat1(long **mat, long s, long cardsub, long *numbase, long *subbase, long *ex, long nbprimfact1, long *primfact1, long *expoprimfact1, GEN form1, long *fpd, long nbprimfact, long *primfact, long *expoprimfact, GEN form2, GEN log2precis, GEN vecexpo)
{
  long i,j,pp,b1,ep;

  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]=fpd[i+1]-ex[i];
  for(j=1;j<=nbprimfact;j++)
    {
      pp=primfact[j];ep=expoprimfact[j];b1=itos(modis((GEN)form2[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]-=ep;
    }
  for(j=1;j<=nbprimfact1;j++)
    {
      pp=primfact1[j];ep=expoprimfact1[j];b1=itos(modis((GEN)form1[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  affrr(shiftr(mpadd(mulir(mulsi(EXP220,subii((GEN)form1[4],(GEN)form2[4])),log2precis),
		     mplog(absr(divrr((GEN)form1[5],(GEN)form2[5])))),-1),(GEN)vecexpo[s]);
}

void addcolumnmat2(long **mat, long s, long cardsub, long *numbase, long *subbase, long *ex, long nbprimfact1, long *primfact1, long *expoprimfact1, GEN form1, long *fpd, long nbprimfact, long *primfact, long *expoprimfact, GEN form2, GEN log2precis, GEN vecexpo)
{
  long i,j,pp,b1,ep;

  for(i=1;i<=cardsub;i++) mat[s][numbase[subbase[i]]]=-fpd[i+1]-ex[i];
  for(j=1;j<=nbprimfact;j++)
    {
      pp=primfact[j];ep=expoprimfact[j];b1=itos(modis((GEN)form2[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  for(j=1;j<=nbprimfact1;j++)
    {
      pp=primfact1[j];ep=expoprimfact1[j];b1=itos(modis((GEN)form1[2],(pp<<1)));
      if(b1>pp) ep= -ep;mat[s][numbase[pp]]+=ep;
    }
  affrr(shiftr(mpadd(mulir(mulsi(EXP220,addii((GEN)form1[4],(GEN)form2[4])),log2precis),mplog(absr(mulrr((GEN)form1[5],(GEN)form2[5])))),-1),(GEN)vecexpo[s]);
}

void initbuchreal(GEN D, double cbach, double cbach2, long *precreg, GEN *log2precis, long *qqq, GEN *dr, double *drc, double *logd, GEN *sqrtD, GEN *isqrtD, double *lim, long *limc, long *limbach, long prec)
{
  long cp;
	 
  /* precision en digits decimaux=(#digits decimaux de D)+50 */
  /* ici CBUCH=15,q=27 */
  /* on prendra les p decomposes tels que prod(p)>lim dans la subbase */
  /* limc=Max(c.(log(D))^2,exp((1/8).sqrt(log(D).loglog(D)))) */
  /* limbach=Max(6.(log(D))^2,exp((1/8).sqrt(log(D).loglog(D)))) */
  /* subbase contient les p decomposes tels que prod(p)>sqrt(D) */
  /* cardsubbase=cardsub=subbase[0]=#subbase; */
  /* tabprform est la table des form[p] pour p dans subbase */
  /* nbram est le nombre de p divisant D elimines dans subbase */
  /* tabpowprform est la table des puissances des formes dans tabprform */

  *precreg=max(prec,(gexpo(D)>>TWOPOTBITS_IN_LONG)+5);
  *log2precis=glog(gdeux,*precreg);
  (*qqq)=BITS_IN_LONG-1-(long)ceil(log((double)CBUCH)/log(2.0));
  *dr=cgetr(3);affir(D,*dr);
  *drc=rtodbl(*dr);
  *logd=log(*drc);
  *sqrtD=gsqrt(D,*precreg);
  *isqrtD=gfloor(*sqrtD);
  *lim=sqrt(*drc);
  (*limc)=max((long)(cbach*(*logd)*(*logd)),13);
  cp=(long)exp(sqrt((*logd)*log((*logd))/8.0));
  if(cp>(*limc)) *limc=cp;
  (*limbach)=max(20,(long)(cbach2*(*logd)*(*logd)));
  if((*limc)>(*limbach)) *limbach=*limc;
}

#define LIMP 30000

GEN lfunc(GEN D)
{
  GEN y;
  long av=avma,tetpil,prime=0;
  byteptr p=diffptr;
  
  prime=*p++;affsr(1,y=cgetr(4));
  do
    {
      if(!*p) err(recprimer);
      y=mulsr(prime,divrs(y,prime-krogs(D,prime)));
      prime+=*p++;
    }
  while(prime<=LIMP);
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN buchall(GEN P, GEN gcbach, GEN gcbach2, GEN gRELSUP, long flun, long prec)
{
  long i,j,k,l,ii,ee,nn,ss,lgsub,n1,cp,av=avma,av0,tetpil,*p1,*ex,q,s,nbtest,av3;
  long N,R1,R2,RU,CO,PRECREG,LIMC,LIMC2,lim,blim,KC,KC2,KCZ,KCZ2,KCCO,KCCOPRO;
  long ip,nbcol3,nbrow3,ran,c,ic,jc,lo,extrarel,iz,pz,ncz;
  long col,k0,nlze,sizeofmit,sreg,ep,colnew;
  long **mat,**matinit,*vperm,*vinvperm;
  long limhash=0,fpc,mitcol,mitlin;
  long expoprimfact[500],primfact[500],*numprim,*prim,*numideal,nrelsup,nreldep;
  double cbach,cbach2,drc,mr,LOGD;
  GEN pgen1,pgen2,pgen3,pgen4,pgen5,dr,ideal,**vp,*idealbase,matarch,exu,fu,zu;
  GEN nf,D,F,BINV,primsubfactorbase,vectbase;
  GEN matgen,matpro,xarch,xreal,vei,p3,met,mot,mit,detmat,reg,mdet,lfun,z,clh;
  GEN matalpha,u1u2,u1,u2,RES,basecl,extramat,extramatc;
  GEN lambda,sublambda_1,c_1,den,matunit,image_mdet,pdep;


#ifdef DEBUG
  gettime();
#endif
  if(abs(flun)>1) RES=cgetg(11,17);
  else RES=flun?cgetg(9,17):cgetg(8,17);
  if(typ(gRELSUP)!=1) gRELSUP=gtrunc(gRELSUP);
  if(gsigne(gRELSUP)<=0) err(bucher5);
  N=lgef(P)-3;
  if(N<=1)
    {
      RES[1]=(long)polx[0];pgen1=cgetg(3,17);RES[2]=(long)pgen1;pgen1[1]=un;
      pgen1[2]=zero;pgen1=cgetg(3,17);RES[3]=(long)pgen1;pgen1[1]=un;pgen1[2]=un;
      pgen1=cgetg(2,17);RES[4]=(long)pgen1;pgen1[1]=un;
      pgen1=cgetg(4,17);RES[5]=(long)pgen1;pgen1[1]=un;pgen1[2]=lgetg(1,17);
      pgen1[3]=lgetg(1,17);
      RES[6]=un;RES[7]=un;
      if(flun) 
	{
	  pgen1=cgetg(3,17);RES[8]=(long)pgen1;
	  pgen1[1]=deux;pgen1[2]=lneg(gun);
	}
      if(abs(flun)>1) {RES[9]=lgetg(1,19);RES[10]=lstoi(EXP220);}
      if(flun>=0) {z=cgetg(2,19);z[1]=(long)RES;return z;}
      else
	{
	  z=cgetg(9,17);
	  z[1]=lgetg(1,19);z[2]=lgetg(1,19);z[3]=lgetg(1,19);
	  z[4]=lgetg(1,19);z[5]=lgetg(1,18);z[6]=lgetg(1,17);
	  z[7]=(long)initalg0(polx[0],5);
	  ncz=(flun==-1)?4:6;
	  pgen1=cgetg(ncz+1,17);z[8]=(long)pgen1;
	  for(i=1;i<=ncz;i++) pgen1[i]=lcopy((GEN)RES[i+4]);
	  return z;
	}
    }
  pgen1=factor(P);pgen2=(GEN)pgen1[1];pgen3=(GEN)pgen1[2];
  if((lg(pgen2)>2)||(cmpis((GEN)pgen3[1],1)>0)) err(bucher10);
#ifdef DEBUG
  printf("temps trivialites: ");output(gettime());
#endif
  nf=initalg0(P,max(8,prec));
#ifdef DEBUG
  printf("temps initalg0: ");output(gettime());
#endif
  RES[1]=nf[1];RES[2]=nf[2];pgen1=cgetg(3,17);RES[3]=(long)pgen1;pgen1[1]=nf[3];pgen1[2]=nf[4];
  R1=itos((GEN)((GEN)nf[2])[1]);R2=(N-R1)/2;RU=R1+R2;
  F=(GEN)nf[4];D=(GEN)nf[3];RES[4]=nf[7];
  BINV=(GEN)nf[8];
  zu=rootsof1(nf);
  CO=itos(gRELSUP)+RU-1;
  PRECREG=max(prec,(gexpo(D)>>TWOPOTBITS_IN_LONG)+N+3);
  dr=cgetr(3);affir(D,dr);drc=rtodbl(dr);
  LOGD=log(fabs(drc));mr=LOGD*log(LOGD);
  lim=max((long)(exp(-(N+0.))*sqrt(2*PI*N*fabs(drc))*pow(4/PI,R2+0.)),3);
  cbach=gtodouble(gcbach);cbach2=gtodouble(gcbach2);cp=(long)exp(sqrt(mr/8.0));
  av0=avma;
 increasegen:
  nreldep=nrelsup=0;
  LIMC=(long)(cbach*LOGD*LOGD);
  if(cp>LIMC) LIMC=cp;
  LIMC2=max(10*N,(long)(cbach2*LOGD*LOGD));
  if(LIMC>LIMC2) LIMC2=LIMC;
#ifdef DEBUG
  printf("temps rootsof1 et/ou trivialites: ");output(gettime());
#endif
  KC2=factorbasegen(nf,LIMC2,LIMC,&numprim,&prim,&numideal,&idealbase,&KC,&KCZ,&KCZ2,&lfun);
#ifdef DEBUG
  printf("temps creation de la factor base: ");output(gettime());
#endif
  if(!KC)
    {
      if(cbach>11.99) 
	err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
      avma=av0;cbach=min(2*cbach,12);cbach2=max(cbach2,cbach);goto increasegen;
    }
  z=gmul(gmul(gmul(gpuigs(gdeux,-R1),gpuigs(gmul2n(mppi(5),1),-R2)),gsqrt(gabs(D),5)),lfun);
  vectbase=cgetg(KC+1,18);
  for(i=1;i<=KCZ;i++) 
    {
      ip=numideal[prim[i]];pgen1=idealbase[i];n1=lg(pgen1);
      for(j=1;j<n1;j++) vectbase[ip+j]=pgen1[j];
    }
  vperm=(long*)malloc(sizeof(long)*(KC+1));for(i=1;i<=KC;i++) vperm[i]=i;
#ifdef DEBUG
  printf("temps creation vperm et vectbase: ");output(gettime());
#endif
  primsubfactorbase=subfactorbasegen(N,min(lim,LIMC2),vectbase,vperm,&ss);
#ifdef DEBUG
  printf("temps creation de la sous-factor base: ");output(gettime());
#endif
  if(ss==-1) 
    {
      free(vperm);
      if(cbach>11.99) 
	err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
      avma=av0;cbach=min(2*cbach,12);cbach2=max(cbach2,cbach);goto increasegen;
    }
  lgsub=lg(primsubfactorbase);
  vp=powsubfactgen(nf,primsubfactorbase,CBUCH+1,PRECREG);
#ifdef DEBUG
  printf("temps powsubfactgen: ");output(gettime());
#endif
  KCCO=KC+max(CO,ss);
#ifdef DEBUG
  printf("KC = %ld, KCCO = %ld, lgsub = %ld\n",KC,KCCO,lgsub-1);fflush(stdout);
#endif
  mat=(long **)malloc(sizeof(long)*(KCCO+1));
  matinit=(long **)malloc(sizeof(long)*(KCCO+1));
  matarch=cgetg(KCCO+1,19);
  for(i=1;i<=KCCO;i++)
    {
      p1=(long *)malloc(sizeof(long)*(KC+1));matinit[i]=mat[i]=p1;
      for(j=1;j<=KC;j++) p1[j]=0;
      pgen1=cgetg(RU+1,18);matarch[i]=(long)pgen1;
      for(j=1;j<=RU;j++) 
	{
	  pgen2=cgetg(3,6);pgen1[j]=(long)pgen2;
	  pgen2[1]=lgetr(PRECREG);pgen2[2]=lgetr(PRECREG);
	}
    }
  ex=(long*)malloc(lgsub<<TWOPOTBYTES_IN_LONG);exu=cgetg(RU+1,17);
  q=BITS_IN_LONG-1-(long)ceil(log((double)CBUCH)/log(2.0));
  s=0;
  for(i=1;i<=KCZ;i++)
    {
      ip=numideal[prim[i]];pgen1=idealbase[i];
      n1=lg(pgen1);k=0;
      for(j=1;j<n1;j++) k+=(itos((GEN)((GEN)pgen1[j])[3])*itos((GEN)((GEN)pgen1[j])[4]));
      if(k==N)
	{
	  s++;for(j=1;j<n1;j++) mat[s][ip+j]=itos((GEN)((GEN)pgen1[j])[3]);
	  for(j=1;j<=RU;j++) gaffsg(0,(GEN)((GEN)matarch[s])[j]);
	}
    }
  nbtest=ss=s;
#ifdef DEBUG
  printf("temps creation mat et matarch: ");output(gettime());
  printf("Apres relations triviales, s = nbtest = %ld\n",s);fflush(stdout);
#endif
/*
  pgen1=minimprim((GEN)((GEN)nf[5])[3],(long)(N*pow(4.*((double)LIMC)*LIMC,(double)(4./N))),1000);
  k=itos((GEN)pgen1[1])>>1;pgen1=(GEN)pgen1[3];
#ifdef DEBUG
  printf("temps minimprim: ");output(gettime());
  printf("place de stockage prevue dans minim = 1000, nombre trouve = %ld\n",k);fflush(stdout);
#endif
  pgen1=vecsort(pgen1,gun);
  pgen3=idmat(N);
  for(k=1;(s<KCCO)&&(k<lg(pgen1));k++)
    {
      av3=avma;
      pgen2=(GEN)((GEN)pgen1[k])[2];
      j=N;while((j>=2)&&(!signe((GEN)pgen2[j]))) --j;
      if(j>1)
	{
	  pgen4=cgetg(N+1,19);
	  for(i=1;i<=N;i++) pgen4[i]=(long)element_mulh(nf,j,i,pgen2,(GEN)pgen3[i]);
	  pgen5=content(pgen4);if(!gcmp1(pgen5)) pgen4=gdiv(pgen4,pgen5);
	  ideal=cgetg(3,17);ideal[1]=(long)hnf(pgen4);
	  pgen5=gmul((GEN)((GEN)nf[5])[1],pgen2);
	  pgen4=cgetg(RU+1,17);ideal[2]=(long)pgen4;
	  for(i=1;i<=R1;i++) pgen4[i]=(long)glog((GEN)pgen5[i],PRECREG);
	  for(i=R1+1;i<=RU;i++) pgen4[i]=lmul2n(glog((GEN)pgen5[i],PRECREG),1);
	  fpc=factorisegen(nf,(GEN)ideal[1],KCZ,LIMC,primfact,expoprimfact,prim,idealbase,numideal,numprim,limhash);
	  nbtest++;
	  if (fpc)
	    {
	      s++;
	      for(j=1;j<=primfact[0];j++) mat[s][primfact[j]]=expoprimfact[j];
	      for(j=1;j<=RU;j++) gaffect((GEN)((GEN)ideal[2])[j],(GEN)((GEN)matarch[s])[j]);
	    }
	}
      avma=av3;
    }
#ifdef DEBUG
  printf("temps relations de petite norme: ");output(gettime());
  printf("Apres relations de petite norme, s/nbtest = %ld/%ld\n",s,nbtest);fflush(stdout);
#endif
*/
  pgen2=cgetg(2,17);pgen2[1]=(long)vp[1][0];
  for(iz=1;s<KCCO;iz++)
    {
      pgen1=(iz<=KCZ)?idealbase[numprim[pz=prim[iz]]]:pgen2;
      for(j=1;j<lg(pgen1);j++) 
	{
	  for(i=1;i<lgsub;i++) ex[i]=mymyrand()>>q;
	  av3=avma;
	  ideal=(iz<=KCZ)?idealmulprime(nf,vp[1][0],(GEN)pgen1[j]):vp[1][0];
	  for (i=1;i<lgsub;i++) ideal=idealmulh(nf,ideal,(GEN)vp[i][ex[i]]);
	  for(i=1;i<=RU;i++) exu[i]=lstoi((mymyrand()>>q)+1);
	  ideal=ideallllred(nf,ideal,exu,PRECREG);
#ifdef DEBUG
	  printf("s = %ld, nbtest = %ld, ideal = ",s,nbtest);
	  output((GEN)ideal[1]);
#endif
	  fpc=factorisegen(nf,(GEN)ideal[1],KCZ,LIMC,primfact,expoprimfact,prim,idealbase,numideal,numprim,limhash);
	  nbtest++;
	  if (fpc&&(s<KCCO))
	    {
	      s++;
	      for(i=1;i<lgsub;i++) mat[s][vperm[i]]= -ex[i];
	      for(i=1;i<=primfact[0];i++) mat[s][primfact[i]]+=expoprimfact[i];
	      if(iz<=KCZ) mat[s][numideal[pz]+j]--;
	      for(i=1;i<=RU;i++) gaffect((GEN)((GEN)ideal[2])[i],(GEN)((GEN)matarch[s])[i]);
	    }
	  else {if(s<KCCO) j--;}
	  avma=av3;
	}
    }
#ifdef DEBUG
  printf("temps pour trouver les relations aleatoires: ");output(gettime());
  printf("nbrelations/nbtest = %ld/%ld\n",s,nbtest);fflush(stdout);
#endif
  k0=lgsub-1;
  mit=hnfspec(mat,&pdep,&matarch,vperm,&matalpha,KCCO,KC,k0,&nlze,&col);
#ifdef DEBUG
  printf("temps hnfspec: ");output(gettime());
#endif
  mitcol=lg(mit)-1;
  KCCOPRO=KCCO;
 morerelgen:
  if(nlze)
    {
      mitcol=lg(mit)-1;
      vinvperm=(long*)malloc(sizeof(long)*(KC+1));
      for(i=1;i<=KC;i++) vinvperm[vperm[i]]=i;
      s=0;extrarel=nlze+2;
      extramat=cgetg(extrarel+1,19);extramatc=cgetg(extrarel+1,19);
      for(j=1;j<=extrarel;j++) 
	{
	  extramat[j]=lgetg(KC+1,18);pgen1=cgetg(RU+1,18);
	  extramatc[j]=(long)pgen1;
	  for(i=1;i<=RU;i++) 
	    {
	      pgen2=cgetg(3,6);pgen1[i]=(long)pgen2;
	      pgen2[1]=lgetr(PRECREG);pgen2[2]=lgetr(PRECREG);
	    }
	}
      free(ex);ex=(long*)malloc(sizeof(long)*(nlze+1));
      while(s<extrarel)
	{
	  for (i=1;i<=nlze;i++) ex[i]=mymyrand()>>q;
	  for(i=1;i<=RU;i++) exu[i]=lstoi((mymyrand()>>q)+1);
	  ideal=idealpowprime(nf,(GEN)vectbase[vperm[1]],stoi(ex[1]),PRECREG);
	  for (i=2;i<=nlze;i++)
	    {
	      pgen1=idealpowprime(nf,(GEN)vectbase[vperm[i]],stoi(ex[i]),PRECREG);
	      ideal=idealmulh(nf,ideal,pgen1);
	    }
	  ideal=ideallllred(nf,ideal,exu,PRECREG);
	  fpc=factorisegen(nf,(GEN)ideal[1],KCZ,LIMC,primfact,expoprimfact,prim,idealbase,numideal,numprim,limhash);
	  if(fpc==1)
	    {
	      s++;pgen1=(GEN)extramat[s];
	      for(i=1;i<=nlze;i++) pgen1[i]=lstoi(-ex[i]);
	      for(i=nlze+1;i<=KC;i++) pgen1[i]=zero;
	      for(i=1;i<=primfact[0];i++)
		{
		  k=vinvperm[primfact[i]];
		  ep=expoprimfact[i];
		  pgen1[k]=laddsg(ep,(GEN)pgen1[k]);
		}
	      for(i=1;i<=RU;i++) gaffect((GEN)((GEN)ideal[2])[i],(GEN)((GEN)extramatc[s])[i]);
	    }
	}
#ifdef DEBUG
      printf("temps calcul relations supplementaires: ");output(gettime());
#endif
      if(nrelsup) nlze=0;
      mit=hnfadd(mit,&pdep,&matarch,vperm,&matalpha,KCCOPRO,KC,col,&nlze,extramat,extramatc);
#ifdef DEBUG
  printf("temps hnfadd: ");output(gettime());
#endif
      free(vinvperm);KCCOPRO+=extrarel;col=KCCOPRO-(lg(matalpha)-1);
      if(nlze)
	{
	  nreldep++;
	  if(nreldep>5) 
	    {
	      for(i=1;i<lg(primsubfactorbase);i++) free(vp[i]);free(vp);
	      free(numprim);free(prim);free(numideal);free(idealbase);
	      free(ex);for(i=1;i<=KCCO;i++) free(matinit[i]);free(matinit);free(mat);
	      free(vperm);
	      if(cbach>11.99) 
		err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
	      else
		{
		  avma=av0;cbach=min(2*cbach,12);cbach2=max(cbach2,cbach);
		  goto increasegen;
		}
	    }
	  else goto morerelgen;
	}
    }
  sizeofmit=lg(mit)-1;sreg=col-sizeofmit;
  xarch=cgetg(sreg+1,19);for(j=1;j<=sreg;j++) xarch[j]=matarch[j];
  xreal=greal(xarch);
  vei=cgetg(RU+1,18);for(i=1;i<=RU;i++) vei[i]=(i<=R1)?un:deux;
  mdet=cgetg(sreg+2,19);for(j=2;j<=sreg+1;j++) mdet[j]=xreal[j-1];
  mdet[1]=(long)vei;
#ifdef DEBUG
  printf("temps trivialites xarch, xreal, mdet: ");output(gettime());
#endif
  image_mdet=imagereel(mdet,PRECREG);
#ifdef DEBUG
  printf("temps imagereel: ");output(gettime());
#endif
  reg=gdivgs(gabs(detreel(image_mdet),PRECREG),N);
#ifdef DEBUG
  printf("temps detreel: ");output(gettime());
#endif
  if(gexpo(reg)<=-4)
    {
      nrelsup++;
      if(nrelsup>5) 
	{
	  for(i=1;i<lg(primsubfactorbase);i++) free(vp[i]);free(vp);
	  free(numprim);free(prim);free(numideal);free(idealbase);
	  free(ex);for(i=1;i<=KCCO;i++) free(matinit[i]);free(matinit);free(mat);
	  free(vperm);
	  if(cbach>11.99) 
	    err(talker,"sorry, buchxxx is not able to compute this field PLEASE REPORT!!!");
	  else
	    {
	      avma=av0;cbach=min(2*cbach,12);cbach2=max(cbach2,cbach);
	      goto increasegen;
	    }
	}
      else {nlze=min(KC,nrelsup);goto morerelgen;}
    }
  lambda=invmulmat(image_mdet,xreal);
  sublambda_1=cgetg(sreg+1,19);
  for(i=1;i<=sreg;i++) 
    {
      pgen1=cgetg(RU,18);sublambda_1[i]=(long)pgen1;pgen2=(GEN)lambda[i];
      for(j=1;j<RU;j++) pgen1[j]=pgen2[j+1];
    }
#ifdef DEBUG
  printf("temps trivialites lambda: ");output(gettime());
#endif
  if(sizeofmit)
    {
      pgen1=gun;
      for(i=1;i<=sizeofmit;i++) pgen1=mulii(pgen1,gcoeff(mit,i,i));
      fflush(stdout);clh=pgen1;
      u1u2=smith2(mit);u1=(GEN)u1u2[1];u2=(GEN)u1u2[2];
      met=gmul(u1,gmul(mit,u2));u1=ginv(u1);
    }
  else {clh=gun;met=cgetg(1,19);u1=cgetg(1,19);}
#ifdef DEBUG
  printf("temps smith/groupe de classes: ");output(gettime());
#endif
  c_1=gmul2n(gdiv(reg,gdiv(gmul(z,(GEN)zu[1]),clh)),1);
  sublambda_1=bestappr(sublambda_1,c_1);
  den=denom(sublambda_1);
  if(gcmp(den,c_1)>0) err(talker,"denominator too large, sorry");
  pgen1=(GEN)lllkerim(gmul(sublambda_1,den))[2];
  reg=gabs(gmul(reg,det(gmul(sublambda_1,pgen1))),PRECREG);
  c_1=gmul2n(gdiv(reg,gdiv(gmul(z,(GEN)zu[1]),clh)),1);
#ifdef DEBUG
  printf("temps bestappr/regulateur: ");output(gettime());
#endif
  if(gcmpgs(gmul2n(c_1,1),3)<0) err(talker,"bug check in buchgen, PLEASE REPORT!!!");
  if(gcmpgs(c_1,3)>0) 
    {
      nrelsup++;
      if(nrelsup>5) 
	{
	  for(i=1;i<lg(primsubfactorbase);i++) free(vp[i]);free(vp);
	  free(numprim);free(prim);free(numideal);free(idealbase);
	  free(ex);for(i=1;i<=KCCO;i++) free(matinit[i]);free(matinit);free(mat);
	  free(vperm);
	  if(cbach>11.99) 
	    fprintf(stderr,"\n  ***   Warning: check is greater than 1.5, suggest increasing extra relations\n");
	  else
	    {
	      avma=av0;cbach=min(2*cbach,12);cbach2=max(cbach2,cbach);
	      goto increasegen;
	    }
	}
      else {nlze=min(KC,nrelsup);goto morerelgen;}
    }
  xarch=cleancol(gmul(xarch,pgen1),N,RU,PRECREG);
  lo=lg(met)-1;
  c=0;for(i=1;i<=lo;i++) if(!gcmp1(gcoeff(met,i,i))) c++;
#ifdef DEBUG
  printf("temps trivialites cleancol: ");output(gettime());
#endif
  basecl=cgetg(c+1,17);
  for(j=1;j<=c;j++)
    {
      p3=(GEN)idealpowprime(nf,(GEN)vectbase[vperm[1]],pgen1=gcoeff(u1,1,j),PRECREG)[1];
      if(signe(pgen1)<0) p3=numer(p3);
      for(i=2;i<=lo;i++)
	{
	  pgen1=gcoeff(u1,i,j);s=signe(pgen1);
	  if(s)
	    {
	      if(s>0)
		p3=idealmulh(nf,p3,(GEN)idealpowprime(nf,(GEN)vectbase[vperm[i]],pgen1,PRECREG)[1]);
	      else
		p3=idealmulh(nf,p3,numer((GEN)idealpowprime(nf,(GEN)vectbase[vperm[i]],pgen1,PRECREG)[1]));
	      p3=ideallllred(nf,p3,gzero,PRECREG);
	    }
	}
      basecl[j]=(long)p3;
    }
  mot=cgetg(c+1,17);for(i=1;i<=c;i++) mot[i]=coeff(met,i,i);
  pgen1=cgetg(4,17);RES[5]=(long)pgen1;pgen1[1]=(long)clh;pgen1[2]=(long)mot;
  pgen1[3]=(long)basecl;
#ifdef DEBUG
  printf("temps generateurs du groupe de classes: ");output(gettime());
#endif
  RES[6]=(long)reg;
  z=gdiv(gmul(reg,clh),gmul((GEN)zu[1],z));
  RES[7]=(long)z;
  if(flun)
    {
      pgen1=cgetg(3,17);RES[8]=(long)pgen1;
      pgen1[1]=zu[1];pgen1[2]=lmul((GEN)nf[7],(GEN)zu[2]);
    }
  if(abs(flun)>1)
    {
      fu=getfu(nf,xarch,reg,&c,PRECREG);
      if(lg(fu)>1)
	{
	  pgen1=gmul((GEN)nf[7],fu);
	  for(j=1;j<lg(fu);j++) 
	    if(!gcmp1(gabs(gnorm(gmodulcp((GEN)pgen1[j],(GEN)nf[1])))))
	      {
		fprintf(stderr,"\n  ***   Warning: fundamental units too large, not given\n");
		c=0;fu=cgetg(1,17);
	      }
	}
      else c=0;
      RES[9]=c?lmul((GEN)nf[7],fu):(long)fu;
      RES[10]=lstoi(c);
#ifdef DEBUG
      printf("temps getfu: ");output(gettime());
#endif
    }
  tetpil=avma;
  if(flun>=0) {z=cgetg(2,19);z[1]=lcopy(RES);}
  else
    {
      z=cgetg(9,17);z[1]=lcopy(mit);z[2]=lcopy(matalpha);
      z[3]=lcopy(xarch);
      colnew=lg(matarch)-1-sreg;pgen1=cgetg(colnew+1,19);z[4]=(long)pgen1;
      for(j=1;j<=colnew;j++) 
	pgen1[j]=(long)cleancol((GEN)matarch[j+sreg],N,RU,PRECREG);
      z[5]=lcopy(vectbase);pgen1=cgetg(KC+1,18);z[6]=(long)pgen1;
      for(i=1;i<=KC;i++) pgen1[i]=lstoi(vperm[i]);
      z[7]=lcopy(nf);
      ncz=(flun==-1)?4:6;
      pgen1=cgetg(ncz+1,17);z[8]=(long)pgen1;
      for(i=1;i<=ncz;i++) pgen1[i]=lcopy((GEN)RES[i+4]);
    }
  for(i=1;i<lg(primsubfactorbase);i++) free(vp[i]);free(vp);
  free(numprim);free(prim);free(numideal);free(idealbase);
  free(ex);for(i=1;i<=KCCO;i++) free(matinit[i]);free(matinit);free(mat);
  free(vperm);
  return gerepile(av,tetpil,z);
#ifdef DEBUG
  printf("temps free finaux: ");output(gettime());
#endif
}

GEN buchgen(GEN P, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec)
{
  return buchall(P,gcbach,gcbach2,gRELSUP,0,prec);
}

GEN buchgenfu(GEN P, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec)
{
  return buchall(P,gcbach,gcbach2,gRELSUP,2,prec);
}

GEN buchinit(GEN P, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec)
{
  return buchall(P,gcbach,gcbach2,gRELSUP,-1,prec);
}

GEN buchinitfu(GEN P, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec)
{
  return buchall(P,gcbach,gcbach2,gRELSUP,-2,prec);
}

/* Calcul de la base des sous-facteurs pour generer les relations entre ideaux. */

GEN subfactorbasegen(long N, long m, GEN vectbase, long *vperm, long* ptss)
{
  long av=avma,tetpil,i,j,k,l,s,s1,s2,e,nbidp,ss=0;
  GEN y,y1,y2,y3,p1,perm,perm1;
  double prod;

  k=lg(vectbase)-1;
  y=cgetg(k+1,18);y1=cgetg(k+1,18);y3=cgetg(k+1,18);
  s=0;s1=0;
  for(i=1;i<=k;i++) 
    {
      p1=(GEN)vectbase[i];y3[i]=(long)gpui((GEN)p1[1],(GEN)p1[4]);
      if((i>1)&&cmpii((GEN)p1[1],(GEN)((GEN)vectbase[i-1])[1]))
	{
	  if(s==N) y1[i-1]=zero;
	  s=0;
	  if(s1==N) ss++;
	  s1=0;
	}
      s2=(e=itos((GEN)p1[3]))*itos((GEN)p1[4]);
      s+=s2;s1+=s2;
      if(e>1) {y1[i]=zero;s=0;}
      else y1[i]=y3[i];
    }
  if(s==N) y1[k]=zero;
  if(s1==N) ss++;
  perm=indexsort(y1);
  i=1;while((i<=k)&&(!signe((GEN)y1[itos((GEN)(perm[i]))]))) i++;
  if(i>k) {*ptss= -1;avma=av;return gzero;}
  nbidp=0;prod=1.0;
  while((nbidp<=(k-i))&&(prod<m+0.5))
    {nbidp++;prod*=gtodouble((GEN)y1[itos((GEN)perm[nbidp+i-1])]);}
  if(prod<m) {*ptss= -1;avma=av;return gzero;}
  for(j=1;j<=nbidp;j++) y3[itos((GEN)(perm[j+i-1]))]=zero;
  perm1=indexsort(y3);
  for(j=1;j<=nbidp;j++) vperm[j]=itos((GEN)(perm[j+i-1]));
  for(j=nbidp+1;j<=k;j++) vperm[j]=itos((GEN)(perm1[j]));
  tetpil=avma;y2=cgetg(nbidp+1,18);
  for(j=1;j<=nbidp;j++) y2[j]=lcopy((GEN)vectbase[itos((GEN)perm[j+i-1])]);
  *ptss=ss;return gerepile(av,tetpil,y2);
}

/*Calcul la table des puissances des ideaux premiers de la base des sous-facteurs ;
w est la base des sous-facteurs, a est l'exposant maximum calcule : 
renvoie une matrice x de GEN , x[j][i] contenant
l'ideal (P_i)^j, sous forme HNF */

GEN **powsubfactgen(GEN nf, GEN w, long a, long PRECREG)
{
  long i,j,n=lg(w)-1,N=lgef((GEN)nf[1])-3,R1,R2,RU;
  GEN **x,pgen1,id;

  R1=itos((GEN)((GEN)nf[2])[1]);R2=(N-R1)/2;RU=R1+R2;
  x=(GEN**)malloc(sizeof(long)*(n+1));
  for(i=1;i<=n;i++) x[i]=(GEN*)malloc(sizeof(long)*(a+1));
  id=cgetg(3,17);id[1]=(long)idmat(N);pgen1=cgetg(RU+1,17);
  id[2]=(long)pgen1;for(i=1;i<=RU;i++) pgen1[i]=zero;
  for(i=1;i<=n;i++) 
    {
      x[i][0]=id;
      for(j=1;j<=a;j++) 
	x[i][j]=(j==1)?idealmulprime(nf,id,(GEN)w[i]):idealmulprimered(nf,x[i][j-1],(GEN)w[i],PRECREG);
    }
  return x;
}

GEN **newpowsubfactgen(GEN nf, GEN w, long a, long PRECREG)
{
  long i,j,n=lg(w)-1,N=lgef((GEN)nf[1])-3,R1,R2,RU;
  GEN **x,pgen1,pgen2,pgen3,pgen4,pgen5,pgen6,id;

  R1=itos((GEN)((GEN)nf[2])[1]);R2=(N-R1)/2;RU=R1+R2;
  x=(GEN**)malloc(sizeof(long)*(n+1));
  for(i=1;i<=n;i++) x[i]=(GEN*)malloc(sizeof(long)*(a+1));
  id=cgetg(3,17);id[1]=(long)idmat(N);pgen1=cgetg(RU+1,17);
  id[2]=(long)pgen1;for(i=1;i<=RU;i++) pgen1[i]=zero;
  for(i=1;i<=n;i++) 
    {
      x[i][0]=id;
      pgen1=(GEN)w[i];x[i][1]=idealmulprime(nf,id,pgen1);
      pgen2=cgetg(6,17);pgen2[1]=pgen1[1];pgen2[2]=pgen1[5];pgen2[5]=pgen1[2];
      pgen2[3]=pgen2[4]=un;pgen4=x[i][1];
      pgen5=idealmulprime(nf,x[i][0],pgen2);
      pgen6=(GEN)pgen1[1];
      for(j=2;j<=a;j++)
	{
	  pgen4=idealmulprime(nf,pgen4,pgen1);
	  pgen5=idealmulprime(nf,pgen5,pgen2);
	  pgen6=mulii(pgen6,(GEN)pgen1[1]);
	  pgen3=minideal(nf,pgen5,gzero,2*PRECREG);
	  x[i][j]=idealmul(nf,pgen3,pgen4);x[i][j][1]=ldiv((GEN)(x[i][j][1]),pgen6);
	}
    }
  return x;
}

/*Calcul de la base de facteurs : n2 est la borne pour les nombres premiers
qui vont etre testes pour obtenir toutes les relations et la norme des ideaux
choisis, n est la borne des nombres premiers qui vont etre testes pour les 
relations primaires (constante de Bach).
Cette fonction cree et affecte un certain nombre de variables :
numprimfactorbase[i] est l'indice k tel que primfactorbase[k]=i (si i n'est
pas premier, numprimfactorbase[i]=0), ; primfactorbase[i] contient le i-eme
nombre premier utilise pour construire la base de facteurs ; numideal[i] est
l'indice k tel que idealbase[k]=i ; idealbase[i] contient les ideaux premiers
de norme convenable et au dessus du nombre premier numero i ;
KCZ contient le nombre de nombres premiers utilises pour construire la base 
de facteurs jusqu'a la constante de Bach, KC contient le nombre d'ideaux 
premiers jusqu'a la constante de Bach ; KCZ2 contient le nombre de nombres 
premiers de la base de facteurs au total ; enfin, la fonction renvoie le 
nombre d'ideaux premiers utilises au total. On n'utilise que des nombres
premiers ne divisant pas l'index F, et non inertes.*/

long factorbasegen(GEN nf, long n2, long n, long **ptnumprim, long **ptprim, long **ptnum, GEN **ptideal, long *ptkc, long *ptkcz, long *ptkcz2, GEN *ptlfun)
{
  byteptr delta=diffptr;
  long av1,tetpil,i,j,k,pp,fl,lon,ip,*numprimfactorbase,*primfactorbase;
  long *numideal,ip0;
  GEN prim,pgen1,pgen2,pgen3,pgen4,*idealbase,lfun;

  numprimfactorbase=(long*)malloc(sizeof(long)*(n2+1));
  primfactorbase=(long*)malloc(sizeof(long)*(n2+1));
  numideal=(long*)malloc(sizeof(long)*(n2+1));
  idealbase=(GEN*)malloc(sizeof(long)*(n2+1));
  lfun=cgetr(5);affsr(1,lfun);*ptlfun=lfun;
  i=0;pp=*delta++;fl=1;ip=0;*ptkc=0;
  while(pp<=n2)
    {
      av1=avma;
      prim=stoi(pp);pgen1=primedec(nf,prim);
      lon=lg(pgen1);divriz(mulir(subis(prim,1),lfun),prim,lfun);
      if((lon>2)||cmpis((GEN)((GEN)pgen1[1])[3],1)>0)
	{
	  ip0=ip;
	  pgen2=cgetg(lon,18);
	  for(j=0,k=1;k<lon;k++)
	    {
	      pgen3=(GEN)pgen1[k];pgen4=gpui(prim,(GEN)pgen3[4]);
	      if(cmpis(pgen4,n2)<=0)
		{
		  ip++;j++;pgen2[j]=(long)pgen3;
		  divriz(mulir(pgen4,lfun),subis(pgen4,1),lfun);
		}
	    }
	  i++;numprimfactorbase[pp]=i;primfactorbase[i]=pp;
	  numideal[pp]=ip0;tetpil=avma;pgen3=cgetg(j+1,17);
	  for(k=1;k<=j;k++) pgen3[k]=lcopy((GEN)pgen2[k]);
	  idealbase[i]=gerepile(av1,tetpil,pgen3);
	}
      else
	{
	  pgen4=gpui(prim,(GEN)((GEN)pgen1[1])[4]);
	  if(cmpis(pgen4,n2)<=0) 
	    divriz(mulir(pgen4,lfun),subis(pgen4,1),lfun);
	}
      pp+=*delta++;
      if((pp>n)&&fl) {*ptkc=ip;fl=0;*ptkcz=i;}
    }
  *ptkcz2=i;
  *ptnumprim=numprimfactorbase;*ptprim=primfactorbase;*ptnum=numideal;*ptideal=idealbase;
  return ip;
}

long factorisegen(GEN nf, GEN ideal, long kcz, long limp, long *primfact, long *expoprimfact, long *primfactorbase, GEN *idealbase, long *numideal, long *numprimfactorbase, long limhash)
{
  long sr,i,j,n1,ip,v,p,k,fl=1,av1,av2,q1,lo;
  GEN x,q,r,pg1;

  av1=avma;lo=0;
  for(x=gun,i=1;i<lg(ideal);i++) x=mulii(x,gcoeff(ideal,i,i));
  if(gcmp1(x)) {avma=av1;primfact[0]=0;return 1;}
  av2=avma;
  for(i=1;(i<=kcz)&&fl;i++)
    {
      p=primfactorbase[i];q=dvmdis(x,p,&r);
      if(sr=(!signe(r)))
	{
	  x=q;k=0;av2=avma;
	  while(sr) {k++;q=dvmdis(x,p,&r);if(sr=(!signe(r))) {x=q;av2=avma;}}
	  pg1=idealbase[numprimfactorbase[p]];
	  n1=lg(pg1);ip=numideal[p];
	  for(j=1;(j<n1)&&k;j++)
	    {
	      v=idealval(nf,ideal,(GEN)pg1[j]);
	      if(v) 
		{
		  primfact[++lo]=ip+j;expoprimfact[lo]=v;
		  k-=v*itos((GEN)((GEN)pg1[j])[4]);
		}
	    }
	  if(k) {avma=av1;return 0;}
	}
      else avma=av2;
      fl=(cmpis(q,p)>0);
    }
  if(!fl)
    {
      if(gcmp1(x)) {avma=av1;primfact[0]=lo;return 1;}
      else
	{
	  if(cmpis(x,limp)<=0)
	    {
	      p=itos(x);
	      pg1=idealbase[numprimfactorbase[p]];
	      n1=lg(pg1);ip=numideal[p];k=1;
	      for(j=1;(j<n1)&&k;j++)
		{
		  v=idealval(nf,ideal,(GEN)pg1[j]);
		  if(v) 
		    {
		      primfact[++lo]=ip+j;expoprimfact[lo]=v;
		      k-=v*itos((GEN)((GEN)pg1[j])[4]);
		    }
		}
	      if(k) {avma=av1;return 0;}
	      avma=av1;primfact[0]=lo;return 1;
	    }
	}
    }
  if(cmpis(x,limhash)<=0)
    {q1=itos(x);avma=av1;primfact[0]=lo;return q1;}
  else {avma=av1;return 0;}
}

GEN idealmulprimered(GEN nf, GEN x, GEN vp, long PRECREG)
{
  long av=avma,tetpil;
  GEN y;
  
  y=idealmulprime(nf,x,vp);tetpil=avma;
  return gerepile(av,tetpil,ideallllred(nf,y,gzero,PRECREG));
}

GEN cleancol(GEN x,long N,long RU,long PRECREG)
{
  long i,j,av=avma,tetpil,tx=typ(x),R1=RU+RU-N;
  GEN s,s2,p1,p2,p3,p4,y;

  if(tx<17) err(talker,"not a vector/matrix in cleancol");
  if(tx==19) 
    {
      y=cgetg(lg(x),tx);
      for(j=1;j<lg(x);j++) y[j]=(long)cleancol((GEN)x[j],N,RU,PRECREG);
      return y;
    }
  p1=greal(x);s=gzero;for(i=1;i<=RU;i++) s=gadd(s,(GEN)p1[i]);
  s=gdivgs(s,-N);if(N>R1) s2=gmul2n(s,1);
  p2=gmul2n(mppi(PRECREG),2);p3=gimag(x);
  tetpil=avma;y=cgetg(RU+1,tx);
  for(i=1;i<=RU;i++)
    {
      p4=cgetg(3,6);y[i]=(long)p4;
      p4[1]=(i<=R1)?ladd((GEN)p1[i],s):ladd((GEN)p1[i],s2);
      p4[2]=(long)gmod((GEN)p3[i],p2);
    }
  return gerepile(av,tetpil,y);
}

GEN getfu(GEN nf, GEN xarch, GEN reg, long *pte, long PRECREG)
{
  long av=avma,av1,tetpil,i,j,RU,N=lgef((GEN)nf[1])-3,e,R1,R2;
  GEN p1,p2,p3,y,rpro,rpro2,matep,s,u,v;

  R1=itos((GEN)((GEN)nf[2])[1]);R2=(N-R1)>>1;RU=R1+R2;
  if(RU==1) return cgetg(1,19);
  if(gexpo(reg)<-8) 
    {
      fprintf(stderr,"\n  ***   Warning: not enough relations for fundamental units, not given\n");
      return cgetg(1,19);
    }
  matep=cgetg(RU,19);
  for(j=1;j<RU;j++)
    {
      s=gzero;for(i=1;i<=RU;i++) s=gadd(s,greal(gcoeff(xarch,i,j)));
      s=gdivgs(s,N);
      p1=cgetg(N+1,18);matep[j]=(long)p1;
      for(i=1;i<=R1;i++)
	p1[i]=lsub(gcoeff(xarch,i,j),s);
      for(i=R1+1;i<=RU;i++)
	{
	  p1[i]=lsub(gmul2n(gcoeff(xarch,i,j),-1),s);
	  p1[i+R2]=lconj((GEN)p1[i]);
	}
    }
  matep=gexp(gmul(matep,lll(greal(matep),PRECREG)),PRECREG);
  p1=(GEN)((GEN)nf[5])[1];
  p2=cgetg(N+1,19);
  for(j=1;j<=N;j++)
    {
      p3=cgetg(N+1,18);p2[j]=(long)p3;
      for(i=1;i<=R1;i++) p3[i]=(long)coeff(p1,i,j);
      for(i=R1+1;i<=RU;i++)
	{
	  p3[i]=(long)coeff(p1,i,j);p3[i+R2]=lconj((GEN)p3[i]);
	}
    }
  y=greal(grndtoi(invmulmat(p2,matep),&e));
  if(e>=0)
    {
      fprintf(stderr,"\n  ***   Warning: insufficient precision for fundamental units, not given\n");
      avma=av;return cgetg(1,19);
    }
  *pte= -e;
  for(j=1;j<lg(y);j++)
    {
      p1=(GEN)y[j];p2=(GEN)(ginv(gmodulcp(gmul((GEN)nf[7],p1),(GEN)nf[1]))[2]);
      p3=cgetg(N+1,18);for(i=1;i<lgef(p2)-1;i++) p3[i]=p2[i+1];
      for(;i<=N;i++) p3[i]=zero;
      p2=gmul((GEN)nf[8],p3);
      if(gcmp(gnorml2(p2),gnorml2(p1))<0) 
	{
	  p1=p2;gaffect(gneg((GEN)xarch[j]),(GEN)xarch[j]);
	}
      for(i=N;(i>=1)&&gcmp0((GEN)p1[i]);i--);
      if(gsigne((GEN)p1[i])<0)
	{
	  y[j]=lneg(p1);
	  av1=avma;p1=cgetg(RU+1,18);p2=gmul(gi,mppi(PRECREG));
	  for(i=1;i<=R1;i++) p1[i]=(long)p2;
	  for(;i<=RU;i++) p1[i]=lmul2n(p2,1);
	  gaddz((GEN)xarch[j],p1,(GEN)xarch[j]);avma=av1;
	}
      else y[j]=(long)p1;
    }
  tetpil=avma;return gerepile(av,tetpil,gcopy(y));
}

GEN gcdrealnoer(GEN a, GEN b)
{
  long av,tetpil,e;
  GEN k1,r;

  if(typ(a)==1)
    {
      if(typ(b)==1) return mppgcd(a,b);
      k1=cgetr(lg(b));affir(a,k1);a=k1;
    }
  else if(typ(b)==1) {k1=cgetr(lg(a));affir(b,k1);b=k1;}
  if(expo(a)<-5) return gabs(b);
  if(expo(b)<-5) return gabs(a);
  av=avma;a=absr(a);b=absr(b);
  while((expo(b)>=(-5))&&(signe(b)))
    {k1=gcvtoi(divrr(a,b),&e);r=subrr(a,mulir(k1,b));a=b;b=r;}
  tetpil=avma;return gerepile(av,tetpil,gabs(a));
}

long factorisegensimple(GEN nf, GEN ideal, long *primfact, long *expoprimfact, GEN vectbase)
{
  long sr,i,j,n1,ip,p,v,k,fl=1,av1,av2,q1,lo;
  GEN x,q,r,p1;

  av1=avma;lo=0;
  for(x=gun,i=1;i<lg(ideal);i++) x=mulii(x,gcoeff(ideal,i,i));
  if(gcmp1(x)) {avma=av1;primfact[0]=0;return 1;}
  av2=avma;fl=1;
  for(i=1;(i<lg(vectbase))&&fl;i++)
    {
      p1=(GEN)vectbase[i];p=itos((GEN)p1[1]);
      if(!signe(modis(x,p)))
	{
	  v=idealval(nf,ideal,p1);
	  if(v) 
	    {
	      primfact[++lo]=i;expoprimfact[lo]=v;
	      x=divii(x,gpui((GEN)p1[1],mulsi(v,(GEN)p1[4])));
	      if(gcmp1(x)) fl=0;
	    }
	}
    }
  primfact[0]=lo;return 1-fl;
}

GEN isprincipal(GEN bignf, GEN x)
{
  long expoprimfact[500],primfact[500],av=avma,tetpil,*vinvperm;
  long i,j,fpc,fl,colmit,colnew,k,N,R1,R2,RU,e,pr,c,ss;
  GEN xalpha,yalpha,mit,matalpha,matunit,matalphac,vectbase,vperm,nf,a,RES;
  GEN u1u2,u1,u2,met,y,p1,p2,p3,p4,p5,s,s1,s2,om1,om2,om3,xar,pgen1,vdir;

  if((typ(bignf)!=17)||(lg(bignf)!=9))
    err(talker,"not a big number field vector in isprincipal");
  mit=(GEN)bignf[1];matalpha=(GEN)bignf[2];matunit=(GEN)bignf[3];
  matalphac=gcopy((GEN)bignf[4]);vectbase=(GEN)bignf[5];vperm=(GEN)bignf[6];
  nf=(GEN)bignf[7];N=lgef((GEN)nf[1])-3;
  if((typ(x)==17)&&(lg(x)==6)) x=idealmulprime(nf,idmat(N),x);
  if((typ(x)!=19)||(lg(x)!=(N+1))||(lg((GEN)x[1])!=(N+1)))
    err(talker,"not an ideal in principalideal");
  RES=(GEN)bignf[8];
  R1=itos((GEN)((GEN)nf[2])[1]);R2=(N-R1)>>1;RU=R1+R2;
  pr=precision((GEN)matalphac[1]);if(!pr) pr=8;
  colmit=lg(mit)-1;colnew=lg(matalpha)-1;
  a=content(x);x=gdiv(x,a);x=hnf(x);vinvperm=(long*)malloc(lg(vectbase)<<TWOPOTBYTES_IN_LONG);
  for(i=1;i<lg(vectbase);i++) vinvperm[itos((GEN)vperm[i])]=i;
  s=gun;for(i=1;i<=N;i++) s=mulii(s,gcoeff(x,i,i));
  xar=cgetg(RU+1,18);
  for(i=1;i<=RU;i++)
    {
      p2=cgetg(3,6);xar[i]=(long)p2;
      p3=cgetr(pr);p2[1]=(long)p3;
      p3=cgetr(pr);p2[2]=(long)p3;
      affsr(0,(GEN)p2[1]);affsr(0,(GEN)p2[2]);
    }
  fpc=factorisegensimple(nf,x,primfact,expoprimfact,vectbase);
  if(!fpc) 
    {
      p3=cgetg(3,17);p3[1]=(long)x;p3[2]=(long)xar;
      p1=ideallllred(nf,p3,gzero,pr);
      x=(GEN)p1[1];
      xar=cleancol((GEN)p1[2],N,RU,pr);settyp(xar,18);
      fpc=factorisegensimple(nf,x,primfact,expoprimfact,vectbase);
      if(!fpc) 
	{
	  vdir=cgetg(RU+1,17);for(i=1;i<=RU;i++) vdir[i]=zero;
	  for(i=1;(i<=RU)&&(!fpc);i++)
	    {
	      vdir[i]=lstoi(10);if(i>1) vdir[i-1]=zero;
	      p1=ideallllred(nf,p3,vdir,pr);
	      x=(GEN)p1[1];
	      xar=cleancol((GEN)p1[2],N,RU,pr);settyp(xar,18);
	      fpc=factorisegensimple(nf,x,primfact,expoprimfact,vectbase);
	    }
	  if(!fpc) 
	    {
	      err(impl,"big principal ideal ");
	    }
	}
    }
  xalpha=cgetg(colmit+1,18);yalpha=cgetg(colnew+1,18);
  for(i=1;i<=colmit;i++) xalpha[i]=zero;
  for(i=1;i<=colnew;i++) yalpha[i]=zero;
  for(i=1;i<=primfact[0];i++)
    {
      k=vinvperm[primfact[i]];
      if(k<=colmit) xalpha[k]=lstoi(expoprimfact[i]);
      else yalpha[k-colmit]=lstoi(expoprimfact[i]);
    }
  u1u2=smith2(mit);u1=(GEN)u1u2[1];u2=(GEN)u1u2[2];
  p3=(GEN)((GEN)RES[1])[2];
  p1=gmul(u1,gsub(xalpha,gmul(matalpha,yalpha)));
  c=lg(p3)-1;u1=ginv(u1);
  p4=cgetg(colmit+colnew+1,18);p2=cgetg(c+1,18);
  for(i=1;i<=c;i++) 
    {
      p4[i]=(long)dvmdii((GEN)p1[i],(GEN)p3[i],(GEN*)(p2+i));
      if(signe((GEN)p2[i])<0) 
	{
	  p2[i]=ladd((GEN)p2[i],(GEN)p3[i]);
	  p4[i]=(long)gaddgs((GEN)p4[i],-1);
	}
    }
  for(;i<=colmit;i++) p4[i]=p1[i];
  for(;i<=colmit+colnew;i++) p4[i]=yalpha[i-colmit];
  p5=cgetg(colmit+1,19);for(i=1;i<=colmit;i++) p5[i]=matalphac[i];
  p3=gmul(p5,u2);for(i=1;i<=colmit;i++) matalphac[i]=p3[i];
  p1=gsub(gmul(matalphac,p4),xar);
  p4=cgetg(c+1,19);
  for(j=1;j<=c;j++)
    {
      p5=(GEN)idealpowprime(nf,(GEN)vectbase[itos((GEN)(vperm[1]))],pgen1=gcoeff(u1,1,j),pr);
      if(signe(pgen1)<0) p5[1]=(long)numer((GEN)p5[1]);
      for(i=2;i<=colmit;i++)
	{
	  pgen1=gcoeff(u1,i,j);ss=signe(pgen1);
	  if(ss)
	    {
	      if(ss>0)
		p5=idealmulh(nf,p5,(GEN)idealpowprime(nf,(GEN)vectbase[itos((GEN)(vperm[i]))],pgen1,pr));
	      else
		p5=idealmulh(nf,p5,numer((GEN)idealpowprime(nf,(GEN)vectbase[itos((GEN)(vperm[i]))],pgen1,pr)));
	      p5=ideallllred(nf,p5,gzero,pr);
	    }
	}
      if(!gegal((GEN)p5[1],(GEN)((GEN)((GEN)RES[1])[3])[j]))
	err(talker,"bug1 in isprincipal");
      p4[j]=lneg((GEN)p5[2]);settyp((GEN)p4[j],18);
    }
  p1=cleancol(c?gadd(p1,gmul(p4,p2)):p1,N,RU,pr);
  if(RU>1)
    {
      s2=gzero;
      p4=cgetg(RU+1,19);
      for(j=1;j<RU;j++)
	{
	  p5=cgetg(RU+1,18);p4[j]=(long)p5;
	  s1=gzero;
	  for(i=1;i<RU;i++) 
	    {
	      p5[i]=(long)greal(gcoeff(matunit,i,j));s1=gadd(s1,gmul((GEN)p5[i],(GEN)p5[i]));
	    }
	  p5[RU]=zero;if(gcmp(s1,s2)>0) s2=s1;
	}
      p5=cgetg(RU+1,18);p4[RU]=(long)p5;
      for(i=1;i<RU;i++) p5[i]=(long)greal((GEN)p1[i]);
      s2=gsqrt(gmul2n(s2,RU+1),pr);if(gcmpgs(s2,100000000)<0) s2=stoi(100000000);
      p5[RU]=(long)s2;
      p4=(GEN)lll(p4,pr)[RU];
      if(signe((GEN)p4[RU])<0) p4=gneg(p4);
      if(!gcmp1((GEN)p4[RU])) err(talker,"bug2 in isprincipal");
      setlg(p4,RU);
      p1=gadd(p1,gmul(matunit,p4));
      setlg(p4,RU+1);
    }
  s2=gun;
  for(j=1;j<=c;j++) 
    {
      p5=(GEN)((GEN)((GEN)RES[1])[3])[j];
      s1=gun;for(i=1;i<=N;i++) s1=mulii(s1,gcoeff(p5,i,i));
      if(signe((GEN)p2[j])) s2=mulii(s2,gpui(s1,(GEN)p2[j]));
    }
  s=gdivgs(glog(gdiv(s,s2),pr),N);
  p4=cgetg(N+1,18);
  for(i=1;i<=R1;i++) p4[i]=(long)gexp(gadd(s,(GEN)p1[i]),pr);
  for(i=R1+1;i<=RU;i++)
    {
      p4[i]=(long)gexp(gadd(s,gmul2n((GEN)p1[i],-1)),pr);;
      p4[i+R2]=lconj((GEN)p4[i]);
    }
  om1=(GEN)((GEN)nf[5])[1];
  om2=cgetg(N+1,19);
  for(j=1;j<=N;j++)
    {
      om3=cgetg(N+1,18);om2[j]=(long)om3;
      for(i=1;i<=R1;i++) om3[i]=(long)coeff(om1,i,j);
      for(i=R1+1;i<=RU;i++)
	{
	  om3[i]=(long)coeff(om1,i,j);om3[i+R2]=lconj((GEN)om3[i]);
	}
    }
  p1=gdiv(grndtoi(gmul(s2,greal(gauss(om2,p4))),&e),s2);
  if(e>=0)
    {
      fprintf(stderr,"\n  ***   Warning: insufficient precision for generators, not given\n");
      p1=cgetg(1,18);
    }
  tetpil=avma;y=cgetg(4,17);y[1]=lcopy(p2);y[2]=lmul(a,p1);y[3]=lstoi(-e);
  return gerepile(av,tetpil,y);
}

GEN isunit(GEN bignf, GEN x)
{
  long av=avma,tetpil,tx,i,R1,R2,RU,nru;
  GEN RES,matunit,y,p1,p2,p3,nf,ro1;

  if((typ(bignf)!=17)||(lg(bignf)!=9))
    err(talker,"not a big number field vector in isunit");
  tx=typ(x);
  if((tx==4)||(tx==5)) return cgetg(1,17);
  matunit=(GEN)bignf[3];RU=lg(matunit);
  RES=(GEN)bignf[8];nf=(GEN)bignf[7];
  ro1=(GEN)RES[4];nru=itos((GEN)ro1[1]);
  if(tx==1)
    {
      if(!gcmp1(absi(x))) return cgetg(1,17);
      y=cgetg(RU+1,17);
      for(i=1;i<RU;i++) y[i]=zero;
      y[RU]=(signe(x)>0)?lmodulcp(gzero,(GEN)ro1[1]):lmodulcp(stoi(nru>>1),(GEN)ro1[1]);
      return y;
    }
  if(tx!=10) 
    {
      if(tx!=9) err(talker,"not an algebraic number in isunit");
      if(!gegal((GEN)nf[1],(GEN)x[1])) err(talker,"not the same number field in isunit");
    }
  p1=(GEN)nf[2];R1=itos((GEN)p1[1]);R2=itos((GEN)p1[2]);
  p1=cgetg(RU+1,18);for(i=1;i<=R1;i++) p1[i]=un;for(;i<=RU;i++) p1[i]=deux;
  p3=(GEN)principalidele(nf,x)[2];
  p1=concat(matunit,p1);p2=ground(gauss(greal(p1),greal(p3)));
  if(!gcmp0((GEN)p2[RU])) err(talker,"insufficient precision (1) in isunit");
  p1=gsub(p3,gmul(p1,p2));
  p3=(GEN)principalidele(nf,(GEN)ro1[2])[2];
  p1=gdiv((GEN)p1[1],(GEN)p3[1]);
  p1=gmod(ground(greal(p1)),(GEN)ro1[1]);
  tetpil=avma;y=cgetg(RU+1,17);for(i=1;i<RU;i++) y[i]=lcopy((GEN)p2[i]);
  y[RU]=lmodulcp(p1,(GEN)ro1[1]);
  return gerepile(av,tetpil,y);
}
