/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include <stdio.h>

#define FL fflush(stdout)

struct facet_struct {
	struct facet_struct *p, *spawn;
	struct link_struct *up, *dn;
	int light, critical, dark, verified, id;
	long c;
	struct vector_struct *v;
};

struct link_struct {
	struct link_struct *p;
	struct facet_struct *f;
};

struct vector_struct {
	int len;
	long v[1];
};

struct matrix_struct {
	int rows, cols;
	struct vector_struct *v[1];
};

typedef struct facet_struct facet;
typedef struct link_struct link;
typedef struct vector_struct vector;
typedef struct matrix_struct matrix;

/* stash.c */
char *get_slug();
char *open_stash();
char *gimmy();

/* defined in h_interface.c */
extern int h_n;  /* number of variables in ring */
extern int h_phase;  /* state of algorithm (0, 1, 2, ...) */
extern int h_i;  /* loop variable */
extern matrix *h_p;  /* results of first 8 std bases */
extern matrix *h_s;  /* result of simplex */
extern facet **h_t;  /* polytope itself */
extern facet *h_f;  /* current facet under study */
extern FILE *h_fout;  /* open output file for polytope */
extern char *h_linkstash, *h_facetstash, *h_vecstash;

/* system functions */
char *malloc();  /* unsigned size */
double sqrt(); /* double x */

/* vector.c */
vector *new_vector();  /* int len; */
void free_vector();  /* vector *p; */
vector *copy_vector(); /* vector *p; */
void pr_vector();  /* vector *p; */
long dot_prod();  /* vector *p, *q; */
vector *add_vectors();  /* (a,p,b,q) long a, b; vector *p, *q; */
int ziptest_vector();  /* vector *p; */
void basis_vector();  /* vector *p; int i; */
void neg_vector();  /* vector *p; */

/* matrix.c */
matrix *new_matrix();  /* int rows, cols; */
void free_matrix();  /* matrix *p; */
matrix *copy_matrix();  /* matrix *p; */
matrix *trans_matrix();  /* matrix *p; */
void pr_matrix();  /* matrix *p; */
long det1_matrix();  /* matrix *p; vector *q; int row; */
long det_matrix();  /* matrix *p; */
vector *mat_times_vec();  /* matrix *p; vector *q; */
matrix *mat_times_tmat();  /* matrix *p, *q; */
matrix *adjoin_row();  /* matrix *p; vector *q; */

/* ops.c */
long gcd_long();  /* long a, b; */
void scale_vector();  /* vector *p; */
vector *delta_matrix();  /* matrix *p; vector *q; */
vector *normal_vector();  /* matrix *p; vector *q; */

/* points.c */
matrix *rand_points();  /* int rows, cols, lim; */
vector *extreme_pt();  /* matrix *p; vector *w; */
matrix *input_points();

/* hull.c */
matrix *simplex();  /* matrix *p; */

/* tope.c */
link *new_link();
void free_link(); /*(p) link *p; */
facet *new_facet(); 
void free_facet(); /* (p) facet *p; */
facet **tope3(); /* (p) matrix *p; */
void join_links(); /* (fup, fdn) facet *fup, *fdn; */
void cut_links(); /* (fup, fdn) facet *fup, *fdn; */
void write_normal(); /* (f,p,i1,i2,i3,i4) facet *f; matrix *p; int i1,i2,i3,i4; */
void output_point(); /* (p, fp) facet *p; FILE *fp; */
void output_edge(); /* (p, fp) facet *p; FILE *fp; */
void output_face(); /* (p, fp) facet *p; FILE *fp; */
void output_tope(); /* (q) facet **q; */

#define ERROR_IF(A, B) {if (A) \
	{printf("\n! ! !\terror in %s.\n\n", B); \
	printf("! ! !\tAt present, the hull command is only implemented for\n"); \
	printf("! ! !\tfull-dimensional polytopes.\n\n"); \
	printf("! ! !\tOf course, this also could be a bug in the code.\n\n"); \
	printf("! ! !\tIf you think this is a bug,\n"); \
	printf("! ! !\tplease email your script to Mike, Dave or Ian.\n\n"); \
	to_shell(1);}}
#define NL printf("\n")

#define PL(N,L) printf("%s = %ld\n", N, L)
#define PV(N,V) { printf("%s = ", N); pr_vector(V); }
#define PM(N,M) { printf("%s :\n", N); pr_matrix(M); }

#define PAUSE \
	{ char ccc; printf("?"); \
	while (ccc = getc(stdin), ccc != '\r' && ccc != '\n'); }



