/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "vars.h"

extern gmatrix gm_in() ;
extern htell() ;

extern int genfun[] ;
extern int verbose;


h_init(hf, deg0)
register hilbFunc *hf ;
{
    register int i ;

    hf->codim = 0 ;
    hf->deg0 = deg0 ;
    hf->degree = 0 ;
    for (i=0; i<GFSIZE; i++)
	hf->genfun[i] = 0 ;
}

h_addto(hf, genfun, deg0)
register hilbFunc *hf ;
register long genfun[] ;
int deg0 ;	/* t^0 in genfun has this degree */
{
    register int diff, i ;

    /* deg0 >= hf->deg0 ALWAYS, or problems result */
    /* hf->codim SHOULD BE 0 */
    if (deg0 < hf->deg0) {
	prerror("\n;internal error: hilb addto: deg0 too small\n") ;
	to_shell();
    }
    if (hf->codim != 0) {
	prerror("\n;internal error: hilb addto: codim not zero\n") ;
	to_shell();
    }

    diff = deg0 - hf->deg0 ;
    for (i=0; i<GFSIZE-diff; i++) {
	hf->genfun[diff+i] += genfun[i] ;
	hf->degree += genfun[i] ;
    }
    while (i<GFSIZE) if (genfun[i++] != 0) {
	prerror("\n;error: hilb addto: degree bound exceeded!\n");
	to_shell();
    }
}

h_divAll(hf)
register hilbFunc *hf ;
{
    while (hf->degree == 0) 
	h_div(hf) ;
}

h_div(hf)
register hilbFunc *hf ;
{
    register int j, lo ;
    lo = hf->codim ;
    hf->degree += hf->genfun[GFSIZE-1] *= -1;
    for (j=GFSIZE-2; j>=lo; j--) {
	hf->genfun[j] = hf->genfun[j+1] - hf->genfun[j] ;
	hf->degree += hf->genfun[j] ;
    }
    hf->codim++ ;
}


h_display(hf)
register hilbFunc *hf ;
{
    register int i ;

    fprint (outfile, "\n");
    for ( i=hf->codim; i<GFSIZE; ++i)
    if (hf->genfun[i] != 0) {
	fnewline(outfile) ;
    	fprint (outfile, "%7ld t %2d\n",hf->genfun[i],
		i + hf->deg0 - hf->codim);
    }
    if (hf->degree != 0) {
	fprint (outfile, "\n");
	fnewline(outfile) ;
	fprint(outfile, "codimension = %d\n", hf->codim) ;
	fnewline(outfile) ;
	fprint(outfile, "degree      = %ld\n", hf->degree) ;
    }
}

long
h_genus(hf)
register hilbFunc *hf ;
{
    int i;
    long n, lo, genus ;

    genus = 1 ;
    lo = hf->codim ;
    for (i=lo; i<GFSIZE; i++) 
	if ((n = hf->genfun[i]) != 0)
	    genus += (i-lo-1)*n ;
    return(genus) ;
}

boolean hilb(hf, M) /* returns TRUE if user doesn't interrupt */
hilbFunc *hf ;
gmatrix M ;
{
    int lodeg, hideg ;
    int comp ;
    arrow head ;
    arrow monhilb() ;

    dl_lohi(&M->degrees, &lodeg, &hideg) ;
    h_init(hf, lodeg) ;
    for (comp=nrows(M); comp>=1; comp--) {
	if (verbose > 0) intflush("[%d] ", comp);
	i_genfun() ;
	if ((head = monhilb(M, comp, htell)) IS NULL)
	    return(FALSE) ;
	h_addto(hf, genfun, DREF(M->degrees, comp)) ;
	monrefund(head) ;
    }
    if (verbose > 0) print("\n");
    return(TRUE) ;
} 

hilbDisplay(hf, M) 
hilbFunc *hf ;
gmatrix M ;
{
    if (NOT hilb(hf, M)) return ;
    h_display(hf) ;
    h_divAll(hf) ;
    h_display(hf) ;
    fnewline(outfile) ;
    fprint(outfile, "genus       = %ld\n", h_genus(hf)) ;
}

hilb_cmd(argc, argv)
int argc ;
char *argv[] ;
{
    gmatrix M ;
    hilbFunc hf ;

    if (argc ISNT 2) {
	printnew("hilb <standard basis>\n") ;
	return ;
    }
    GET_MOD(M, 1) ;
    stdWarning(M) ;
    hilbDisplay(&hf, M) ;
}
