/*
 * have_vs - Determine if we want or can support vsprintf()
 *
 * usage:
 *	have_vs 0
 *
 *	NOTE: we must pass at least 1 arg!
 *
 * Not all systems have vsprintf(), so this may not compile on your system.
 *
 * Because we don't yet know if we should use stdarg.h or varargs.h, we
 * cannot from the 3rd arg to vsprintf().  But we are only interested in
 * knowing if we can even link in vsprintf(), so we pass a NULL arg.
 * We never execute this call because we use if (argc < 2) below.
 *
 * This prog outputs several defines:
 *
 *	HAVE_VSPRINTF
 *		defined ==> ok to use vsprintf()
 *		undefined ==> do not use vsprintf()
 */
/*
 * Copyright (c) 1995 by Landon Curt Noll.  All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright, this permission notice and text
 * this comment, and the disclaimer below appear in all of the following:
 *
 *	supporting documentation
 *	source copies
 *	source works derived from this source
 *	binaries derived from this source or from derived source
 *
 * LANDON CURT NOLL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
 * EVENT SHALL LANDON CURT NOLL BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * chongo was here	/\../\
 */

#include <stdio.h>

main(argc, argv)
	int argc;	/* arg count */
	char *argv[];	/* the args */
{
#if defined(DONT_HAVE_VSPRINTF)
	printf("#undef HAVE_VSPRINTF /* no */\n");
#else /* DONT_HAVE_VSPRINTF */

	/*
	 * We will force cc to link in vsprintf() never call it.
	 * Some compilers are tricky and will stub out code that
	 * they find will never be executed.  On the other hand,
	 * we always give an arg to this prog so argc will always
	 * be at least 2.  But cc never knows this so we win.
	 */
	if (argc < 2) {
		vsprintf(NULL, NULL, NULL);
	}

	printf("#define HAVE_VSPRINTF /* yes */\n");
#endif /* DONT_HAVE_VSPRINTF */
	exit(0);
}
