/* general.h -- defines that everybody likes to use. */

#if !defined (_GENERAL_)
#define _GENERAL_

#ifndef savestring
#define savestring(x) (char *)strcpy (xmalloc (1 + strlen (x)), (x))
#endif

#ifndef whitespace
#define whitespace(c) (((c) == ' ') || ((c) == '\t'))
#endif

#ifndef digit
#define digit(c)  ((c) >= '0' && (c) <= '9')
#endif

#ifndef isletter
#define isletter(c) (((c) >= 'A' && (c) <= 'Z') || ((c) >= 'a' && (c) <= 'z'))
#endif

#ifndef digit_value
#define digit_value(c) ((c) - '0')
#endif

#if !defined (__STDC__)
char *index (), *rindex ();
#endif

#ifndef member
#define member(c, s) (int)((c) ? index ((s), (c)) : 0)
#endif

/* String comparisons that possibly save a function call each. */
#define STREQ(a, b) ((a)[0] == (b)[0] && strcmp(a, b) == 0)
#define STREQN(a, b, n) ((a)[0] == (b)[0] && strncmp(a, b, n) == 0)

/* Function pointers can be declared as (Function *)foo. */
#ifndef __FUNCTION_DEF
typedef int iFunction ();
#define __FUNCTION_DEF
#endif

/* The output of `signal' is different on different systems.  Yechh. */
#if !defined (VOID_SIGHANDLER)
#  if defined(_POSIX_HANDLER) || defined(SunOS4) || defined(NeXT) || defined(Ultrix) || defined(USG) || defined(__GNU_LIBRARY)
#    define VOID_SIGHANDLER
#  endif
#endif

#if defined (VOID_SIGHANDLER)
#define sighandler void
#else
#define sighandler int
#endif

typedef sighandler SigHandler (int);

#define NOW	((time_t) time ((time_t *) 0))

/* Definitions to set file descriptors to close-on-exec, the Posix way. */
#if !defined (FD_CLOEXEC)
#define FD_CLOEXEC	1
#endif

#define FD_NCLOEXEC	0

#define SET_CLOSE_ON_EXEC(fd)	(fcntl ((fd), F_SETFD, FD_CLOEXEC))
#define SET_OPEN_ON_EXEC(fd)	(fcntl ((fd), F_SETFD, FD_NCLOEXEC))

/*extern char *xmalloc (), *malloc (), *xrealloc (), *realloc ();*/
EXTERN void* xmalloc(size_t);
EXTERN char *itos ();
EXTERN char * get_string_value(char *);

/* Values that can be returned by execute_command (). */
#define EXECUTION_FAILURE 1
#define EXECUTION_SUCCESS 0

/* All structs which contain a `next' field should have that field
   as the first field in the struct.  This means that functions
   can be written to handle the general case for linked lists. */
typedef struct g_list {
  struct g_list *next;
} GENERIC_LIST;

/* Some defines for calling file status functions. */
#define FS_EXISTS	  0x1
#define FS_EXECABLE	  0x2
#define FS_EXEC_PREFERRED 0x4
#define FS_EXEC_ONLY	  0x8


/* **************************************************************** */
/*								    */
/*			Ulimit builtin and Hacks.       	    */
/*								    */
/* **************************************************************** */

/* Block size for ulimit operations. */
#define ULIMIT_BLOCK_SIZE ((long)1024)

#define u_FILE_SIZE 		0x001
#define u_MAX_BREAK_VAL		0x002
#define u_PIPE_SIZE		0x004
#define u_CORE_FILE_SIZE	0x008
#define u_DATA_SEG_SIZE		0x010
#define u_PHYS_MEM_SIZE		0x020
#define u_CPU_TIME_LIMIT	0x040
#define u_STACK_SIZE		0x080
#define u_NUM_OPEN_FILES	0x100

#define u_ALL_LIMITS		0x7ff

#ifndef RLIM_INFINITY
#  define RLIM_INFINITY  0x7fffffff
#endif

#define LIMIT_HARD 0x01
#define LIMIT_SOFT 0x02

EXTERN long shell_ulimit (int which, long newlim, int setting, int mode);
EXTERN void print_specific_limits (int cmd, int mode);
EXTERN void without_job_control ();

#define NO_JOB -1	/* An impossible job array index. */
#define DUP_JOB -2	/* A possible return value for get_job_spec (). */
extern int job_slots;

#if 1
#define DUP2(x,y) dup2(x,y)
#define DUP(x) dup(x)
#define CLOSE(fd) close(fd)
#define FORK() fork()
#define PIPE(fds) pipe(fds)
#else
EXTERN int CLOSE(int old);
EXTERN int DUP(int old);
EXTERN int DUP2(int old, int n);
EXTERN int FORK();
EXTERN int PIPE(int *fds);
#endif

#endif	/* _GENERAL_ */
