/* Copyright Per Bothner 1987. Read the file Q-INFO */
typedef long Scaled;

#define half(x) ((x)>>1)
#define half_unit 0x8000
#define twice_unit 0x20000
#define unity 65536 /* 2**16 */
#define scIntPart(x) ((x)>>16)
#define scFracPart(x) ((x)&0xFFFF)
#define scIntRound(x) scIntPart((x)+half_unit)
#ifdef M68000
#define scHighPart(x) ((short*)&x)
#endif M68000
#define DoRoundScaled(dst) { dst += half_unit; dst = *scHighPart(dst)}

#define FloatToScaled(f) (long)((f)<=0 ? (f)*unity-0.5 : (f)*unity+0.5)
#define ScaledToFloat(s) ((s) / 65536.0)
#define IllegalScaled 0x8000000
