#include "graphics.h"

void Transform::printon(ostream& outs) const
{
    outs << "Transform xx:"; xx.printon(outs);
    outs << " xy:"; xy.printon(outs);
    outs << " x1:"; x1.printon(outs);
    outs << " yx:"; yx.printon(outs);
    outs << " yy:"; yy.printon(outs);
    outs << " y1:"; y1.printon(outs);
}

ComplexPair Transform::apply_to(Complex& arg) const
{
    const Real& in_x = arg.realPart();
    const Real& in_y = arg.imagPart();
    const Real& out_x = in_x * xx + in_y * xy + x1;
    const Real& out_y = in_x * yx + in_y * yy + y1;
    return ComplexPair(out_x, out_y);
}
