/* C code produced by gperf version 1.9 (GNU C++ version) */
/* Command-line: gperf -a -C -g -G -p -t -N bool_name_hash ../mi/bool-hash.gperf  */


struct bool_name { char *name; int number; };

#define MIN_WORD_LENGTH 1
#define MAX_WORD_LENGTH 12
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 45
/*
   27 keywords
   44 is the maximum key range
*/

#ifdef __GNUC__
inline
#endif
static int
hash (register const char *str, register size_t len)
{
  static const unsigned char hash_table[] =
    {
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45,  5,
     20, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
     45, 45, 45, 45, 45, 45, 45, 20, 45,  0,
      0,  5, 45, 45, 45, 30, 45, 45, 45, 45,
     15,  0, 10, 45,  0, 10,  0, 45, 30, 45,
      5,  0, 45, 45, 45, 45, 45, 45,
    };
  return len + hash_table[str[len - 1]] + hash_table[str[0]];
}


static const struct bool_name  wordlist[] =
{
      {"",}, {"",}, 
      {"or",  7},
      {"clr",  0},
      {"copy",  3},
      {"clear",  0},
      {"",}, 
      {"c1",  12},
      {"xor",  6},
      {"orc1",  13},
      {"orinverted",  13},
      {"1",  3},
      {"copyinverted",  12},
      {"set",  15},
      {"orreverse",  11},
      {"",}, {"",}, {"",}, 
      {"nor",  8},
      {"nand",  14},
      {"",}, {"",}, 
      {"c2",  10},
      {"and",  1},
      {"orc2",  11},
      {"",}, {"",}, {"",}, {"",}, 
      {"noop",  5},
      {"andc1",  4},
      {"andinverted",  4},
      {"",}, 
      {"ior",  7},
      {"",}, 
      {"andreverse",  2},
      {"invert",  10},
      {"",}, 
      {"eqv",  9},
      {"",}, 
      {"equiv",  9},
      {"2",  5},
      {"",}, {"",}, {"",}, 
      {"andc2",  2},
};

#ifdef __GNUC__
inline
#endif
const struct bool_name *
bool_name_hash (register const char *str, register size_t len)
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          register const char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
