;;; -*- Mode:Lisp; Package:User; Base:10; Lowercase:T; Syntax:Common-Lisp -*-
;;; ===========================================================================
;;;			    System Definition
;;; ===========================================================================
;;; (c) Copyright 1989, 1991 Cornell University

;;; $Id: sysdef.lisp,v 2.9 1992/02/18 22:31:15 rz Exp $

(in-package "USER")

;; This was taken from PCL
(defun load-truename (&optional (errorp nil))
  (flet ((bad-time ()
	   (when errorp
	     (error "LOAD-TRUENAME called but a file isn't being loaded."))))
    #+Lispm  (or sys:fdefine-file-pathname (bad-time))
    #+excl   excl::*source-pathname*
    #+Xerox  (pathname (or (il:fullname *standard-input*) (bad-time)))
    #+(and dec vax common) (truename (sys::source-file #'load-truename))
    ;;
    ;; The following use of  `lucid::' is a kludge for 2.1 and 3.0
    ;; compatibility.  In 2.1 it was in the SYSTEM package, and i
    ;; 3.0 it's in the LUCID-COMMON-LISP package.
    ;;
    #+LUCID (or lucid::*source-pathname* (bad-time))
    #+CMU *compile-file-pathname*
    #-(or Lispm excl Xerox (and dec vax common) LUCID CMU) nil))

#+CMU
(setf (ext:search-list "weyl:") '("/fsys/night/z/weyl/develop/"))

(defvar *weyl-directory* #-CMU (load-truename t)
			 #+CMU (pathname "weyl:"))
#+Lucid
(defvar *weyl-archive-directory* "/fsys/davinci/a/weyl/bin"
  "The directory into which world loads are saved")

(defvar *weyl-version* ())
(defvar *weyl-version-file*
        (make-pathname :name "Weyl-Version"
		       :device (pathname-device *weyl-directory*)
		       :directory (pathname-directory *weyl-directory*)))

#+Genera
(progn 
  (when (and (find-package 'clos) (fboundp (intern "DEFCLASS" 'clos)))
    (push :CLOS *features*))

  (pushnew (intern (format nil "REL~D" (sct:get-release-version)) "KEYWORD")
	   *features*)
  )  ;; End Genera

#+Lucid
(progn 
  (proclaim '(optimize (speed 3) (safety 2) (compilation-speed 0)))
  ;; Safety 0:  No error checking code is provided
  ;; Safety 2:  Write access ops are error checked, (setf (svref...)) etc.
  ;; Safety 3:  read accesses are checked, declarations are ignored

  ;; (compiler-options :show-optimizations t)  ;; Shows optimizations in Lucid.

  (change-memory-management :growth-rate 16)
  ) ;; End Lucid

#+CMU
(progn
  (proclaim '(optimize (speed 3) (safety 2) (debug 0.5) (compilation-speed 0)))

;;  (setq *compile-verbose* nil)		;Be quiet a begining of file
  (setq *compile-print* nil)		;Don't print on each function
  (pushnew :UNIX *features*)		;Unix style file system
  ) ;;End CMU


#-(or CLOS PORTABLE-COMMONLOOPS)
(unless (and (find-package 'pcl) (fboundp (intern "LOAD-PCL" 'pcl)))
  (load #-Genera "/usr/local/lib/lisp/pcl/defsys"
	#+Genera "BRAGI:/usr/local/lib/lisp/pcl/defsys")
  (funcall (intern "LOAD-PCL" 'pcl)))

(unless (and (find-package 'defsys) (fboundp (intern "MAKE-SYSTEM" 'defsys)))
  (load (make-pathname :name "defsystem"
		       :device (pathname-device *weyl-directory*)
		       :directory (pathname-directory *weyl-directory*))))

(unless (find-package 'weyl)
  (load (make-pathname :name "packages" :type "lisp"
		       :device (pathname-device *weyl-directory*)
		       :directory (pathname-directory *weyl-directory*))))

(load (make-pathname :name "maintenance"
		     :device (pathname-device *weyl-directory*)
		     :directory (pathname-directory *weyl-directory*)))

