#include "def.h"
#include "macro.h"

static struct skewpartition * callocskewpartition();

INT swap(a,b) OP a,b;
/* AK 280388 */ /* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{
	struct object c;
	if (a == b)
		return error("swap:identical");
	c = *a; 
	*a = *b; 
	*b = c; 
	return(OK);
	}

INT rz(a,b) OP a, b;
/* AK 261087 berechnet die reduzierte Zerlegung */
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 120391 V1.2 */
/* AK 210891 V1.3 */
	{
	INT erg = OK;
	if (not EMPTYP(b)) 
		erg += freeself(b);
	if (EMPTYP(a))	
		return(OK);
	if (a == b)  /* 260292 */
		{
		OP c = callocobject();
		*c = *a;
		C_O_K(a,EMPTY);
		erg += rz(c,a);
		erg += freeall(c);
		return erg;
		}

	switch(S_O_K(a))
		{
#ifdef PERMTRUE
		case PERMUTATION : 
			switch(S_P_K(a))
				{
				case VECTOR: erg += rz_perm(a,b);break;
				}
			break;
		case VECTOR : 
			switch(S_O_K(S_V_I(a,0L)))
				{
				case INTEGER: erg += rz_lc(a,b);break;
				}
			break;
#endif
		default:
			{
			printobjectkind(a);
			return error("rz:unknown type");
			}
		};
	if (erg != OK)
		return error("rz:error during computation");
}
 
INT lastof(obj,ergebnis) OP obj,ergebnis;
/* ergebnis ist das letzte Element */
/* AK 280689 V1.0 */ /* AK 090790 V1.1 */ /* AK 200691 V1.2 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(obj))
		{
#ifdef PARTTRUE
		case PARTITION: return(lastof_partition(obj,ergebnis));
#endif
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : return(lastof_skewpartition(obj,ergebnis));
#endif
#ifdef VECTORTRUE
		case VECTOR : return(lastof_vector(obj,ergebnis));
#endif
		default:
			{
			printobjectkind(obj); 
			return error("lastof:wrong type");
			}
		};
	}

INT freeall(a) OP a;
/* AK 101286 */ /* AK 280689 V1.0 */ /* AK 071289 V1.1 */
/* AK 270291 V1.2 */ /* AK 050891 V1.3 */
	{ 
	INT erg = OK;
	if (not EMPTYP(a)) 
		if (S_O_K(a) != INTEGER) /* AK 071091 */
			erg += freeself(a); 

	if (speicherposition+1L < SPEICHERSIZE) /* AK 111091 */
		speicher[++speicherposition] = a;
	else

		free(a); 
	if (erg != OK)
		return error ("freeall: error in computing");
	return erg;
	}


INT freeself(a) OP a;
/* AK 061186 */ /* AK 280689 V1.0 */ /* AK 041289 V1.1 */ /* AK 050891 V1.3 */
	{
	INT erg=OK;
	if (EMPTYP(a)) 
		{
		error("freeself:unneccessary call, object is empty");
		return OK;
		}
	else switch(S_O_K(a))
		{
#ifdef BINTREETRUE
		case BINTREE : erg += freeself_bintree(a); break;
#endif /* BINTREETRUE */
#ifdef BRUCHTRUE
		case BRUCH : erg += freeself_bruch(a); break;
#endif /* BRUCHTRUE */
#ifdef GENCHARTRUE
		case GEN_CHAR : erg += freeself_gen_char(a); break;
#endif /* GENCHARTRUE */
#ifdef GRAPHTRUE
		case GRAPH : erg += freeself_graph(a); break;
#endif /* GRAPHTRUE */
		case INTEGER : erg += FREESELF_INTEGER(a);break;
#ifdef LISTTRUE
		case GRAL:
		case HOM_SYM:
		case MONOPOLY:
		case POLYNOM:
		case SCHUR:
		case SCHUBERT:
		case LIST : erg += freeself_list(a); break; 
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT : erg += freeself_longint(a); break; 
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KRANZTYPUS : erg += freeself_kranztypus(a);break;
		case KOSTKA :
		case MATRIX : erg += freeself_matrix(a); break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM : erg += freeself_monom(a); break;
#endif /* MONOMTRUE */
#ifdef NUMBERTRUE
		case SQ_RADICAL:
		case CYCLOTOMIC: erg += freeself_number(a);break;
#endif /* NUMBERTRUE */
#ifdef PARTTRUE
		case AUG_PART : 
		case PARTITION : erg += freeself_partition(a); break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION : erg += freeself_permutation(a);break;
#endif /* PERMTRUE */
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : erg += freeself_skewpartition(a); break;
#endif /* PERMTRUE */
#ifdef CHARTRUE
		case SYMCHAR : erg += freeself_symchar(a); break;
#endif /* CHARTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX : erg += freeself_tableaux(a); break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
		case COMP:
		case KRANZ:
		case WORD:	/* AK 210488 */
		case VECTOR : erg += freeself_vector(a);break;
#endif /* VECTORTRUE */
		default:
			{
			printobjectkind(a);
			return error("freeself:wrong type");
			}
		};
	C_O_K(a,EMPTY);
	if (erg != OK) 
		return error("freeself: error in computing");
	return erg;
	}

INT copy(a,b) OP a, b;
/* AK 280689 V1.0 */ /* AK 201289 V1.1 */ /* AK 050891 V1.3 */
	{
	INT erg = OK;
	if (a == b) 
		return(OK);
	if (a == NULL) 
		return error("copy:a == NULL");
	if (b == NULL) 
		return error("copy:b == NULL");

	if (not EMPTYP(b)) 
		erg += freeself(b);
	if (EMPTYP(a))	
		return(OK);
	switch(S_O_K(a))
		{
#ifdef PARTTRUE
		case AUG_PART :
			erg += copy_partition(a,b);
			C_O_K(b,AUG_PART); break;
#endif /* PARTTRUE */
#ifdef BINTREETRUE
		case BINTREE : erg += copy_bintree(a,b);break;
#endif /* BINTREETRUE */
#ifdef BRUCHTRUE
		case BRUCH : erg += copy_bruch(a,b);break;
#endif /* BRUCHTRUE */
#ifdef GENCHARTRUE
		case GEN_CHAR : erg += copy_gen_char(a,b);break;	
#endif
#ifdef GRAPHTRUE
		case GRAPH : erg += copy_graph(a,b);break;
#endif
#ifdef INTEGERTRUE
		case INTEGER : erg += COPY_INTEGER(a,b);break;	
#endif
#ifdef LISTTRUE
		case POLYNOM : erg += COPY_POLYNOM(a,b);break;
		case GRAL:
		case HOM_SYM:
		case SCHUR :
		case MONOPOLY:
		case SCHUBERT: 
		case LIST : erg += copy_list(a,b);break;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT : erg += copy_longint(a,b);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KRANZTYPUS : erg += copy_kranztypus(a,b);break;
		case KOSTKA :
		case MATRIX : erg += copy_matrix(a,b);break;
			
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM : erg += COPY_MONOM(a,b);break;
		/* AK 140891 macro */
#endif /* MONOMTRUE */
#ifdef NUMBERTRUE
		case SQ_RADICAL:
		case CYCLOTOMIC: erg += copy_number(a,b);break;
#endif /* NUMBERTRUE */
#ifdef PARTTRUE
		case PARTITION : erg += copy_partition(a,b);break;
				/*kein macro*/
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION : erg += copy_permutation(a,b);break;
				/*kein macro*/
#endif /* PERMTRUE */
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : erg += copy_skewpartition(a,b);break;
#endif /* SKEWPARTTRUE */
#ifdef CHARTRUE
		case SYMCHAR : erg += copy_symchar(a,b);break;
#endif /* CHARTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX : erg += copy_tableaux(a,b);break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
		case COMP:
		case KRANZ:
		case WORD: /*250488 */
		case VECTOR :   erg += copy_vector(a,b);break;
#endif /* VECTORTRUE */
		default:	
			printobjectkind(a);
			return error("copy: wrong type");
		};

	if (erg != OK) /* 250391 */
		{
		error("copy:error during computation");
		}
	return erg;
	}

INT append(a,b,e) OP a,b,e;
/* AK 280689 V1.0 */ /* AK 221289 V1.1 */
/* AK 190291 V1.2 */ /* AK 090891 V1.3 */
	{
	INT erg = OK;
	if (a == NULL)  /* AK 190291 */
		return error("append: a == NULL");
	if (b == NULL)  /* AK 190291 */
		return error("append: b == NULL");

	/* integer objecte werden in einen vector umgewandelt AK 260887 */

        if (S_O_K(a) == INTEGER)
        	{
        	OP 	c = callocobject(),
        		d = callocobject();
        	COPY_INTEGER(a,d);
        	m_o_v(d,c);
        	append(c,b,e);
        	freeall(d);freeall(c);
        	return(OK);
        	};

        if (S_O_K(b) == INTEGER)
        	{
        	OP 	c = callocobject(),
        		d = callocobject();
        	COPY_INTEGER(b,d);
        	m_o_v(d,c);
        	append(a,c,e);
        	freeself(d);freeall(c);
        	return(OK);
        	};

	if (EMPTYP(a)) return(copy(b,e));
	if (EMPTYP(b)) return(copy(a,e));

	if (a == e)
        	{
        	OP c = callocobject();
        	copy(a,c);
        	append(c,b,e);
        	freeall(c);
        	return(OK);
        	};

	if (b == e)
        	{
        	OP c = callocobject();
        	copy(b,c);
        	append(a,c,e);
        	freeall(c);
        	return(OK);
        	};

	if (not EMPTYP(e)) 
		erg += freeself(e);
	switch(S_O_K(a))
		{
#ifdef PARTTRUE
		case PARTITION :  erg += append_part_part(a,b,e);
			break;
#endif /* PARTTRUE */
#ifdef VECTORTRUE
		case VECTOR :  erg += append_vector(a,b,e);
			break;
#endif /* VECTORTRUE */
		default:
			{
			printobjectkind(a);
			return error("append:wrong first type");
			}
		};
	if (erg != OK)
		error("append: error during computation");
	return erg;
	}


INT scalarp(a) OP a;
/* test ob scalarer datentyp
 Fri Mar  3 12:43:30 MEZ 1989
AK wahr falls INTEGER,LONGINT,BRUCH */
/* AK 280689 V1.0 */ /* AK 221289 V1.1 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(a))
		{
		case BRUCH:
		case INTEGER:
		case LONGINT:
			return(TRUE);
		default:
			return(FALSE);
		}
	}

INT dynamicp(a) OP a;
/* test ob dynamische datenstruktur */
/* Tue Jan 10 07:16:33 MEZ 1989 */
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 050891 V1.3 */
	{
	switch (S_O_K(a))
		{
		case GRAL: /* AK 050891 */
		case HOM_SYM: /* AK 050891 */
		case BINTREE:
		case MONOPOLY:
		case SCHUR:
		case SCHUBERT:
		case LIST:
			return(TRUE);
		default:
			return(FALSE);
		}
	}

INT hookp(a) OP a;
/* AK 110888 */
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 180391 V1.2 */
/* AK 210891 V1.3 */
	{
#ifdef PARTTRUE
	if (S_O_K(a) != PARTITION) error("hookp:wrong type");
	if (S_PA_K(a) != VECTOR) error("hookp:wrong partition type");
	if (S_PA_LI (a) == 1L) return(TRUE);
	if (S_PA_II (a, S_PA_LI(a) - 2L) == 1L) return(TRUE);
		/* wahr falls vorletzte zeile = 1 */
	return(FALSE);
#else /* PARTTRUE */
	error("hookp:PARTITION not available");return(ERROR);
#endif /* PARTTRUE */
	}


INT nullp(a) OP a;
/* 290388  aus macro */ /* AK 280689 V1.0 */ /* AK 081289 V1.1 */
/* AK 210891 V1.3 */
	{
	switch (S_O_K(a))
		{
		case INTEGER:  return (NULLP_INTEGER(a)); 
#ifdef LONGINTTRUE
		case LONGINT: return nullp_longint(a);
#endif /* LONGINTTRUE */
#ifdef BRUCHTRUE
		case BRUCH: return(NULLP_BRUCH(a));
#endif /* BRUCHTRUE */
#ifdef CYCLOTRUE
		case CYCLOTOMIC: return nullp_cyclo(a);
#endif /* CYCLOTRUE */
#ifdef SQRADTRUE
		case SQ_RADICAL: return nullp_sqrad(a);
#endif /* SQRADTRUE */
#ifdef CHARTRUE
		case SYMCHAR: return nullp_symchar(a); /* AK 010692 */
#endif /* CHARTRUE */
#ifdef POLYTRUE
		case POLYNOM: return nullp_polynom(a);
#endif /* POLYTRUE */
#ifdef VECTORTRUE  /* AK 311091 */
		case VECTOR: return nullp_vector(a);
#endif /* VECTORTRUE */
		default:  return(FALSE);
		};
	}

INT einsp(a) OP a;
/* TRUE if a is unity */
/* 290388  aus macro */ /* AK 280689 V1.0 */ /* AK 081289 V1.1 */
/* AK 250291 V1.2 */ /* AK 210891 V1.3 */
	{
	switch (S_O_K(a)) {
#ifdef BRUCHTRUE
		case BRUCH:  return einsp_bruch(a);
#endif /* BRUCHTRUE */
		case INTEGER:  return einsp_integer(a);
#ifdef LONGINTTRUE
		case LONGINT:  return einsp_longint(a);
#endif /* LONGINTTRUE */
#ifdef PERMTRUE
		case PERMUTATION:  return einsp_permutation(a);
#endif /* PERMTRUE */
		case POLYNOM:  return einsp_polynom(a);
		case GRAL:
#ifdef SCHUBERTTRUE
		case SCHUBERT: return einsp_schubert(a);
#endif /* SCHUBERTTRUE */
		case VECTOR: return einsp_vector(a); /* AK 010692 */
#ifdef CHARTRUE
		case SYMCHAR: return einsp_symchar(a); /* AK 010692 */
#endif /* CHARTRUE */
		default:  return(FALSE);
		};
	}

INT negeinsp(a) OP a;
/* AK 181289 V1.1 */ /* AK 250291 V1.2 */
/* AK 210891 V1.3 */
	{
	switch (S_O_K(a))
		{
#ifdef INTEGERTRUE
		case INTEGER:  return(NEGEINSP_INTEGER(a));
#endif /* INTEGERTRUE */
#ifdef BRUCHTRUE
		case BRUCH:  return(negeinsp_bruch(a));
#endif /* BRUCHTRUE */
		default:  return(FALSE);
		};
	}

INT vexillaryp(a,part) OP a,part;
/* AK 290986 */
/* part ist die Partition zugehoerig zur permutation */
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(a))
		{
#ifdef PERMTRUE
		case PERMUTATION : return(vexillaryp_permutation(a,part));
#endif /* PERMTRUE */
		default:
			{
			printobjectkind(a);
			return error("vexillary:wrong type");
			}
		};
	}

INT lastp(a) OP a;
/*  AK 250986 */ /* AK 280689 V1.0 */ /* AK 181289 V1.1 */
/* AK 200691 V1.2 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(a)) {
#ifdef LISTTRUE
		case HOM_SYM :
		case GRAL :
		case POLYNOM : 	
		case MONOPOLY:
		case SCHUBERT :
		case SCHUR : 
		case LIST : {
			return(lastp_list(a));
			/* AK 210688 */
			}
#endif /* LISTTRUE */
		default: {
			printobjectkind(a);
			return error("cannot check on last");
			}
		};
	}
	
INT odd(a) OP a;
/* AK 210291 V1.2 */ /* AK 210891 V1.3 */
	{
	return not even(a);
	}

INT even(a) OP a;
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210291 V1.2 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(a))
		{
#ifdef INTEGERTRUE
		case INTEGER : return even_integer(a);
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
		case LONGINT : return even_longint(a);
#endif /* LONGINTTRUE */
#ifdef PERMTRUE
		case PERMUTATION : return even_permutation(a); /* AK 010692 */
#endif /* PERMTRUE */
		default:
			{
			printobjectkind(a);
			return error("even:wrong type");
			}
		};
	}

INT negp(a) OP a;
/* AK 190888 */ /* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	switch(S_O_K(a))
		{
#ifdef BRUCHTRUE
		case BRUCH : return negp_bruch(a);
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE
		case INTEGER : return negp_integer(a);
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
		case LONGINT : return negp_longint(a);
#endif /* LONGINTTRUE */
		default:
			{
			printobjectkind(a);
			error("negp: wrong input type");
			return(ERROR);
			}
		};

	}

INT posp(a) OP a;
/* AK 190888 */ /* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	switch(S_O_K(a))
		{
#ifdef BRUCHTRUE
		case BRUCH : return(posp_bruch(a));
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE
		case INTEGER : return(posp_integer(a));
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
		case LONGINT : return(posp_longint(a));
#endif /* LONGINTTRUE */
		default:
			{
			printobjectkind(a);
			error("posp:wrong type");
			return(ERROR);
			}
		};
	}

INT comp(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 281289 V1.1 */ /* AK 210891 V1.3 */
	{
	if (EMPTYP(a) && EMPTYP(b)) return(0L);
	else if (EMPTYP(a)) return(-1L);
	else if (EMPTYP(b)) return(1L);
	else switch(S_O_K(a)){
#ifdef BRUCHTRUE
		case BRUCH : return(comp_bruch(a,b));
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE
		case INTEGER : 
			if (S_O_K(b) == INTEGER)
				return ( S_I_I(a) > S_I_I(b) ? 1L : 
					 S_I_I(a) == S_I_I(b) ? 0L : -1L );
			else
			return comp_integer(a,b);
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
		case LONGINT : return comp_longint(a,b);
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KRANZTYPUS :return comp_kranztafel(a,b);
		case MATRIX : return comp_matrix(a,b);
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM :	return comp_monom(a,b);
#endif /* MONOMTRUE */
#ifdef LISTTRUE
		case SCHUBERT:
		case SCHUR:
		case POLYNOM:
		case MONOPOLY:
		case LIST : return comp_list(a,b);
#endif /* LISTTRUE */
#ifdef PARTTRUE
		case PARTITION: return comp_partition(a,b);
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION: return comp_permutation(a,b);
#endif /* PERMTRUE */
#ifdef CHARTRUE
		case SYMCHAR: return comp_symchar(a,b);
#endif /* CHARTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX :	/* 060588 */
			return comp_tableaux(a,b);
#endif /* TABLEAUXTRUE */
#ifdef WORDTRUE
		case WORD:/* AK 060588 */return COMP_WORD(a,b);
#endif /* WORDTRUE */
#ifdef VECTORTRUE
		case COMP:	/* 010989 */
		case VECTOR : return comp_vector(a,b);
#endif /* VECTORTRUE */
		default:{
			printobjectkind(a);
			error("comp:not possible");
			return(ERROR);
			}
		}
	}

INT lt(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) < 0L) return(TRUE);
	return(FALSE);
	}

INT eq(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) == 0L) return(TRUE);
	return(FALSE);
	}

INT neq(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) != 0L) return(TRUE);
	return(FALSE);
	}

INT gr(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) > 0L) return(TRUE);
	return(FALSE);
	}

INT ge(a,b) OP a,b;
/* AK 260789 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) >= 0L) return(TRUE);
	return(FALSE);
	}

INT gt(a,b) OP a,b;
/* AK 010889 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) > 0L) return(TRUE);
	return(FALSE);
	}

INT le(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 160890 V1.1 */ /* AK 210891 V1.3 */
	{
	if (comp(a,b) > 0L) return(FALSE);
	return(TRUE);
	}

INT listp(a) OP a;
/* AK 030789 V1.0 */ /* AK 160890 V1.1 */ /* AK 060891 V1.3 */
	{
	OBJECTKIND kind = S_O_K(a);
	if (	kind == LIST || 
		kind == POLYNOM || 
		kind == MONOPOLY || 
		kind == GRAL || 
		kind == HOM_SYM || 
		kind == SCHUR || 
		kind == SCHUBERT
            ) return(TRUE);
	else return(FALSE);
	}
	    
#ifdef INTEGERTRUE
INT factorize_integer(a,b) OP a,b;
/* a integer b wird vector of integer */
/* AK 060690 V1.1 */ /* AK 060891 V1.3 */
{
	INT ai = S_I_I(a);
	INT i=2L;
	if (not EMPTYP(b)) freeself(b);
	m_il_v(0L,b);
	while (i <= ai) 
		{
		if (ai % i == 0L) {
			inc(b);
			m_i_i(i,S_V_I(b,S_V_LI(b)-1L));
			ai = ai / i; continue; }
		i++;
		}
	return OK;
}
#endif /* INTEGERTRUE */


INT invers_apply_integer(a) OP a;
/* AK 140591 V1.2 */ /* AK 060891 V1.3 */
	{ 
#ifdef BRUCHTRUE
	return m_ioiu_b(1L, S_I_I(a), a);
#else /* BRUHTRUE */
	return error("invers_apply_integer:BRUCH not available");
#endif /* BRUCHTRUE */
	}

INT addinvers_apply_integer(a) OP a;
/* AK 201289 V1.1 */ /* AK 140591 V1.2 */ /* AK 060891 V1.3 */
	{ 
	M_I_I(- S_I_I(a), a);
	return OK;  
	}


INT addinvers_integer(a,b) OP a,b;
/* AK 280689 V1.0 */ /* AK 131289 V1.1 */ /* AK 060891 V1.3 */
	{ 
	M_I_I(- S_I_I(a), b);
	return OK;  
	}

INT inc_integer(a) OP a;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{ 
	C_I_I(a,S_I_I(a)+1L); 
	return(OK); 
	}

INT dec_integer(a) OP a;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{ 
	C_I_I(a,S_I_I(a)-1L); 
	return(OK); 
	}

INT mult_integer_integer(a,b,d) OP a,b,d;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{
	INT l;
	l=intlog(a) + intlog(b);
	if ( l> 7L) 
			{
#ifdef LONGINTTRUE
			OP c= callocobject(); 
			OP e= callocobject(); 
			t_int_longint(b,e);
			t_int_longint(a,c);
			mult_longint_longint(c,e,d); 
			freeall(c); 
			freeall(e);
			return(OK);
#else /* LONGINTTRUE */
			return error("mult_integer_integer:no LONGINT");
#endif /* LONGINTTRUE */
			}

	M_I_I(S_I_I(a)*S_I_I(b),d);
	return(OK);
	}

INT mult_integer(a,b,d) OP a,b,d;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{
	INT erg=OK;
	/* es gilt S_O_K(a) == INTEGER */
	if (S_O_K(a) != INTEGER)
		{
		printobjectkind(a);
		return error("mult_integer: wrong type");
		}

	switch(S_O_K(b)) {
#ifdef BRUCHTRUE
		case BRUCH: erg += mult_bruch_integer(b,a,d);break;
#endif /* BRUCHTRUE */
		case INTEGER: erg += mult_integer_integer(a,b,d);break;
#ifdef LONGINTTRUE
		case LONGINT: erg += mult_longint_integer(b,a,d);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KRANZTYPUS :
		case MATRIX:  erg += mult_scalar_matrix(a,b,d);break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM: erg += mult_scalar_monom(a,b,d);break;
#endif /* MONOMTRUE */
#ifdef POLYTRUE
		case GRAL:
		case POLYNOM: erg += mult_scalar_polynom(a,b,d);break;
#endif /* POLYTRUE */
#ifdef SCHUBERTTRUE
		case SCHUBERT: erg += mult_scalar_schubert(a,b,d);break;
#endif /* SHUBERTTRUE */
#ifdef SCHURTRUE
		case SCHUR: erg += mult_scalar_schur(a,b,d);break;
#endif /* SCHURTRUE */
#ifdef CHARTRUE
		case SYMCHAR: erg += mult_scalar_symchar(a,b,d);break;
#endif /* CHARTRUE */
#ifdef VECTORTRUE
		case VECTOR: erg += mult_scalar_vector(a,b,d);break;
#endif /* VECTORTRUE */
#ifdef PERMTRUE
		case PERMUTATION:
			if (NULLP_INTEGER(a)) 
				erg+= m_i_i(0L,d); 
			else 
			{
			printobjectkind(b);
			erg += error("mult_integer:wrong second kind");
			}
			break;
#endif /* PERMTRUE */
		default:
			{
			printobjectkind(b);
			error("mult_integer:wrong second kind");
			return(ERROR);
			}
		}
	if (erg != OK)
		return error("mult_integer: error in computing");
	return erg;
	}

INT even_integer(a) OP a;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{ 
	return(S_I_I(a) %2L == 0L); 
	}

INT posp_integer(a) OP a;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{ 
	return(S_I_I(a) > 0L); 
	}

INT negp_integer(a) OP a;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{ 
	return(S_I_I(a) < 0L); 
	}

INT add_integer_integer(a,b,c) OP a,b,c;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{
	if 	((S_I_I(b) >1000000L)|| (S_I_I(b) < -1000000L))
		{
#ifdef LONGINTTRUE
		OP d = callocobject(); 
		m_i_longint(S_I_I(b),d);
		add(a,d,c); 
		freeall(d); 
		return(OK);
#else /* LONGINTTRUE */
		return error("add_integer_integer:overflow no LONGINT");
#endif /* LONGINTTRUE */
		};
	M_I_I(S_I_I(a)+S_I_I(b),c);
	return OK;
	}

INT add_integer(a,b,c) OP a,b,c;
/* das erste object ist vom typ INTEGER, das ergebnis ist ein leere
object */
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */ /* AK 280291 V1.2 */
/* AK 060891 V1.3 */
	{
	INT erg = OK;
#ifdef LONGINTTRUE
	if ( (S_I_I(a) >1000000L) || (S_I_I(a) < -1000000L))
		{
		OP d = callocobject(); 
		erg += m_i_longint(S_I_I(a),d);
		erg += add(d,b,c); 
		erg += freeall(d); 
		if (erg != OK)
			return error("add_integer: (1) error in computation");
		return erg;
		}
#endif /* LONGINTTRUE */

	switch(S_O_K(b))
		{
#ifdef BRUCHTRUE
		case BRUCH: erg += add_bruch_scalar(b,a,c); break;
#endif /* BRUCHTRUE */
		case INTEGER: erg += add_integer_integer(a,b,c); break;
#ifdef LONGINTTRUE
		case LONGINT: erg += add_longint(b,a,c); break;
#endif  /* LONGINTTRUE */
#ifdef POLYTRUE   /* AK 060891 */
		case POLYNOM: erg += add_scalar_polynom(a,b,c); break;
#endif /* POLYTRUE */
		default :
			{
			if (NULLP_INTEGER(a)) 
				return copy(b,c);
			printobjectkind(a); 
			printobjectkind(b);
			return error("add_integer:wrong second type");
			};
		}
	if (erg != OK)
		return error("add_integer: (2) error in computation");
	return erg;
	}

INT comp_integer_integer(a,b) OP a,b;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{
	INT ai = S_I_I(a);
	INT bi = S_I_I(b);
	if (ai == bi) return(0L);
	if (ai > bi) return(1L);
	return(-1L);
	}

INT comp_integer(a,b) OP a,b; 
/* a ist vom typ INTEGER, b ist von unbekannten typ */
/* AK 280888 */ /* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	switch (S_O_K(b))
		{
#ifdef BRUCHTRUE
		case BRUCH: return (-1L) * comp_bruch_scalar(b,a);
#endif /* BRUCHTRUE */
		case INTEGER:return COMP_INTEGER_INTEGER(a,b); 
#ifdef LONGINTTRUE
		case LONGINT: return (-1L) * comp_longint(b,a);
#endif /* LONGINTTRUE */
		default:
			{
			printobjectkind(b);
			error("comp_integer: wrong second type");
			return(ERROR);
			}
		}
	} 


INT ganzdiv_integer(a,b,c) OP a,b,c;
/* AK 280888 */ /* AK 270689 V1.0 */ /* AK 081289 V1.1 */  /* AK 130691 V1.2 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(b))
		{
		case INTEGER: M_I_I(S_I_I(a) / S_I_I(b), c);return OK;
#ifdef LONGINTTRUE
		case LONGINT:
			{
			OP d = callocobject(); 
			m_i_longint(S_I_I(a),d);
			ganzdiv_longint(d,b,c);
			freeall(d);
			return(OK);
			};
#endif /* LONGINTTRUE */
#ifdef BRUCHTRUE       /* AK 130691 V1.2 */
		case BRUCH: 
			{
			if (einsp(S_B_U(b)))
				return ganzdiv_integer(a,S_B_O(b),c);
			else
				{
		printobjectkind(b); debugprint(b);
		return error("ganzdiv_integer: wrong bruch as second type");
				}
			}
#endif /* BRUCHTRUE */
		default:
			{
			printobjectkind(a); debugprint(a);
			printobjectkind(b); debugprint(b);
			return error("ganzdiv_integer: wrong second type");
			}
		}
	}

INT quores_integer(a,b,c,d) OP a,b,c,d;
/* AK 280888 */ /* AK 270689 V1.0 */ /* AK 081289 V1.1 */
/* AK 210891 V1.3 */
	{
	switch(S_O_K(b))
		{
		case INTEGER: return(M_I_I(S_I_I(a) / S_I_I(b), c),
                                     M_I_I(S_I_I(a) % S_I_I(b), d), OK);
#ifdef LONGINTTRUE
		case LONGINT:
			{
			OP e = callocobject(); 
			m_i_longint(S_I_I(a),e);
			quores_longint(e,b,c,d);
			freeall(e);
			return(OK);
			};
#endif /* LONGINTTRUE */
		default:
			{
			printobjectkind(b);
			return error("quores_integer: wrong second type");
			}
		}
	}

INT nullp_integer(a) OP a;
/* AK 280689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ return(S_I_I(a) == 0L); }

INT einsp_integer(a) OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ 
	return(S_I_I(a) == 1L); 
	}

INT negeinsp_integer(a) OP a;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ 
	return(S_I_I(a) == -1L); 
	}

INT copy_integer(a,b) OP a,b;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ 
	M_I_I(S_I_I(a),b);
	return OK;
	}
	
INT invers_integer(a,b) OP a,b;
/* AK 031286 */ /* AK 220888 gilt auch bei longint */
/* AK 270689 V1.0 */ /* AK 151289 V1.1 */ /* AK 210891 V1.3 */
	{
#ifdef BRUCHTRUE
	if (S_O_K(a) != INTEGER) 
		{
		if (S_O_K(a) != LONGINT) 
			{
			printobjectkind(a);
			return error("invers_integer: wrong type");	
			}
		b_ou_b(callocobject(),callocobject(),b);
		M_I_I(1L,S_B_O(b)); 
		copy(a,S_B_U(b)); 
		return OK;
		}

	if (EINSP_INTEGER(a)) return(copy(a,b));
	if (NEGEINSP_INTEGER(a)) return(copy(a,b));
	b_ou_b(callocobject(),callocobject(),b);
	M_I_I(1L,S_B_O(b)); 
	COPY_INTEGER(a,S_B_U(b)); 
	return OK;
#else /* BRUCHTRUE */
	error("invers_integer:BRUCH not available");return(ERROR);
#endif  /* BRUCHTRUE */
	}

INT mod_integer(a,b,c) OP a,b,c;
/* AK 280888 */ /* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	switch (S_O_K(b))
		{
		case INTEGER: M_I_I((S_I_I(a) % S_I_I(b)),c);
				return OK;
#ifdef LONGINTTRUE
		case LONGINT: 
			{
			OP d = callocobject(); 
			m_i_longint(S_I_I(a),d);
			mod_longint(d,b,c);
			freeall(d);
			return(OK);
			};
#endif /* LONGINTTRUE */
		default:
			{
			printobjectkind(b);
			error("mod_integer:wrong second type");
			return(ERROR);
			}
		};
	}

INT random_integer(erg,para1,p2) OP erg,para1,p2; 
/* AK 150587 */ /* AK 090688 geaendert, angepasst an random */
/* para1 = untergrenze, p2= obergrenze */
/* ergibt zufallszahl zwischen untergrnze <
ergebnis < obergrenze */
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{
	INT untergrenze,obergrenze;

	if (para1==NULL) untergrenze=0L;
	else if (S_O_K(para1) != INTEGER)
		error("para1 != INTEGER in randominteger");
	else untergrenze = S_I_I(para1);


	if (p2==NULL) obergrenze=untergrenze + 10;
	else if (S_O_K(p2) != INTEGER)
		error("p2 != INTEGER in randominteger");
	else obergrenze = S_I_I(p2);

	M_I_I( untergrenze + (INT)(
		  ( (rand()%32767)/32767.0 )
		* (obergrenze - untergrenze)
			) ,erg);
	return(OK);
	}

INT tex_integer(a) OP a;
/* AK 101187 */ /* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 070291 V1.2 prints to texout instead of stdout */
/* AK 210891 V1.3 */
	{
	texposition +=  /* AK 210291 */ intlog(a);
	if (S_I_I(a) <0L) texposition++; 
	fprintf(texout," $%ld$ ",S_I_I(a)); 
	return OK;
	}


INT scan_integer(ergebnis) OP ergebnis;
/* liest ein integerobject ein AK 270787 */
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 080591 V1.2 */
/* AK 210891 V1.3 */
	{
	INT eingabe;

	printeingabe("integerobject ");
	scanf("%ld",&eingabe);
	M_I_I(eingabe,ergebnis);
	return OK;
	}

INT objectread_integer(filename,obj) FILE *filename; OP obj;
/* AK 131086 */ /* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 020591 V1.2 */
/* AK 210891 V1.3 */
	{
	INT eingabe;
	fscanf(filename,"%ld",&eingabe); 
	M_I_I(eingabe,obj); 
	return(OK); 
	}

INT objectwrite_integer(filename,obj) FILE *filename; OP obj;
/* AK 131086 */ /* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ 
	fprintf(filename," %ld %ld\n",(INT)INTEGER,S_I_I(obj)); 
	return(OK); 
	}

INT fprint_integer(f,a) FILE *f; OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{
	if (f == stdout) { zeilenposition +=  /* AK 270290 */ intlog(a);
		if (S_I_I(a) <0L) zeilenposition++; }
	fprintf(f,"%ld",S_I_I(a)); 
	if (f == stdout) /* AK 290192 */
	if (zeilenposition >= 70L)
		{
		fprintf(f,"\n");
		zeilenposition = 0L;
		}
	return(OK);
	}

INT s_i_i(a) OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{ 
	if (s_o_k(a) != INTEGER)   /* AK 081191 */
		{
		printobjectkind(a);
		error("s_i_i: object is not INTEGER");
		}
	return(a->ob_self.ob_INT); 
	}

INT c_i_i(a,b) OP a;INT b;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	if (s_o_k(a) != INTEGER)   /* AK 081191 */
		{
		printobjectkind(a);
		error("c_i_i: object is not INTEGER");
		}
	a->ob_self.ob_INT=b;
        return(OK); 
	}

INT m_i_i(a,b) INT a;OP b;
/* AK 270689 V1.0 AK 181289 V1.1 AK 110291 V1.2 AK 060891 V1.3 */
	{  
	/* first we free the memory */
	if (not emptyp(b)) 
		if (freeself(b) != OK) 
			return(error("m_i_i:error in freeself"));
	/* now we change the type to INTEGER */
	c_o_k(b,INTEGER); 
	/* now we write the value */
	c_i_i(b,a); 
	/* now everything was ok */
	return(OK);
	}

INT freeself_integer(a) OP a;
/* AK 270689 V1.0 AK 181289 V1.1 AK 210891 V1.3 */
	{ 
	C_O_K(a,EMPTY); return(OK); 
	}

INT test_integer()
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{
	OP a=callocobject();
	OP b=callocobject();
	INT erg;

	m_i_i(5L,a);printf("test_integer:m_i_i(5L,a)\n"); debugprint_object(a);
	C_I_I(a,7L);printf("test_integer:c_i_i(a,7L)\n"); debugprint_object(a);
	printf("test_integer:fprint_integer(a)\n"); fprint_integer(stdout,a);
	printf("\n");
	printf("test_integer:tex_integer(a)\n"); tex_integer(a);printf("\n");
	printf("test_integer:copy_integer(a,b)\n"); copy_integer(a,b);
	printf("b=");println(b);
	printf("test_integer:comp_integer_integer(a,b)\n");
	erg=comp_integer_integer(a,b);printf("%ld\n",erg);
	free(a);free(b);return(OK);
	}

INT add_apply_scalar_polynom(a,b) OP a,b;
/* AK 110990 V1.1 */ /* AK 270291 V1.2 */ /* AK 080891 V1.3 */
/* a is INTEGER BRUCH LONGINT */
{
#ifdef POLYTRUE 
	INT erg;
	OP c = callocobject();
	m_scalar_polynom(a,c);
	erg = add_apply(c,b);
	freeall(c);
	return erg;
#else /* POLYTRUE */
	debugprint(a);
	debugprint(b);
	return error("add_apply_scalar_polynom:not implemented");
#endif /* POLYTRUE */
}

INT add_apply_integer(a,b) OP a,b;
/* AK 120390 V1.1 */ /* AK 080891 V1.3 */
{
	OP c;
	INT erg=OK;
	switch(S_O_K(b)) {
#ifdef BRUCHTRUE 
		case BRUCH:  erg += add_apply_scalar_bruch(a,b);break;
#endif /* BRUCHTRUE */
		case INTEGER: erg += add_apply_integer_integer(a,b);break;
#ifdef LONGINTTRUE 
		case LONGINT: erg += add_apply_integer_longint(a,b);break;
#endif /* LONGINTTRUE */
		case POLYNOM:
		case SCHUBERT:
		case SCHUR:erg += add_apply_scalar_polynom(a,b);break;
		default: 
			/*
			printobjectkind(b);
			error("add_apply_integer: wrong second type");
			return(ERROR);
			*/
			c = callocobject();
			*c = *b;
			C_O_K(b,EMPTY);
			erg += add(a,c,b);
			erg += freeall(c); 
			break;
		}
	if (erg != OK)
		error("add_apply_integer: error during computation");
	return erg;
}	


#ifdef MATRIXTRUE
INT mult_apply_integer_matrix(a,b) OP a,b;
/* b = b* a */ /* AK 220390 V1.1 */ /* AK 250291 V1.2 */
/* AK 080891 V1.3 */
	{
	OP z = S_M_S(b);
	INT i = S_M_HI(b)*S_M_LI(b);
	INT erg = OK;
	for(;i>0;i--,z++) erg += mult_apply_integer(a,z);
	return erg;
	}
#endif /* MATRIXTRUE */

#ifdef BRUCHTRUE
INT mult_apply_integer_bruch(a,b) OP a,b;
/* b = b* a */ /* AK 220390 V1.1 */ /* AK 250291 V1.2 */
/* AK 210891 V1.3 */
	{
	mult_apply_integer(a,S_B_O(b));
	return(kuerzen(b));
	}
#endif /* BRUCHTRUE */

INT mult_apply_integer(a,b) OP a,b;
/* b = b* a */ /* AK 201289 V1.1 */ /* AK 250291 V1.2 */
/* AK 210891 V1.3 */
{
	switch(S_O_K(b)) {
#ifdef BRUCHTRUE
		case BRUCH:return(mult_apply_integer_bruch(a,b));
#endif /* BRUCHTRUE */
		case INTEGER:return(mult_apply_integer_integer(a,b));
#ifdef LONGINTTRUE
		case LONGINT:return(mult_apply_integer_longint(a,b));
#endif /* LONGINTTRUE */
		case KRANZTYPUS :
#ifdef MATRIXTRUE
		case MATRIX:return(mult_apply_integer_matrix(a,b));
#endif /* MATRIXTRUE */
		case MONOM:return(mult_apply_scalar_monom(a,b));
		case SCHUR:
		case SCHUBERT:
		case GRAL:
		case POLYNOM:return mult_apply_scalar_polynom(a,b);
		default: 
			{
			OP c = callocobject();
			INT erg;
			*c = *b; 
			C_O_K(b,EMPTY);
			erg = mult(a,c,b);
			if (erg == ERROR) {
				printobjectkind(c);
				error("mult_apply_integer: wrong second type");
				}
			freeall(c); 
			return erg;
			}
		}
}

INT mult_apply_integer_integer(a,b) OP a,b;
/* AK 201289 V1.1 */ /* AK 250291 V1.2 */
/* AK 210891 V1.3 */
{ 
	OP c;
	INT l;
	if ( 
		(S_I_I(a) < 10000L) && (S_I_I(a) > -10000L)
		&&
		(S_I_I(b) < 10000L) && (S_I_I(b) > -10000L)
	    )  
		return( M_I_I(S_I_I(a)*S_I_I(b),b) ); 
	else
		l=intlog(a) + intlog(b);
	if ( l > 8L )
		{
#ifdef LONGINTTRUE
		c = callocobject();
		t_int_longint(b,c);
		*b = *c; free(c);
		return mult_apply_integer_longint(a,b);
#else /* LONGINTTRUE */
		return 
		error("mult_apply_integer_integer: LONGINT not available");
#endif /* LONGINTTRUE */
		}
	else 
		return( M_I_I(S_I_I(a)*S_I_I(b),b) ); 
}


INT add_apply_integer_integer(a,b) OP a,b;
/* AK 120390 V1.1 */ /* AK 250291 V1.2 */ /* AK 210891 V1.3 */
{ 

	if ( 
		(S_I_I(a) >1000000L) ||  (S_I_I(b) > 1000000L) ||
		(S_I_I(a) < -1000000L) ||  (S_I_I(b) < -1000000L) )
		{
#ifdef LONGINTTRUE
		OP c;
		c = callocobject();
		t_int_longint(b,c);
		*b = *c; free(c);
		return add_apply_integer_longint(a,b);
#else /* LONGINTTRUE */
		return error("add_apply_integer_integer:Overflow no LONGINT");
#endif /* LONGINTTRUE */
		}
	
	C_I_I(b,	S_I_I(a)+S_I_I(b)	); 
	return OK;
}

INT intlog(a) OP a;
/* anzahl stellen */ /* AK 150290 V1.1 */ /* AK 250291 V1.2 */
/* AK 210891 V1.3 */
	{
	INT ai = S_I_I(a);
	if (ai < 0L) ai = -ai;
	if (ai >= 1000000000L) return(10L);
	if (ai >= 100000000L) return(9L);
	if (ai >= 10000000L) return(8L);
	if (ai >= 1000000L) return(7L);
	if (ai >= 100000L) return(6L);
	if (ai >= 10000L) return(5L);
	if (ai >= 1000L) return(4L);
	if (ai >= 100L) return(3L);
	if (ai >= 10L) return(2L);
	return(1L);
	}

INT random(kind,erg,para1,p2,p3)OBJECTKIND kind; OP erg,para1,p2,p3;
/* AK 030789 V1.0 */ /* AK 080290 V1.1 */ /* AK 250291 V1.2 */
/* AK 210891 V1.3 */
	{
	if (not EMPTYP(erg)) freeself(erg);
	switch(kind) {
		case INTEGER: 	return(random_integer(erg,para1,p2));
		default: 	{
			error("kann kein random");
			return(ERROR);
			}
		};
	}

INT init(kind,a) OBJECTKIND kind; OP a;
/* AK 300588 */ /* AK 030789 V1.0 */ /* AK 060390 V1.1 */ /* AK 250291 V1.2 */
/* AK 050891 V1.3 */
	{
	INT erg=OK;
	if (kind == EMPTY) 
		return error("init:EMPTY");
	if (not EMPTYP(a)) 
		erg += freeself(a);
	switch (kind) {
#ifdef BINTREETRUE
		case BINTREE: erg +=  init_bintree(a); break;
#endif /* BINTREETRUE */
#ifdef BRUCHTRUE
		case BRUCH: erg += b_ou_b(callocobject(),callocobject(),a);
				break;
#endif /* BRUCHTRUE */
#ifdef GENCHARTRUE
		case GEN_CHAR: erg +=  init_gen_char(a); break;
#endif /* GENCHARTRUE */
		case INTEGER: break;
#ifdef KRANZTRUE
		case KRANZ:  erg+= init_kranz(a);break;
#endif /* KRANZTRUE */
#ifdef LISTTRUE
		case LIST: erg += b_sn_l(NULL,NULL,a); break;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT: erg += init_longint(a); break;
#endif /* LONGINTTRUE */
#ifdef MONOMTRUE
		case MONOM: erg += b_sk_mo(callocobject(),callocobject(),a);
				break;
#endif /* MONOMMTRUE */
#ifdef NUMBERTRUE 
		case CYCLOTOMIC:
		case SQ_RADICAL:
			/* MD */
			erg += b_ksd_n(kind,callocobject(),callocobject(),a); 
			break;
#endif /* NUMBERTRUE */
#ifdef PARTTRUE
		case PARTITION: 
			erg+= b_ks_pa(VECTOR,callocobject(),a);break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION: 
			erg+=b_ks_p(VECTOR,callocobject(),a);break;
#endif /* PERMTRUE */
		case GRAL:
		case HOM_SYM: /* AK 050891 */
		case MONOPOLY:
#ifdef POLYTRUE
		case POLYNOM: 
#endif /* POLYTRUE */
		case SCHUBERT: 
#ifdef SCHURTRUE
		case SCHUR:  
#endif /* SCHURTRUE */
			erg += b_sn_l(NULL,NULL,a);   /* NEW */
			C_O_K(a,kind);
			break;
#ifdef TABLEAUXTRUE
		case TABLEAUX:
			erg+=b_us_t(callocobject(),callocobject(),a); break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE   /* AK 071190 */
		case VECTOR:
			erg += b_ls_v(callocobject(),NULL,a); 
			erg += M_I_I(0L,S_V_L(a));
			break;
#endif /* VECTORTRUE */
		default: 
			fprintf(stderr,"kind = %ld\n",(INT) kind);
			return error("init:wrong kind");
		}
	
	if (erg != OK)
		{
		error("init:error during computation");
		}
	return erg;
}

INT next(von,nach) OP von, nach;
/* AK 220488 */ /* AK 030789 V1.0 */ /* AK 081289 V1.1 */ /* AK 250291 V1.2 */
/* AK 050891 V1.3 */
	{
	if (von == nach)
		{
		OP c = callocobject(); 
		INT erg;
		*c = *nach; 
		C_O_K(nach,EMPTY);
		erg = next(c,nach); 
		freeall(c); 
		return(erg);
		};
	if (not EMPTYP(nach)) freeself(nach);
	switch(S_O_K(von))
		{
#ifdef PARTTRUE
		case PARTITION: {
			return((next_partition(von,nach) 
				== 
				LASTPARTITION)?
						FALSE : TRUE);
			}
		case COMP: {
			return((next_composition(von,nach) 
				== 
				LASTCOMP)?
						FALSE : TRUE);
			}
#endif
#ifdef PERMTRUE
		case PERMUTATION: {
			return((next_permutation(von,nach) == LASTPERMUTATION)?
				FALSE : TRUE);
			}
#endif
		default:
			{
			printobjectkind(von);
			return error("next:wrong type");
			}
		}
	}



INT insert(a,c,eh,cf) OP a,c; INT (*eh)(),(*cf)();
/* AK 221286*/ /* AK 030789 V1.0 */ /* AK 221289 V1.1 */ /* AK 250291 V1.2 */
/* AK 060891 V1.3 */
	{
	if (a == NULL) 
		return error("insert:first == NULL");
	if (a == c) 
		return error("insert:first == ERGEBNIS");
	if (EMPTYP(a))  
		return freeall(a);
		

	switch(S_O_K(c))
		{
#ifdef BINTREETRUE
		case BINTREE: return(insert_bintree(a,c,
						eh,cf));
#endif /* BINTREETRUE */
#ifdef LISTTRUE
		case LIST: return(insert_list(a,c,
						eh,cf));
#endif /* LISTTRUE */
		case MONOPOLY:
		case SCHUR:
		case SCHUBERT:
		case HOM_SYM: /* AK 060891 */
#ifdef POLYTRUE
		case GRAL:
		case POLYNOM: 
#endif /* POLYTRUE */
			{
#ifdef LISTTRUE
			if (cf == NULL)
				cf= comp_monomvector_monomvector;
			return(insert_list(a,c,
					  add_koeff,cf));
#endif /* LISTTRUE */
			}
		};

	switch(S_O_K(a))
		{
#ifdef POLYTRUE
		case GRAL:
		case HOM_SYM: /* AK 060891 */
		case MONOPOLY:
		case SCHUBERT:
		case SCHUR:
		case POLYNOM:{
			if (cf == NULL)
				cf= comp_monomvector_monomvector;
			return(insert_list(a,c,
					  add_koeff,cf));

			}
#endif /* POLYTRUE */
		default: {
			printobjectkind(a);
			printobjectkind(c);
			return error("insert:wrong first or second type");
			}
		};
	}


INT first(kind,erg,para1) OBJECTKIND kind; OP erg,para1;
/* AK 270788 */ /* AK 030789 V1.0 */ /* AK 060390 V1.1 */ /* AK 200691 V1.2 */
/* AK 210891 V1.3 */
	{
	if (not EMPTYP(erg)) 
		freeself(erg);
	switch (kind)
		{
#ifdef PERMTRUE
		case PERMUTATION:  return(first_permutation(para1,erg)); 
#endif /* PERMTRUE */
#ifdef PARTTRUE
		case PARTITION:  return(first_partition(para1,erg)); 
#endif /* PARTTRUE */
		default: return error("first:wrong kind");
		};
	}

INT b_ks_o(kind,self,object) OBJECTKIND kind; OBJECTSELF self; OP object;
/* build_kind_self_object */ /* AK 061086 */
/* erzeugt ein object der art kind (z.B. VECTOR)
und einen pointer auf self, das eigentliche
object (z.B. struct vector) 270787/ */
/* AK 270689 V1.0 */ /* AK 060390 V1.1 */
/* AK 210891 V1.3 */
	{
	if (not EMPTYP(object))
		freeself(object);
	C_O_K(object,kind); 
	C_O_S(object,self); 
	return(OK);
	}


OP callocobject()
/* erzeugt den speicherplatz fuer ein object 270787 */
/* AK 270689 V1.0 */ /* AK 170190 V1.1 */ /* AK 060891 V1.3 */
	{
	OP c;

	if (speicherposition >= 0L) /* AK 111091 */
		c = speicher[speicherposition--];
	else

		c = (OP) malloc(sizeof(struct object));
	if (c == NULL) error("callocobject:NULL object");
	C_O_K(c,EMPTY);
	return c;
	}

OBJECTSELF s_o_s(a) OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */ /* AK 060891 V1.3 */
	{
	if (a==NULL) {error("s_o_s:object == NULL");}
	return(a->ob_self);
	}

OBJECTKIND s_o_k(a) OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	if (a==NULL) {return((OBJECTKIND) error("s_o_k:object == NULL"));}
	return(a->ob_kind);
	}

INT c_o_k(a,b) OP a; OBJECTKIND b;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	if (a==NULL) {
		error("c_o_k:object == NULL");
		return(ERROR);
		}
	a->ob_kind = b;
	return(OK);
	}

INT c_o_s(a,b) OP a; OBJECTSELF b;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	if (a==NULL) {error("c_o_s:object == NULL");return(ERROR);}
	a->ob_self = b; return(OK);
	}

INT emptyp(a) OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_o_k(a) == EMPTY); }

INT test_callocobject()
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	OP a = callocobject();
	printf("test_callocobject: sizeof(OP)=%d\n",sizeof(a));
	printf("test_callocobject: sizeof(*OP)=%d\n",sizeof(*a));
	printf("test_callocobject: sizeof(struct object)=%d\n",sizeof(struct object));
	if (a==NULL) {
	printf("test_callocobject: NULL-object");return(OK);}
	printf("test_callocobject: a=%ld\n",a);
	printf("test_callocobject: a->ob_kind=%d\n",a->ob_kind);
	printf("test_callocobject: a->ob_self.ob_INT=%ld\n",
						(a->ob_self).ob_INT);
	free(a);
	return(OK);
	}

INT debugprint_object(a) OP a;
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	if (a==NULL) {
	fprintf(stderr,"debugprint_object: NULL-object");return(OK);}
	fprintf(stderr,"debugprint_object: a=%ld\n",a);
	fprintf(stderr,"debugprint_object: kind=%d\n",a->ob_kind);
	fprintf(stderr,"debugprint_object: self.INT=%ld\n",a->ob_self.ob_INT);
	return(OK);
	}

INT test_object()
/* AK 270689 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	OP a=callocobject();
	OBJECTSELF d;
	printf("test von callocobject()\n");
	test_callocobject();
	printf("\nobject vor c_o_k()\n");
	debugprint_object(a);
	c_o_k(a,(OBJECTKIND)5);
	printf("\nobject nach c_o_k(a,5)\n");
	debugprint_object(a);
	d.ob_INT = 12345L;
	c_o_s(a,d);
	printf("\nobject nach c_o_s(a,12345L)\n");
	debugprint_object(a);
	free(a);
	return(OK);
	}


#ifdef SKEWPARTTRUE
OP s_spa_g(a) OP a;
/* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ OBJECTSELF b; b = s_o_s(a); return(b.ob_skewpartition->spa_gross); }

INT c_spa_g(a,b) OP a,b;
/* AK 280789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ OBJECTSELF c;
	c=s_o_s(a);
	c.ob_skewpartition->spa_gross=b;
	return(OK); }

OP s_spa_k(a) OP a;
/* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ OBJECTSELF c; c = s_o_s(a); return(c.ob_skewpartition->spa_klein); }

INT c_spa_k(a,b) OP a,b;
/* AK 280789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ OBJECTSELF c;c=s_o_s(a);c.ob_skewpartition->spa_klein=b;return(OK);}

OP s_spa_gi(a,i) OP a; INT i;
/* AK 260789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_pa_i(s_spa_g(a),i)); }

OP s_spa_ki(a,i) OP a; INT i;
/* AK 260789 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_pa_i(s_spa_k(a),i)); }

INT s_spa_gii(a,i) OP a; INT i;
/* AK 260789 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_pa_ii(s_spa_g(a),i)); }

INT s_spa_gli(a,i) OP a;
/* AK 260789 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_pa_li(s_spa_g(a))); }

INT s_spa_kii(a,i) OP a; INT i;
/* AK 260789 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_pa_ii(s_spa_k(a),i)); }

INT s_spa_kli(a,i) OP a;
/* AK 260789 V1.1 */
/* AK 210891 V1.3 */
	{ return(s_pa_li(s_spa_k(a))); }
#endif

INT lastof_skewpartition(a,b) OP a,b;
/* AK 280789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	return(lastof(s_spa_g(a),b));
#else
	return error("lastof_skewpartition:SKEWPARTITION not available");
#endif
	}

INT length_skewpartition(a,b) OP a,b;
/* AK 280789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	return length(s_spa_g(a),b);
#else /* SKEWPARTTRUE */
	error("length_skewpartition:SKEWPARTITION not available");return(ERROR);
#endif /* SKEWPARTTRUE */
	}

INT freeself_skewpartition(a) OP a;
/* AK 280789 V1.1 */ /* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	OBJECTSELF c;
	INT erg = OK;
	c = s_o_s(a);

	erg += freeall(s_spa_g(a)); 
	erg += freeall(s_spa_k(a));
	free(c.ob_skewpartition); 
	return erg;
#else /* SKEWPARTTRUE */
	error("freeself_skewpartition:SKEWPARTITION not available");
	return(ERROR);
#endif /* SKEWPARTTRUE */
	}

INT copy_skewpartition(a,b) OP a,b;
/* AK 280789 V1.1 */ /* AK 140891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	b_gk_spa(callocobject(),callocobject(),b);
	copy(s_spa_g(a),s_spa_g(b)); copy(s_spa_k(a),s_spa_k(b)); return(OK);
#else /* SKEWPARTTRUE */
	error("copy_skewpartition:SKEWPARTITION not available"); return(ERROR);
#endif /* SKEWPARTTRUE */
	}

INT weight_skewpartition(a,b) OP a,b;
/* AK 020488 */ /* AK 060390 V1.1 */ /* AK 020591 V1.2 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	OP c=callocobject(), d=callocobject(); 
	weight(s_spa_g(a),c); weight(s_spa_k(a),d); sub(c,d,b);
	freeall(c);freeall(d); return(OK);
#else /* SKEWPARTTRUE */
	return error("weight_skewpartition:SKEWPARTITION not available");
#endif /* SKEWPARTTRUE */
	}

INT objectread_skewpartition(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 020591 V1.2 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	b_gk_spa(callocobject(),callocobject(),a);
	objectread(f,s_spa_g(a));
	objectread(f,s_spa_k(a));
	return OK;
#else /* SKEWPARTTRUE */
	return error("objectread_skewpartition:SKEWPARTITION not available");
#endif /* SKEWPARTTRUE */
	}

INT objectwrite_skewpartition(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	fprintf(f, "%ld ", (INT)SKEWPARTITION);
	objectwrite(f,s_spa_g(a));
	objectwrite(f,s_spa_k(a));
	return OK;
#endif /* SKEWPARTTRUE */
	}

INT dimension_skewpartition(a,b) OP a,b;
/* dimension der dartsellung */
/* AK 020890 V1.1 */ /* AK 210891 V1.3 */
{
#ifdef SKEWPARTTRUE
	OP c = callocobject();
	part_part_skewschur(S_SPA_G(a),S_SPA_K(a),c);
	dimension(c,b);
	freeall(c);
	return OK;
#endif /* SKEWPARTTRUE */
}


INT starpart(a,b,c) OP a,b,c;
/* 020488 AK implementiert staroperation aus REWH */
/* bsp 123 * 222 -> 222345/222 */
/* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	INT i,letztes;
	OP glength = callocobject(); 
	OP klength = callocobject(); 

	b_gk_spa(callocobject(),callocobject(),c);
	add(s_pa_l(a),s_pa_l(b),glength);
	length(a,klength);
	m_kl_pa(VECTOR,glength,s_spa_g(c));
	m_kl_pa(VECTOR,klength,s_spa_k(c));
	
	letztes = S_PA_II(b,S_PA_LI(b)-1);
	for (i=0L;i<S_PA_LI(a);i++) M_I_I(letztes,s_spa_ki(c,i));
	for (i=0L;i<S_PA_LI(b);i++)
		M_I_I(S_PA_II(b,i),s_spa_gi(c,i));
	for (i=0L;i<S_PA_LI(a);i++)
		M_I_I(S_PA_II(a,i)+letztes,s_spa_gi(c,i+S_PA_LI(b)));
#else /* SKEWPARTTRUE */
	error("startpart:SKEWPARTITION not available");
#endif /* SKEWPARTTRUE */
	}

INT fprint_skewpartition(f,a) OP a; FILE *f;
/* AK 280789 */ /* AK 181289 V1.1 */ /* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	INT erg = OK; /* AK 150192 */
	erg += fprint(f,s_spa_g(a));
	fprintf(f," / ");
	erg += fprint(f,s_spa_k(a));
	return erg; /* AK 150192 */
#else /* SKEWPARTTRUE */
	error("fprint_skewpartition:SKEWPARTITION not available");
	return(ERROR);
#endif /* SKEWPARTTRUE */
	}

INT scan_skewpartition(a) OP a;
/* 020488 AK */
/* AK 010889 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef SKEWPARTTRUE
	INT dt=0L;

	b_gk_spa(callocobject(),callocobject(),a);
	printeingabe("Eingabe einer Skewpartition, die groessere partition");
	scan(PARTITION,s_spa_g(a));
	printeingabe("Eingabe einer Skewpartition, die kleinere partition");
	scan(PARTITION,s_spa_k(a));

if (dt) {fprintf(stderr,"scan_skewpartition:a =");debugprint(a);}

	return(OK);
#else /* SKEWPARTTRUE */
	error("scan_skewpartition:SKEWPARTITION not available");return(ERROR);
#endif /* SKEWPARTTRUE */
	}

#ifdef SKEWPARTTRUE
static struct skewpartition * callocskewpartition()
/* 020488 AK erste prozedur beim einfuehren eines neuen datentyps */
/* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	struct  skewpartition *erg
	= (struct skewpartition *) calloc(1,sizeof(struct skewpartition));
	if (erg == NULL) error("erg == NULL in callocskewpartition()");
	return(erg);
	}

INT m_gk_spa(gross,klein,ergebnis)  OP gross,klein,ergebnis;
/* AK 110790 V1.1 */ /* AK 140891 V1.3 */
	{
	OP a=callocobject(),b=callocobject();
	copy(gross,a);copy(klein,b);
	return b_gk_spa(a,b,ergebnis);
	}

INT b_gk_spa(gross,klein,ergebnis)  OP gross,klein,ergebnis;
/* die zweite prozedur bei neuen typen */
/* AK 020488
erzeugt aus den partitionen gross,klein die skewpartition
gross/ klein */
/* AK 181289 V1.1 */ /* AK 140891 V1.3 */
	{
	OBJECTSELF d;

	if (ergebnis==NULL)	/* kein speicher reserviert fuer
				das ergebnis */
		{ error("ergebnis == NULL in b_gk_spa"); return(ERROR); };

	d.ob_skewpartition = callocskewpartition();
	B_KS_O(SKEWPARTITION, d, ergebnis);

	c_spa_g(ergebnis,gross); /*change_skewpartition_gross*/
	c_spa_k(ergebnis,klein); /*change_skewpartition_klein*/
	return(OK);
	}
#endif

INT S_a_rofword(w,a,r) OP w,a,r;
/* 220488 */ /* AK 160890 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP i=callocobject(); 
	if (ge(a,r)) { fprintln(stderr,a); fprintln(stderr,r);
		error("a >= r in S_a_rofword"); }

	copy(r,i);
	do {	dec(i); S_rofword(w,i); } while( ge(i,a) );
	freeall(i);return(OK);
#else
	error("S_a_rofword:WORD not available");
#endif
	}

INT S_rofword(w,r) OP w,r;
/* 210488 */ /* AK 160890 V1.1 */
/* liefert TRUE solange ein r-index > 0 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP max=callocobject(); 
	OP index=callocobject(); 

	maxrindexword(w,r,index,max);
	if (S_I_I(max) <= 0L) return(FALSE);
	M_I_I(S_I_I(r)-1,S_W_I(w,S_I_I(index)));
	freeall(max); freeall(index); return(TRUE);
#else
	error("S_rofword:WORD not available");
#endif
	}

INT R_roftableaux(w,r) OP w,r;
/* 250488 */ /* AK 160890 V1.1 */
/* AK 210891 V1.3 */
/* der umriss wird nicht gebraucht */
	{
#ifdef WORDTRUE
	INT j,i,k;

	i=s_t_hi(w)-S_I_I(r)+1; /* die zeilenummer in die gewechselt wird */
	for (j=0;j<s_t_li(w);j++)
		if (EMPTYP(s_t_ij(w,i,j))) break;
	if (j==s_t_li(w)) 	{ inc(w); i=i+1; };
	/* j ist die spaltennummer in die gewechselt wird */
	
	for (k=0;k<s_t_li(w);k++) if (EMPTYP(s_t_ij(w,i-1,k))) break;
	k = k-1;
	/* k ist die spaltennummer aus der gewechselt wird */

	M_I_I(s_t_iji(w,i-1,k),s_t_ij(w,i,j));
	freeself(s_t_ij(w,i-1,k));return(OK);
	 
#else
	error(":WORD not available");
#endif
	}

INT starttableaux(t,s) OP t,s;
/* berechnet das Tableaux T_0 aus MD */
/* 250488 */ /* AK 160890 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP in = callocobject();
	OP m = callocobject();
	OP l = callocobject();
	OP h = callocobject();
	
	INT i,j,k;

	m_us_t(callocobject(),callocobject(),s);
	inhalt(t,in); max(in,m);
	/* ist der maximale eintrag in  inhalt */
	copy(s_v_l(in),h); copy(m,l);
	m_lh_m(l,h,S_T_S(s));
	for (i=S_I_I(h)-1L,k=0L;i>=0L;i--,k++)
		for (j=s_v_ii(in,k)-1;j>=0;j--)
			M_I_I(k+1,s_t_ij(s,i,j));

	freeall(in);
	free(m);
#else
	error(":WORD not available");
#endif
	}

INT rm_rindex(word,r) OP word,r;
/* 250488 */ /* AK 160890 V1.1 */
/* AK 210891 V1.3 */
	{

#ifdef WORDTRUE
	while(S_rofword(word,r))
		{
		};

	return(OK);
#else
	error(":WORD not available");
#endif
	}

INT coroutine250488(i,word,tableaux) INT i; OP word,tableaux;
/* AK 160890 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP rindex=callocobject(); 
	OP umriss;
	M_I_I(i,rindex);
	while(S_rofword(word,rindex))
		R_roftableaux(tableaux,rindex);
		/* simultane operation auf tableaux */


	if (i>2) coroutine250488(i-1,word,tableaux);

	umriss = callocobject();  /* AK 100688 den umriss ausrechnen */
	m_matrix_umriss(S_T_S(tableaux), S_T_U(tableaux));

	freeall(rindex);
	return(OK);
#else
	error(":WORD not available");
#endif
	}

INT m_tableaux_tableauxpair(tab,ergtab1,s) OP tab,ergtab1,s; 
/* AK 160890 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP w = callocobject(); 

	INT i,j,l;
	INT index;

	wordoftableaux(tab,w);
	starttableaux(tab,s);
	l = s_t_hi(s);
	for(i=2;i<=l;i++)
		coroutine250488(i,w,s);
	copy(tab,ergtab1);
	index=0;
	for (i=s_t_hi(ergtab1)-1;i>=0;i--)
		for (j=s_t_li(ergtab1)-1;j>=0;j--)
			if (not EMPTYP(s_t_ij(ergtab1,i,j)))
				{
				M_I_I(S_W_II(w,index),s_t_ij(ergtab1,i,j));
				index++;
				};
	freeall(w);
#else
	error("m_tableaux_tableauxpair:WORD not available");
#endif
	}

INT maxrindexword(w,r,index,erg) OP w,r,erg,index;
	/*210488*/ /* AK 160890 V1.1 */
	/* berechnet den maximalen wert der r-indices */
	/* er wird an der stelle index erreicht */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	INT i;
	OP zw1=callocobject(); 
	OP stelle=callocobject(); 

	M_I_I(-1000000L,erg);
	M_I_I(0L,index);
	for(i=0;i<s_w_li(w);i++)
		{
		M_I_I(i,stelle);
		rindexword(w,r,stelle,zw1);
		if (gr(zw1,erg)) {copy(zw1,erg);M_I_I(i,index);};
		};
	freeall(zw1); freeall(stelle);return(OK);
#else
	error("maxrindexword:WORD not available");
#endif
	}

INT latticepword(w) OP w;
/* 210488 */ /* AK 160890 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP m = callocobject(); 
	OP null = callocobject(); 
	OP stelle = callocobject(); 
	OP r = callocobject(); 
	OP erg = callocobject(); 
	INT i,j,a=FALSE;

	max(w,m);
	M_I_I(0L,null);
	for (i=2L;i<=S_I_I(m);i++)
		for(j=0L;j<s_w_li(w);j++)
			{
			M_I_I(i,r); M_I_I(j,stelle); rindexword(w,r,stelle,erg);
			if (gr(erg,null)) goto lwende;
			};
	a = TRUE;
	lwende:
	freeall(null); freeall(r); freeall(erg); freeall(stelle);
	return(a);
#else /* WORDTRUE */
	error(":WORD not available");
#endif /* WORDTRUE */
	}

INT rindexword(w,r,stelle,erg) OP w,r,stelle,erg;
/* 210488 */ /* AK 020290 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP zw1= callocobject(); 
	OP zw2= callocobject(); 
	if (S_I_I(r) <= 1) error("zu diesem r ist r-index nicht definiert");
	dec(r);
	rindexword_sub(w,r,stelle,zw1);
	inc(r);
	rindexword_sub(w,r,stelle,zw2);
	sub(zw2,zw1,erg);
	freeall(zw1);
	freeall(zw2);
#else /* WORDTRUE */
	error("rindexword:WORD not available");
#endif /* WORDTRUE */
	}

INT rindexword_sub(w,r,stelle,erg) OP w,r,stelle,erg;
/* 210488 */ /* AK 020290 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	INT i,z=0;
	if (ge(stelle,s_w_l(w))) { error("so lang ist das wort nicht"); };
	for(i=0;i<=S_I_I(stelle);i++)
		if (S_W_II(w,i) == S_I_I(r)) z++;
	M_I_I(z,erg);
	return(OK);
#else /* WORDTRUE */
	error("rindexword_sub:WORD not available");
#endif /* WORDTRUE */
	}

INT scan_word(ergebnis) OP ergebnis;
/* AK 020290 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	OP length = callocobject();
	INT i;
	
	printeingabe("Laenge des Wortes ");
	scan(INTEGER,length);

	m_l_w(length,ergebnis);
	for (i=0L;i < S_I_I(length); scan(INTEGER,S_W_I(ergebnis,i++)));
	return(OK);
#else /* WORDTRUE */
	error("scan_word:WORD not available");
#endif /* WORDTRUE */
	}
	
INT m_l_w(a,b) OP a,b;
/* AK 020290 V1.1 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	m_l_v(a,b); 
	C_O_K(b,WORD); 
	return(OK);
#else /* WORDTRUE */
	error("m_l_w:WORD not available");
#endif /* WORDTRUE */
	}

INT m_il_w(a,b) OP b; INT a;
/* AK 020290 V1.1 */ /* AK 290591 V1.2 */
/* AK 210891 V1.3 */
	{
#ifdef WORDTRUE
	m_il_v(a,b); 
	C_O_K(b,WORD); 
	return(OK);
#else /* WORDTRUE */
	error("m_il_w:WORD not available");
#endif /* WORDTRUE */
	}

#ifdef WORDTRUE
OP s_w_s(a) OP a;
/* AK 260789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	return(s_v_s(a));
	}

OP s_w_l(a) OP a;
/* AK 260789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	return(s_v_l(a));
	}

INT s_w_li(a) OP a;
/* AK 260789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	return(s_v_li(a));
	}

OP s_w_i(a,i) OP a;INT i;
/* AK 260789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	return(s_v_i(a,i));
	}

INT s_w_ii(a,i) OP a;INT i;
/* AK 260789 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
	{
	return(s_v_ii(a,i));
	}
#endif /* WORDTRUE */
