/* file: matrix.c */ /* AK 091086 */
#include "def.h"
#include "macro.h"

static struct matrix * callocmatrix();

#ifdef MATRIXTRUE
INT delete_row_matrix(a,index,b) INT index; OP a,b;
/* AK 270789 */ /* AK 111289 V1.1 */ /* AK 110691 V1.2 */ 
/* AK 070891 V1.3 */
{
	INT i,j;

	if (index >= S_M_HI(a) ) {
		return 	error("delete_row_matrix: index to big");
	}
	if (index < 0L){
		return error("delete_row_matrix: index < 0");
	}

	if (a==b) {
		OP c = callocobject();
		*c = *b; C_O_K(b,EMPTY);
		delete_row_matrix(c,index,b);
		freeall(c);
		return(OK);
	}

	if (not EMPTYP(b)) 
		freeself(b);
	m_ilih_m(S_M_LI(a),S_M_HI(a)-1L,b);
	for (i=0;i<index;i++)
		for (j=0;j<S_M_LI(a);j++)
			copy(S_M_IJ(a,i,j),S_M_IJ(b,i,j));
	for (i=index+1;i<S_M_HI(a);i++)
		for (j=0;j<S_M_LI(a);j++)
			copy(S_M_IJ(a,i,j),S_M_IJ(b,i-1L,j));
	return OK;
}
#endif /* MATRIXTRUE */


#ifdef MATRIXTRUE
INT delete_column_matrix(a,index,b) INT index; OP a,b;
/* AK 270789 */ /* AK 310790 V1.1 */ /* AK 110691 V1.2 */ 
/* AK 070891 V1.3 */
{
	INT i,j;

	if (index >= S_M_LI(a) ) {
		error("delete_column_matrix: index to big");
		return(ERROR); 
	}
	if (index < 0) {
		error("delete_column_matrix: index < 0");
		return(ERROR); 
	}

	if (a==b) {
		OP c = callocobject();
		*c = *b; C_O_K(b,EMPTY);
		delete_column_matrix(c,index,b);
		freeall(c);
		return(OK);
	}

	if (not EMPTYP(b)) freeself(b);
	m_ilih_m(S_M_LI(a)-1L,S_M_HI(a),b);
	for (j=0;j<index;j++)
		for (i=0;i<S_M_HI(a);i++)
			copy(S_M_IJ(a,i,j),S_M_IJ(b,i,j));
	for (j=index+1;j<S_M_LI(a);j++)
		for (i=0;i<S_M_HI(a);i++)
			copy(S_M_IJ(a,i,j),S_M_IJ(b,i,j-1));
	return OK;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT det_matrix(a,b) OP a,b; 
/* AK 151289 V1.1 */ /* AK 110691 V1.2 */
/* hier wird zum konkreten algorithmus geschaltet */
/* AK 210891 V1.3 */
{ 
	if (not quadraticp(a))
		{ 
		error("det_matrix: not quadratic matrix"); 
		return(ERROR); 
		}
	return det_mat_tri(a,b); 
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT det_mat_tri(a,erg) OP a,erg;
/* AK Fri Jan 20 12:29:58 MEZ 1989
algorithmus zur berechnung der determinante einer matrix a
mittels triangulation
ergebnis in erg
algorithmus 41 in CACM */
/* verbessert 1963 */
/* immer noch fehler bei zeilenvertauschung */
/* AK 310790 V1.1 */ /* AK 110691 V1.2 */
/* AK 210891 V1.3 */
{
	INT r,i,j,y,count,sign=1L,n;
	INT dt=0L;
	OP  b,  product,factor,temp;

	n = S_M_LI(a);
	b = callocobject(); 

	product = callocobject(); 
	M_I_I(1L,product);
	factor = callocobject(); 
	temp = callocobject();

	copy(a,b);

	for (r=1;r < n;r++)
	{
		count = r-1;
		if (not nullp(S_M_IJ(b,r-1L,r-1))) goto det_mat_tri_resume;
det_mat_tri_zerocheck:
		if (count < (n-1)) count++;
		else goto det_mat_tri_zero;

		if(dt) { fprintf(stderr,"det_mat_tri: vor swap b= ");
			fprintln(stderr,b); }
		if (not nullp(S_M_IJ(b,count,r-1))) {
		for (y=r; y<=n; y++)
			{
			swap(S_M_IJ(b,count,y-1),S_M_IJ(b,r-1L,y-1));
			}
		if(dt) { fprintf(stderr,"det_mat_tri: nach swap b= ");
			fprintln(stderr,b); }
		sign = -sign; goto det_mat_tri_resume;
		}


		goto det_mat_tri_zerocheck;
det_mat_tri_zero:
		M_I_I(0L,erg); 
		goto det_mat_tri_return;
det_mat_tri_resume:
		if (dt) { fprint(stderr,S_M_IJ(b,r-1L,r-1));
			fprintf(stderr," ungleich null\n"); }
		for (i=r+1; i<=n; i++)
		{
			if(dt) { fprintf(stderr,"det_mat_tri: b vor div= ");
				fprintln(stderr,b); 
				fprintf(stderr,"r = %d\n",r);}
			div(S_M_IJ(b,i-1L,r-1),S_M_IJ(b,r-1L,r-1),factor);
			if(dt) { fprintf(stderr,"det_mat_tri: factor= ");
				fprintln(stderr,factor); }
			for (j=r+1;j<=n;j++)
			{
				mult(factor,S_M_IJ(b,r-1L,j-1),temp);
/* durch nachfolgende 2 Zeilen ersetzt AK 240791 
				sub(S_M_IJ(b,i-1L,j-1),temp,S_M_IJ(b,i-1L,j-1));
*/
				addinvers_apply(temp);
				add_apply(temp,S_M_IJ(b,i-1L,j-1L));
			}
		}
		if(dt) { fprintf(stderr,"det_mat_tri: b= ");
			fprintln(stderr,b); }
	}

	for (i=1;i<=n;i++)
		mult(product,S_M_IJ(b,i-1L,i-1),product);

	if(dt) { fprintf(stderr,"det_mat_tri: b= ");
		fprintln(stderr,b); }

	if (sign == -1L) addinvers(product,erg);
	else	copy(product,erg);
det_mat_tri_return:
	freeall(product); freeall(temp); freeall(factor); freeall(b);
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT m_ilih_nm(l,h,m) OP m; INT l,h;
/* AK 110691 V1.2 */
/* mit 0 vorbesetzen */
/* make_intlength_intheight_null_matrix */
/* AK 210891 V1.3 */
{
	INT i,erg = OK;
	OP z;
	erg += m_ilih_m(l,h,m);
	for (z=S_M_S(m), i=S_M_HI(m) * S_M_LI(m); i>0L; i--,z++)
		M_I_I(0L,z);
	return erg; /* AK 090692 */
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT m_lh_nm(l,h,m) OP l,h,m;
/* AK 110691 V1.2 */
/* mit 0 vorbesetzen */
/* make_length_height_null_matrix */
/* AK 210891 V1.3 */
{
	INT i,erg = OK;
	OP z;
	erg += m_lh_m(l,h,m);
	for (z=S_M_S(m), i=S_M_HI(m) * S_M_LI(m); i>0L; i--,z++)
		M_I_I(0L,z);
	return erg; /* AK 090692 */
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT b_lh_nm(l,h,m) OP l,h,m;
/* AK 110691 V1.2 */
/* mit 0 vorbesetzen */
/* build_length_height_null_matrix */
/* AK 210891 V1.3 */
{
	INT i,erg = OK;
	OP z;
	erg += b_lh_m(l,h,m);
	for (z=S_M_S(m), i=S_M_HI(m) * S_M_LI(m); i>0L; i--,z++)
		M_I_I(0L,z);
	return erg; /* AK 090692 */
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT b_lh_m(l,h,m) OP l,h,m;
/* build_length_height_matrix */
/* height und length werden nicht kopiert */
/* AK 250590 V1.1 */ /* AK 110691 V1.2 */
/* AK 210891 V1.3 */
{
	OP s;
	INT i;
	s = (OP) malloc(S_I_I(l)*S_I_I(h)*sizeof(struct object));
	for (i=0L;i<S_I_I(l)*S_I_I(h); i++) C_O_K(s+i,EMPTY);
	return b_lhs_m(l,h,s,m);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT m_lh_m(len,height,matrix) OP height, len, matrix;
/* make_length_height_matrix */
/* height und length werden kopiert */
/* AK 041286 */ /* AK 070789 V1.0 */ /* AK 310790 V1.1 */
/* AK 260291 V1.2 */ /* AK 210891 V1.3 */
{
	b_lhs_m(callocobject(), callocobject(), /* old length and height
					instead of callocobject */
	    (struct object *) calloc((int)
	    ((S_I_I(height))*(S_I_I(len))),
	    sizeof(struct object)),
	    matrix);

	COPY_INTEGER(len,S_M_L(matrix)); /* 260291 */
	COPY_INTEGER(height,S_M_H(matrix)); /* 260291 */
	if (S_M_S(matrix) == NULL)
	{
		return error("m_lh_m:self == NULL no memory");
	}

	return(OK);
}
#endif  /* MATRIXTRUE */


#ifdef MATRIXTRUE
INT b_lhs_m(len,height,self,ergebnis) OP len, height, self, ergebnis;
/* AK 060789 V1.0 */ /* AK 081289 V1.1 */ /* AK 110691 V1.2 */
/* AK 210891 V1.3 */
{
	OBJECTSELF d;

	d.ob_matrix = callocmatrix();
	B_KS_O(MATRIX, d, ergebnis);
	C_M_L(ergebnis,len); 
	C_M_H(ergebnis,height);
	C_M_S(ergebnis,self);
	return(OK);
}
#endif /* MATRIXTRUE */


#ifdef MATRIXTRUE
INT m_ilih_m(len,height,matrix) INT height, len; OP matrix;
/* AK 090988 */ /* AK 070789 V1.0 */ /* AK 310790 V1.1 */
/* AK 210891 V1.3 */
{
	b_lhs_m(	callocobject(),
	    callocobject(),
	    (struct object *) calloc( (int) (height*len),
	    sizeof(struct object)),
	    matrix);

	if (S_M_S(matrix) == NULL) error("m_ilih_m:self == NULL ");
	m_i_i(len,S_M_L(matrix));
	m_i_i(height,S_M_H(matrix));
	return(OK);
}
#endif  /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT quadraticp(mat) OP mat;
/* AK 060789 V1.0 */ /* AK 310790 V1.1 */
/* AK 210891 V1.3 */
{
	return(S_M_LI(mat) == S_M_HI(mat));
}
#endif /* MATRIXTRUE */


#ifdef MATRIXTRUE
#ifdef PERMTRUE
INT det270588(mat,perm,c) OP mat,perm,c;
/* AK270588 */
/* brechnet aus Matrix (a_ij) und der Permutation p_1,..,p_n
den wert a_1,p_1 * a_2,p_2 * .. a_n,p_n */
/* damit kannn z.b. die determinante berechnet werden */
/* AK 060789 V1.0 */ /* AK 310790 V1.1 */ /* AK 180691 V1.2 */
/* AK 210891 V1.3 */
{
	INT i,erg = OK;
	if (not quadraticp(mat)) 
		return error("det270588:not quadratic");

	if (neq(S_M_L(mat),S_P_L(perm)))
		return error("det270588:wrong lengthes");

	erg += copy(S_M_IJ(mat,0L,S_P_II(perm,0L)-1L),c);

	for (i=1L;i<S_P_LI(perm);i++)
		{
		erg += mult_apply(S_M_IJ(mat,i,S_P_II(perm,i)-1L),c);
		}

	return erg;
}
#endif /*PERMTRUE */
#endif /* MATRIXTRUE */


#ifdef MATRIXTRUE
#ifdef PERMTRUE
#ifdef CHARTRUE
INT det_mat_imm(mat,erg) OP mat,erg; 
	{ 
	return det_imm_matrix(mat,erg); 
	}
INT det_imm_matrix(mat,erg) OP mat,erg;
/* AK 270588 neue version mit immanente */
/* AK 060789 V1.0 */ /* AK 310790 V1.1 */ /* AK 180691 V1.2 */
/* AK 210891 V1.3 */
{
	OP part;
	part = callocobject();
	last_partition(S_M_H(mat),part); /* = 1,1,1,1,1,..,1 */
	immanente_matrix(mat,part,erg);
	/* der zugehoerige Charakter ist das signum */
	freeall(part);
	return(OK);
}
#endif /* CHARTRUE */
#endif /* PERMTRUE */
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
#ifdef PERMTRUE
#ifdef CHARTRUE
INT immanente_matrix(mat,part,erg) OP mat,part,erg;
/* berechnet immanente */
/* AK270588 */ /* AK 060789 V1.0 */ /* AK 090790 V1.1 */ /* AK 180691 V1.2 */
/* AK 210891 V1.3 */
{
	OP perm,nextperm,zwerg,zzerg;

	if (not quadraticp(mat)) 
		return error("immanente:not quadratic matrix");

	perm = callocobject(); 
	zwerg = callocobject(); 
	zzerg = callocobject();
	nextperm = callocobject();
	first_permutation(S_M_H(mat),perm);

	det270588(mat,perm,erg);
	charvalue(part,perm,zwerg,NULL);
	mult_apply(zwerg,erg);

	while (next(perm,nextperm))
	{
		det270588(mat,nextperm,zwerg);
		charvalue(part,nextperm,zzerg,NULL);
		mult_apply(zwerg,zzerg);
		add_apply(zzerg,erg);
		copy(nextperm,perm);
	};

	freeall(perm);
	freeall(nextperm);
	freeall(zwerg);
	freeall(zzerg);
	return(OK);
}
#endif  /* CHARTRUE */
#endif  /* PERMTRUE */
#endif  /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT inc_matrix(a) OP a;
/* 250488 */ /* AK 060789 V1.0 *//* AK 130790 V1.1 */ /* AK 180691 V1.2 */
/* AK 210891 V1.3 */
{
	OP l=callocobject(),h=callocobject();
	OP b=callocobject(); /* die neue matrix */
	INT i,j;

	COPY_INTEGER(S_M_H(a),h);
	INC_INTEGER(h); 
	COPY_INTEGER(S_M_L(a),l);
	INC_INTEGER(l);
	b_lh_m(l,h,b);C_O_K(b,S_O_K(a));

	for (i=0L;i<S_M_HI(a);i++)
		for (j=0L;j<S_M_LI(a);j++)
			*(S_M_IJ(b,i,j)) =  *(S_M_IJ(a,i,j));
	for (i=0L;i<S_M_HI(b);i++) C_O_K(S_M_IJ(b,i,S_M_LI(a)),EMPTY);
	for (j=0L;j<S_M_LI(b);j++) C_O_K(S_M_IJ(b,S_M_HI(a),j),EMPTY);

	free(S_M_S(a)); free(S_M_H(a)); free(S_M_L(a));
	free(S_O_S(a).ob_matrix);

	*a = *b;
	return OK;
}
#endif  /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT invers_matrix(a,b) OP a,b;
/* AK 290388 nach stoer (dietmar) */
/* umgewandelt aus pascal */
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 150591 V1.2 */
/* AK 220791 V1.3 */
{
	INT erg=OK;
	INT i,j,k,r;
	/* r ist die selectierte spalte */
	/* r = 0 ... n */
	INT n=S_M_LI(a)-1L;
	INT singulaer = FALSE;
	OP p=callocobject();
	OP hr = callocobject();
	OP hs = callocobject();
	OP hv = callocobject();

	if (not quadraticp(a))
		 return error("invers_matrix:not quadratic"); 

	erg += m_il_v(n+1L,p);

	for(j=0L;j<=n;j++) M_I_I(j,S_V_I(p,j));

	j= -1L;
	erg += copy(a,b);
	while ((j++ <n) && (! singulaer))
	{
		/*pivotsuche*/
		for(r=j;r<=n;r++)
			if (not nullp(S_M_IJ(b,r,j))) goto im290388;

im290388:
		if (r == n+1L)/* nur nullen in der spalte j */ singulaer = TRUE;
		else {
			/*zeilentausch*/
			if (r>j){
				for (k=0L;k<=n;k++) 
					erg+=swap(S_M_IJ(b,j,k),S_M_IJ(b,r,k));
				erg+=swap(S_V_I(p,j),S_V_I(p,r));
			};
			/*transformation*/
			erg+=invers(S_M_IJ(b,j,j),hr);
			for (i=0L;i<=n;i++) erg+=mult_apply(hr,S_M_IJ(b,i,j));
			erg+=copy(hr,S_M_IJ(b,j,j));
			erg+=addinvers_apply(hr);
			for (k=0L;k<=n;k++)
			{
				if (k==j) k++; /* spalte j nicht anwenden */
				if (k>n) break;
				for (i=0L;i<=n;i++)
				{
				if (i==j) i++; /* auf zeile j nicht anwenden */
				if (i>n) break;
				erg+=mult(S_M_IJ(b,i,j),S_M_IJ(b,j,k),hs);
				erg += addinvers_apply(hs);
				erg += add_apply(hs,S_M_IJ(b,i,k));
/* alt fuer beide zeilen drueber 
				erg+=sub(S_M_IJ(b,i,k),hs,S_M_IJ(b,i,k));
*/
				};
				erg+=mult_apply(hr,S_M_IJ(b,j,k));
			};
		}; /* end else */
	}; /* end while */
	if (erg != OK)
		return error("invers_matrix: (1) error in computation");
	erg+=freeall(hr); 
	erg+=freeall(hs);

	erg+=m_il_v(n+1L,hv);
	if (not singulaer)
		/*spaltentausch*/
		for (i=0L;i<=n;i++)
			{
			for (k=0L;k<=n;k++) {
				erg+=copy(S_M_IJ(b,i,k), S_V_I(hv,S_V_II(p,k)));
				}
			for (k=0L;k<=n;k++) {
				erg+=copy(S_V_I(hv,k), S_M_IJ(b,i,k));
				}
			}

	erg+=freeall(p);
	erg+=freeall(hv);
	if (singulaer)	{ 
		freeself(b);
		error("invers_matrix: singulary");
		return(SINGULAER); 
	};
	if (erg != OK)
		return error("invers_matrix: (2) error in computation");
	return erg;
}
#endif /* MATRIXTRUE */


#ifdef MATRIXTRUE
INT transpose_matrix(a,b) OP a,b;
/* AK 280388 */ /* AK 060789 V1.0 */ /* AK 310790 V1.1 */ /* AK 210891 V1.3 */
{
	INT i,j;

	m_ilih_m(S_M_HI(a),S_M_LI(a),b);
	C_O_K(b,S_O_K(a));

	for (i=0;i<S_M_HI(b);i++)
		for (j=0;j<S_M_LI(b);j++)
			copy(S_M_IJ(a,j,i),S_M_IJ(b,i,j));

	return(OK);
}
#endif/* MATRIXTRUE */


#ifdef MATRIXTRUE
INT comp_kranztafel(a,b) OP a, b;
/* AK 280390 V1.1 */ /* AK 210891 V1.3 */
{
	INT i,j,erg;
	OP x,y;
	
	x = S_M_S(a);
	y = S_M_S(b);	
	for (i=0L;i<S_M_HI(a);i++)
		{
		if 	(i >= S_M_HI(b)) return(1L);
		else    {
			for (j=0L;j<S_M_LI(a);j++)
				{
				if (j>=S_M_LI(b)) return(1L);
				else {
					erg=COMP_INTEGER_INTEGER(x,y);
					if (erg != 0L) return(erg);
					x++;y++;
					};
				}
			}
		}
	return(0L); /* matrizen sind gleich */
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT comp_matrix(a,b) OP a, b;
/* AK 060789 V1.0 */ /* AK 070290 V1.1 */ /* AK 210891 V1.3 */
{
	INT i,j,erg;
	OP x,y;
	
	x = S_M_S(a);
	y = S_M_S(b);	
	for (i=0L;i<S_M_HI(a);i++)
		{
		if 	(i >= S_M_HI(b)) return(1L);
		else    {
			for (j=0L;j<S_M_LI(a);j++)
				{
				if (j>=S_M_LI(b)) return(1L);
				else {
					erg=comp(x++,y++);
					if (erg != 0L) return(erg);
					};
				}
			}
		}
	if ( S_M_HI(b) > S_M_HI(a) ) return(-1L); /* AK 170790 */
	return(0L); /* matrizen sind gleich */
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT add_apply_matrix_matrix(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 090891 V1.3 */
/* AK 210891 V1.3 */
{
	OP c,d;
	INT i,erg = OK;
	if (
		(S_M_HI(a) == S_M_HI(b))&&
		(S_M_LI(a) == S_M_LI(b))
		)
		{
		i = S_M_HI(a)*S_M_LI(a);
		c = S_M_S(a);d=S_M_S(b);
		while (i-- > 0)
			erg += add_apply(c++,d++);
		}
	else    {
		c = callocobject();
		*c = *b;
		C_O_K(b,EMPTY);
		erg += add_matrix(a,c,b);
		erg += freeall(c);
		}
	return erg;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT add_apply_matrix(a,b) OP a,b;
/* AK 220390 V1.1 */
/* AK 210891 V1.3 */
{
	if (EMPTYP(b)) 
		return(copy_matrix(a,b));
	switch (S_O_K(b)){
		case KRANZTYPUS:
		case MATRIX: return(add_apply_matrix_matrix(a,b));
		default:
			printobjectkind(b);
			error("add_apply_matrix:wrong second type");
			return(ERROR);
	}
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT add_matrix(a,b,ergeb) OP a,b,ergeb;
/* AK 041186 */ /* AK 171186 */ /* AK 060789 V1.0 */ /* AK 081289 V1.1 */
/* AK 090891 V1.3 */
{
	INT i,j;
	OP 	len = callocobject(),
	    height = callocobject();
	OP z;

	if 	(S_M_LI(a) >=S_M_LI(b))
		COPY_INTEGER(S_M_L(a),len);
	else	COPY_INTEGER(S_M_L(b),len);
	if 	(S_M_HI(a) >=S_M_HI(b))
		COPY_INTEGER(S_M_H(a),height);
	else	COPY_INTEGER(S_M_H(b),height);

	if (not EMPTYP(ergeb)) freeself(ergeb);
	b_lh_m(len,height,ergeb);
	C_O_K(ergeb,S_O_K(a));

	z = S_M_S(ergeb);
	for (i=0;i<S_M_HI(ergeb);i++)
		for (j=0;j<S_M_LI(ergeb);j++,z++)
		{
			if (
			    (i<S_M_HI(a))&&(i<S_M_HI(b))&&
			    (j<S_M_LI(a))&&(j<S_M_LI(b))
			    )

			{ 
			add(S_M_IJ(a,i,j), S_M_IJ(b,i,j), z); 
			}

			else if ( (i<S_M_HI(a))&&(j<S_M_LI(a)))
				copy(S_M_IJ(a,i,j),z); 
			else if ( (i<S_M_HI(b))&&(j<S_M_LI(b)))
				copy(S_M_IJ(b,i,j),z); 
		}
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT copy_kranztypus(a,b) OP a,b;
/* AK 270390 V1.1 */ /* AK 210891 V1.3 */
/* AK 040392 cast to char * */
	{
	m_ilih_m(S_M_LI(a),S_M_HI(a),b);
	C_O_K(b,S_O_K(a));
	memcpy((char *) S_M_S(b),(char *) S_M_S(a),
			S_M_LI(a)*S_M_HI(a)*sizeof(struct object));
	return(OK);
	}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT copy_matrix(von,b) OP von , b;
/* AK 051186 */ /* AK 021286 */ /* AK 060789 V1.0 */ /* AK 071289 V1.1 */
/* AK 210891 V1.3 */
{
	INT k;
	OP z,w;

	m_ilih_m(S_M_LI(von),S_M_HI(von),b);
	C_O_K(b,S_O_K(von));


	z = S_M_IJ(von,S_M_HI(von)-1L,S_M_LI(von)-1L);
	w = S_M_IJ(b,S_M_HI(von)-1L,S_M_LI(von)-1L);
	k = S_M_HI(von) * S_M_LI(von);
	for (;k>0L;k--,z--,w--) 
			if (S_O_K(z) == INTEGER) *w = *z;
			else if (EMPTYP(z)) *w = *z;
			else copy(z,w);

	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT freeself_kranztypus(a) OP a;
/* AK 270390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF d;
	d=S_O_S(a);
	free(S_M_S(a)); free(S_M_L(a)); free(S_M_H(a));
	free(d.ob_matrix);C_O_K(a,EMPTY);
	return(OK);
	}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT freeself_matrix(matrix) OP matrix;
/* AK 060789 V1.0 */ /* AK 071289 V1.1 */ /* AK 100691 V1.2 */ 
/* AK 160891 V1.3 */
{
	INT k;
	OBJECTSELF d;
	OP z;

	d=S_O_S(matrix);

	z = S_M_IJ(matrix,S_M_HI(matrix)-1L,S_M_LI(matrix)-1L);
	k = S_M_HI(matrix) * S_M_LI(matrix);
	for (;k>0L;k--,z--) 
			if (S_O_K(z) == INTEGER) ;
			else if (EMPTYP(z));
			else freeself(z);
	
	free(S_M_S(matrix)); 
	free(S_M_L(matrix)); 
	free(S_M_H(matrix));
	free(d.ob_matrix);
	C_O_K(matrix,EMPTY);
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
static struct matrix * callocmatrix()
/* AK 060789 V1.0 */ /* AK 220390 V1.1 */ /* AK 160891 V1.3 */
{
	struct matrix *ergebnis;

	ergebnis = (struct matrix *) calloc((int)1,sizeof(struct matrix));
	if (ergebnis == NULL)
		error("callocmatrix:no mem");
	return(ergebnis);
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
INT scan_matrix(ergebnis) OP ergebnis;
/* AK 060789 V1.0 */ /* AK 310790 V1.1 */ /* AK 080891 V1.3 */
{
	OP len, height;
	INT i,j;
	OBJECTKIND kind;
	char a[20];  /* AK 080891 */

	len = callocobject();
	height = callocobject();
	printeingabe("height of matrix"); 
	scan(INTEGER,height);
	printeingabe("length of matrix"); 
	scan(INTEGER,len);
	kind=scanobjectkind();
	b_lh_m(len,height,ergebnis);
	for (i=0; i<S_I_I(height); i++)
	{
		sprintf(a,"row nr %d \n",(i+1L));  /* AK 080891 */
		printeingabe(a);  /* AK 080891 */
		for (j=0;j<S_I_I(len);j++)
			scan(kind,S_M_IJ(ergebnis,i,j));
	};
	return(OK);
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
INT change_column_ij(a,i,j) OP a; INT i,j;
/* AK 301288 vertauscht spalten i und j dabei kein copy */
/* AK 060789 V1.0 */ /* AK 050390 V1.1 */ /* AK 160891 V1.3 */
{
	INT k;
	if (S_O_K(a) != MATRIX) error("change_column_ij: no matrix");
	if ((i<0) || (i>=S_M_LI(a))) error("change_column_ij: wrong i");
	if ((j<0) || (j>=S_M_LI(a))) error("change_column_ij: wrong j");

	for (k=0; k<S_M_HI(a); k++) swap(S_M_IJ(a,k,i),S_M_IJ(a,k,j));
	return(OK);
}
#endif/* MATRIXTRUE */



#ifdef MATRIXTRUE
INT change_row_ij(a,i,j) OP a; INT i,j;
/* AK 301288 vertauscht zeilen i und j dabei kein copy */
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{
	INT k;

	if (S_O_K(a) != MATRIX) error("change_row_ij: no matrix");
	if ((i<0L) || (i>=S_M_HI(a))) error("change_row_ij: wrong i");
	if ((j<0L) || (j>=S_M_HI(a))) error("change_row_ij: wrong j");

	for (k=0L; k<S_M_LI(a); k++) swap(S_M_IJ(a,i,k),S_M_IJ(a,j,k));
	return(OK);
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
OP s_m_s(a) OP a;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); return(c.ob_matrix->m_self); }

OP s_m_h(a) OP a;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); return(c.ob_matrix->m_height); }

OP s_m_l(a) OP a;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); return(c.ob_matrix->m_length); }

INT s_m_hi(a) OP a;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ return(s_i_i(s_m_h(a))); }

INT s_m_li(a) OP a;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ return(s_i_i(s_m_l(a))); }

INT c_m_s(a,b) OP a,b;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); c.ob_matrix->m_self = b; return(OK); }


INT c_m_h(a,b) OP a,b;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); c.ob_matrix->m_height = b; return(OK); }


INT c_m_l(a,b) OP a,b;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); c.ob_matrix->m_length = b; return(OK); }

OP s_m_ij(a,i,j) OP a; INT i,j;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ 
	if (i < 0L)
		error("s_m_ij:row index too small");
	if (i >= s_m_hi(a))
		error("s_m_ij:row index too big");
	if (j >= s_m_li(a))
		error("s_m_ij:column index too big");
	if (j < 0L)
		error("s_m_ij:column index too small");
	return(s_m_s(a) + (s_m_li(a)*i+j) ); 
}

INT s_m_iji(a,i,j) OP a; INT i,j;
/* AK 070789 V1.0 */ /* AK 181289 V1.1 */ /* AK 160891 V1.3 */
{ return(s_i_i(s_m_ij(a,i,j))); }
#endif /* MATRIXTRUE */


#ifdef MATRIXTRUE
INT fprint_matrix(f,obj) FILE  *f; OP obj;
/* AK 211186 */ /* AK 070789 V1.0 */ /* AK 181289 V1.1 */
/* AK 210891 V1.3 */
{
	INT i,j;
	for (i=0;i<S_M_HI(obj);i++)
	{
		fprintf(f,"\n[");
		if (f == stdout) zeilenposition=0;
		for (j=0;j<S_M_LI(obj);j++)
		{
			fprint(f,S_M_IJ(obj,i,j));
			fprintf(f,":");zeilenposition++;
			if ((f == stdout)&&(zeilenposition>70L))
				{fprintf(stdout,"\n");zeilenposition = 0L;}
		};
		fprintf(f,"]");
	};
	fprintf(f,"\n");
	if (f == stdout) zeilenposition=0L;
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT tex_matrix(obj) OP obj;
/* AK 150988 */ /* AK 310790 V1.1 */
/* AK 070291 V1.2 texout for output */ /* AK 210891 V1.3 */
{
	INT i,j;
	fprintf(texout,"\n$\\matrix { \n");
	texposition = 0L;
	for (i=0;i<S_M_HI(obj);i++)
	{
		for (j=0L;j<S_M_LI(obj);j++)
		{
			tex(S_M_IJ(obj,i,j));
			fprintf(texout," & "); 
			texposition += 3L;
		}
		fprintf(texout," \\cr\n");
		texposition=0L;
	};
	fprintf(texout," }$ \n");
	texposition=0L;
	return(OK);
}
#endif/* MATRIXTRUE */


#ifdef MATRIXTRUE
INT mult_scalar_matrix(scalar,mat,erg) OP scalar , mat,erg;
/* AK 310588 */ /* komponentenweise multiplikation */
/* AK 010889 V1.0 */ /* AK 081289 V1.1 */ /* AK 210891 V1.3 */
{
	INT i,j;
	OP height = callocobject(), len = callocobject();

	COPY_INTEGER(S_M_L(mat), len); 
	COPY_INTEGER(S_M_H(mat), height);
	b_lh_m(len,height,erg);
	for (i=0L;i<S_I_I(height);i++) for(j=0L;j<S_I_I(len);j++)
		mult(scalar,S_M_IJ(mat,i,j),S_M_IJ(erg,i,j));
	return(OK);
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
INT mult_apply_scalar_matrix(a,b) OP a,b;
/* AK 150290 V1.1 */ /* AK 210891 V1.3 */
{
	OP z = S_M_S(b);
	INT grenze = S_M_LI(b)*S_M_HI(b);
	INT i;
	for (i=0L;i<grenze;i++,z++) mult_apply(a,z);
	return(OK);
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
INT mult_apply_matrix_matrix(a,b) OP a,b;
/* AK 131190 V1.1 */ /* b =  a * b */
/* AK 210891 V1.3 */
{
	OP c = callocobject();
	INT erg = OK; /* AK 200192 */
	*c = *b;
	C_O_K(b,EMPTY);
	erg += mult_matrix_matrix(a,c,b);
	erg += freeall(c);
	return erg;
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
INT mult_matrix_matrix(a,b,c) OP a,b,c;
/* AK 280388 */ /* AK 060789 V1.0 */ /* AK 111289 V1.1 */
/* c = a * b */
/* AK 210891 V1.3 */
{
	INT i,j,k;
	OP z; /* zwischen ergebnis bei matrix-multiplikation */

	if (neq(s_m_l(a),s_m_h(b)))
	{ 
		error("mult_matrix_matrix:can not be multiplied");
		return(ERROR); 
	};
	m_ilih_m(S_M_LI(b),S_M_HI(a),c);
	z=callocobject(); /* zwischensumme*/
	for (i=0;i<S_M_HI(a);i++)	/* ueber zeilen der linken Matrix */
		for (j=0;j<S_M_LI(b);j++) /* ueber spalten der rechten Matrix */
			for (k=0;k<S_M_LI(a);k++)
			{ 
				mult(S_M_IJ(a,i,k),S_M_IJ(b,k,j),z);
				add(z,S_M_IJ(c,i,j),S_M_IJ(c,i,j)); 
			};
	freeall(z); 
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT mult_matrix(a,b,d) OP a,b,d;
/* AK 070789 V1.0 */ /* AK 310790 V1.1 */ /* AK 210891 V1.3 */
{
	switch(S_O_K(b))
	{
	case BRUCH:
	case INTEGER:
	case LONGINT: return mult_scalar_matrix(b,a,d);
	case MATRIX: return mult_matrix_matrix(a,b,d);
	case VECTOR: return mult_matrix_vector(a,b,d); /* AK 200192 */
	default:
		{
			printobjectkind(b);
			error("mult_matrix:wrong second type"); 
			return(ERROR);
		}
	}
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
#ifdef VECTORTRUE
INT mult_matrix_vector(b,a,c) OP a, b, c;
/* AK 200192 */
{
	INT i,j;
	INT erg = OK;
	OP d;
	if (S_O_K(a) != VECTOR) return ERROR;
	if (S_O_K(b) != MATRIX) return ERROR;
	if ((a == c) || (b == c)) return ERROR;
	if (S_V_LI(a) != S_M_LI(b)) return ERROR;
	erg += m_il_nv(S_M_HI(b),c);
	d = callocobject();
	for (i=0L;i<S_V_LI(c);i++)
	for (j=0L;j<S_V_LI(a);j++)
		{
		erg += mult(S_M_IJ(b,i,j),S_V_I(a,j),d);
		erg += add_apply(d,S_V_I(c,i));
		}
	erg += freeall(d);
	return erg;
}
#endif /* VECTORTRUE */
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT mult_apply_matrix(a,b) OP a,b;
/* AK 131190 V1.1 */ /* AK 210891 V1.3 */
{
	switch(S_O_K(b))
	{
	case MATRIX: return(mult_apply_matrix_matrix(a,b));
	default:
		{
			printobjectkind(b);
			error("mult_apply_matrix:wrong second type"); 
			return(ERROR);
		}
	}
}
#endif/* MATRIXTRUE */


#ifdef MATRIXTRUE
INT objectread_matrix(fp,matrix) FILE *fp; OP matrix;
/* AK 300888 */ /* AK 070789 V1.0 */ /* AK 310790 V1.1 */
/* AK 210891 V1.3 */
{
	INT i,j;
	OP l= callocobject();
	OP h = callocobject();
	objectread(fp,h);
	objectread(fp,l);
	b_lh_m(l,h,matrix);
	for (i=0;i<S_M_HI(matrix); i++)
		for (j=0;j<S_M_LI(matrix); j++)
			objectread(fp,S_M_IJ(matrix,i,j));
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT objectwrite_matrix(fp,matrix) FILE *fp; OP matrix;
/* AK 300888 */ /* AK 070789 V1.0 */ /* AK 310790 V1.1 */
/* AK 210891 V1.3 */
{
	INT i,j;

	fprintf(fp, " %d ",MATRIX);
	objectwrite(fp,S_M_H(matrix));
	/* zuerst die hoehe */
	objectwrite(fp,S_M_L(matrix));
	/* dann die laenge */

	for (i=0;i<S_M_HI(matrix); i++)
		for (j=0;j<S_M_LI(matrix); j++)
			objectwrite(fp,S_M_IJ(matrix,i,j));
	return(OK);
}
#endif/* MATRIXTRUE */

#ifdef MATRIXTRUE
INT test_matrix() 
/* AK 181289 V1.1 */
/* AK 120891 V1.3 */
{
	OP a = callocobject();
	OP b = callocobject();

	printf("test_matrix:scan(a)");
	scan(MATRIX,a);
	println(a);
	printf("test_matrix:add(a,a,b)");
	add(a,a,b);
	println(b);
	printf("test_matrix:mult(a,b,b)"); 
	mult(a,b,b); 
	println(b);
	printf("test_matrix:kronecker_product(a,b,b)"); 
	kronecker_product(a,b,b); 
	println(b);
#ifdef BRUCHTRUE
	printf("test_matrix:invers(b,a)"); 
	invers(b,a); 
	println(a);
#endif /* BRUCHTRUE */
	printf("test_matrix:delete_row_matrix(a,1L,b)");
	delete_row_matrix(a,1L,b); 
	println(b);
	printf("test_matrix:delete_column_matrix(b,1L,b)");
	delete_column_matrix(b,1L,b); 
	println(b);


	freeall(a);
	freeall(b);
	return(OK);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT trace_matrix(a,b) OP a,b;
/* AK 131289 spur einer matrix */
/* AK 131289 V1.1 */ /* AK 270291 V1.2 */ /* AK 210891 V1.3 */
{
	INT i;
	if (not EMPTYP(b)) freeself(b);
	if (not quadraticp(a)) {
		error("trace_matrix: matrix not quadratic");
		return(ERROR); }
	M_I_I(0L,b);
	for (i=S_M_HI(a)-1L; i>=0L; i--)
		add_apply(S_M_IJ(a,i,i),b);
	return OK;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
#ifdef VECTORTRUE
INT spalten_summe(a,b) OP a,b;
/* AK 281289 summe ueber die Spalten, ergebnis ist vector */
/* AK 281289 V1.1 */ /* AK 240791 V1.3 */
{
	INT i,j;
	INT erg = OK;
	if (S_O_K(a) != MATRIX) 
		return(error("spalten_summe: typ not MATRIX"));
	if (not EMPTYP(b)) 
		erg += freeself(b);
	erg += m_il_v(S_M_LI(a),b);
	for (j=0;j<S_M_LI(a);j++)
		{
		M_I_I(0L,S_V_I(b,j));
		for (i=0;i<S_M_HI(a);i++)
			erg += add(S_M_IJ(a,i,j),S_V_I(b,j),S_V_I(b,j));
		}
	return erg;
}
#endif /* VECTORTRUE */
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
char * t_INTMATRIX_charvektor(a) OP a;
/* AK 210891 V1.3 */
{
	INT i,j,k=0;
	char *erg = (char *) 
		malloc(S_M_HI(a)*S_M_LI(a)*sizeof(char));
	if(erg == NULL) error("t_INTMATRIX_charvektor:no memory");
	else {
		for (i=0;i<S_M_HI(a);i++)
				for (j=0;j<S_M_LI(a);j++,k++)
					erg[k] =(char)S_M_IJI(a,i,j);
		}
	return(erg);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
#ifdef VECTORTRUE
INT m_vector_diagonalmatrix(a,b) OP a,b;
/* AK 171290 V1.1 */ /* AK 110691 V1.2 */ /* AK 210891 V1.3 */
{
	INT i;
	m_lh_nm(S_V_L(a),S_V_L(a),b);
	for (i=0L; i<S_M_HI(b);i++)
			copy(S_V_I(a,i),S_M_IJ(b,i,i));
	return OK;
}
#endif /* VECTORTRUE */
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT max_matrix(a,b) OP a,b;
/* b becomes copy of the maximum entry */
/* AK 110691 V1.2 */ /* AK 210891 V1.3 */
{
	OP z = S_M_S(a),zb = S_M_S(a);
	INT i;

	for (i=S_M_HI(a)*S_M_LI(a); i>0L; i--, z++)
		if (GR(z,zb)) zb = z;
	return copy(zb,b);
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE

INT zeilen_summe(a,b) OP a,b;
/* AK 281289 summe ueber die Zeilen, ergebnis ist vector */
/* AK 281289 V1.1 */ /* AK 210891 V1.3 */
{
	INT i,j;
	if (S_O_K(a) != MATRIX) 
		return(error("spalten_summe: typ not MATRIX"));
	if (not EMPTYP(b)) freeself(b);
	m_il_v(S_M_HI(a),b);
	for (j=0;j<S_M_HI(a);j++)
		{
		M_I_I(0L,S_V_I(b,j));
		for (i=0;i<S_M_LI(a);i++)
			add(S_M_IJ(a,j,i),S_V_I(b,j),S_V_I(b,j));
		}
	return OK;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE


INT n_fold_kronecker_product(n,A,B) OP	n; OP	A; OP	B;
/* RH 080891 V1.3 */
{
	INT	i;

	if(S_I_I(n)>= 2L) 	kronecker_product(A,A,B);
	for(i=2;i<S_I_I(n);++i) kronecker_product(A,B,B);
	return OK;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE

INT kronecker_product(A,B,C) OP	A; OP	B; OP	C;
/* RH 080891 V1.3 */
{
	INT	i;
	INT	j;
	INT	k;
	INT	l;

	OP	M 	=	callocobject();
	OP	H 	=	callocobject();
	OP	dim	=	callocobject();

	mult(S_M_L(A),S_M_L(B),dim);

	m_lh_m(dim,dim,M);
	m_lh_m(S_M_L(B),S_M_L(B),H);

	for(i=0L;i<S_M_LI(A);++i)
	{
		for(j=0L;j<S_M_HI(A);++j)
		{
			mult(S_M_IJ(A,i,j),B,H);
			for(k=0L;k<S_M_LI(H);++k)
				for(l=0L;l<S_M_HI(H);++l)
					copy(S_M_IJ(H,k,l),
					 S_M_IJ(M,i*S_M_HI(B)+k,j*S_M_LI(H)+l));
		}
	}
	copy(M,C);

	freeall(M);
	freeall(H);
	freeall(dim);
	return OK;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE

INT select_row(a,index,b) OP a,b; INT index;
/* transfer one row to vector object  */
/* AK 110592 */
{
	INT j;
	INT erg = OK;
	erg += m_il_v(S_M_LI(a),b);
	for (j=0L;j<S_M_HI(a);j++)
		erg += copy(S_M_IJ(a,index,j),S_V_I(b,j));
	return erg;
}
#endif /* MATRIXTRUE */

#ifdef MATRIXTRUE
INT select_column(a,index,b) OP a,b; INT index;
/* transfer one column to vector object  */
/* AK 110592 */
{
	INT j;
	INT erg = OK;
	erg += m_il_v(S_M_HI(a),b);
	for (j=0L;j<S_M_LI(a);j++)
		erg += copy(S_M_IJ(a,j,index),S_V_I(b,j));
	return erg;
}
#endif /* MATRIXTRUE */
