module showrules; % Display rules for an operator.

% Author: Herbert Melenk, ZIB, Berlin. E-mail: melenk@sc.zib-berlin.de.

% Copyright (c) 1992 ZIB Berlin. All rights reserved.

global '(!*match );

fluid '(asymplis!*);

% All let-rules for an operator are collected as rule set.

% Usage in algebraic mode:
%  e.g. SHOWRULES SIN;
% The rules for exponentiation can be listed by
%       SHOWRULES EXPT;

symbolic procedure showrules (opr);
   begin scalar r;
     r := showruleskvalue opr;
     r:=append(r,showrulesopmtch opr);
     r:=append(r,showrules!*match opr);
     r:=append(r,showrulesdfn opr);
     if opr = 'expt then
        <<r:=append(r,showrulespowlis!*());
          r:=append(r,showrulespowlis1!*());
          r:=append(r,showrulesasymplis!*())>>;
       return 'list.r;
   end;

symbolic procedure showruleskvalue opr;
  for each rule in get(opr,'KVALUE) collect
   begin scalar pattern,vars,svars,target;
      pattern := car rule;
      vars := selectletvars pattern;
      svars := arbvars vars;
      pattern := subla(svars,pattern);
      target := cadr rule;
      target := subla (svars,target);
      return mkrule(nil,pattern,target);
   end;

symbolic procedure showonerule(test,pattern,target);
     % central routine produces one rule.
   begin scalar rules,pattern,vars,svars,target,test;
      vars := selectletvars pattern;
      svars := arbvars vars;
      pattern := subla(svars,pattern);
      test := subla(svars,test);
      target := subla (svars,target);
      vars := for each var in svars collect cdr var;
      svars := vars;
      test := simpletsymbolic test;
      target := simpletsymbolic target;
      if test=t then test:=nil;
      target := simpletsymbolic target;
      return  mkrule(test,pattern,target);
   end;

symbolic procedure showrulesopmtch opr;
  for each rule in get(opr,'opmtch) collect
    showonerule(cdadr rule,opr . car rule,caddr rule);

symbolic procedure showrulesdfn opr;
      append(showrulesdfn1 opr, showrulesdfn2 opr);

symbolic procedure showrulesdfn1 opr;
   % simple derivatives
  for each rule in get(opr,'dfn) collect
   begin scalar pattern,vars,svars,target,test;
        pattern := car rule;
        pattern := append(list('df,opr . pattern),pattern);
        target := cdr rule;
        return showonerule(nil,pattern,target);
     end;

symbolic procedure mkrule(c,a,b);
    {'replaceby,a,if c then {'when,b,c} else b};

symbolic procedure showrulesdfn2 opr;
   % collect possible rules from df
   for each rule in get('df,'opmtch) join
      if eqcar(caar rule,opr) then {showrulesopmtch1 ('df,rule)};

symbolic procedure showrules!*match opr;
  for each rule in !*match join if smember (opr,rule) then
   begin scalar pattern,target,test,p1,p2;
       pattern := car rule;
       p1 := car pattern;
       p2 := cadr pattern;
       pattern := list ('times,prepsq !*p2q p1,
                                prepsq !*p2q p2);
       test := cdadr rule;
       target := caddr rule;
       return showonerule(test,pattern,target);
     end;

symbolic procedure showrulespowlis!*();
 for each rule in powlis!* collect
   begin scalar pattern,target,test;
      pattern := list ('expt,car rule,cadr rule);
      target := cadddr rule;
      return mkrule(nil,pattern,target);
   end;

symbolic procedure showrulespowlis1!*();
 for each rule in powlis1!* collect
   begin scalar pattern,target,test,p1,p2;
      pattern := car rule;
      p1 := car pattern;
      p2 := cdr pattern;
      pattern := list ('expt, p1, p2);
      test := cdadr rule;
      target := caddr rule;
      return showonerule(test,pattern,target);
    end;

symbolic procedure showrulesasymplis!*();
   for each rule in asymplis!* collect
      mkrule(nil,{'expt,car rule,cdr rule},0);

symbolic procedure selectletvars u;
     if null u then nil else
     if memq(u,frlis!*) then {u} else
     if atom u then nil else
     union (selectletvars car u, selectletvars cdr u);

symbolic procedure simpletsymbolic u;
    if atom u then u else
    if car u = 'quote then simpletsymbolic cadr u else
    if car u = 'aeval then simpletsymbolic cadr u else
    if car u = 'reval then simpletsymbolic cadr u else
    if car u = 'boolvalue!* then simpletsymbolic cadr u else
    if car u = 'list then simpletsymbolic cdr u else
    if isboolfn car u then simpletsymbolic (isboolfn car u . cdr u)
       else simpletsymbolic car u . simpletsymbolic cdr u;

fluid '(bool!-functions!*);

bool!-functions!* :=
  for each x in {'equal,'greaterp,'lessp,'geq,'leq,'neq,'numberp}
      collect get(x,'boolfn).x;

symbolic procedure isboolfn u;
    if idp u and (u:=assoc(u,bool!-functions!*)) then cdr u; 
     
symbolic procedure arbvars vars;
  for each var in vars collect 
         var . {'!~, intern compress cddr explode var};

symbolic operator showrules;

endmodule;

end;
