% REIMPART.RED  F.J.Wright, FJW@Maths.QMW.AC.UK, London  23/3/92

% This code attempts to improve the way that the complex operators
% CONJ, REPART and IMPART handle values that are implicitly real,
% namely composed functions of explicitly real numbers.

% The functions MKREPART and MKIMPART are defined in file
% POLY.RED and compiled into module compopr.
% The standard versions return values like REPART SQRT 3 and
% IMPART SQRT 3, which I think should simplify to SQRT 3 and 0 resp.
% The following code attempts to fix this, and seems to work for
% simple cases at least, but this may not be the best way to do it.

symbolic procedure mkrepart u;
   if eqcar(u,'impart) or eqcar(u,'repart)
    or realvalued u then !*k2q u
    else mksq(list('repart, u),1);

symbolic procedure mkimpart u;
   if eqcar(u,'repart) or eqcar(u,'impart)
    or realvalued u then nil ./ 1
    else mksq(list('impart, u),1);

symbolic procedure realvalued u;
   % True if the true prefix kernel form u is real-valued.
   if atom u then
      fixp u or get(u, '!:rd!:)
      % integer or symbolic value like pi or e
   else
      ((get(car u, '!:rd!:) or flagp(car u, 'realvalued))
         and realvaluedlist cdr u)  % real-valued function
      or car u eq '!:rd!:;  % rounded number

symbolic procedure realvaluedlist u;
   % True if every element of the list u of
   % true prefix kernel forms is real-valued.
   realvalued car u and (null cdr u or realvaluedlist cdr u);

% The realvalued flag means that a function returns
% a real value when applied to a real argument,
% as does every function with the property :rd:
% This extra flag is needed mainly for kernels with
% arguments that are general algebraic expressions.

flag('(plus minus times quotient), 'realvalued);
% anything else needed?


symbolic operator realvaluep;

symbolic procedure realvaluep u;
   % Algebraic-mode interface, mainly for testing
   if realvalued u then 1 else 0;

end;



% REIMPART.LOG  F.J.Wright, FJW@Maths.QMW.AC.UK, London  23/3/92

% Saved transcript to demonstrate REIMPART.RED.
% First the standard REDUCE 3.4 behaviour:

r := sqrt 2 + 3pi - sqrt cos (2/3);

             2
 - sqrt(cos(---)) + sqrt(2) + 3*pi
             3

conj r;

            2  1/2              1/2
impart(cos(---)   )*i - impart(2   )*i - 3*impart(pi)*i
            3

               2  1/2            1/2
 - repart(cos(---)   ) + repart(2   ) + 3*repart(pi)
               3

repart r;

               2  1/2            1/2
 - repart(cos(---)   ) + repart(2   ) + 3*repart(pi)
               3

impart r;

               2  1/2            1/2
 - impart(cos(---)   ) + impart(2   ) + 3*impart(pi)
               3

% Now install REIMPART and repeat:
in "reimpart.red";

conj r;

             2
 - sqrt(cos(---)) + sqrt(2) + 3*pi
             3

repart r;

             2
 - sqrt(cos(---)) + sqrt(2) + 3*pi
             3

impart r;

0

% Well, I like it better!

end;
