% INTDF.RED  F.J.Wright, FJW@Maths.QMW.AC.UK, London  22/3/92

module intdf;

% Provide integrator pre-processing to support
% changes of integration variable of the form
% int(f(y)*df(y,x), x) and int(f(y)/df(x,y), x)
%   ->  int(f(y), y)

% Can always invoke this facility by calling the integrator as
% intdf(integrand, variable)  via
put('intdf, 'simpfn, 'simpintdf);

% To have this routine called automatically by int do instead
% put('int, 'simpfn, 'simpintdf);
% Supply a switch to control this facility:
switch intdf;  % off by default
put('intdf, 'simpfg, '((nil (put 'int 'simpfn 'simpint))
                       ( t  (put 'int 'simpfn 'simpintdf))));


symbolic smacro procedure dfchecknum dfl;
   dfcheck(dfl, t);     % Check numerator

symbolic smacro procedure dfcheckden dfl;
   dfcheck(dfl, nil);   % Check denominator

fluid'(var depvar);

symbolic procedure simpintdf u;
   % Search for df(depvar, var) as factor in numerator of integrand
   % or df(var, depvar) as factor in denominator of integrand;
   % remove and change integration variable if found.
   begin scalar integrand, var, dfl, dfl1, depvar;
      if length u neq 2 then
         rederr "Int requires 2 arguments";
      % True prefix form seems most appropriate for this
      % searching, which is more symbolic than algebraic.
      integrand := reval car u;  var := reval cadr u;
      % Ensure that (df depvar var) appears as an
      % element of a list that can be rplaca'd
      dfl := integrand := list integrand;
      % dfl points to a sublist of the integrand list.
      begin  % Use block instead of gotos.
         % Check for (x) or ((df ...)) where x is any atom:
         if atom car dfl or dfchecknum dfl then return;
         dfl := car dfl;  % discard list wrapper
         % Check for (quotient x ...) or (quotient (df ...) ...):
         if eqcar(dfl, 'quotient) then <<
            dfl1 := cdr(dfl := cdr dfl);  % dfl1 is (denominator)
            if dfchecknum dfl then return;
            dfl := car dfl    % dfl is actual numerator
         >>;
         % Examine numerator:
         % -----------------
         % Check for (minus x) or (minus (df ...))
         if eqcar(dfl, 'minus) then <<
            dfl := cdr dfl;
            if (null dfl1 and atom car dfl) or dfchecknum dfl then
               return;
            dfl := car dfl
         >>;
         % Check for (times x ... (df ... ) ... )
         if eqcar(dfl, 'times) then <<
            while (dfl := cdr dfl) and not dfchecknum dfl do
               ; % nothing
            if dfl then return
         >>;
         % Examine denominator:
         % -------------------
         if null dfl1 or atom car dfl1 or dfcheckden dfl1 then return;
         dfl1 := car dfl1;    % dfl1 is actual denominator
         % Check for (times x ... (df ... ) ... )
         if eqcar(dfl1, 'times) then
            while (dfl1 := cdr dfl1) and not dfcheckden dfl1 do
               ; % nothing
      end;
      integrand := car integrand;  % discard wrapping list.
      if depvar then
         % Check new integrand independent of old variable var:
         if smember(var, integrand) then
            rederr "Incomplete change of variable in integral"
         else u := list(integrand, depvar)
      else u := list(integrand, var);
         % (May as well use simplification performed so far.)
      % The integrator resets the simpfn property of int, so ...
      u := simpint u;
      if !*intdf then put('int, 'simpfn, 'simpintdf);
      return u;
%%      print('simpint . u);  return '(nil . 1)  % for testing
   end;  % simpintdf

symbolic procedure dfcheck(dfl, !*numerator);
   % Check for and process a derivative in the
   % numerator or denominator of the integrand.
   begin scalar df;  % true if ((df var1 var2) ... ) found
      if not eqcar(df := car dfl, 'df) then return nil;
      if length(df := cdr df) neq 2 then
         rederr "Derivative in integral not first order";
      if !*numerator then  % df(depvar, var)?
         (if cadr df = var then depvar := car df)
      else                 % df(var, depvar)?
         (if car df = var then depvar := cadr df);
      if depvar then rplaca(dfl, 1);
      return t
   end;  % dfcheck

endmodule;
END;  % of file INTDF.RED



% INTDF.LOG  F.J.Wright, FJW@Maths.QMW.AC.UK, London  22/3/92

% This is a transcript of a REDUCE session that demonstrates the
% use of INTDF.  It is based on exercise question 7 in chapter 1
% of MacCallum and Wright.
% (This transcript was generated retrospectively
% using my SAVEIO command.)

ode := exp y * df(y,x) = exp(-2x)*x;

                 x
exp(y)*df(y,x)=------
                 2*x
                e

depend y,x;
on evallhseqp;
ode := ode;

 y           x
e *df(y,x)=------
             2*x
            e

soln := int(lhs ode, x) = int(rhs ode, x);
% This fails, so use INTDF, which works:
% =====================================
on intdf;
retry;

 y   - 2*x - 1
e =------------
         2*x
      4*e

;END;
