;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   This file contains the Window Manager functions. The functions
;;;   are all invoked by the main menu.
;;;
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(eval-when (compile) (require  '//user//vaxima//young//devdep//gelib))
(declare (macros t)
          (special **graphrect **textrect **visrect **copyform
	           **window_list** **fromcopybb **tocopybb **drawbb
		   **erasebb **maxrect **texterasebb **prev-dstate
		   **current-window** **cursors **oldrow** **oldcol**
		   $linenum linenum ttyheight $gcdisable $linel 
		   **top-level-menu** **select-menu** tefont **font
		   **verify-delete-menu** $outchar lg-character-x
		   **win_number** **prompt-area**)
)
(defvar **current-window** nil)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: $WCREATE
;;;   
;;;      Purpose: create a window from the macsyma top level
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Mon Jun 02 17:13:57 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun $wcreate  (name)
    (make-window :name name)
 )  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: MAKE-WINDOW
;;;   
;;;      Purpose: create a window
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Jan 21 22:54:46 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun make-window (&key (name (next_free_window_name))
			 (rectangle (rect-from-user)))
   (prog (topbar icon1 icon2 icon3 icon4 p1 p2 p3 p4 topbar bottombar
		 rectangle2)
      (setcursor waitcursor)
      ; set a minimum size
      ;
      (if (> 175. (rect->w rectangle)) then (setf (rect->w rectangle) 175.))
      (if (> 150. (rect->h rectangle)) then (setf (rect->h rectangle) 150.))
      ;;;
      ;;;   update the top window
      ;;;
      (cond((and **current-window** (nequal name **current-window**))
	    (update_screen_form **current-window**)))
      ;
      ; save the previous display under the  window
      ;
      (putprop  name rectangle 'rect)
      (putprop name (make-rect x (+ (rect->x rectangle) 2)
			       y (+ (rect->y rectangle) 20.)
			       w (- (rect->w rectangle) 4)
			       h (- (rect->h rectangle) 24.)) 'screenrect)
      (putprop  name 'full 'size)
      (save_previous_state  name)
      (push_window_on_list  name)
      (setq **current-window** name)
      (setq **oldrow** 0 **oldcol** 0 $linenum 1 linenum 1)
      (cond((equal name 'calc)(setq $outchar 'c))
		   (t(setq $outchar (concat (car (explode name))
					    (car(last (explode name)))
					    '|_|))))
      ;
      ;  make the rectangle slightly smaller
      ;
      (setf rectangle2 (make-rect x (+ 2 (rect->x rectangle))
				  y (+ 2 (rect->y rectangle))
				  w (- (rect->w rectangle) 4)
				  h (- (rect->h rectangle) 4)))
      ; create a bar for the window name
      ;
      (setf topbar (+ (rect->y rectangle2) 15.))
      (setf p1 (make-point x (rect->x rectangle2) y  topbar))
      (setf p2 (make-point x (+(rect->w rectangle2)(rect->x rectangle2))
			   y  topbar))
      (setf bottombar (+ (rect->h rectangle2)(rect->y rectangle2) (minus 15.)))
      ; draw the window
      (draw-rectangle rectangle2 :rule bbzero)
      (draw-rectangle (make-rect x (rect->x rectangle2)
				 y (rect->y rectangle2)
				 h 15.
				 w (+ (stringsize name **font) 40.)))
      (draw-box rectangle2 :width 2)
      (draw-line p1 p2)
      ; paint the window name centered in the label line
      (paint-string  (+(rect->x rectangle) 20.)
		     (- topbar 12.)
		     name)
      ;
      ; save the rectangle as a property of the window name
      ;
      (update_screen_form name)
      ;;;
      ;;;   this sets up the stuff for display to keep track of the formatting
      ;;;
      (setq linel (*quo(rect->w (get **current-window** 'screenrect))
				(1+ lg-character-x)))
      (setq $linel linel)
      (setq ttyheight (*quo(rect->h (get **current-window** 'screenrect))
				    lg-character-y))
      (setq  **oldrow** 0  **oldcol** 0)
      (setq $linenum 1 linenum 1)
      )
   (setcursor normalcursor)
   )

;******************************************************************
;  next_free_number:
;
;  generate succesive numbered windows -- Window1,Window2, Window3...
;******************************************************************
;;;   
;;;   this has to go in continue
;;;   
(setq **win_number** 0)
(defun next_free_window_name ()
   (setq **win_number** (1+ **win_number**))
   (concat 'scratch **win_number**))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: Save-previous-state
;;;   
;;;      Purpose: Save the screen portion covered by a window as a 
;;;               property "previous-display" of the window
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Jan 21 22:53:33 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun save_previous_state (window)
   (let* ( (rect (get window 'rect))
	   ( x1 (rect->x rect))(y1 (rect->y rect))
	   ( w1 (rect->w rect))(h1 (rect->h rect)))
      (putprop window (form_create w1 h1) 'previous-display)
      (putprop window (make-bbcom srcform **screen
				  destform  (get window 'previous-display)
				  destrect (make-rect x 0 y 0 w w1 h h1)
				  cliprect **maxrect
				  rule bbs
				  srcpoint (make-point x x1 y y1))
	       'save-bb)
      (bit_blt (get window  'save-bb))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: remove_window_from_screen
;;;   
;;;      Purpose:Remove a window from the screen, restoring the background
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Jan 21 22:53:05 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun remove_window_from_screen (window)
   (let* (( rect (get window 'rect))
	  (x1 (rect->x rect))(y1 (rect->y rect))
	  (w1 (rect->w rect))(h1 (rect->h rect))
	  (src (get window 'previous-display)))
      (bit_blt (make-bbcom srcform  src
			   destform **screen
			   destrect (make-rect x x1 y y1 w w1 h h1)
			   cliprect **maxrect
			   rule bbs
			   srcpoint (make-point x 0 y 0)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: MOVE-WINDOW
;;;   
;;;      Purpose: Move a Window to a new location obtained from the user
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Jan 21 22:51:48 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun move-window (window)
   (prog (w1 x1 y1 h1 current newrect)
      (if (nequal window **current-window**) (pop_window window))
      (setf w1 (rect->w (get window 'rect)))
      (setf h1 (rect->h (get window 'rect)))
      (setf x1 (rect->x (get window 'rect)))
      (setf y1 (rect->y (get window 'rect)))
      (set_mposition (make-point x x1 y y1))
      ;;;
      ;;; get the new location
      ;;;
      (setf newrect (fixed-rect-from-user :minh h1 :minw w1))
      (setf current (get window 'current-display))
      ;;;
      ;;; remove the old window display
      ;;;
      (update_screen_form window)
      (remove_window_from_screen window)
      ;;;
      ;;; save all the old displays, now that the screen is clear
      ;;;
      (if (nequal window **current-window**)
	  (update_screen_form **current-window**))
      ;;;
      ;;; save the new location
      ;;;
      (putprop window newrect 'rect)
      (putprop window (make-rect x (+ (rect->x newrect) 2.)
				 y (+ (rect->y newrect) 20.)
				 w (- (rect->w newrect) 4.)
				 h (-(rect->h newrect) 40.)) 'screenrect)
      (save_previous_state window)
      (setf w1 (rect->w (get window 'rect)))
      (setf h1 (rect->h (get window 'rect)))
      (setf x1 (rect->x (get window 'rect)))
      (setf y1 (rect->y (get window 'rect)))
      (setf current (get window 'current-display))
      ;;;
      ;;; set up the transfer for the new location
      ;;;
      (setcursor waitcursor)
      (bit_blt (make-bbcom srcform  current
			   destform **screen
			   destrect (make-rect x x1 y y1 w w1 h h1)
			   cliprect **maxrect
			   rule bbs

			   srcpoint (make-point x 0 y 0))))

   (setcursor normalcursor)
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: UPDATE_SCREEN_FORM
;;;   
;;;      Purpose: store the current state of a window as a 
;;;               property "current-display" of the window
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Jan 21 22:50:33 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  (defun update_screen_form (window)
   (let* (( w1 (rect->w (get window 'rect)))
   (h1 (rect->h (get window 'rect)))
   (x1 (rect->x (get window 'rect)))
   (y1 (rect->y (get window 'rect))))
;;;   
;;;   remember displa stuff
;;;   
   (putprop window $linenum 'linenum)
   (putprop window **oldrow** 'oldrow)
   (putprop window **oldcol** 'oldcol)
   (putprop window $outchar 'outchar)
   ; save the old display
   (putprop window (form_create w1 h1) 'current-display)
   (bit_blt (make-bbcom srcform **screen
          destform (get window 'current-display)
			destrect (make-rect x 0 y 0 w w1 h h1)
			cliprect **maxrect
			rule bbs
			srcpoint (make-point x x1 y y1)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: SHRINK-WINDOW
;;;   
;;;      Purpose: Shrink a window to an icon
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Jan 22 00:34:39 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun shrink-window (window)
   (prog (ww w1 x1 y1 h1 current newrect temp icon-form)
      (if (= 'shrunk (get window 'size)) (return))
      (if (nequal window **current-window**) (pop_window window))
      (putprop  window 'shrunk 'size)
      (setf w1 (rect->w (get window 'rect)))
      (setf h1 (rect->h (get window 'rect)))
      (setf x1 (rect->x (get window 'rect)))
      (setf y1 (rect->y (get window 'rect)))
      (setf ww (+ 10. (stringsize window **font)))
      (set_mposition (make-point x (+ x1 (quotient w1 2)) y y1))
      ;;;
      ;;; get the new location
      ;;;
      (setf newrect (fixed-rect-from-user :minh 24 :minw (+ 4 ww)))
      ;;;
      ;;; save the old display
      ;;;
      (update_screen_form window)
      (putprop window (get window 'current-display) 'fullsized-display)
      (putprop window (get window 'rect) 'fullsize)
      ;;;
      ;;; remove the old window display
      ;;;
      (remove_window_from_screen window)
      (setq temp (remove* window **window_list**))
      ;;;
      ;;; save the new location
      ;;;
      (putprop window newrect 'rect)
      (save_previous_state window)
      (setf w1 (rect->w (get window 'rect)))
      (setf h1 (rect->h (get window 'rect)))
      (setf x1 (rect->x (get window 'rect)))
      (setf y1 (rect->y (get window 'rect)))
      ;;;
      ;;; set up the transfer for the new location
      ;;;
      (putprop window (form_create  w1 h1) 'icon-form)
      (setf icon-form (get window 'icon-form))
      (setf temp (make-rect x 2 y 2  w (- w1 4) h (- h1 4)))
      (draw-rectangle temp  :destform icon-form
		      :halftone whitehalftone :rule bbzero)
      (draw-box temp  :width 2 :destform icon-form)
      (paint-string 5 4 window :destform icon-form)

      (bit_blt (make-bbcom srcform  icon-form
			   destform **screen
			   destrect (make-rect x x1 y y1 w w1 h h1)
			   cliprect **maxrect
			   rule bbs
			   srcpoint (make-point x 0 y 0))))
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: GROW-WINDOW
;;;   
;;;      Purpose: Expand an iconized window back to full size
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Jan 22 01:54:17 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun grow-window (window)
   (prog (ww w1 x1 y1 h1 current newrect)
      (if (= 'full (get window 'size)) (return))
      (setcursor waitcursor)

      (if (nequal window **current-window**) (pop_window window))
      (putprop window 'full 'size)
      (remove_window_from_screen window)
      ;;;
      ;;;   update all other windows
      ;;;
      (if (nequal window **current-window**)
	  (update_screen_form **current-window**))
      (putprop window (get window 'fullsize) 'rect)
      (putprop window (get window 'fullsized-display) 'current-display)
      (setf w1 (rect->w (get window 'rect)))
      (setf h1 (rect->h (get window 'rect)))
      (setf x1 (rect->x (get window 'rect)))
      (setf y1 (rect->y (get window 'rect)))
      ;      (set_mposition (make-point x x1 y y1))
      ;;;
      ;;; get the new location
      ;;;
      (setf newrect (fixed-rect-from-user :minh h1 :minw w1))
      (setcursor waitcursor)
      ;;;
      ;;; remove the old window display
      ;;;
      ;;; save the new location
      ;;;
      (putprop window newrect 'rect)
      (putprop window (make-rect x (+ (rect->x newrect) 2.)
				 y (+ (rect->y newrect) 20.)
				 w (- (rect->w newrect) 4)
				 h (-(rect->h newrect) 40.)) 'screenrect)
      (save_previous_state window)
      (setf w1 (rect->w (get window 'rect)))
      (setf h1 (rect->h (get window 'rect)))
      (setf x1 (rect->x (get window 'rect)))
      (setf y1 (rect->y (get window 'rect)))
      (setf current (get window 'current-display))
      ;;;
      ;;; set up the transfer for the new location
      ;;;
      (bit_blt (make-bbcom srcform  current
			   destform **screen
			   destrect (make-rect x x1 y y1 w w1 h h1)
			   cliprect **maxrect
			   rule bbs
			   srcpoint (make-point x 0 y 0))))

   (setcursor normalcursor)
   )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: PUSH_ON_WINDOW_LIST
;;;   
;;;      Purpose: Put window on the current window list
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Jan 22 22:22:18 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun push_window_on_list  (window)
    (push window **window_list**)
 )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: POP_WINDOW_LIST
;;;   
;;;      Purpose: pop off the top window
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Jan 22 22:24:06 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun pop_window_list  (window)
   (setq **window_list** (remove* window **window_list**))
   (push window **window_list**)
 )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: POP_WINDOW
;;;   
;;;      Purpose: pop the named window to the top of all other windows
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Jan 22 22:30:09 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun pop_window  (window)
   (prog (over_list x1 y1 x2 y2 tx1 ty1 tx2 ty2 u rect testrect w1 h1)
      (cond((or(equal window **window_list**)(null **window_list**))(return)))
      (update_screen_form **current-window**)
      (setq **current-window** window)
      ;;;
      ;;;   stuff for displa
      ;;;
      (setq linel (*quo(rect->w (get **current-window** 'screenrect))
				(1+ lg-character-x)))
      (setq $linel linel)
      (setq ttyheight (*quo(rect->h (get **current-window** 'screenrect))
				    lg-character-y))
      (setq **oldcol** (get **current-window** 'oldcol)
	    **oldrow** (get **current-window** 'oldrow)
	    $linenum (get **current-window** 'linenum)
	    linenum $linenum
	    $outchar (get **current-window** 'outchar))

      (setq over_list (cdr (member window
				   (reverse **window_list**))))
      (pop_window_list window)
      (setf rect (get window 'rect))
      (setq x1 (rect->x rect)
	    y1 (rect->y rect)
	    x2 (+ x1 (rect->w rect))
	    y2 (+ y1 (rect->h rect)))
      (do (( u (car over_list)(car over_list))
	   (over_list (cdr over_list) (cdr over_list)))
	  ((null u))
	  ;;;
	  ;;;   body of do
	  ;;;
	  (setf testrect (get u 'rect))
	  (setq tx1 (rect->x testrect)
		ty1 (rect->y testrect)
		tx2 (+ tx1 (rect->w testrect))
		ty2 (+ ty1 (rect->h testrect)))
	  (cond((lessp x1 tx1 x2 tx2)
		(cond((lessp y1 ty1 y2 ty2)
		      (swap_blt window u tx1 ty1 x2 y2))
			     ((lessp y1 ty1 ty2 y2)
			      (swap_blt window u tx1 ty1 x2 ty2))
			     ((lessp ty1 y1 y2 ty2)
			      (swap_blt window u tx1 y1 x2 y2))
			     ((lessp ty1 y1 ty2 y2)
			      (swap_blt window u tx1 y1 x2 ty2))))
		       ((lessp x1 tx1 tx2 x2)
			(cond((lessp y1 ty1 y2 ty2)
			      (swap_blt window u tx1 ty1 tx2 y2))
				     ((lessp y1 ty1 ty2 y2)
				      (swap_blt window u tx1 ty1 tx2 ty2))
				     ((lessp ty1 y1 y2 ty2)
				      (swap_blt window u tx1 y1 tx2 y2))
				     ((lessp ty1 y1 ty2 y2)
				      (swap_blt window u tx1 y1 tx2 ty2))))
		       ((lessp tx1 x1 x2 tx2)
			(cond((lessp y1 ty1 y2 ty2)
			      (swap_blt window u x1 ty1 x2 y2))
				     ((lessp y1 ty1 ty2 y2)
				      (swap_blt window u x1 ty1 x2 ty2))
				     ((lessp ty1 y1 y2 ty2)
				      (swap_blt window u x1 y1 x2 y2))
				     ((lessp ty1 y1 ty2 y2)
				      (swap_blt window u x1 y1 x2 ty2))))
		       ((lessp tx1 x1 tx2 x2)
			(cond((lessp y1 ty1 y2 ty2)
			      (swap_blt window u x1 ty1 tx2 y2))
				     ((lessp y1 ty1 ty2 y2)
				      (swap_blt window u x1 ty1 tx2 ty2))
				     ((lessp ty1 y1 y2 ty2)
				      (swap_blt window u x1 y1 tx2 y2))
				     ((lessp ty1 y1 ty2 y2)
				      (swap_blt window u x1 y1 tx2 ty2)))))
	  (setf w1 (rect->w (get window 'rect)))
	  (setf h1 (rect->h (get window 'rect)))
	  (setf x1 (rect->x (get window 'rect)))
	  (setf y1 (rect->y (get window 'rect)))
	  ;;;
	  ;;; set up the transfer
	  ;;;
	  (bit_blt (make-bbcom srcform  (get window 'current-display)
			       destform **screen
			       destrect (make-rect x x1 y y1 w w1 h h1)
			       cliprect **maxrect
			       rule bbs
			       srcpoint (make-point x 0 y 0)))

	  )
      )

   )
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;   Function: SWAP_BLT
   ;;;
   ;;;      Purpose: This swaps the front and back info between two windows
   ;;;
   ;;;      Written By: Douglas A. Young
   ;;;      Date: Thu Jan 23 00:46:04 1986
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   (defun swap_blt  (A B  x1 y1 x2 y2 )
     (let* ( ( temprect (get A 'rect))
             (Ax1 (rect->x temprect))
	     (Ay1 (rect->y temprect))
	     (Ax2 (+ Ax1 (rect->w temprect)))
	     (Ay2 (+ Ay1 (rect->h temprect)))
	     (temprect (get B 'rect))
	     (Bx1 (rect->x temprect))
	     (By1 (rect->y temprect))
	     (Bx2 (+ Bx1 (rect->w temprect)))
	     (By2 (+ By1 (rect->h temprect)))
	     (temp (form_create (- x2 x1) (- y2 y1))))
	  ;;;
	  ;;;   save whats under window A in a temp form
	  ;;;
	  (bit_blt (make-bbcom
		      srcform   (get A 'previous-display)
		      destform  temp
		      destrect (make-rect x 0 y 0
					  w (- x2 x1) h (- y2 y1))
		      cliprect **maxrect
		      rule bbs
		      srcpoint (make-point
				  x (abs(- x1 Ax1))
				  y (abs(- y1 Ay1)))))
	  ;;;
	  ;;;   move whats in  window B to window A
	  ;;;
	  (bit_blt
	     (make-bbcom
		srcform   (get B 'current-display)
		destform  (get A 'previous-display)
		destrect  (make-rect x (abs(- x1 Ax1))
				     y (abs(- y1 Ay1))
				     w (- x2 x1)
				     h (- y2 y1))
		cliprect **maxrect
		rule bbs
		srcpoint (make-point x (abs(- x1 Bx1))
				     y (abs(- y1 By1)))))
	  ;;;
	  ;;;   Now put the image saved in temp back in window B
	  ;;;
	  (bit_blt(make-bbcom
		srcform   temp
		destform  (get B 'previous-display)
		destrect  (make-rect x (abs(- x1 Bx1))
				     y (abs(- y1 By1))
				     w (- x2 x1)
				     h (- y2 y1))
		cliprect **maxrect
		rule bbs
		srcpoint (make-point x  0 y 0)))
     ))
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;   Function: DELETE-WINDOW
   ;;;
   ;;;      Purpose: remove a window from the screen and delete all
   ;;;               references to it
   ;;;
   ;;;      Written By: Douglas A. Young
   ;;;      Date: Fri Jan 24 02:42:55 1986
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   (defun delete-window  (window &key (verify t))
     (prog()
	  (cond((equal window 'calc)(tyo 7)(return)))
	  (cond((and verify (not(menu-choose **verify-delete-menu**)))
		  (return nil)))
      (setcursor waitcursor)	  
	  (pop_window window)
	  (setq **window_list** (cdr **window_list**))
	  (remove_window_from_screen window)
	  (putprop window nil 'current-display)
	  (putprop window nil 'previous-display)
	  (putprop window nil 'save-bb)
	  (putprop window nil 'rect)
	  (putprop window nil 'screenrect)	  
	  (setq **current-window** (car **window_list**))
      (setq linel (*quo(rect->w (get **current-window** 'screenrect))
				(1+ lg-character-x)))
      (setq $linel linel)
      (setq ttyheight (*quo(rect->h (get **current-window** 'screenrect))
				      lg-character-y))
      (setq **oldcol** (get **current-window** 'oldcol)
            **oldrow** (get **current-window** 'oldrow)
            $linenum (get **current-window** 'linenum)
	    linenum $linenum
            $outchar (get **current-window** 'outchar))
            (setcursor normalcursor)
	  )
   )
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;   Function: CHANGE-WINDOW-SIZE
   ;;;
   ;;;      Purpose: Reduce the size of a window
   ;;;
   ;;;      Written By: Douglas A. Young
   ;;;      Date: Fri Jan 24 11:20:17 1986
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   (defun change-window-size  (window)
	  (let* ((x (rect->x (get window 'rect)))
		(y (rect->y (get window 'rect)))
		(w (rect->w (get window 'rect)))
		(h (rect->h (get window 'rect)))
		(templinenum $linenum)
                (newrect (rect-from-user :xx x :yy y 
			                             :initw w :inith h)))
	     (remove_window_from_screen window)	  	     
             (make-window :name window
	                  :rectangle newrect)
	     (setq $linenum templinenum)
      (setcursor waitcursor)	     
      (putprop window newrect 'rect)
      (putprop window (make-rect x (+ (rect->x newrect) 2)
                               y (+ (rect->y newrect) 20.)
                               w (- (rect->w newrect) 4)
		               h (-(rect->h newrect) 40.)) 'screenrect)
      (redimension-window)
      (setcursor normalcursor)      
	  )
   )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: MSELECT_WINDOW
;;;   
;;;      Purpose: select a window with the mouse
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Jan 25 15:10:46 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun mselect_window  ( )
   (do ( (win (car **window_list**)(car temp_list))
	 (temp_list (cdr **window_list**)(cdr temp_list)))
       ((or(null win)(mouse-in-region(get win 'rect)))
	win)))



