;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Various functions
;;;
(macsyma-module support1)
(eval-when (compile) (require '//user//vaxima//young//devdep//gelib))
(defun beep ()
    (tyo 7))
;;;------------------------------------------------------------------
;;; lcase : converts a string of fixnum represenations of characters
;;;         to lower case
;;;------------------------------------------------------------------
(defun lcase (str)
    (prog (result)
	  loop
	  (cond((null str)(return result)))
	  (cond((and(<= 65. (car str))(>= 90. (car str)))
		(setq result (append1 result (+ (car str) 32.))))
	       (t(setq result (append1 result (car str)))))
	  (setq str (cdr str))(go loop)))

;;;
;;; remove all operators
;;;
(defun stripop (a)
    (cond((member (car (reverse a)) '(43. 45. 42. 47.))
	  (reverse (cdr (reverse a))))
	 (t a)))
;;;
;;; reduces a list containing sublists to one long list
;;; removes all parenthesis
;;;
(defun strip (l)
  (prog (tlist)
     (setq tlist l result nil)
   loop
     (cond((null tlist)(return result)))
     (cond((atom (car tlist))
	   (setq result(append1 result (car tlist)))
	   (setq tlist (cdr tlist)))
	  ((listp (car tlist))
	   (setq result(append result (strip (car tlist))))
	   (setq tlist (cdr tlist))))
     (go loop)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: NEWBREAK
;;;   
;;;      Purpose: set break to turn the terminal emulator back on first
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sun Feb 02 03:01:40 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(putd  'temp-*break (getd '*break))
(defun *break  (&optional (pred nil)( message nil))
    (terminal_enable t)(msg "[41")
    (temp-*break pred message))  






