/*   Least Squares Method, a standalone version
 * 
 *     
 */
#include <stdio.h>
main ()
{
    double  x[400],
            y[400],
            c[400];
    int     n,
            mf,
            i,
            j;
/* 
 *  read in initial parameters
 */
    printf ("input number of points ");
    scanf ("%d", &n);
    printf ("input %d pairs of points\n", n);
    for (i = 1; i <= n; i++)
	scanf ("%lf %lf", &x[i], &y[i]);
    printf (" input desired degree");
    scanf ("%d", &mf);
/* ******
 *   check to see if max degree is too large
 */
    if (mf > (n - 1)) {
	mf = n - 1;
}
/*
 *   call leastsq to return coeficients
 */
    leastsq (n, x, y, mf, c);
/*
 * write out results
 */
    printf ("\n  %.2f + \n ", c[1]);
    for (j = 2; j <= mf+1; j++)
	printf ("  %.2f X**%d +  \n", c[j], j-1);


}
leastsq(n,x,y,mf,c)
int n,mf;
double x[],y[],c[];
{
    double  a[60][60],
            xn[],
            sum;
    int     mfp1,
            mfp2,
            i,
            j,
            im1,
            ipt,
            icoef,
            jcoef;

    mfp1 = mf + 1;
    mfp2 = mf + 2;
/* *****
 *  put ones into a new array this will hold the powers of the x values
 */
fprintf(stderr," mf = %d n= %d\n",mf,n);
for(i=1;i<=n;i++)
   fprintf(stderr," %f %f  %f    ",x[i],y[i],c[i]);
getchar();
    for (i = 0; i <= n; i++)
	xn[i] = 1.0;
/* 
 *   compute forst col and n+1st col of a I moves down the rows,
 *   j sums over the n values
 */
    for (i = 1; i <= mfp1; i++) {
	a[i][mfp2] = a[i][1] = 0.0;
	for (j = 1; j <= n; j++) {
	    a[i][1] += xn[j];
	    a[i][mfp2] += y[j] * xn[j];
	    xn[j] *= x[j];
	}
    }
fprintf(stderr," point 1 \n");

for(i=1;i<=n;i++)
   for(j=1;j<=n;j++)
     fprintf(stderr,"%d %d %lf \n",i,j,a[i][j]);
   for(j=1;j<=n;j++)
     fprintf(stderr,"%d %f \n",j,xn[j]);
getchar();
/*
 * compute the last row of a I moves across the columns, j
 * sums over the n values
 */
    for (i = 2; i <= mfp1; i++) {
	a[mfp1][i] = 0.0;
	for (j = 1; j <= n; j++) {
	    a[mfp1][i] += xn[j];
	    xn[j] *= x[j];
	}
    }
fprintf(stderr," point 2 \n");

for(i=1;i<=n;i++)
   for(j=1;j<=n;j++)
     fprintf(stderr,"%d %d %f \n",i,j,a[i][j]);
   for(j=1;j<=n;j++)
     fprintf(stderr,"%d %f \n",j,xn[j]);
getchar();
getchar();
/* 
 *  now fill in the rest of the a matrix i moves down the rows
 *  j moves across the columns
 */
    for (j = 2; j <= mfp1; j++)
	for (i = 1; i <= mf; i++)
	    a[i][j] = a[i + 1][j - 1];
fprintf(stderr," point 3 \n");

for(i=1;i<=n;i++)
   for(j=1;j<=n;j++)
     fprintf(stderr,"%d %d %f \n",i,j,a[i][j]);
getchar();
getchar();
/*
 * now call a subroutine to solve this set of normal equations
 */
    ludcmq (a, mfp1, 10);
    for (j = 1; j <= mfp1; j++)
	c[j] = a[j][mfp2];
fprintf(stderr," point 4\n");
for(i=1;i<=n;i++)
   for(j=1;j<=n;j++)
     fprintf(stderr,"%d %d %f \n",i,j,a[i][j]);
getchar();
getchar();
    solnq (a, c, mfp1, 10);

}
/* 
 *  function ludcmq forms the lu equivalent of the square
 * coefficient matrix a
 */
ludcmq(a,n,ndim)
double a[60][60];
int n,ndim;
{
    double  sum;
    int     i,
            j,
            jm1,
            im1,
            k;
    for (i = 1; i <= n; i++) {
	for (j = 2; j <= n; j++) {
	    sum = 0.0;
	    if (j <= i) {
		jm1 = j - 1;
		for (k = 1; k <= jm1; k++)
		    sum += a[i][k] * a[k][j];
		a[i][j] -= sum;
	    }
	    else {
		im1 = i - 1;
		if (im1 != 0) {
		    for (k = 1; k <= im1; k++)
			sum += a[i][k] * a[k][j];
		}
		if (abs (a[i][i]) < 1.0 / 10000000.0) {
		    printf ("reduction not complete because of small value\n");
		    return;
		}
		else {
		    a[i][j] = (a[i][j] - sum) / a[i][i];
		}
	    }
	}
    }
}
/* **************
 * subroutine solnq finds the solution to a set of n linear equations
 */
solnq(a,b,n,ndim)
double a[60][60],b[];
int n,ndim;
{
    double  sum;
    int     i,
            im1,
            k,
            j,
            nmjp1,
            nmjp2;
/*
 * do the reduction step
 */
    b[1] /= a[1][1];
    for (i = 2; i <= n; i++) {
	im1 = i - 1;
	sum = 0.0;
	for (k = 1; k <= im1; k++)
	    sum += a[i][k] * b[k];
	b[i] = (b[i] - sum) / a[i][i];
    }
/*
 * now we are ready for back substitution
 */
    for (j = 2; j <= n; j++) {
	nmjp2 = n - j + 2;
	nmjp1 = n - j + 1;
	sum = 0.0;
	for (k = nmjp2; k <= n; k++)
	    sum += a[nmjp1][k] * b[k];
	b[nmjp1] -= sum;
    }
}
       
   
	      
		
	     
    

    
    



