;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: CURVE-FIT
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Feb 18 19:20:56 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
(eval-when (compile)(require "//user//vaxima//young//devdep//gelib"))
(setq **curve-precision** 3)
(defun curve-fit  ( )
   (make-window :name 'Curve  :rectangle
		(rect-from-user))
   (putprop  'curve -1 'plotminx)
   (putprop  'curve -1 'plotminy)
   (putprop  'curve 1 'plotmaxx)
   (putprop   'curve 1 'plotmaxy)
   (setq **xcurve-precision** 
           (fix (quotient 10.0 
               (difference  (get 'curve 'plotmaxx)
	          	      (get 'curve 'plotminx)))))
   (setq **ycurve-precision** 
           (fix (quotient 10.0 
               (difference  (get 'curve 'plotmaxy)
	          	      (get 'curve 'plotminy)))))   
   (draw-axis  (get 'curve 'plotminx)
	       (get 'curve 'plotminy)
	       (get 'curve 'plotmaxx)    
	       (get 'curve 'plotmaxy)
	       (rect->x(get 'curve 'screenrect))
	       (rect->y(get 'curve 'screenrect))
	       (rect->w(get 'curve 'screenrect))
	       (rect->h(get 'curve 'screenrect)))
   (curve-cmd-loop))
		  
(defun curve-cmd-loop ()
   (prog (choice)
      cmdloop
      (cond((equal (car choice) 'delete-window)(go exit)))
      (cond((equal (get_buttons) m_right)
	    (eval (setq choice (menu-choose **curve-menu**))))
		   ((equal (get_buttons) m_left)
		    (draw-points))
		   ((equal (get_buttons) m_middle)
		    (eval (menu-choose **top-level-menu**))))
      (go cmdloop)
      exit
      (return)
      )
   )
      (defvar **curve-menu-items**
	      '(("set scale" (set-scale))
                ("set precision" (set-precision))
		("set order" (set-order))
		("paint curve" (paint-curve))
		("enter points" (draw-points))
		("input file"  (get-pts-from-file))
		("fit curve" (get-fit))
		("exit"  (delete-window 'curve))))
      (defvar **curve-menu** (make-menu **curve-menu-items** :title "Curve Menu"))

      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;   Function: SET-SCALE
      ;;;
      ;;;      Purpose:
      ;;;
      ;;;      Written By: Douglas A. Young
      ;;;      Date: Tue Feb 18 19:29:52 1986
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      (defun set-scale  ( )
	     (draw-rectangle (get 'curve 'screenrect) :halftone whitehalftone)
	     (setup-prompt-area)
	     (paint-string 60 60 "Enter Xmin")(setq xmin (read))
	     (paint-string 60 75 "Enter Ymin")(setq ymin (read))
	     (paint-string 60 90 "Enter Xmax")(setq xmax (read))
	     (paint-string 60 105 "Enter Ymax")(setq ymax (read))

	     (restore-prompt-area)
              (setq **xcurve-precision** 
	            (fix (quotient 10.0 (difference xmax xmin))))
              (setq **ycurve-precision** 
	            (fix (quotient 10.0 (difference ymax ymin))))	      
	     (putprop  'curve xmin 'plotminx)
             (putprop  'curve ymin 'plotminy)
             (putprop  'curve xmax 'plotmaxx)
             (putprop   'curve ymax 'plotmaxy)
              (draw-axis  (get 'curve 'plotminx)
	       (get 'curve 'plotminy)
	       (get 'curve 'plotmaxx)    
	       (get 'curve 'plotmaxy)
	       (rect->x(get 'curve 'screenrect))
	       (rect->y(get 'curve 'screenrect))
	       (rect->w(get 'curve 'screenrect))
	       (rect->h(get 'curve 'screenrect)))
	     )
            (defun set-precision  ( )
	     (setup-prompt-area)
	     (paint-string 60 60 "Enter no. of places of precision")
	     (setq **xcurve-precision** (fix(read)))
	     (restore-prompt-area))

      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;   Function: GET-FIT
      ;;;
      ;;;      Purpose:
      ;;;
      ;;;      Written By: Douglas A. Young
      ;;;      Date: Tue Feb 18 19:30:10 1986
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      (defun get-fit  ( )
	  (setq ptlength (length xylist))
          (setq xvect (new-vectori-double (1+  ptlength)))
          (setq fitted-coeficients (new-vectori-double (1+ ptlength)))
          (setq yvect (new-vectori-double (1+  ptlength)))	  

        (do* ((x (caar xylist)(caar xylist))
	        (y (cadar xylist)(cadar xylist))
		(index 1 (1+ index))
		(xylist (cdr xylist)(cdr xylist)))
	       ((> index ptlength)
		(errset(leastsq ptlength xvect yvect $fit fitted-coeficients))
		   (print-result $fit fitted-coeficients))
	       (vseti-double xvect index (scalefix x **xcurve-precision**))
	       (vseti-double yvect index (scalefix y **ycurve-precision**))
	  ))

      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      ;;;   Function: PAINT-CURVE
      ;;;
      ;;;      Purpose:
      ;;;
      ;;;      Written By: Douglas A. Young
      ;;;      Date: Tue Feb 18 19:31:03 1986
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

      (defun paint-curve  ( )
;;;   
;;;   wait for mouse press
;;;   
        (do ()((not(zerop(get_buttons m_any)))))
	     (setf p1 (make-point ))
	     (setf p2 (make-point ))	     
	     (setq xylist nil)
        (do ()
	    ((zerop (get_buttons))(return xylist))
	    (get_mposition p1)
	    (if (and(or(nequal (point->x p1) (point->x p2))
	               (nequal (point->y p1) (point->y p2)))
		    (lessp (+ 50 (rect->x (get 'curve 'screenrect)))
		           (point->x p1)
			   (-(+ (rect->x (get 'curve 'screenrect))
			      (rect->w (get 'curve 'screenrect))) 50))
		    (lessp (+ (rect->y (get 'curve 'screenrect)) 20)
		           (point->y p1)
			    (+ (minus 20)(rect->h (get 'curve 'screenrect))
			      (rect->y (get 'curve 'screenrect))))
		)
             then
            (if (not(zerop(point->x p2))) then (draw-line p2 p1 :width 2))
	    (setf (point->x p2)(point->x p1))
	    (setf (point->y p2)(point->y p1))	    	    
	    (setf xylist (append1 xylist 
	                         (list (scale-curve-x (point->x p1))
				       (scale-curve-y (point->y p1)))))
	    ))
      )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: DRAW-POINTS
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Feb 19 19:04:37 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      (defun draw-points  ( )
	(setf p1 (make-point ))(setq xylist nil)
        (do ((button (wait-mouse-click m_any)(wait-mouse-click m_any)))
	    ((equal m_right button)(return xylist))
	    (get_mposition p1)
	    (if (and
		    (lessp (+ 50 (rect->x (get 'curve 'screenrect)))
		           (point->x p1)
			   (-(+ (rect->x (get 'curve 'screenrect))
			      (rect->w (get 'curve 'screenrect))) 50))
		    (lessp (+ (rect->y (get 'curve 'screenrect)) 20)
		           (point->y p1)
			    (+ (minus 20)(rect->h (get 'curve 'screenrect))
			      (rect->y (get 'curve 'screenrect)))))
	      then	   
            (draw-x p1)
	    (setf xylist (append1 xylist 
	                         (list (scale-curve-x (point->x p1))
				       (scale-curve-y (point->y p1))))))
	)
      )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: DRAW-X
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Feb 19 19:19:52 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun draw-x  (point)
   (setf xx (point->x point))(setf yy (point->y point))
    (draw-line (make-point x (- xx 2) y (+ yy 2))
               (make-point x (+ xx 2) y (- yy 2)))
    (draw-line (make-point x (- xx 2) y (- yy 2))
               (make-point x (+ xx 2) y (+ yy 2)))
 )  

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: SCALE-CURVE-X
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Feb 19 21:12:12 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun scale-curve-x  (pt)
   (prog ()
      (setq wmin (float(+ 50 (rect->x (get 'curve 'screenrect))))
            wwidth (float(- (rect->w (get 'curve 'screenrect)) 100)))
      (setq x1 (get 'curve 'plotminx) x2 (get 'curve 'plotmaxx))
      (return (plus x1 (times(quotient(difference pt wmin) wwidth)
                             (difference x2 x1))))
   )
 )

(defun scale-curve-y  (pt)
   (prog ()
      (setq wmin (float(- (+(rect->h (get 'curve 'screenrect))
	                        (rect->y (get 'curve 'screenrect))) 20))
	    wheight (float(-(rect->h (get 'curve 'screenrect))40)))
      (setq y1 (get 'curve 'plotminy) y2 (get 'curve 'plotmaxy))
      (return (plus y1 (times(quotient(difference  wmin pt) wheight)
                             (difference y2 y1))))      

   )
 )  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: GET-PTS-FROM-FILE
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Thu Feb 20 23:13:04 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun get-pts-from-file  ( )
   (prog (xlist ylist xylist)
      (setup-prompt-area)
      (paint-string 60 60 "Enter Filename")(setq file (read))
      (cond((not(probef file))
	    (paint-string 60 75 (concat file " Doesnt exist"))
	    (restore-prompt-area)
	    (return)))
      (restore-prompt-area)
      (draw-rectangle (get 'curve 'screenrect) :halftone whitehalftone)
      (setq fp (fileopen file 'r))
      (do* ((x (read fp)(read fp))
	    (y (read fp)(read fp)))
	   ((or(null x)(null y)))
	   (setq xlist (append1 xlist x))
	   (setq ylist (append1 ylist y))
	   (setq xylist (append1 xylist (list x y))))
      (setq maxx (apply 'max xlist))
      (setq minx (apply 'min xlist))
      (setq maxy (apply 'max ylist))
      (setq miny (apply 'min ylist))
              (setq **ycurve-precision** 
	            (fix (quotient 10.0 (difference ymax ymin))))
              (setq **xcurve-precision** 
	            (fix (quotient 10.0 (difference xmax xmin))))	      
      (draw-axis minx miny maxx maxy
		 (rect->x(get 'curve 'screenrect))
		 (rect->y(get 'curve 'screenrect))
		 (rect->w(get 'curve 'screenrect))
		 (rect->h(get 'curve 'screenrect)))
      (do* ((xx (car xlist)(car xlist))
	    (yy (car ylist)(car ylist))
	    (xlist (cdr xlist)(cdr xlist))
	    (ylist (cdr ylist)(cdr ylist)))
	   ((null xx))
	   (draw-x (make-point x
			       (fix (plus(times(quotient(difference xx minx)
						    (difference maxx minx))
							    (difference
				       (rect->w (get 'curve 'screenrect))
			                   100))
			       (rect->x (get 'curve 'screenrect)) 50))
			       y
                              (fix (difference
         				 (+(rect->y (get 'curve 'screenrect))
	        			   (rect->h (get 'curve 'screenrect)))
					   20
		        	      (times(quotient (difference yy miny)
           					 (difference maxy miny))
					 (-(rect->h (get 'curve 'screenrect))
					   20))))
		   )))))
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: PRINT-RESULT
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Mon Feb 24 21:29:53 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun print-result  (n vect)
   (setq $%curve '((mplus simp)))
   (do ((i 1 (1+ i)))
       ((lessp (1+  n) i)(princ 'done)(terpri))
       (setq $%curve (append $%curve 
          `(((mtimes simp) ,(scalefix(vrefi-double vect i)**xcurve-precision**)
	     ((mexpt simp) $x ,(1- i))))))
       )
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: SET-ORDER
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Mon Mar 03 22:16:05 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun set-order  ( )
   (setup-prompt-area)
   (paint-string 60. 60. "Old Order of Fit = ")
   (paint-string 250. 60. (strcat $fit))
   (paint-string 60. 75. "Enter New Value ")
   (setq st (read))
   (cond((null st)(paint-string 60. 90. "Order Defaults to "))
	       ((not(numberp st))
		(paint-string 60. 90. "Invalid Input - Default to"))
	       (t(setq $fit  st)
		       (paint-string 60. 90. "Order Set to ")))
   (paint-string 100 90 (strcat $fit))
   (restore-prompt-area))

