/***************************************************************************
*        Copyright (C) 1986 by Douglas A. Young,
*        Kent State University, Kent Ohio
*        Unrestricted permission is granted to copy, modify
*        or redistribute this file.
*        Douglas A. Young phone: (415) 857-6478
*                         net  : dayoung@hplabs.hp.com
*****************************************************************************/

#include <stdio.h>
/*   Least Squares Method
 * 
 *     
 */
leastsq(n,x,y,mf,c)
int n,mf;
double x[],y[],c[];
{
    double  a[60][60],
            xn[60],
            sum;
    int     mfp1,
            mfp2,
            i,
            j,
            im1,
            ipt,
            icoef,
            jcoef;

    mfp1 = mf + 1;
    mfp2 = mf + 2;
/* *****
 *  put ones into a new array this will hold the powers of the x values
 */
    for (i = 0; i <=n; i++)
	xn[i] = 1.0;
    for(i=0;i<60;i++)
        for(j=0;j< 60;j++)
           a[i][j] = 0.0;

/* 
 *   compute forst col and n+1st col of a I moves down the rows,
 *   j sums over the n values
 */
    for (i = 1; i <= mfp1; i++) {
	a[i][mfp2] = a[i][1] = 0.0;
	for (j = 1; j <= n; j++) {
	    a[i][1] += xn[j];
	    a[i][mfp2] += y[j] * xn[j];
	    xn[j] *= x[j];
	}
    }

/*
 * compute the last row of a I moves across the columns, j
 * sums over the n values
 */
    for (i = 2; i <= mfp1; i++) {
	a[mfp1][i] = 0.0;
	for (j = 1; j <= n; j++) {
	    a[mfp1][i] += xn[j];
	    xn[j] *= x[j];
	}
    }

/* 
 *  now fill in the rest of the a matrix i moves down the rows
 *  j moves across the columns
 */
    for (j = 2; j <= mfp1; j++)
	for (i = 1; i <= mf; i++)
	    a[i][j] = a[i + 1][j - 1];

/*
 * now call a subroutine to solve this set of normal equations
 */
    ludcmq (a, mfp1, 10);
    for (j = 1; j <= mfp1; j++)
	c[j] = a[j][mfp2];
    solnq (a, c, mfp1, 10); 

}
/* 
 *  function ludcmq forms the lu equivalent of the square
 * coefficient matrix a
 */
ludcmq(a,n,ndim)
double a[60][60];
int n,ndim;
{
    double  sum;
    int     i,
            j,
            jm1,
            im1,
            k;
    for (i = 1; i <= n; i++) {
	for (j = 2; j <= n; j++) {
	    sum = 0.0;
	    if (j <= i) {
		jm1 = j - 1;
		for (k = 1; k <= jm1; k++)
		    sum += a[i][k] * a[k][j];
		a[i][j] -= sum;
	    }
	    else {
		im1 = i - 1;
		if (im1 != 0) {
		    for (k = 1; k <= im1; k++)
			sum += a[i][k] * a[k][j];
		}
		if (abs (a[i][i]) < 1.0 / 1000000.0) {
		    printf ("reduction not complete because of small value\n");
		    return;
		}
		else {
		    a[i][j] = (a[i][j] - sum) / a[i][i];
		}
	    }
	}
    }
}
/* **************
 * subroutine solnq finds the solution to a set of n linear equations
 */
solnq(a,b,n,ndim)
double a[60][60],b[];
int n,ndim;
{
    double  sum;
    int     i,
            im1,
            k,
            j,
            nmjp1,
            nmjp2;
/*
 * do the reduction step
 */
    b[1] /= a[1][1];
    for (i = 2; i <= n; i++) {
	im1 = i - 1;
	sum = 0.0;
	for (k = 1; k <= im1; k++)
	    sum += a[i][k] * b[k];
	b[i] = (b[i] - sum) / a[i][i];
    }
/*
 * now we are ready for back substitution
 */
    for (j = 2; j <= n; j++) {
	nmjp2 = n - j + 2;
	nmjp1 = n - j + 1;
	sum = 0.0;
	for (k = nmjp2; k <= n; k++)
	    sum += a[nmjp1][k] * b[k];
	b[nmjp1] -= sum;
    }
}
       
   
	      
		
	     
    

    
    



