module decomp;

% Authors:  Andreas Brand and Thomas Wolf.

algebraic procedure decomp(problem,runmode);
begin scalar i,j,k,de,m,n,x,y,yy,yyy,new!_d!_yk,as,sol,h1,h2,dep$
  lisp put('d!_y,'simpfn, 'simpiden)$
  lisp put('u!#,'simpfn, 'simpiden)$
  de:=first problem$ problem:=rest problem$
  y :=first problem$ problem:=rest problem$
  x :=first problem$ problem:=0$
  as:=first runmode$ runmode:=rest runmode$
  fl:=first runmode$ runmode:=0$
  symbolic write "Differential factorization of:  "$
  lisp terpri()$
  write de$
           % order of the de
  n :=lisp highdiff(reval algebraic de, reval algebraic y,
                    reval algebraic x)$
  k:=1;    % factorization into a first-order ODE + ...
  clear d1!_,d2!_,d3!_;
  de:=rhs de - lhs de;
  for i:=2:n do <<de:=sub(df(y,x,i)=d!_y(i),de);
                  as:=sub(df(y,x,i)=d!_y(i),as)>>;
  de:=sub(df(y,x)=d!_y(1),de);
  as:=sub(df(y,x)=d!_y(1),as);
  yy:=lisp if atom (yyy:=reval algebraic y) then yyy 
                                            else car yyy;
  if (y neq yy) then << let y=yy; de:=de; as:=as; clear y; y:=yy >>;
  depend a!#,x;
  depend b!#,x;
  depend c!#,x;
  depend d!#,y;
  d!_y(k):=
  if as=1 then <<fl:={a!#,d!#};     a!#*d!#            >> else
  if as=2 then <<fl:={a!#,b!#};     a!#*y+b!#          >> else
  if as=3 then <<fl:={a!#,b!#};     a!#*y**d1!_+b!#*y  >> else
  if as=4 then <<fl:={a!#,b!#,c!#}; a!#*y**2+b!#*y+c!# >> else
  as$
  vl:={y,x};
  for i:=1:(k-1) do vl:=.(d!_y(i),vl);
  new!_d!_yk:=d!_y(k)$
  write "The ansatz: ", df(y,x)," = ",d!_y(k);
  if df(yy,x) neq 0 then <<dep:=1;nodepend yy,x>> else dep:=0;
  for m:=k+1:n do 
  d!_y(m):=df(d!_y(m-1),x)+df(d!_y(m-1),y)*d!_y(1)+
           for j:=1:k-1 sum df(d!_y(m-1),d!_y(j))*d!_y(j+1);
  de:=de;
  for m:=k:n do clear d!_y(m);

  sol:=crack({de},fl,vl);   % first, because {a} is linear
  if sol={} then <<
   write"There exists no such factorization.";
   return {} >>
            else <<
   sol:=first sol;
   h1:=second sol;
   for each h2 in h1 do
   if symbolic (not atom algebraic h2) then 
   if symbolic (equal(car algebraic h2,'equal)) then 
   new!_d!_yk:=sub(h2,new!_d!_yk)$
   if dep=1 then depend yy,x;
   new!_d!_yk:=sub(d!_y(1)=df(y,x),new!_d!_yk);
   for i:=2:n do new!_d!_yk:=sub(d!_y(i)=df(y,x,i),new!_d!_yk);
   h1:=first sol$
   if h1 neq {} then 
   <<write "Remaining conditions:";
     while h1 neq {} do <<write"0 = ",first h1;h1:=rest h1>> >>;
   !!arbconst:=0;
   h1:=df(y,x,k)-new!_d!_yk  ;
   h2:=first odesolve(h1,y,x);
   if h1=h2 then write "The solution of ",df(y,x,k)," = ",new!_d!_yk
            else 
   <<yyy:=mkid(lisp fname!_,lisp nfct!_);
     h2:=sub(arbconst(1)=yyy,h2);
     lisp(nfct!_:=add1 nfct!_);
     write "The solution ",h2>>;
   if length third sol<(n-k)                         then 
   write "is a special solution of the original ODE" else
   if length first sol = 0                             then
   write "is the general solution of the original ODE" else
   write "is a solution of the original ODE";
   h1:=first sol;
   return {h1,new!_d!_yk,third sol} >>
end$

symbolic procedure lesedec;
begin scalar c;
  <<rds nil;wrs nil;
    terpri();write "Input: "$
    c:=xread(nil);
    if ifl!* then rds cadr ifl!*;
    if ofl!* then wrs cdr ofl!* >>;
return c
end$

endmodule;

module dfint;  % Differentiate integrals.

% Author: Francis J. Wright <F.J.Wright@QMW.ac.uk>
% Date: 18 June 1992
% REDUCE version: 3.4; PSL
% Preliminary alpha test version!!!

% This patch causes  df(int(f(A, x, B), x), C, x, D),
% where A, B, C, D are arbitrary sequences of kernels,
% or any equivalent composition of derivatives and an integral,
% to evaluate to  df(f(A, x, B), C, D).

% It is not possible to do this in general by pattern matching.
% This patch makes redundant the following very restricted
% kludge defined in INT.RED
% put('df,'opmtch,'(((int !=y !=x) !=x) (nil . t)
%                   (evl!* !=y) nil) . get('df,'opmtch));
% which is equivalent to the algebraic command
% for all y,x let df(int(y,x), x) = y;
% This kludge should probably be removed when using this patch.

% Moreover, if the switch DFINT is turned on (it is off by default)
% then df int will always be commuted into int df,
% i.e. differentiation under the integral sign will be performed,
% so that  df(int(f(A, x, B), x), C, y, D),
% where A, B, C, D are arbitrary sequences of kernels,
% evaluates to  int(df(f(A, x, B), C, y, D), x).

% A more sophisticated version (later, perhaps!) might do this
% commutation only when the integrand reduces in complexity.

% If used together with either Herbert Melenk's or my patch that
% allows integrands to be implicitly dependent on the integration
% variable, then this code also works with such dependent integrands.


put('int, 'dfform, 'dfform_int)$

% dfform is a new hook, otherwise used only by taylor.
% This routine does not necessarily need to use this hook,
% but it needs to be called as an alternative to diffp so
% that the linearity of differentiation has already been applied.

% Supply a switch to control this facility:
switch dfint$  % off by default
put('dfint, 'simpfg, '((t (rmsubs))) )$
   % There is no code to reverse the df_int commutation,
   % so no reason to call rmsubs when the switch is turned off.

symbolic procedure dfform_int(u, v, n)$
   % u = '(int y x) [as main variable of SQ form]
   % v = kernel
   % n = integer power
   % Return SQ form of df(u**n, v) = n*u**(n-1)*df(u, v)
   % This routine is called by diffp via the hook
   % if x := get(car u,'dfform) then return apply3(x,u,v,n)
   begin scalar result, x, y$
      y := simp!* cadr u$  % SQ form integrand
      x := caddr u$  % kernel
      result :=
      if v = x then y  %%% CAN THIS BE EQ?
         % df(int(y,x), x) -> y
      else if !*dfint then
         % differentiate under the integral sign
         % df(int(y, x), v) -> int(df(y, v), x)
         !*k2q {'int, mk!*sq diffsq(y, v), x}
   % perhaps I should use prepsq - kernels are normally true prefix?
      else
         % remain unchanged
         !*k2q {'df, u, v}$
      if n neq 1 then
         result := multsq((((u .**(n-1)) .* n) .+ nil) ./ 1,result)$
      return result
   end$


% This procedure from POLY.RED needs a minor addition to
% simplify a general multiple derivatives of an integral.
% Note that in PSL-REDUCE POLY is compiled into the base system,
% so this procedure is always defined and can safely be re-defined.
% Under other Lisps this may not be true, so BEWARE!!!

symbolic procedure diffp(u,v)$
   % U is a standard power, V a kernel.
   % Value is the standard quotient derivative of U wrt V.
   begin scalar n,w,x,y,z$ integer m$
        n := cdr u$     % integer power.
        u := car u$     % main variable.
        if u eq v and (w := 1 ./ 1) then go to e
         else if atom u then go to f
         %else if (x := assoc(u,dsubl!*)) and (x := atsoc(v,cdr x))
%               and (w := cdr x) then go to e   % deriv known.
             % DSUBL!* not used for now.
         else if (not atom car u and (w:= difff(u,v)))
                  or (car u eq '!*sq and (w:= diffsq(cadr u,v)))
          then go to c  % extended kernel found.
         else if x := get(car u,'dfform) then return apply3(x,u,v,n)
         else if x:= get(car u,'dfn) then nil
         else if car u eq 'plus and (w := diffsq(simp u,v))
          then go to c
         else go to h$  % unknown derivative.
        y := x$
        z := cdr u$
    a:  w := diffsq(simp car z,v) . w$
        if caar w and null car y then go to h$  % unknown deriv.
        y := cdr y$
        z := cdr z$
        if z and y then go to a
         else if z or y then go to h$  % arguments do not match.
        y := reverse w$
        z := cdr u$
        w := nil ./ 1$
    b:  % computation of kernel derivative.
        if caar y
          then w := addsq(multsq(car y,simp subla(pair(caar x,z),
                                                   cdar x)),
                          w)$
        x := cdr x$
        y := cdr y$
        if y then go to b$
    c:  % save calculated deriv in case it is used again.
        % if x := atsoc(u,dsubl!*) then go to d
        %  else x := u . nil$
        % dsubl!* := x . dsubl!*$
  % d:   rplacd(x,xadd(v . w,cdr x,t))$
    e:  % allowance for power.
        % first check to see if kernel has weight.
        if (x := atsoc(u,wtl!*))
          then w := multpq('k!* .** (-cdr x),w)$
        m := n-1$
        % Evaluation is far more efficient if results are rationalized.
        return rationalizesq if n=1 then w
                else if flagp(dmode!*,'convert)
                     and null(n := int!-equiv!-chk
                                         apply1(get(dmode!*,'i2d),n))
                 then nil ./ 1
                else multsq(!*t2q((u .** m) .* n),w)$
    f:  % Check for possible unused substitution rule.
        if not depends(u,v)
           and (not (x:= atsoc(u,powlis!*))
                 or not depends(cadddr x,v))
          then return nil ./ 1$
        w := list('df,u,v)$
        go to j$
    h:  % Final check for possible kernel deriv.
        if car u eq 'df
          then
          % BEGIN addition by fjw
          % Commute derivatives to differentiate an integral.
          % I cannot see any alternative to modifying this procedure.
          % Here because it should be a fast test.
          if eqcar(cadr u, 'int) and caddr cadr u = v then  % EQ ?
             % Evaluating (df u v) where
             % u = (df (int F x) a b ...), return (df F a b ...)
             return !*k2q('df . cadr cadr u . cddr u)
          else
          % END addition by fjw
               if depends(cadr u,v)
                 then if assoc(w := list('df,cadr u,v),
                               get('df,'kvalue))
                          then <<w := mksq(w,1)$
                                 x := cddr u$
                                 while x do
                                   <<if cdr x and numberp cadr x
                                         then <<for i := 1:cadr x do
                                                w := diffsq(w,car x)$
                                                x := cdr x>>
                                       else w := diffsq(w,car x)$
                                      x := cdr x>>$
                                 go to e>>
                       else w := 'df . cadr u . derad(v,cddr u)
                else return nil ./ 1
         else if depends(u,v) then w := list('df,u,v)
         else return nil ./ 1$
    j:  w := if x := opmtch w then simp x else mksq(w,1)$
        go to e
   end$

endmodule$

module firint;

% Authors:  Andreas Brand and Thomas Wolf.

algebraic procedure firint(problem,runmode);
%de...das DGL-Problem, n...Ordnung der DGL, r...Grad des Ansatzes
begin scalar de,n,x,y,yy,yyy,fl,vl,f!_new,a,sol,h1,h2,co,
             newfl,fi,dg,dep$
  symbolic put('d!_y,'simpfn,'simpiden)$
  de:=first problem$ problem:=rest problem$
  y:=first problem$ problem:=rest problem$
  x:=first problem$ problem:=0$
  fi:=first runmode$ runmode:=rest runmode$
  fl:=first runmode$ runmode:=rest runmode$
  dg:=first runmode$ runmode:=0$
  vl:={}$
  lisp terpri()$
  write "Determination of a first integral for: ";
  write de;
  n :=lisp highdiff(reval algebraic de, reval algebraic y,
                    reval algebraic x)$
  de:=rhs de;
  for i:=2:n do <<de:=sub(df(y,x,i)=d!_y(i),de);
                  fi:=sub(df(y,x,i)=d!_y(i),fi)>>;
  de:=sub(df(y,x)=d!_y(1),de);
  fi:=sub(df(y,x)=d!_y(1),fi);
  yy:=lisp if atom (yyy:=caaar caadr algebraic y) then yyy 
                                                  else car yyy;
  if (y neq yy) then << let y=yy; de:=de; fi:=fi; clear y; y:=yy >>;
  if freeof(de,d!_y(n)) then
  <<d!_y(n):=de;
  if fi=0 then begin
    fi:=polyans(n-1,dg,x,y,d!_y,h!_);
    fl:=second fi;
    fi:=first fi
  end;
  symbolic if print_ then
  algebraic write "of the type: ",sub(d!_y(1)=df(y,x),fi) ;
  if df(yy,x) neq 0 then <<dep:=1;nodepend yy,x>> else dep:=0;
  a:=df(fi,x)+df(fi,y)*d!_y(1)+
    for k:=1:n-1 sum (df(fi,d!_y(k))*d!_y(k+1));
  vl:=.(d!_y(n-1),vl);
  clear d!_y(n);
  sol:=crack({a},fl,vl);   % first, because {a} is linear
  if sol={} then <<
   write"There exists no such first integral.";
   return {} >>
            else <<
   sol:=first sol;
   h1:=second sol;
   for each h2 in h1 do
   % if symbolic (not atom algebraic h2) then 
   % if symbolic (equal(car algebraic h2,'equal)) then 
   fi:=sub(h2,fi)$
   h1:=third sol;
   newfl:={};
   for each h2 in h1 do
   if (df(h2,y) eq 0) and (df(h2,x) eq 0) and (df(h2,d!_y 1) eq 0)
   then 
   <<on ratarg;
     co:=coeffn(fi,h2,1);
     if freeof(co,x) and freeof(co,y) and freeof(co,d!_y 1) and 
        deg(fi-co*h2,h2)=0 then fi:=sub(h2=0,fi)
                           else newfl:=.(h2,newfl)>>;
   h1:=newfl;
   newfl:={};
   for each h2 in h1 do
   if (df(h2,y) eq 0) and (df(h2,x) eq 0) and (df(h2,d!_y 1) eq 0)
   then 
   if df(fi/h2,h2)=0 then fi:=sub(h2=1,fi)
                     else newfl:=.(h2,newfl);
   if freeof(fi,x) and freeof(fi,y) and freeof(fi,d!_y 1) then fi:=0;
   printco(first(sol));
   if dep=1 then depend yy,x;
   if fi neq 0 then <<co:=df(fi,d!_y 1);
                      fi:=sub(d!_y(1)=df(y,x),fi);
                      co:=sub(d!_y(1)=df(y,x),co);
                      for i:=2:n do <<fi:=sub(d!_y(i)=df(y,x,i),fi);
                                      co:=sub(d!_y(i)=df(y,x,i),co)>>;
                      write"A first integral is:  ",fi;
                      write"and an integrating factor:  ",co;
                      if (third sol neq {}) then
                      <<lisp terpri();
                        if (first sol neq {}) then lisp 
                   write "functions and constants to be determined: "
                     else lisp write "free constants: ";
                        lisp fctprint(cdr reval algebraic newfl)>> >>
               else write"There exists no such first integral.";
   return {first sol,fi,newfl}>> >>
 else
    <<write "Implicit d.e. ! "$
    return {{},{},{}}>>
end$

algebraic procedure printco(sol);
if (sol neq {}) then 
<<write "Remaining conditions:";
  while sol neq {} do <<write"0 = ",first sol;sol:=rest sol>> >>$

endmodule;

module intpatch;  % Integrate dependent variables & rational powers.

% Author: Francis J. Wright <fjw@maths.qmw.ac.uk>
% Date: 19 June 1992
% REDUCE version: 3.4; PSL, Cambridge Lisp

% This version fixes a bug that integrals that remained symbolic
% were not returned as unique kernels - I now use !*kk2q.
% This bug caused rather obscure symptoms, such as failures with
% on factor.

% This patch has two separate functions:

% 1: It allow integrals containing IMPLICITLY dependent variables,
% created using the DEPEND command, to remain symbolic rather than
% cause an error, whilst preserving other error handling as normal.
% ON FAILHARD turns this facility off.
% This facility was developed from a patch by Herbert Melenk,
% which this patch is intended to replace.

% 2: It integrates simple rational powers of the integration
% variable that the integrator currently fails to integrate.

load_package int;

fluid '(!*failhard);

%% fluid'(soft!-rerror!-number);
% Hope not necessary - it seems not to be.

put('int, 'simpfn, 'SimpIntPatch)$

symbolic procedure SimpIntPatch u$
   % Driver for various patches:
   % 1: Catch errors from SimpInt, trap error number 7 only,
   % and pass on all other errors as normal hard REDUCE errors.
   % 2: Post-process unintegrated rational powers.
   begin scalar r, !*redefmsg, !*uncached$ !*uncached := t$
      % !*redefmsg rebound to avoid PSL messages
      % about redefinition of rerror.
      %% integer soft!-rerror!-number$    % defaults to 0, not nil
      put('int, 'simpfn, 'SimpInt)$       % assumed & reset by SimpInt
      copyd('rerror, 'intpatch!-rerror)$  % redefine rerror
      r := errorset!*({'SimpInt, mkquote u}, nil)$
      copyd('rerror, 'rerror!%)$          % restore rerror
      put('int, 'simpfn, 'SimpIntPatch)$  % reset INT interface
      if pairp r then <<
         % First call of SimpInt succeeded -
         % try to reprocess any integrals left:
         put('int, 'simpfn, 'SimpIntRatPow)$
         u := resimp car r$  % this works ONLY with !*uncached := t$
         put('int, 'simpfn, 'SimpIntPatch)$
         return u
      >>
      else if !*failhard or not(r eq 7) then
         rederr EMSG!*              % Error failure
      else return !*kk2q('int . u)  % Remain symbolic
   end$


% Integrator error trap patch to allow controlled error handling
% ==============================================================

% The error numbers generated by SIMPINT and the corresponding
% error message that would be output by INT are the following,
% collected from the INT source code:

%  1  =  "Improper number of arguments to INT"
%  2  =  "Improper number of arguments to INT"
%  3  =  "Too many arguments to INT"
%  4  =  "FAILHARD switch set"
%  5  =  "Invalid polynomial in int-quadterm"
%  6  =  "Empty list to mapply"
%  7  =  "Can't integrate in the presence of side-relations" (TRAPPED)
%  8  =  "Invalid exponent"
%  9  =  "FAILHARD switch set"

% If any other error number, such as 0, should occur then it
% corresponds to some other non-specific error.


symbolic procedure rerror!%(packagename,number,message)$
   % This is precisely the definition of rerror in RLISP.RED,
   % but redefining it here makes sure it is loaded,
   % and also avoids the need to save it.
   % Precisely this procedure is also defined in SOFTSOLV.
   rederr message$

symbolic procedure intpatch!-rerror(packagename,number,message)$
   %%   << soft!-rerror!-number := number$ error1() >>$
   % The following will suffice provided errorsets
   % are not nested in the integrator.
   % It makes error message text available in EMSG!*.
   error(number, message)$


% Integrator postprocessor patch to integrate simple rational
% powers that the integrator currently fails to integrate.
% =======================================================

symbolic procedure SimpIntRatPow u$  % u = (integ var)
   % Integrate integrands of the form var**(m/n),
   % which the integrator leaves in a rather bizarre form -
   % hence the precise form of the following code.
   % Returns original integral if it has the wrong form.
   begin scalar integ, var, power$
      integ := car u$  var := cadr u$
         % assumes true prefix forms, already evaluated by SimpInt.
%     power := errorset!*(
%        {'FindRatPow, mkquote integ, mkquote var}, nil)$
%     errorset!*(u,v) == errorset(u,v,!*backtrace)
%     Backtrace from this is unlikely to be interesting, so ...
      power := errorset(
         {'FindRatPow, mkquote integ, mkquote var}, nil, nil)$
      if errorp power then return !*kk2q('int . u)$
      power := car power$  % correct form of integrand found.
      % integrand = var**power, so return integral:
      power := reval {'plus, power, 1}$
      return simp!* {'quotient, {'expt, var, power}, power}
   end$

symbolic procedure FindRatPow(monom, var)$
   % Return power of a monomial in var, as a
   % rational number in UNSIMPLIFIED prefix form
   % or cause error return to enclosing errorset.
   if eqcar(monom, 'quotient) then
      {'plus, FindRatPow(cadr monom, var), 
         {'minus, FindRatPow(caddr monom, var)}}
   else if eqcar(monom, 'times) then
      'plus . for each el in cdr monom collect FindRatPow1(el, var)
   else FindRatPow1(monom, var)$

symbolic procedure FindRatPow1(monom, var)$
   if monom eq 1 then 0  % only possible constant by linearity
   else if monom = var then 1
   else if eqcar(monom, 'expt) and
      cadr monom = var then caddr monom
   else error1()$  % wrong form

endmodule$

module lagran;

% Authors:  Andreas Brand and Thomas Wolf.

algebraic procedure lagran(problem,runmode);
% sol = false : determination of the Lagrangian only
% sol = true  : also transformation to L = y^'2
% returns return of lagfcn 
begin scalar de,n,fl,vl,lg,x,y,yy,yyy,loes,k,a,b,ll,h1,h2,dep$
  scalar imp,y!',ham,sf$      % for the Hamiltonian part
  symbolic put('d!_y,'simpfn,'simpiden)$
  de:=first problem$ problem:=rest problem$
  y :=first problem$ problem:=rest problem$
  x :=first problem$ problem:=0$
  lg:=first runmode$ runmode:=rest runmode$
  fl:=first runmode$ runmode:=0$
  vl:={};
  symbolic write "Determination of a Lagrangian L for:";
  lisp terpri()$
  write de$
  n :=lisp highdiff(reval algebraic de, reval algebraic y,
                    reval algebraic x)$
  de:=rhs de;
  for i:=2:n do <<de:=sub(df(y,x,i)=d!_y(i),de);
                  lg:=sub(df(y,x,i)=d!_y(i),lg)>>;
  de:=sub(df(y,x)=d!_y(1),de);
  lg:=sub(df(y,x)=d!_y(1),lg);
  yy:=lisp if atom (yyy:=reval algebraic y) then yyy 
                                            else car yyy;
  if (y neq yy) then << let y=yy; de:=de; lg:=lg; clear y; y:=yy >>;
  if lg=0 then
  <<depend u!_,x,y;
    depend v!_,x,y;
    lg:=u!_*d!_y 1**2+v!_;
    fl:=append({u!_,v!_},fl)>>$
  if n>1 then vl:=.(d!_y(n-1),vl)$
  symbolic(if print!_ neq nil then
  algebraic write "The ansatz:  L = ",sub(d!_y(1)=df(y,x),lg) )$
  if df(yy,x) neq 0 then <<dep:=1;nodepend yy,x>> else dep:=0;
  loes:=lagfcn(de,n,x,y,fl,vl,lg);
  lg:=second loes;
  if (lg eq 0) then write"No Lagrangian of this structure!" else
  <<if dep=1 then depend yy,x;
    on factor,mcd;
    write "The solution:  L = ",sub(d!_y(1)=df(y,x),lg)$
    if dep=1 then nodepend yy,x;
    off factor; % ,mcd; 
    if (first loes neq {})                     then
    <<write "Remaining conditions: "$
      for each s in first loes do symbolic deprint 
       list algebraic s>>$
  >>;
  if dep=1 then depend yy,x;
  return loes 
end$

algebraic procedure lagfcn(p,n,x,y,fl,vl,lg);
%determines the Lagrangian
%returns {{necessary eq.s},{suff. equ.s},Lagrangian,{free functions}}
begin scalar h1,h2,newfl,co$
  h1:=df(lg,d!_y 1,x)+df(lg,d!_y 1,y)*d!_y 1-df(lg,y)+
      df(lg,d!_y 1,2)*p;
  p:= crack({h1},fl,vl)$   % first, because {h1} is linear
  if p={} then p:={{},{v_=0,u_=0},{}}
          else p:=first p;
  h1:=second p;
  for each h2 in h1 do
  if symbolic (not atom algebraic h2) then 
  if symbolic (equal(car algebraic h2,'equal)) then 
  lg:=sub(h2,lg)$
  h1:=third p;
  newfl:={};
  on ratarg;
  for each h2 in h1 do
  if (df(h2,y) eq 0) and (df(h2,x) neq 0) then 
  <<co:=coeffn(lg,h2,1);
    if freeof(co,y) and freeof(co,d!_y 1) then 
    if deg(lg-co*h2,h2)=0 then lg:=sub(h2=0,lg)
                          else newfl:=.(h2,newfl)
                                          else newfl:=.(h2,newfl)>>$
  for each h2 in h1 do
  if (df(h2,y)=0) and (df(h2,x)=0) then 
  if deg(lg/h2,h2)=0 then lg:=sub(h2=1,lg)
                     else newfl:=.(h2,newfl)$
  on gcd;
  lg:=lg;
  off gcd;on mcd;
  return {first p,lg,newfl}
end$

endmodule;

module lieord;

% Authors:  Andreas Brand and Thomas Wolf.

algebraic procedure lieord(problem,runmode);
begin scalar de,n,vl,a,dksi,eta,ksi,x,y,yy,yyy,dep,lp,fl,od,dg$
comment
 problem ~ {df(y,x,n)=...,                     % de  (below)
     dependent variable,                % y
     independent variable}              % x
 for lp=0 standard ansaetze are taken, i.e. lp is a polynomial in 
     d!_y(od) of dg-degree with free functions of x,y,.,d!_y(od-1)
     as coefficients, for point-symmetries od=dg=1
 for lp<>0 this value is taken. It is then expected, that all free
     functions of the ansatz are listed in fl 
 ksi, eta are obtained from  ksi:=df(lp,d!_y(1)) 
                             eta:=ksi*d!_y(1)-lp;

  symbolic put('e!_p,'simpfn,'simpiden)$
  symbolic put('d!_y,'simpfn,'simpiden)$
  de:=first problem$ problem:=rest problem$
  y :=first problem$ problem:=rest problem$
  x :=first problem$ problem:=0$
  lp:=first runmode$ runmode:=rest runmode$
  fl:=first runmode$ runmode:=rest runmode$
  od:=first runmode$ runmode:=rest runmode$
  dg:=first runmode$ runmode:=0$
  symbolic write "Determination of symmetries for: "$
  lisp terpri()$
  write de$
  n :=lisp highdiff(reval algebraic de, reval algebraic y,
                    reval algebraic x)$
  de:=rhs de;
  for i:=2:n do <<de:=sub(df(y,x,i)=d!_y(i),de);
                  lp:=sub(df(y,x,i)=d!_y(i),lp)>>;
  de:=sub(df(y,x)=d!_y(1),de);
  lp:=sub(df(y,x)=d!_y(1),lp);
  yy:=lisp(if atom (yyy:=reval algebraic y) then yyy 
                                            else car yyy);
  if (y neq yy) then <<let y=yy; de:=de; lp:=lp; clear y; y:=yy>>;
  if df(yy,x) neq 0 then <<dep:=1;nodepend yy,x>> else dep:=0;
  if freeof(de,d!_y(n)) then
  <<d!_y(n):=de;
  if lp=0 then begin
    a:=polyans(od,dg,x,y,d!_y,u);
    lp:=first(a);
    fl:=append(second(a),fl);
    a:={};
  end;
  vl:={y,x};
  for i:=1:(n-1) do vl:=.(d!_y(i),vl);
  ksi:=df(lp,d!_y(1));
  eta:=ksi*d!_y(1)-lp;
  symbolic(if print!_ neq nil then
  algebraic write "The ansatz:  ETA = ",eta,",    KSI = ",ksi)$
  dksi:=df(ksi,x)+d!_y(1)*df(ksi,y)+
        for i:=1:n-1 sum d!_y(i+1)*df(ksi,d!_y(i));
  e!_p(0):=eta;
  for i:=1:n do
      e!_p(i):=df(e!_p(i-1),x)+df(e!_p(i-1),y)*d!_y(1)-d!_y(i)*dksi
                +for j:=1:n-1 sum df(e!_p(i-1),d!_y(j))*d!_y(j+1);
  a:=ksi*df(d!_y(n),x)+eta*df(d!_y(n),y)-e!_p(n)+
        for i:=1:n-1 sum e!_p(i)*df(d!_y(n),d!_y(i));
  clear d!_y(n)$
  for i:=1:n do clear e!_p(i);
  a:=first crack({a},fl,vl)$        % first, because {a} is linear
  factor d!_y(1);
  ksi:=sub(second(a),ksi);
  eta:=sub(second(a),eta);
  if dep=1 then depend yy,x;
  if (ksi neq 0) or (eta neq 0) then
  <<
    ksi:=sub(d!_y(1)=df(y,x),ksi);
    eta:=sub(d!_y(1)=df(y,x),eta);
    for i:=2:n do <<ksi:=sub(d!_y(i)=df(y,x,i),ksi);
                    eta:=sub(d!_y(i)=df(y,x,i),eta)>>;
    write "The solution: ";
    write "ksi = ",ksi;
    write "eta = ",eta>>        else
  write "It has no symmetry of that type.";
  if (third a neq {}) then
  <<lisp terpri();
    if (first a neq {}) then lisp 
    write "functions and constants to be determined: "
                        else lisp write "free constants: ";
    lisp fctprint(cdr algebraic third a)>>;
  >>
  else 
  <<write "Implicit d.e. !"$
x  a:={{},{},{}}>>$
return a
end$

endmodule;

end;
