#ifndef xdouble__H
#define xdouble__H

#include "ZZ.h"

// XD_HBOUND = 2^{max(ZZ_DOUBLE_PRECISION,ZZ_BITS_PER_LONG)+4}

#if (ZZ_DOUBLE_PRECISION > ZZ_BITS_PER_LONG)

#define XD_HBOUND (ZZ_FDOUBLE_PRECISION*32.0)

#else

#define XD_HBOUND (double(1L << (ZZ_BITS_PER_LONG - 2))*64.0)

#endif

#define XD_HBOUND_INV (double(1)/XD_HBOUND)

#define XD_BOUND (XD_HBOUND*XD_HBOUND)
#define XD_BOUND_INV (double(1)/XD_BOUND)


class xdouble {

public:

double x;
long e;

xdouble() : x(0), e(0) { }
xdouble(int a) : x(a), e(0)  { }
xdouble(long a) : x(a), e(0) { }
xdouble(double a);
xdouble(float a);

~xdouble() { }

void normalize();

static long oprec;
static void SetOutputPrecision(long p);
static long OutputPrecision() { return oprec; }

double mantissa() const { return x; }
long exponent() const { return e; }

};

xdouble operator+(xdouble a, xdouble b);
xdouble operator-(xdouble a, xdouble b);
xdouble operator-(xdouble a);
xdouble operator*(xdouble a, xdouble b);
xdouble operator/(xdouble a, xdouble b);



inline void operator+=(xdouble& a, xdouble b) { a = a + b; }
inline void operator-=(xdouble& a, xdouble b) { a = a - b; }
inline void operator*=(xdouble& a, xdouble b) { a = a * b; }
inline void operator/=(xdouble& a, xdouble b) { a = a / b; }
inline void operator++(xdouble& a) { a = a + 1; }
inline void operator++(xdouble& a, int) { a = a + 1; }
inline void operator--(xdouble& a) { a = a - 1; }
inline void operator--(xdouble& a, int) { a = a - 1; }

long compare(xdouble a, xdouble b);

inline long operator==(xdouble a, xdouble b) { return compare(a, b) == 0; }
inline long operator!=(xdouble a, xdouble b) { return compare(a, b) != 0; }
inline long operator<=(xdouble a, xdouble b) { return compare(a, b) <= 0; }
inline long operator>=(xdouble a, xdouble b) { return compare(a, b) >= 0; }
inline long operator <(xdouble a, xdouble b) { return compare(a, b)  < 0; }
inline long operator >(xdouble a, xdouble b) { return compare(a, b)  > 0; }



void zxdoubtoz(xdouble a, verylong *xx);

inline void operator<<(ZZ& x, xdouble a)
// x = floor(a);

   { zxdoubtoz(a, &x.rep); }

xdouble XDouble(const ZZ& a);

inline void operator<<(xdouble& z, const ZZ& a)

   { z = XDouble(a); }

void operator<<(double& x, xdouble a);

inline double Double(xdouble a)

   { double res; res << a; return res; }

inline void operator<<(long& x, xdouble a)
{
   double z;
   z << a;
   x = long(z);
}

inline long Long(xdouble a)
{
   return long(Double(a));
}

ostream& operator<<(ostream& s, xdouble a);

istream& operator>>(istream& s, xdouble& x);

xdouble trunc(xdouble a);
xdouble floor(xdouble a);
xdouble ceil(xdouble a);
xdouble fabs(xdouble a);
xdouble sqrt(xdouble a);

void power(xdouble& z, xdouble a, const ZZ& e);
void power(xdouble& z, xdouble a, long e);

#endif
