

/***********************************************************************

   This software is for research and educational purposes only.

************************************************************************/



#ifndef vector__H
#define vector__H

#include "tools.h"

struct _VectorHeader {
   long length;
   long alloc;
   long init;
   long fixed;
};

union _Aligned_VectorHeader {
   _VectorHeader h;
   double x1;
   long x2;
   char *x3;
};

#define _VEC_HEAD(p) (& (((_Aligned_VectorHeader *) p)[-1].h))


#define vector(T) NAME2(VECTOR___,T)

inline void *operator new(size_t, void *p) { return p; }

#ifndef RANGE_CHECK
#define RANGE_CHECK_CODE 
#else
#define RANGE_CHECK_CODE if (i < 0 || !rep || i >= _VEC_HEAD(rep)->length) RangeError(i);
#endif

// vectors are allocated in chunks of this size

#ifndef VectorMinAlloc
#define VectorMinAlloc (10)
#endif

// vectors are always expanded by at least this ratio

#ifndef VectorExpansionRatio
#define VectorExpansionRatio (1.2)
#endif

// controls initialization during input

#ifndef VectorInputBlock
#define VectorInputBlock 50
#endif


#define vector_default(T)   \
void BlockConstruct(__AKA__(T)* p, long n)  \
{  \
   long i;  \
  \
   for (i = 0; i < n; i++)  \
      (void) new(&p[i]) __AKA__(T);  \
}  \
  \
void BlockDestroy(__AKA__(T)* p, long n)  \
{  \
   long i;  \
  \
   for (i = 0; i < n; i++)  \
      p[i].~__AKA__(T)();  \
}



#define vector_decl(T)  \
typedef T __AKA__(T);  \
class vector(T) {  \
private:  \
   __AKA__(T) *rep;  \
  \
   void RangeError(long i) const;  \
  \
public:  \
   vector(T)() { rep = 0; }  \
   vector(T)(INIT_SIZE_TYPE, long n) { rep = 0; SetLength(n); }  \
   vector(T)(const vector(T)& a) { rep = 0; *this = a; }     \
   void operator=(const vector(T)& a);  \
   ~vector(T)();  \
   void kill(); \
  \
   void SetLength(long n);  \
   void SetMaxLength(long n); \
   void FixLength(long n); \
  \
   long length() const { return (!rep) ?  0 : _VEC_HEAD(rep)->length; }  \
   long MaxLength() const { return (!rep) ?  0 : _VEC_HEAD(rep)->init; } \
   long fixed() const { return rep && _VEC_HEAD(rep)->fixed; } \
  \
   __AKA__(T)& operator[](long i)   \
   {  \
      RANGE_CHECK_CODE  \
      return rep[i];  \
   }  \
  \
   const __AKA__(T)& operator[](long i) const \
   {  \
      RANGE_CHECK_CODE  \
      return rep[i];  \
   }  \
  \
   __AKA__(T)& operator()(long i) { return (*this)[i-1]; }  \
   const __AKA__(T)& operator()(long i) const { return (*this)[i-1]; } \
   \
   friend void swap(vector(T)& x, vector(T)& y);  \
  \
   const __AKA__(T)* elts() const { return rep; }  \
   __AKA__(T)* elts() { return rep; }  \
         \
   friend void append(vector(T)& v, const __AKA__(T)& a); \
   friend void append(vector(T)& v, const vector(T)& w); \
}; 




#define vector_io_decl(T)  \
istream& operator>>(istream&, vector(T)&);  \
  \
ostream& operator<<(ostream&, const vector(T)&);  \


#define vector_eq_decl(T)  \
long operator==(const vector(T)& a, const vector(T)& b);  \
long operator!=(const vector(T)& a, const vector(T)& b);


#define vector_impl(T)  vector_default(T)  vector_impl_plain(T)  

#define vector_impl_plain(T)  \
 \
void vector(T)::SetLength(long n)   \
{   \
   long m;  \
  \
   if (n < 0) {  \
      Error("negative length in vector::SetLength");  \
   }  \
      \
   if (n == 0) {  \
      if (rep) _VEC_HEAD(rep)->length = 0;  \
      return;  \
   }  \
   if (rep && _VEC_HEAD(rep)->fixed) \
      if (_VEC_HEAD(rep)->length == n) \
         return; \
      else \
         Error("SetLength: can't change this vector's length"); \
  \
   if (!rep) {  \
      m = ((n+VectorMinAlloc-1)/VectorMinAlloc) * VectorMinAlloc; \
      char *p = (char *) malloc(sizeof(_Aligned_VectorHeader)+sizeof(__AKA__(T))*m); \
      if (!p) {  \
	 Error("out of memory in vector::SetLength()");  \
      }  \
      rep = (__AKA__(T) *) (p + sizeof(_Aligned_VectorHeader)); \
  \
      BlockConstruct(rep, n); \
  \
      _VEC_HEAD(rep)->length = n;  \
      _VEC_HEAD(rep)->init = n;  \
      _VEC_HEAD(rep)->alloc = m;  \
      _VEC_HEAD(rep)->fixed = 0;  \
   }  \
   else if (n <= _VEC_HEAD(rep)->init) {  \
      _VEC_HEAD(rep)->length = n;  \
   }  \
   else  {  \
      if (n > _VEC_HEAD(rep)->alloc) {  \
	 if (n < VectorExpansionRatio*_VEC_HEAD(rep)->alloc)  \
	    m = (long) (VectorExpansionRatio*_VEC_HEAD(rep)->alloc);  \
         else  \
	    m = n;  \
         m = ((m+VectorMinAlloc-1)/VectorMinAlloc) * VectorMinAlloc; \
         char *p = ((char *) rep) - sizeof(_Aligned_VectorHeader); \
         p = (char *) realloc(p, sizeof(_Aligned_VectorHeader)+sizeof(__AKA__(T))*m); \
         if (!p) {  \
	    Error("out of memory in vector::SetLength()");  \
         }  \
         rep = (__AKA__(T) *) (p + sizeof(_Aligned_VectorHeader)); \
	 _VEC_HEAD(rep)->alloc = m;  \
      }  \
      BlockConstruct(rep + _VEC_HEAD(rep)->init, n - _VEC_HEAD(rep)->init); \
      _VEC_HEAD(rep)->length = n;  \
      _VEC_HEAD(rep)->init = n;  \
   }  \
}  \
 \
 \
void vector(T)::SetMaxLength(long n) \
{ \
   long OldLength = length(); \
   SetLength(n); \
   SetLength(OldLength); \
} \
 \
void vector(T)::FixLength(long n) \
{ \
   if (rep) Error("FixLength: can't fix this vector"); \
   if (n < 0) Error("FixLength: negative length"); \
   if (n > 0) \
      SetLength(n); \
   else { \
      char *p = (char *) malloc(sizeof(_Aligned_VectorHeader)); \
      if (!p) {  \
	 Error("out of memory in vector::FixLength()");  \
      }  \
      rep = (__AKA__(T) *) (p + sizeof(_Aligned_VectorHeader)); \
  \
      _VEC_HEAD(rep)->length = 0;  \
      _VEC_HEAD(rep)->init = 0;  \
      _VEC_HEAD(rep)->alloc = 0;  \
   } \
   _VEC_HEAD(rep)->fixed = 1; \
} \
  \
void vector(T)::operator=(const vector(T)& a)  \
{  \
   long i, n;  \
   __AKA__(T) *p;  \
   const __AKA__(T) *ap;  \
  \
   if (this == &a) return;  \
  \
   n = a.length();  \
   ap = a.elts();  \
  \
   SetLength(n);  \
   p = elts();  \
  \
  \
   for (i = 0; i < n; i++)  \
      p[i] = ap[i];  \
}  \
       \
  \
vector(T)::~vector(T)()  \
{  \
   if (!rep) return;  \
   BlockDestroy(rep, _VEC_HEAD(rep)->init); \
   free(((char *) rep) - sizeof(_Aligned_VectorHeader));  \
}  \
   \
void vector(T)::kill()  \
{  \
   if (!rep) return;  \
   if (_VEC_HEAD(rep)->fixed) Error("can't kill this vector"); \
   BlockDestroy(rep, _VEC_HEAD(rep)->init); \
   free(((char *) rep) - sizeof(_Aligned_VectorHeader));  \
   rep = 0; \
}  \
  \
void vector(T)::RangeError(long i) const  \
{  \
   cerr << "index out of range in vector: ";  \
   cerr << i;  \
   if (!rep)  \
      cerr << "(0)\n";  \
   else  \
      cerr << "(" << _VEC_HEAD(rep)->length << ")\n";  \
   abort();  \
}  \
 \
void swap(vector(T)& x, vector(T)& y)  \
{  \
   __AKA__(T)* t;  \
   long xf = x.fixed();  \
   long yf = y.fixed();  \
   if (xf != yf ||   \
       (xf && _VEC_HEAD(x.rep)->length != _VEC_HEAD(y.rep)->length))  \
      Error("swap: can't swap these vectors");  \
   t = x.rep;  \
   x.rep = y.rep;  \
   y.rep = t;  \
} \
 \
void append(vector(T)& v, const __AKA__(T)& aa)  \
{  \
   long l = v.length(); \
   if (!v.rep || _VEC_HEAD(v.rep)->alloc > l) { \
      v.SetLength(l+1); \
      v[l] = aa; \
   } \
   else { \
      __AKA__(T) a = aa; \
      v.SetLength(l+1);  \
      v[l] = a;  \
   } \
}  \
  \
void append(vector(T)& v, const vector(T)& w)  \
{  \
   long l = v.length();  \
   long m = w.length();  \
   long i;  \
   v.SetLength(l+m);  \
   for (i = 0; i < m; i++)  \
      v[l+i] = w[i];  \
}





#define vector_io_impl(T)  \
istream & operator>>(istream& s, vector(T)& a)   \
{   \
   vector(T) ibuf;  \
   long c;   \
   long n;   \
   if (!s) Error("bad vector input"); \
   \
   c = s.peek();  \
   while (c == ' ' || c == '\n' || c == '\t') {  \
      s.get();  \
      c = s.peek();  \
   }  \
   if (c != '[') {  \
      Error("bad vector input");  \
   }  \
   \
   n = 0;   \
   ibuf.SetLength(0);  \
      \
   s.get();  \
   c = s.peek();  \
   while (c == ' ' || c == '\n' || c == '\t') {  \
      s.get();  \
      c = s.peek();  \
   }  \
   while (c != ']' && c != EOF) {   \
      if (n % VectorInputBlock == 0) ibuf.SetMaxLength(n + VectorInputBlock); \
      n++;   \
      ibuf.SetLength(n);   \
      if (!(s >> ibuf[n-1])) Error("bad vector input");   \
      c = s.peek();  \
      while (c == ' ' || c == '\n' || c == '\t') {  \
         s.get();  \
         c = s.peek();  \
      }  \
   }   \
   if (c == EOF) Error("bad vector input");  \
   s.get(); \
   \
   a = ibuf; \
   return s;   \
}    \
   \
   \
ostream& operator<<(ostream& s, const vector(T)& a)   \
{   \
   long i, n;   \
  \
   n = a.length();  \
   \
   s << '[';   \
   \
   for (i = 0; i < n; i++) {   \
      s << a[i];   \
      if (i < n-1) s << " ";   \
   }   \
   \
   s << ']';   \
      \
   return s;   \
}   \

#define vector_eq_impl(T) \
long operator==(const vector(T)& a, const vector(T)& b) \
{  \
   long n = a.length();  \
   if (b.length() != n) return 0;  \
   const __AKA__(T)* ap = a.elts(); \
   const __AKA__(T)* bp = b.elts(); \
   long i;  \
   for (i = 0; i < n; i++) if (ap[i] != bp[i]) return 0;  \
   return 1;  \
} \
long operator!=(const vector(T)& a, const vector(T)& b) \
{  return !(a == b); }

   


#endif

