

/***********************************************************************

   This software is for research and educational purposes only.

************************************************************************/



#include "vec_ZZ_p.h"
#include <malloc.h>
#include "tools.h"

const long ZZ_pVecMaxAlloc = 10000;


void BlockConstruct(ZZ_p* x, long n)
{
   if (n <= 0) return; 

   long d = ZZ_p::ModulusSize();

   long size = d  + 3;
   long AllocAmt = (MaxAllocBlock-1) / size;
   if (AllocAmt == 0) AllocAmt = 1;

   long i = 0;
   long m;
   long *p, *q;
   long j;

   while (i < n) {
      m = min((n-i), AllocAmt);
      p = (long *) malloc((m*size + 1)*(sizeof (long)));
      if (!p) Error("out of memory in BlockConstruct(ZZ_p*,long)");
      *p = m;
      for (j = 0, q = p+2; j < m; j++, i++, q += size) {
         q[-1] = ((d+1) << 1 ) | 1;
         q[0] = 1;
         q[1] = 0;
         x[i].rep.rep = q;
      }
   }
}

void BlockDestroy(ZZ_p* x, long n)
{
   if (n <= 0) return;

   long i = 0;
   long *p;
   long m;

   while (i < n) {
      p = x[i].rep.rep-2;
      m =  *p;
      free(p);
      i += m;
   }
}


vector_impl_plain(ZZ_p)

vector_io_impl(ZZ_p)

vector_eq_impl(ZZ_p)

void operator<<(vector(ZZ)& x, const vector(ZZ_p)& a)
{
   long i, n;

   n = a.length();
   x.SetLength(n);

   ZZ* xp = x.elts();
   const ZZ_p* ap = a.elts();

   for (i = 0; i < n; i++)
      xp[i] = rep(ap[i]);
}



void operator<<(vector(ZZ_p)& x, const vector(ZZ)& a)
{
   long i, n;

   n = a.length();
   x.SetLength(n);

   ZZ_p* xp = x.elts();
   const ZZ* ap = a.elts();

   for (i = 0; i < n; i++)
      xp[i] << ap[i];
}


void InnerProduct(ZZ_p& x, const vector(ZZ_p)& a, const vector(ZZ_p)& b)
{
   long n = min(a.length(), b.length());
   long i;
   static ZZ accum, t;

   clear(accum);
   for (i = 0; i < n; i++) {
      mul(t, rep(a[i]), rep(b[i]));
      add(accum, accum, t);
   }

   x << accum;
}

void InnerProduct(ZZ_p& x, const vector(ZZ_p)& a, const vector(ZZ_p)& b,
                  long offset)
{
   long n = min(a.length(), b.length()+offset);
   long i;
   static ZZ accum, t;

   clear(accum);
   for (i = offset; i < n; i++) {
      mul(t, rep(a[i]), rep(b[i-offset]));
      add(accum, accum, t);
   }

   x << accum;
}

void mul(vector(ZZ_p)& x, const vector(ZZ_p)& a, const ZZ_p& b_in)
{
   ZZ_p b = b_in;
   long n = a.length();
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      mul(x[i], a[i], b);
}


void add(vector(ZZ_p)& x, const vector(ZZ_p)& a, const vector(ZZ_p)& b)
{
   long n = a.length();
   if (b.length() != n) Error("vector add: dimension mismatch");

   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      add(x[i], a[i], b[i]);
}

void sub(vector(ZZ_p)& x, const vector(ZZ_p)& a, const vector(ZZ_p)& b)
{
   long n = a.length();
   if (b.length() != n) Error("vector sub: dimension mismatch");
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      sub(x[i], a[i], b[i]);
}

void clear(vector(ZZ_p)& x)
{
   long n = x.length();
   long i;
   for (i = 0; i < n; i++)
      clear(x[i]);
}

void negate(vector(ZZ_p)& x, const vector(ZZ_p)& a)
{
   long n = a.length();
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      negate(x[i], a[i]);
}

