
#ifndef pair__H
#define pair__H

#include "tools.h"

#define pair(S,T) NAME2(PAIR___,NAME2(S,NAME2(__X__,T)))

#define pair_decl(S,T)  \
typedef S __AKA__(S);  \
typedef T __AKA__(T);  \
class pair(S,T) {  \
public:  \
   __AKA__(S) a;  \
   __AKA__(T) b;  \
  \
   pair(S,T)() { }  \
   pair(S,T)(const __AKA__(S)& x, const __AKA__(T)& y) : a(x), b(y) { }  \
   ~pair(S,T)() { }  \
};  \
  \
inline pair(S,T) cons(const __AKA__(S)& x, const __AKA__(T)& y) { return pair(S,T)(x, y); } \




#define pair_io_decl(S,T) \
istream& operator>>(istream&, pair(S,T)&);  \
  \
ostream& operator<<(ostream&, const pair(S,T)&);  \



#define pair_eq_decl(S,T)  \
inline long operator==(const pair(S,T)& x, const pair(S,T)& y)  \
   { return x.a == y.a && x.b == y.b; }  \
inline long operator!=(const pair(S,T)& x, const pair(S,T)& y) \
   { return !(x == y); }  \



// For compatability...
#define pair_impl(S,T)


#define pair_io_impl(S,T)  \
istream& operator>>(istream& s, pair(S,T)& x)  \
{  \
   long c;  \
  \
   if (!s) Error("bad pair input");  \
  \
   c = s.peek();  \
   while (c == ' ' || c == '\n' || c == '\t') {  \
      s.get();  \
      c = s.peek();  \
   }  \
  \
   if (c != '[')  \
      Error("bad pair input");  \
  \
   s.get();  \
  \
   if (!(s >> x.a))   \
      Error("bad pair input");  \
   if (!(s >> x.b))  \
      Error("bad pair input");  \
  \
   c = s.peek();  \
   while (c == ' ' || c == '\n' || c == '\t') {  \
      s.get();  \
      c = s.peek();  \
   }  \
  \
   if (c != ']')  \
      Error("bad pair input");  \
  \
   s.get();  \
  \
   return s;  \
}  \
  \
ostream& operator<<(ostream& s, const pair(S,T)& x)  \
{  \
   return s << "[" << x.a << " " << x.b << "]";  \
}  \



// For compatability...
#define pair_eq_impl(S,T)




#endif
