#ifndef matrix__H
#define matrix__H

#include "vector.h"

// matrix templates

#define matrix(T) NAME2(MATRIX___,T)

#define matrix_decl(T)  \
class matrix(T) {  \
private:  \
  \
   vector(vector(T)) rep;  \
   long numcols;  \
  \
public:  \
  \
   matrix(T)() { numcols = 0; }  \
   matrix(T)(const matrix(T)& a);  \
   void operator=(const matrix(T)& a);  \
   ~matrix(T)() { }  \
  \
   matrix(T)(INIT_SIZE_TYPE, long n, long m);  \
  \
   void kill();  \
  \
   void SetDims(long n, long m);  \
  \
   long NumRows() const { return rep.length(); }  \
   long NumCols() const { return numcols; }  \
  \
   vector(T)& operator[](long i) { return rep[i]; }  \
   const vector(T)& operator[](long i) const { return rep[i]; }  \
  \
   vector(T)& operator()(long i) { return rep[i-1]; }  \
   const vector(T)& operator()(long i) const { return rep[i-1]; }  \
  \
   __AKA__(T)& operator()(long i, long j) { return rep[i-1][j-1]; }  \
   const __AKA__(T)& operator()(long i, long j) const   \
      { return rep[i-1][j-1]; }  \
  \
   friend const vector(vector(T))& rep(const matrix(T)& a)  \
      { return a.rep; }  \
  \
   friend void swap(matrix(T)& X, matrix(T)& Y); \
  \
};  \
  \
void operator<<(matrix(T)& x, const vector(vector(T))& a);  \



#define matrix_eq_decl(T) \
long operator==(const matrix(T)& a, const matrix(T)& b); \
long operator!=(const matrix(T)& a, const matrix(T)& b); \



#define matrix_io_decl(T) \
istream& operator>>(istream&, matrix(T)&); \
ostream& operator<<(ostream&, const matrix(T)&);  \


#define matrix_impl(T)  \
matrix(T)::matrix(T)(const matrix(T)& a)  \
{  \
   numcols = 0;  \
   SetDims(a.NumRows(), a.NumCols());  \
   rep = a.rep;  \
}  \
  \
void matrix(T)::operator=(const matrix(T)& a)  \
{  \
   SetDims(a.NumRows(), a.NumCols());  \
   rep = a.rep;  \
}  \
  \
  \
matrix(T)::matrix(T)(INIT_SIZE_TYPE, long n, long m)  \
{  \
   numcols = 0;  \
   SetDims(n, m);  \
}  \
  \
void matrix(T)::kill()  \
{  \
   numcols = 0;  \
   rep.kill();  \
}  \
  \
void matrix(T)::SetDims(long n, long m)  \
{  \
   if (n < 0 || m < 0)  \
      Error("SetDims: bad args");  \
  \
   if (m != numcols) {  \
      rep.kill();  \
      numcols = m;  \
   }  \
        \
   long oldmax = rep.MaxLength();  \
   long i;  \
   rep.SetLength(n);  \
  \
   for (i = oldmax; i < n; i++)  \
      rep[i].FixLength(m);  \
}  \
     \
        \
void operator<<(matrix(T)& x, const vector(vector(T))& a)  \
{  \
   long n = a.length();  \
  \
   if (n == 0) {  \
      x.SetDims(0, 0);  \
      return;  \
   }  \
  \
   long m = a[0].length();  \
   long i;  \
  \
   for (i = 1; i < n; i++)  \
      if (a[i].length() != m)  \
         Error("nonrectangular matrix");  \
  \
   x.SetDims(n, m);  \
   for (i = 0; i < n; i++)  \
      x[i] = a[i];  \
}  \
  \
void swap(matrix(T)& X, matrix(T)& Y)  \
{  \
   swap(X.numcols, Y.numcols);  \
   swap(X.rep, Y.rep);  \
}  \


   

#define matrix_eq_impl(T)  \
long operator==(const matrix(T)& a, const matrix(T)& b)  \
{  \
   if (a.NumCols() != b.NumCols())  \
      return 0;  \
  \
   if (a.NumRows() != b.NumRows())  \
      return 0;  \
  \
   long n = a.NumRows();  \
   long i;  \
  \
   for (i = 0; i < n; i++)  \
      if (a[i] != b[i])  \
         return 0;  \
  \
   return 1;  \
}  \
  \
  \
long operator!=(const matrix(T)& a, const matrix(T)& b)  \
{  \
   return !(a == b);  \
}  \




#define matrix_io_impl(T)  \
istream& operator>>(istream& s, matrix(T)& x)  \
{  \
   vector(vector(T)) buf;  \
   s >> buf;  \
   x << buf;  \
   return s;  \
}  \
  \
ostream& operator<<(ostream& s, const matrix(T)& a)  \
{  \
   long n = a.NumRows();  \
   long i;  \
   s << "[";  \
   for (i = 0; i < n; i++)  \
      s << a[i] << "\n";  \
   s << "]";  \
   return s;  \
}  \




#endif
