
#ifndef mat_ZZ_p__H
#define mat_ZZ_p__H

#include "matrix.h"
#include "vec_vec_ZZ_p.h"

matrix_decl(ZZ_p)
matrix_io_decl(ZZ_p)
matrix_eq_decl(ZZ_p)

void add(matrix(ZZ_p)& X, const matrix(ZZ_p)& A, const matrix(ZZ_p)& B); 
void sub(matrix(ZZ_p)& X, const matrix(ZZ_p)& A, const matrix(ZZ_p)& B); 
void mul(matrix(ZZ_p)& X, const matrix(ZZ_p)& A, const matrix(ZZ_p)& B); 
void mul(vector(ZZ_p)& x, const matrix(ZZ_p)& A, const vector(ZZ_p)& b); 
void mul(vector(ZZ_p)& x, const vector(ZZ_p)& a, const matrix(ZZ_p)& B); 
void mul(matrix(ZZ_p)& X, const matrix(ZZ_p)& A, const ZZ_p& b);
void ident(matrix(ZZ_p)& X, long n); 
void determinant(ZZ_p& d, const matrix(ZZ_p)& A);
long IsIdent(const matrix(ZZ_p)& A, long n);
void transpose(matrix(ZZ_p)& X, const matrix(ZZ_p)& A);
void solve(ZZ_p& d, vector(ZZ_p)& X,
           const matrix(ZZ_p)& A, const vector(ZZ_p)& b);
void inv(ZZ_p& d, matrix(ZZ_p)& X, const matrix(ZZ_p)& A);

void diag(matrix(ZZ_p)& X, long n, const ZZ_p& d);
long IsDiag(const matrix(ZZ_p)& A, long n, const ZZ_p& d);


long gauss(matrix(ZZ_p)& M);
long gauss(matrix(ZZ_p)& M, long w);
void image(matrix(ZZ_p)& X, const matrix(ZZ_p)& A);
void kernel(matrix(ZZ_p)& X, const matrix(ZZ_p)& A);





#endif
