
#ifndef mat_RR__H
#define mat_RR__H

#include "matrix.h"
#include "vec_vec_RR.h"

matrix_decl(RR)
matrix_io_decl(RR)
matrix_eq_decl(RR)

void add(matrix(RR)& X, const matrix(RR)& A, const matrix(RR)& B); 
void sub(matrix(RR)& X, const matrix(RR)& A, const matrix(RR)& B); 
void mul(matrix(RR)& X, const matrix(RR)& A, const matrix(RR)& B); 
void mul(vector(RR)& x, const matrix(RR)& A, const vector(RR)& b); 
void mul(vector(RR)& x, const vector(RR)& a, const matrix(RR)& B); 
void mul(matrix(RR)& X, const matrix(RR)& A, const RR& b);
void ident(matrix(RR)& X, long n); 
void determinant(RR& d, const matrix(RR)& A);
long IsIdent(const matrix(RR)& A, long n);
void transpose(matrix(RR)& X, const matrix(RR)& A);
void solve(RR& d, vector(RR)& X,
           const matrix(RR)& A, const vector(RR)& b);
void inv(RR& d, matrix(RR)& X, const matrix(RR)& A);

void diag(matrix(RR)& X, long n, const RR& d);
long IsDiag(const matrix(RR)& A, long n, const RR& d);


#endif
