
#include "ZZ_pX.h"


main()
{
   long n, k;

   n = 200;
   k = 200;

   ZZ p;

   // p is computed as a random k-bit number.
   // It is not prime, but who cares.

   cerr << "compilation flags: ";

#ifdef AVOID_FLOAT
   cerr << "AVOID_FLOAT ";
#endif

#ifdef AVOID_BRANCHING
   cerr << "AVOID_BRANCHING ";
#endif

#ifdef FFT_PIPELINE
   cerr << "FFT_PIPELINE ";
#endif

#ifdef SINGLE_MUL
   cerr << "SINGLE_MUL ";
#endif

#ifdef FAST_INT_MUL
   cerr << "FAST_INT_MUL ";
#endif

#ifdef TBL_REM
   cerr << "TBL_REM ";
#endif

   cerr << "\n";

   RandomPrime(p, k);


   ZZ_pInit(p);         // initialization

   ZZ_pX f, g, h, r1, r2, r3;

   random(g, n);    // g = random polynomial of degree < n
   random(h, n);    // h =             "   "
   random(f, n);    // f =             "   "

   // SetCoeff(f, n);  // Sets coefficient of X^n to 1
   
   ZZ_p lc;

   do {
      random(lc);
   } while (IsZero(lc));

   SetCoeff(f, n, lc);


   // For doing arithmetic mod f quickly, one must pre-compute
   // some information.

   ZZ_pXModulus F;
   build(F, f);

   PlainMul(r1, g, h);  // this uses classical arithmetic
   PlainRem(r1, r1, f);

   MulMod(r2, g, h, F);  // this uses the FFT

   MulMod(r3, g, h, f);  // uses FFT, but slower

   // compare the results...

   if (r1 != r2) {
      cerr << "r1 != r2!!\n";
      return 1;
   }
   else if (r1 != r3) {
      cerr << "r1 != r3!!\n";
      return 1;
   }

   cerr << "test is OK\n";

   ZZ x1, x2, x3, x4;
   double t;
   long i;

   RandomLen(x1, 512);
   RandomBnd(x2, x1);
   RandomBnd(x3, x1);

   mul(x4, x2, x3);

   t = GetTime();
   for (i = 0; i < 100000; i++)
      mul(x4, x2, x3);
   t = GetTime()-t;

   cerr << "time for 512-bit mul: " << long(t*10 + 0.5) << "us\n";

   t = GetTime();
   for (i = 0; i < 100000; i++)
      rem(x2, x4, x1);
   t = GetTime()-t;

   cerr << "time for 1024/512-bit rem: " << long(t*10 + 0.5) << "us\n";


   // test modulus switching
   
   n = 1024;
   k = 1024;
   RandomLen(p, k);

   ZZ_pInit(p);

   ZZ_pX j1, j2, j3;

   random(j1, n);
   random(j2, n);

   t = GetTime();

   mul(j3, j1, j2);

   t = GetTime()-t;

   cerr << "time to multiply degree 1023 polynomials mod a 1024-bit number: ";
   cerr << t << "s\n";

   return 0;
}
