#ifndef RR__H
#define RR__H

#include "ZZ.h"
#include "xdouble.h"

class RR {

public:

ZZ x;
long e;

RR() {  e = 0; }
RR(const RR&);
void operator=(const RR&);

~RR() { }

const ZZ& mantissa() const { return x; }
long exponent() { return e; }

static long prec;
static void SetPrecision(long p);
static long precision() { return prec; }

static long oprec;
static void SetOutputPrecision(long p);
static long OutputPrecision() { return oprec; }


};



long IsZero(const RR& a);
long IsOne(const RR& a);
long sign(const RR& a);
void clear(RR& z);
void set(RR& z);
void swap(RR& a, RR& b);

void add(RR& z, const RR& a, const RR& b);
void add(RR& z, const RR& a, long b);
inline void add(RR& z, const RR& a, int b) { add(z, a, long(b)); }
void add(RR& z, const RR& a, double b);
inline void add(RR& z, const RR& a, float b) { add(z, a, double(b)); }
void add(RR& z, long a, const RR& b);
inline void add(RR& z, int a, const RR& b) { add(z, long(a), b); }
void add(RR& z, double a, const RR& b);
inline void add(RR& z, float a, const RR& b) { add(z, double(a), b); }


void sub(RR& z, const RR& a, const RR& b);
void sub(RR& z, const RR& a, long b);
inline void sub(RR& z, const RR& a, int b) { sub(z, a, long(b)); }
void sub(RR& z, const RR& a, double b);
inline void sub(RR& z, const RR& a, float b) { sub(z, a, double(b)); }
void sub(RR& z, long a, const RR& b);
inline void sub(RR& z, int a, const RR& b) { sub(z, long(a), b); }
void sub(RR& z, double a, const RR& b);
inline void sub(RR& z, float a, const RR& b) { sub(z, double(a), b); }


void negate(RR& z, const RR& a);

void abs(RR& z, const RR& a);

void mul(RR& z, const RR& a, const RR& b);
void sqr(RR& z, const RR& a);
void mul(RR& z, const RR& a, long b);
inline void mul(RR& z, const RR& a, int b) { mul(z, a, long(b)); }
void mul(RR& z, const RR& a, double b);
inline void mul(RR& z, const RR& a, float b) { mul(z, a, double(b)); }
void mul(RR& z, long a, const RR& b);
inline void mul(RR& z, int a, const RR& b) { mul(z, long(a), b); }
void mul(RR& z, double a, const RR& b);
inline void mul(RR& z, float a, const RR& b) { mul(z, double(a), b); }


void div(RR& z, const RR& a, const RR& b);
void div(RR& z, const RR& a, long b);
inline void div(RR& z, const RR& a, int b) { div(z, a, long(b)); }
void div(RR& z, const RR& a, double b);
inline void div(RR& z, const RR& a, float b) { div(z, a, double(b)); }
void div(RR& z, long a, const RR& b);
inline void div(RR& z, int a, const RR& b) { div(z, long(a), b); }
void div(RR& z, double a, const RR& b);
inline void div(RR& z, float a, const RR& b) { div(z, double(a), b); }

inline void inv(RR& z, const RR& a) { div(z, 1, a); }

long compare(const RR& a, const RR& b);
long compare(const RR& a, long b);
inline long compare(const RR& a, int b) { return compare(a, long(b)); }
long compare(const RR& a, double b);
inline long compare(const RR& a, float b) { return compare(a, double(b)); }

long operator==(const RR& a, const RR& b);
inline long operator!=(const RR& a, const RR& b) { return !(a == b); }
inline long operator<=(const RR& a, const RR& b) { return compare(a, b) <= 0; }
inline long operator>=(const RR& a, const RR& b) { return compare(a, b) >= 0; }
inline long operator <(const RR& a, const RR& b) { return compare(a, b)  < 0; }
inline long operator >(const RR& a, const RR& b) { return compare(a, b)  > 0; }

long operator==(const RR& a, long b);
inline long operator!=(const RR& a, long b) { return !(a == b); }
inline long operator<=(const RR& a, long b) { return compare(a, b) <= 0; }
inline long operator>=(const RR& a, long b) { return compare(a, b) >= 0; }
inline long operator <(const RR& a, long b) { return compare(a, b)  < 0; }
inline long operator >(const RR& a, long b) { return compare(a, b)  > 0; }

inline long operator==(const RR& a, int b) { return a == long(b); }
inline long operator!=(const RR& a, int b) { return a != long(b); }
inline long operator<=(const RR& a, int b) { return compare(a, b) <= 0; }
inline long operator>=(const RR& a, int b) { return compare(a, b) >= 0; }
inline long operator <(const RR& a, int b) { return compare(a, b)  < 0; }
inline long operator >(const RR& a, int b) { return compare(a, b)  > 0; }

long operator==(const RR& a, double b);
inline long operator!=(const RR& a, double b) { return !(a == b); }
inline double operator<=(const RR& a, double b) { return compare(a, b) <= 0; }
inline double operator>=(const RR& a, double b) { return compare(a, b) >= 0; }
inline double operator <(const RR& a, double b) { return compare(a, b)  < 0; }
inline double operator >(const RR& a, double b) { return compare(a, b)  > 0; }

inline long operator==(const RR& a, float b) { return a == double(b); }
inline long operator!=(const RR& a, float b) { return a != double(b); }
inline long operator<=(const RR& a, float b) { return compare(a, b) <= 0; }
inline long operator>=(const RR& a, float b) { return compare(a, b) >= 0; }
inline long operator <(const RR& a, float b) { return compare(a, b)  < 0; }
inline long operator >(const RR& a, float b) { return compare(a, b)  > 0; }

void trunc(RR& z, const RR& a);
void floor(RR& z, const RR& a);
void ceil(RR& z, const RR& a);

void operator<<(RR& z, const ZZ& a);
void operator<<(RR& z, long a);
inline void operator<<(RR& z, int a) { z << long(a); }
void operator<<(RR& z, double a);
inline void operator<<(RR& z, float a) { z << double(a); }
void operator<<(RR& z, xdouble a);



void operator<<(ZZ& z, const RR& a);
void operator<<(long& z, const RR& a);
void operator<<(double& z, const RR& a);
void operator<<(xdouble& z, const RR& a);

inline long Long(const RR& a) { long z; z << a; return z; }
inline double Double(const RR& a) { double z; z << a; return z; }
inline xdouble XDouble(const RR& a) { xdouble z; z << a; return z; }



void power(RR& z, const RR& a, long e);
void power(RR& z, long a, long e);
void power(RR& z, int a, long e);
void power(RR& z, double a, long e);

ostream& operator<<(ostream& s, const RR& a);
istream& operator>>(istream& s, RR& x);

#endif
